<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title><?php echo e($patient->first_name); ?> Profile</title>
    <link rel="stylesheet" href="<?php echo e(public_path('css/kv-mpdf-bootstrap.css')); ?>">

</head>

<body>

    <!-- Patient Info -->
    <div class="card-body px-4">

        <div class="row mb-3 b-r-s-cont border2 py-3 px-2">

            <div class="col-xs-5 text-truncate p-0" style="">
                <div class="w-10">
                    <div class="p-0" style="width: 25%;float: left;">
                        <div class="rounded-circle avatar-m2 profile_img"
                            style="background-image: url(<?php echo e(public_path('img/useravatar/' . $patient->avatar)); ?>)">
                        </div>
                    </div>

                    <div class="text-truncate p-0" style="width: 75%;float: left;">
                        <p class="m-0 p-0 text-s">
                            Patient</p>
                        <p class="m-0 p-0 text-s fw-bold2 text-truncate">
                            <?php echo e($patient->first_name . ' ' . $patient->second_name); ?></p>
                        <p class="m-0 p-0 text-s"><?php echo e($patient->city->name); ?> <?php echo e($patient->country->name); ?></p>
                    </div>
                </div>
            </div>

            <div class="col-xs-2 px-0" style="display: inline;">
                <p class="text-s mb-0">Age</p>
                <p class="fw-bold2">
                    <?php echo e(\Carbon\Carbon::parse($patient->birthday)->diff(\Carbon\Carbon::now())->format('%y')); ?>

                </p>
            </div>

            <div class="col-xs-2 px-0 text-truncate">
                <p class="text-s mb-0 text-truncate">Insurance</p>
                <p class="fw-bold2"><?php echo e($patient->insurance); ?></p>
            </div>
            <div class="col-xs-2">
                <p class="text-s mb-0">Phone Number</p>
                <p class="fw-bold2"><?php echo e($patient->phone_number); ?></p>
            </div>
        </div>

        <!-- Examination -->
        <div class="row justify-content-center mb-2">
            <span class="text-s2">Last Examination:</span>
            <div class="col-xs-6 p-0"
                style="background-image: url('<?php echo e(public_path('img/dashboard/system/human_front2.jpg')); ?>'); width:181px; height:325px; position: relative; background-repeat: no-repeat; margin-left: 25%;">
                <?php if(!empty($disease_draw->front)): ?>
                <img src="<?php echo e(public_path('img/diseasedraw/' . $disease_draw->front)); ?>" width="181" height="325"
                    style=" solid;position: absolute;top:0;left:0;">
                <?php else: ?>
                <div class="ms-4 text-center main-color-bg text-white p-2 b-r-s-cont"
                    style=" solid;position: absolute;top:13rem;left:3rem;">
                    No Back Draw
                </div>
                <?php endif; ?>
            </div>

            <div class="col-xs-6 p-0"
                style="background-image: url('<?php echo e(public_path('img/dashboard/system/human_back2.jpg')); ?>'); width:181px; height:325px; position: relative; background-repeat: no-repeat;">

                <?php if(!empty($disease_draw->back)): ?>
                <img src="<?php echo e(public_path('img/diseasedraw/' . $disease_draw->back)); ?>" width="181" height="325"
                    style=" solid;position: absolute;top:0;left:0;">
                <?php else: ?>
                <div class="ms-4 text-center main-color-bg text-white p-2 b-r-s-cont"
                    style=" solid;position: absolute;top:13rem;left:3rem;">
                    No Back Draw
                </div>
                <?php endif; ?>
            </div>

        </div>


        <div class="p-4 main-color-bg b-r-s-cont flex-wrap justify-content-center mb-3">
            <div class="row text-s">
                <div class="col-xs-12 mb-2 me-3 me-xl-5">
                    <span class="form-label text-blue-300 mb-1">Examination
                        Note:</span>
                    <div id="exam-note" class="form-control-textarea overflow-auto text-white fw-bold2"
                        style="width: 241px;">
                        <?php if(!empty($disease_draw->note)): ?>
                        <?php echo e($disease_draw->note); ?>

                        <?php else: ?>
                        No Note
                        <?php endif; ?>
                    </div>
                </div>
                <div class="col-xs-3 mb-2 me-3 me-xl-5">
                    <span class="form-label text-blue-300 mb-1">Appointment
                        Date:</span>
                    <div id="exam-date" class="text-white fw-bold2">
                        <?php if(!empty($disease_draw->appointment->start_at)): ?>
                        <?php echo e($disease_draw->appointment->start_at); ?>

                        <?php else: ?>
                        Not Selected
                        <?php endif; ?>
                    </div>
                </div>
                <div class="col-xs-3 mb-2">
                    <span class="form-label text-blue-300 mb-1">Doctor:</span>
                    <div id="exam-doctor" class="text-white fw-bold2">
                        <?php if(!empty($disease_draw->appointment->doctor->name)): ?>
                        <?php echo e($disease_draw->appointment->doctor->name); ?>

                        <?php else: ?>
                        Not Selected
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>


        <!-- All exminations -->
        <div class="row mb-3">
            <div class="col-xs-12">
                <h4 class="">Examinations</h4>
                <div class="table-responsive">
                    <table class="table-responsive text-s table-bordered2 bordered w-100">
                        <thead>
                            <tr>
                                <th>Name</th>
                                <th>OD</th>
                                <th>OS</th>
                            </tr>
                        </thead>

                        <tbody>
                            <?php if(count($patient->examinations) > 0): ?>

                            <?php if($patient->examinations[0]->type == 3): ?>
                            <tr>
                                <td class="w-25 fw-bold2">LID</td>
                                <td class="fw-bold text-uppercase fw-bold2"><?php echo e($patient->examinations[0]->lid_od); ?></td>
                                <td class="fw-bold text-uppercase fw-bold2"><?php echo e($patient->examinations[0]->lid_os); ?></td>
                            </tr>
                            <tr>
                                <td class="w-25 fw-bold2">Surface</td>
                                <td class="fw-bold text-uppercase fw-bold2"><?php echo e($patient->examinations[0]->surface_od); ?></td>
                                <td class="fw-bold text-uppercase fw-bold2"><?php echo e($patient->examinations[0]->surface_os); ?></td>
                            </tr>
                            <tr>
                                <td class="w-25 fw-bold2">A.C.</td>
                                <td class="fw-bold text-uppercase fw-bold2"><?php echo e($patient->examinations[0]->ac_od); ?></td>
                                <td class="fw-bold text-uppercase fw-bold2"><?php echo e($patient->examinations[0]->ac_os); ?></td>
                            </tr>
                            <tr>
                                <td class="w-25 fw-bold2">Pupil</td>
                                <td class="fw-bold text-uppercase fw-bold2"><?php echo e($patient->examinations[0]->pupil_od); ?></td>
                                <td class="fw-bold text-uppercase fw-bold2"><?php echo e($patient->examinations[0]->pupil_os); ?></td>
                            </tr>
                            <tr>
                                <td class="w-25 fw-bold2">Lens</td>
                                <td class="fw-bold text-uppercase fw-bold2"><?php echo e($patient->examinations[0]->lens_od); ?></td>
                                <td class="fw-bold text-uppercase fw-bold2"><?php echo e($patient->examinations[0]->lens_os); ?></td>
                            </tr>
                            <tr>
                                <td class="w-25 fw-bold2">Iris</td>
                                <td class="fw-bold text-uppercase fw-bold2"><?php echo e($patient->examinations[0]->iris_od); ?></td>
                                <td class="fw-bold text-uppercase fw-bold2"><?php echo e($patient->examinations[0]->iris_os); ?></td>
                            </tr>
                            <tr>
                                <td class="w-25 fw-bold2">Angle</td>
                                <td class="fw-bold text-uppercase fw-bold2"><?php echo e($patient->examinations[0]->angle_od); ?></td>
                                <td class="fw-bold text-uppercase fw-bold2"><?php echo e($patient->examinations[0]->angle_os); ?></td>
                            </tr>
                            <tr>
                                <td class="w-25 fw-bold2">Fundus</td>
                                <td class="fw-bold text-uppercase fw-bold2"><?php echo e($patient->examinations[0]->fundus_od); ?></td>
                                <td class="fw-bold text-uppercase fw-bold2"><?php echo e($patient->examinations[0]->fundus_os); ?></td>
                            </tr>
                            <tr>
                                <td class="w-25 fw-bold2">Motility</td>
                                <td class="fw-bold text-uppercase fw-bold2"><?php echo e($patient->examinations[0]->motility_od); ?></td>
                                <td class="fw-bold text-uppercase fw-bold2"><?php echo e($patient->examinations[0]->motility_os); ?></td>
                            </tr>
                            <tr>
                                <td class="w-25 fw-bold2">IOP</td>
                                <td class="fw-bold text-uppercase fw-bold2"><?php echo e($patient->examinations[0]->iop_od); ?></td>
                                <td class="fw-bold text-uppercase fw-bold2"><?php echo e($patient->examinations[0]->iop_os); ?></td>
                            </tr>
                            <?php endif; ?>
                            <?php endif; ?>
                        </tbody>

                    </table>
                </div>
            </div>
        </div>

        <!-- All exminations -->
        <div class="row mb-3">
            <div class="col-xs-12">
                <h4 class="">Examinations</h4>
                <div class="table-responsive">
                    <table class="table-responsive text-s table-bordered2 bordered w-100">
                        <thead>
                            <tr>
                                <th style="width:40%;">Name</th>
                                <th style="width:20%;">Start</th>
                                <th style="width:20%;">End</th>
                                <th style="width:20%;">Status</th>
                            </tr>
                        </thead>

                        <tbody>
                            <?php $__currentLoopData = $disease; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if($item->status == 0): ?>
                            <?php
                            $text_color = 'active-color-btn';
                            $msg = 'Still';
                            ?>
                            <?php elseif($item->status == 1): ?>
                            <?php
                            $text_color = 'done-color-btn';
                            $msg = 'Healed';
                            ?>
                            <?php endif; ?>


                            <tr style="word-wrap: break-word;">
                                <td style="width:30%;"><?php echo e($item->diseasecats->name); ?></td>
                                <td style="width:20%;"><?php echo e($item->start); ?></td>
                                <td style="width:20%;"><?php echo e($item->end); ?></td>
                                <td style="width:20%;"><span
                                        class="badge rounded-pill <?php echo e($text_color); ?> badge-padd-l"><?php echo e($msg); ?></span>
                                </td>

                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>

                    </table>
                </div>
            </div>
        </div>


        <!-- Examination -->
        <div class="row justify-content-center mb-2">
            <?php if(count($patient->eyeglasses) > 0): ?>
            <h4 class="">Eyeglasses</h4>
            <?php endif; ?>

            <div class="col-xs-6 p-0">
                <div class="border p-2 m-1 b-r-s-cont">
                    <img src="<?php echo e(public_path('img/dashboard/system/eye_axi.png')); ?>">

                    <!-- All exminations -->
                    <div class="row mb-3">
                        <div class="col-xs-12">

                            <div class="table-responsive">
                                <table class="table-responsive text-s table-bordered2 bordered w-100">
                                    <thead>
                                        <tr style="background-color: #e6e6e6;">
                                            <th class="text-s text-center" colspan="4">Right Eye</th>
                                        </tr>
                                    </thead>
                                    <tbody class="text-l fw-bold2">
                                        <tr style="background-color: #e6e6e6;">
                                            <td style="background-color: #e6e6e6;"></td>
                                            <td class="text-center fw-bold2">Sph.</td>
                                            <td class="text-center fw-bold2">Cyl.</td>
                                            <td class="text-center fw-bold2">Axis.</td>
                                        </tr>
                                        <tr>
                                            <td style="background-color: #e6e6e6;" class="text-center">D</td>
                                            <td class="text-l fw-bold2 text-center">
                                                <?php if(count($patient->eyeglasses) > 0): ?>
                                                <?php echo e($patient->eyeglasses[0]->glass_right_sph); ?>

                                                <?php endif; ?>
                                            </td>
                                            <td class="text-l fw-bold2 text-center">
                                                <?php if(count($patient->eyeglasses) > 0): ?>

                                                <?php echo e($patient->eyeglasses[0]->glass_right_cyl); ?>


                                                <?php endif; ?>
                                            </td>
                                            <td class="text-l fw-bold2 text-center">
                                                <?php if(count($patient->eyeglasses) > 0): ?>
                                                <?php echo e($patient->eyeglasses[0]->glass_right_axis); ?>°
                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="background-color: #e6e6e6;" class="text-center">N</td>
                                            <td class="text-l fw-bold2 text-center">
                                                <?php if(count($patient->eyeglasses) > 0): ?>
                                                <?php echo e($patient->eyeglasses[0]->glass_right_n); ?>

                                                <?php endif; ?>
                                            </td>
                                            <td class="text-l fw-bold2 text-center">
                                                <?php if(count($patient->eyeglasses) > 0): ?>

                                                <?php echo e($patient->eyeglasses[0]->glass_right_cyl); ?>


                                                <?php endif; ?>
                                            </td>
                                            <td class="text-l fw-bold2 text-center">
                                                <?php if(count($patient->eyeglasses) > 0): ?>
                                                <?php echo e($patient->eyeglasses[0]->glass_right_axis); ?>°
                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>

            </div>

            <div class="col-xs-6 p-0">
                <div class="border p-2 m-1 b-r-s-cont">
                    <img src="<?php echo e(public_path('img/dashboard/system/eye_axi.png')); ?>">
                    <!-- All exminations -->
                    <div class="row mb-3">
                        <div class="col-xs-12">

                            <div class="table-responsive">
                                <table class="table-responsive text-s table-bordered2 bordered w-100">
                                    <thead>
                                        <tr style="background-color: #e6e6e6;">
                                            <th class="text-s text-center" colspan="4">Left Eye</th>
                                        </tr>
                                    </thead>
                                    <tbody class="text-l fw-bold2">
                                        <tr style="background-color: #e6e6e6;">
                                            <td></td>
                                            <td class="text-center fw-bold2">Sph.</td>
                                            <td class="text-center fw-bold2">Cyl.</td>
                                            <td class="text-center fw-bold2">Axis.</td>
                                        </tr>
                                        <tr>
                                            <td style="background-color: #e6e6e6;" class="text-center">D</td>
                                            <td class="text-l fw-bold2 text-center">
                                                <?php if(count($patient->eyeglasses) > 0): ?>
                                                <?php echo e($patient->eyeglasses[0]->glass_left_sph); ?>

                                                <?php endif; ?>
                                            </td>
                                            <td class="text-l fw-bold2 text-center">
                                                <?php if(count($patient->eyeglasses) > 0): ?>
                                                <?php echo e($patient->eyeglasses[0]->glass_left_cyl); ?>

                                                <?php endif; ?>
                                            </td>
                                            <td class="text-l fw-bold2 text-center">
                                                <?php if(count($patient->eyeglasses) > 0): ?>
                                                <?php echo e($patient->eyeglasses[0]->glass_left_axis); ?>°
                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="background-color: #e6e6e6;" class="text-center">N</td>
                                            <td class="text-l fw-bold2 text-center">
                                                <?php if(count($patient->eyeglasses) > 0): ?>
                                                <?php echo e($patient->eyeglasses[0]->glass_left_n); ?>

                                                <?php endif; ?>
                                            </td>
                                            <td class="text-l fw-bold2 text-center">
                                                <?php if(count($patient->eyeglasses) > 0): ?>
                                                <?php echo e($patient->eyeglasses[0]->glass_left_cyl); ?>

                                                <?php endif; ?>
                                            </td>
                                            <td class="text-l fw-bold2 text-center">
                                                <?php if(count($patient->eyeglasses) > 0): ?>
                                                <?php echo e($patient->eyeglasses[0]->glass_left_axis); ?>°
                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="row mb-2">

            <div class="col-xs-5">

                <div class="table-responsive">
                    <table class="table-responsive text-s table-bordered2 bordered w-100">
                        <thead>
                            <tr style="background-color: #e6e6e6;">
                                <th class="text-s2 text-center" colspan="">IPD mm</th>
                            </tr>
                        </thead>
                        <tbody class="text-s2 fw-bold2">
                            <tr style="background-color: #e6e6e6;">
                                <td class="text-l fw-bold2  text-center">
                                    <?php if(count($patient->eyeglasses) > 0): ?>
                                    <?php echo e($patient->eyeglasses[0]->ipd); ?>

                                    <?php else: ?>
                                    <h1 class="p-4 m-4"> </h1>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>



        <!-- Treatments -->
        <div class="row mb-3">
            <div class="col-xs-12">
                <h4 class="">Treatments</h4>
                <div class="table-responsive">
                    <table class="table-responsive text-s table-bordered2 bordered w-100">
                        <thead>
                            <tr>
                                <th style="width:30%;">Name</th>
                                <th style="width:20%;">From</th>
                                <th style="width:20%;">To</th>
                                <th style="width:15%;">Sessions</th>
                                <th style="width:15%;">Status</th>
                            </tr>
                        </thead>

                        <tbody>
                            <?php $__currentLoopData = $treatment; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if($item->status == 0): ?>
                            <?php
                            $text_color = 'active-color-btn';
                            $msg = 'In prog';
                            ?>
                            <?php elseif($item->status == 1): ?>
                            <?php
                            $text_color = 'done-color-btn';
                            $msg = 'Done';
                            ?>
                            <?php endif; ?>

                            <tr style="word-wrap: break-word;">
                                <td style="width:30%;"><?php echo e($item->treatment_cat->name); ?></td>
                                <td style="width:20%;"><?php echo e($item->start); ?></td>
                                <td style="width:20%;"><?php echo e($item->end); ?></td>
                                <td style="width:15%;"><?php echo e($item->sessions_done); ?></td>
                                <td style="width:15%;"><span
                                        class="badge rounded-pill <?php echo e($text_color); ?> badge-padd-l"><?php echo e($msg); ?></span>
                                </td>

                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>

                    </table>
                </div>
            </div>
        </div>

        <div class="row mb-3">
            <div class="col-xs-12">
                <h4 class="">Medicenes</h4>
                <div class="table-responsive">
                    <table class="table-responsive text-s table-bordered2 bordered w-100">
                        <thead>
                            <tr>
                                <th style="width:40%;">Name</th>
                                <th style="width:20%;">From</th>
                                <th style="width:20%;">To</th>
                                <th style="width:20%;">Status</th>
                            </tr>
                        </thead>

                        <tbody>
                            <?php $__currentLoopData = $medicine; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if($item->status == 0): ?>
                            <?php
                            $text_color = 'active-color-btn';
                            $msg = 'On medicine';
                            ?>
                            <?php elseif($item->status == 1): ?>
                            <?php
                            $text_color = 'cancel-color-btn';
                            $msg = 'No result';
                            ?>
                            <?php elseif($item->status == 2): ?>
                            <?php
                            $text_color = 'done-color-btn';
                            $msg = 'Done';
                            ?>
                            <?php endif; ?>

                            <tr style="word-wrap: break-word;">
                                <td style="width:40%;">
                                    <?php echo e($item->medicinescats->name); ?>

                                </td>
                                <td style="width:20%;">
                                    <?php echo e($item->start); ?></td>
                                <td style="width:20%;"><?php echo e($item->end); ?>

                                </td>
                                <td style="width:20%;">
                                    <span class="badge rounded-pill <?php echo e($text_color); ?> badge-padd-l"><?php echo e($msg); ?></span>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>

                    </table>
                </div>
            </div>
        </div>

        <!-- All exminations -->
        <div class="row mb-3">
            <div class="col-xs-12">
                <h4 class="">Investigation</h4>
                <div class="table-responsive">
                    <table class="table-responsive text-s table-bordered2 bordered w-100">
                        <thead>
                            <tr>
                                <th>Name</th>
                                <th>Value</th>
                            </tr>
                        </thead>

                        <tbody>
                            <?php if(count($patient->investigation) > 0): ?>
                            <?php if($patient->investigation[0]->type == 3): ?>
                            <tr>
                                <td class="w-25 fw-bold2">Colored Photo</td>
                                <td class="fw-bold text-uppercase fw-bold2"><?php echo e($patient->investigation[0]->colored_photo); ?></td>
                            </tr>
                            <tr>
                                <td class="w-25 fw-bold2">Sonar</td>
                                <td class="fw-bold text-uppercase fw-bold2"><?php echo e($patient->investigation[0]->sonar); ?>

                                </td>
                            </tr>
                            <tr>
                                <td class="w-25 fw-bold2">UBM</td>
                                <td class="fw-bold text-uppercase fw-bold2"><?php echo e($patient->investigation[0]->ubm); ?></td>
                            </tr>
                            <tr>
                                <td class="w-25 fw-bold2">Biometry</td>
                                <td class="fw-bold text-uppercase fw-bold2"><?php echo e($patient->investigation[0]->biometry); ?>

                                </td>
                            </tr>
                            <tr>
                                <td class="w-25 fw-bold2">Visual Field</td>
                                <td class="fw-bold text-uppercase fw-bold2"><?php echo e($patient->investigation[0]->visual_field); ?></td>
                            </tr>
                            <tr>
                                <td class="w-25 fw-bold2">FFA</td>
                                <td class="fw-bold text-uppercase fw-bold2"><?php echo e($patient->investigation[0]->ffa); ?></td>
                            </tr>
                            <tr>
                                <td class="w-25 fw-bold2">OCT</td>
                                <td class="fw-bold text-uppercase fw-bold2"><?php echo e($patient->investigation[0]->oct); ?></td>
                            </tr>
                            <tr>
                                <td class="w-25 fw-bold2">Pentacam</td>
                                <td class="fw-bold text-uppercase fw-bold2"><?php echo e($patient->investigation[0]->pentacam); ?>

                                </td>
                            </tr>
                            <tr>
                                <td class="w-25 fw-bold2">Electro Physiology</td>
                                <td class="fw-bold text-uppercase fw-bold2"><?php echo e($patient->investigation[0]->electro_physiology); ?></td>
                            </tr>
                            <tr>
                                <td class="w-25 fw-bold2">Specular Microscopy</td>
                                <td class="fw-bold text-uppercase fw-bold2"><?php echo e($patient->investigation[0]->specular_microscopy); ?></td>
                            </tr>
                            <?php endif; ?>
                            <?php endif; ?>
                        </tbody>

                    </table>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-xs-12">
                <h4 class="">Lab</h4>
                <div class="table-responsive">
                    <table class="table-responsive text-s table-bordered2 bordered w-100">
                        <thead>
                            <tr>
                                <th style="width:30%;">Name</th>
                                <th style="width:20%;">Code</th>
                                <th style="width:30%;">Note</th>
                                <th style="width:20%;">Created</th>
                            </tr>
                        </thead>

                        <tbody>
                            <?php $__currentLoopData = $lab; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if($item->status == 0): ?>
                            <?php
                            $text_color = 'active-color-btn';
                            $msg = 'Sent';
                            ?>
                            <?php elseif($item->status == 1): ?>
                            <?php
                            $text_color = 'done-color-btn';
                            $msg = 'Done';
                            ?>
                            <?php endif; ?>

                            <?php if($item->invoice_item->invoice->status == 0): ?>
                            <?php
                            $text_color_invoice = 'cancel-color-btn';
                            $msg_invoice = 'Not Paid';
                            ?>
                            <?php elseif($item->invoice_item->invoice->status == 1): ?>
                            <?php
                            $text_color_invoice = 'pend-color-btn';
                            $msg_invoice = __('basic.pending');
                            ?>
                            <?php elseif($item->invoice_item->invoice->status == 2): ?>
                            <?php
                            $text_color_invoice = 'done-color-btn';
                            $msg_invoice = 'Paid';
                            ?>
                            <?php endif; ?>

                            <tr style="word-wrap: break-word;">
                                <td style="width:30%;"><?php echo e($item->service_item->name); ?></td>
                                <td style="width:20%;"><?php echo e($item->code); ?></td>
                                <td style="width:30%;"><?php echo e($item->note_lab); ?></td>
                                <td style="width:20%;"><?php echo e(date('d M Y', strtotime($item->created_at))); ?>

                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>

                    </table>
                </div>
            </div>
        </div>


    </div>


</body>

</html><?php /**PATH /home/medix/public_html/samirghoraba/med/resources/views/patient/print.blade.php ENDPATH**/ ?>