<?php $__env->startSection('title', 'With Doctor | Proxima - Medical Management app'); ?>

<?php $__env->startSection('title-topbar', 'Patients Waiting'); ?>

<!-- css insert -->
<?php $__env->startSection('css'); ?>

    <!-- select 2 -->
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

    <!-- boostrap datepicker -->
    <link rel="stylesheet"
        href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.1/css/bootstrap-datepicker3.css" />

<?php $__env->stopSection(); ?>

<!-- content insert -->
<?php $__env->startSection('content'); ?>
    <div class="container-fluid px-0 mt-3">


        <!-- Button trigger modal -->
        <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#sidemodal">
            Launch demo modal
        </button>

        <!-- Modal -->
        <div class="modal side_modal_prox fade" id="sidemodal" tabindex="-1" aria-labelledby="exampleModalLabel"
            aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLabel">Modal title</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        ...
                    </div>
                    <div class="modal-footer">
                        <span class="text-gray-300 clickable-item-pointer me-3" data-bs-dismiss="modal">Close</span>
                        <button type="button" class="btn btn-primary px-5">Save changes</button>
                    </div>
                </div>
            </div>
        </div>

        <!-- page title link -->
        <div class="d-sm-flex align-items-center justify-content-between mb-3">

            <div class="calendar-datepicker mb-2 mb-md-0">
                <div class="input-group">
                    <div class="input-group-prepend">
                        <div class="input-group-text ps-3"><i class="bi bi-calendar2-week-fill"></i> </div>
                    </div>
                    <input id="calendar-date-input" type="text" class="form-control hasdatetimepicker"
                        placeholder="YYYY/MM/DD">
                </div>
            </div>

            <div class="d-flex justify-content-center">
                <div class="cont-branch-calendar me-2">
                    <select id="select-branch-calendar" data-month="<?php echo e(date('m')); ?>" data-year="<?php echo e(date('Y')); ?>"
                        class="js-example-basic-single_branch select2-no-search_branch select2-hidden-accessible">
                        <?php $__currentLoopData = $branches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $iteam): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($iteam->id); ?>">
                                <?php echo e($iteam->name); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>

                <a href="<?php echo e(route('sett.appointment.create')); ?>"
                    class="bg-white  btn btn-sm shadow-sm b-r-l-cont p-2 px-4 text-gray-400"><i
                        class="fas fa-plus fa-sm text-gray-300 me-1"></i> <?php echo e(__('basic.new')); ?></a>
            </div>

        </div>


        <div class="card shadow mb-3 pb-2">
            <!-- Card Header - Dropdown -->
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                <h6 class="m-0 fw-bold text-gray-500"><i class="fas fa-users me-2"></i> All users</h6>
                <div class="dropdown no-arrow">
                    <a class="dropdown-toggle" href="#" role="button" id="dropdownMenuLink" data-bs-toggle="dropdown"
                        aria-haspopup="true" aria-expanded="false">
                        <i class="fas fa-ellipsis-v fa-sm fa-fw text-gray-300"></i>
                    </a>
                    <div class="dropdown-menu dropdown-menu-right shadow animated--fade-in"
                        aria-labelledby="dropdownMenuLink">
                        <div class="dropdown-header">Action:</div>
                        <a class="dropdown-item" href="<?php echo e(route('sett.admin.create')); ?>"><i class="fas fa-user me-1"></i>
                            new user</a>
                        <a class="dropdown-item" href="<?php echo e(route('sett.role.index')); ?>"><i class="fas fa-plus me-1"></i>
                            roles</a>
                    </div>
                </div>
            </div>

            <!-- Card Body -->
            <div class="card-body">
                <div class="row mb-2">
                    <div class="col-12 px-0" id="withdoctor-cont-ajax">

                    </div>
                </div>
            </div>

            <div class="row p-5">
                <span class="col"><i class="fas fa-circle main-color"></i>
                    <?php echo e(__('patientappo.not accepted')); ?></span>
                <span class="col"><i class="fas fa-circle not_accepted-color"></i>
                    <?php echo e(__('patientappo.accepted')); ?></span>
                <span class="col"><i class="fas fa-circle arrived-color"></i>
                    <?php echo e(__('patientappo.arrived')); ?>

                </span>
                <span class="col"><i class="fas fa-circle inprog-color"></i>
                    <?php echo e(__('patientappo.with doctor')); ?></span>
                <span class="col"><i class="fas fa-circle done-color"></i>
                    <?php echo e(__('patientappo.done appointment')); ?></span>
                <span class="col"><i class="fas fa-circle cancel-color"></i>
                    <?php echo e(__('patientappo.canceled')); ?>

                </span>
                <span class="col mt-2 mt-md-0"><i class="fas fa-circle notresp-color"></i>
                    <?php echo e(__('patientappo.not respond')); ?></span>
            </div>

        </div>

    <?php $__env->stopSection(); ?>

    <!-- js insert -->
    <?php $__env->startSection('js'); ?>

        <!-- select 2 -->
        <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
        <script>
            $(document).ready(function() {
                $('.js-example-basic-single_branch').select2();
                //hide search
                $('.select2-no-search_branch').select2({
                    minimumResultsForSearch: -1
                });
            });
        </script>

        <!-- jquery ui datepicker -->
        <script type="text/javascript"
                src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.1/js/bootstrap-datepicker.min.js"></script>
        <script>
            $(function() {
                $('.hasdatetimepicker').datepicker({
                    todayHighlight: true,
                    format: "yyyy-mm-dd",
                });
            });
        </script>

        <script>
            $(document).ready(function() {

                //--------------------- fetch appoingtments -------------------

                var branches_selc = $('#select-branch-calendar').val();

                monthly_calendar();

                function monthly_calendar(month = <?php echo e(date('m')); ?>, year = <?php echo e(date('Y')); ?>, branch =
                    branches_selc) {

                    var url =
                        "<?php echo e(route('sett.app_monthly_calendar_data', [':year_re', ':month_re', ':branch_re'])); ?>";
                    url = url.replace(':year_re', year).replace(':month_re', month).replace(':branch_re', branch)

                    $.ajax({
                        url: url,
                        type: "GET",
                        success: function(data) {

                            $('#withdoctor-cont-ajax').html(data);

                        }

                    })
                };


                //reinsert calander when branch selector is changed (#branches_selc_form)
                $('body').on('change', '#select-branch-calendar', function() {
                    var branch = $(this).val();
                    var month = $(this).attr('data-month');
                    var year = $(this).attr('data-year');
                    monthly_calendar(month, year, branch);
                });


                //reinsert the calander when the month arrows are clicked
                $(document).on('click', '#change_month', function() {

                    var month = $(this).data('month');
                    var year = $(this).data('year');
                    var branch = $('#select-branch-calendar').val();

                    $('#select-branch-calendar').attr('data-month', month)
                    $('#select-branch-calendar').attr('data-year', year)

                    monthly_calendar(month, year, branch)
                });



            });
        </script>

    <?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/proxima/resources/views/branch/appointment/monthly_calendar.blade.php ENDPATH**/ ?>