<?php $__env->startSection('title', 'Complaints | Suggestion | Proxima - Medical Management app'); ?>

<?php $__env->startSection('title-topbar', 'Complaints | Suggestion'); ?>

<!-- css insert -->
<?php $__env->startSection('css'); ?>

    <!-- -- datatables plugin -- -->
    <link rel="stylesheet" href="https://cdn.datatables.net/1.11.2/css/dataTables.bootstrap5.min.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.0.0/css/buttons.bootstrap5.min.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/autofill/2.3.9/css/autoFill.bootstrap5.min.css">

<?php $__env->stopSection(); ?>


<!-- session successful message -->
<?php if(Session::has('success')): ?>
    <div id="flash-msg" class="shadow pt-3">
        <div class="d-flex justify-content-between mb-2">
            <i class="fas fs-1 fa-check"></i>
            <a id="flash-msg-btn" class="text-blue-300 clickable-item-pointer"><i class="fas fa-times"></i></a>
        </div>
        <h3>Sent Successfully</h3>
        <p class="text-blue-300"><?php echo e(Session::get('success')); ?></p>
    </div>
<?php endif; ?>


<!-- content insert -->
<?php $__env->startSection('content'); ?>
    <div class="container-fluid px-2 mt-3">

        <!-- page title link -->
        <div class="d-sm-flex align-items-center justify-content-between mb-3">
            <span class="mb-0">
                <a class="link-cust-text text-gray-200 fw-light" href="<?php echo e(route('sett.home')); ?>">Dashboard |</a>
                <a class="text-gray-300">Complaints | Suggestion</a>
            </span>

            <div class="d-flex justify-content-center">
                <a href="<?php echo e(route('sett.admin.create')); ?>"
                    class=" main-color-bg text-white btn btn-sm shadow-sm b-r-l-cont p-2 px-4 me-1"><i
                        class="fas fa-plus fa-sm me-1"></i> New</a>
            </div>
        </div>

        <div class="card shadow mb-3 pb-2">
            <!-- Card Header - Dropdown -->
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
            </div>

            <!-- Card Body -->
            <div class="card-body">

                <div class="table-responsive">
                    <table class="table display datatable-modal" id="p-lab-table" width="100%" cellspacing="0">
                        <thead>
                            <tr>
                                <th class="text-xxs">NAME</th>
                                <th class="text-xxs text-center">STATUS</th>
                                <th class="text-xxs text-center">BRANCH</th>
                                <th class="text-xxs text-center">Responsable Doctor</th>
                                <th class="text-xxs text-center">HANDLE</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $complaints; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td>
                                        <a class="d-flex align-items-center"
                                            href="<?php echo e(route('sett.complaint.show', $item->id)); ?>">
                                            <img class="rounded-circle avatar-small me-2"
                                                src="<?php echo e(URL::asset('img/useravatar/' . $item->appointment->patient->avatar)); ?>">
                                            <div class="">
                                                <h6
                                                    class=" mb-1
                                                text-s fw-bold text-gray-mixed-400">
                                                    <?php echo e($item->appointment->patient->name); ?></h6>
                                                <p class="mb-0 text-xs text-gray-300"><?php echo e($item->start_at); ?></p>
                                            </div>
                                        </a>
                                    </td>
                                    <td class="text-center">
                                        <?php if($item->status == 0): ?>
                                            <span class="badge rounded-pill cancel-color-btn badge-padd-l">
                                                Unsolved
                                            </span>
                                        <?php else: ?>
                                            <span class="badge rounded-pill done-color-btn badge-padd-l">
                                                Solved
                                            </span>
                                        <?php endif; ?>
                                    </td>

                                    <td class="text-center">
                                        <?php echo e($item->appointment->branch->name); ?>

                                    </td>

                                    <td class="text-center">
                                        <?php if($item->appointment->doctor): ?>
                                            <?php echo e($item->appointment->doctor->name); ?>

                                        <?php else: ?>
                                            No Doctor Selected
                                        <?php endif; ?>
                                    </td>

                                    <td class="text-center">
                                        <a href="<?php echo e(route('sett.complaint.show', $item->id)); ?>"
                                            class="btn btn-sm status-col-link active-color-btn b-r-xs mb-1"
                                            title="delete"><i class="fas fa-envelope-open-text"></i> Show</a>
                                    </td>

                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                        </tbody>
                    </table>
                </div>
            </div>

        </div>
    </div>
<?php $__env->stopSection(); ?>


<!-- js insert -->
<?php $__env->startSection('js'); ?>

    <!-- delete confirmation modal -->
    <script>
        $('.delete-conf').click(function(event) {
            var user_id = $(this).data("user_id");
            var username = $(this).data("username");
            console.log(user_id);
            var modal = $('.delete-conf-input [name="user_id"]')
            modal.val(user_id);
            $('#username').val(username);
        })
    </script>

    <script>
        $(document).ready(function() {
            var table = $('#p-lab-table').DataTable({
                lengthChange: true,
                buttons: [{
                    extend: 'csv',
                    split: ['pdf', 'excel'],
                }]
            });
        });
    </script>

    <!-- -- datatables plugin -- -->
    <script type="text/javascript" src="https://cdn.datatables.net/1.11.2/js/jquery.dataTables.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/1.11.2/js/dataTables.bootstrap5.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/buttons/1.3.1/js/dataTables.buttons.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/buttons/2.0.0/js/buttons.bootstrap5.min.js"></script>

    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/buttons/1.3.1/js/buttons.html5.min.js"></script>
    <script type="text/javascript" language="javascript"
        src="https://cdn.datatables.net/buttons/2.0.0/js/buttons.print.min.js"></script>
    <script type="text/javascript" language="javascript"
        src="https://cdn.datatables.net/buttons/2.0.0/js/buttons.colVis.min.js"></script>



<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/proxima/resources/views/branch/complaint/index.blade.php ENDPATH**/ ?>