<?php $__env->startSection('title', 'Show Appointment | Proxima - Medical Management app'); ?>

<?php $__env->startSection('title-topbar', 'Show Appointment'); ?>

<!-- css insert -->
<?php $__env->startSection('css'); ?>

<?php $__env->stopSection(); ?>


<!-- content insert -->
<?php $__env->startSection('content'); ?>

<div class="container-fluid px-2 mt-3">

    <!-- page title link -->
    <div class="d-flex align-items-center justify-content-center justify-content-md-between mb-3 flex-wrap">
        <span class="mb-0 me-2">
            <a class="link-cust-text text-gray-200 fw-light" href="<?php echo e(route('sett.home')); ?>"><?php echo e(__('basic.dashboard')); ?>

                |</a>
            <a class="link-cust-text text-gray-200 fw-light" href="<?php echo e(route('sett.appointment.index')); ?>"><?php echo e(__('basic.appointments')); ?>

                | </a>
            <a class="text-gray-300"><?php echo e(__('basic.appointment')); ?></a>
        </span>
        <div class="d-flex justify-content-center mt-2 mt-md-0">
            <?php if($appointment->meet_join_url): ?>
            <?php
            $patient_ur_wa = $appointment->meet_join_url;
            ?>
            <a target="_blank" href="<?php echo e($appointment->meet_join_url); ?>"
                class=" main-color-bg text-white btn btn-sm shadow-sm b-r-l-cont p-2 px-4 me-1"><i
                    class="fas fa-video me-1"></i> Start Video</a>
            <?php else: ?>
            <?php
            $patient_ur_wa = route('patient_auth.land_show_pat_appointment_public', $appointment->code);
            ?>
            <?php endif; ?>

            <a target="_blank"
                href="<?php echo e('https://wa.me/+2' . $appointment->patient->phone_number . '?text= اهلا' . $appointment->patient->name . ' معاك ' . $appointment->creator->name . ' من عيادات ' . $clinicname . '. تم تاكيد حجزك علي العنوان التالي ' . $appointment->branch->address); ?>"
                class=" main-color-bg text-white btn btn-sm shadow-sm b-r-l-cont p-2 px-4 me-1"><i
                    class="fab fa-whatsapp me-1"></i> WhatsApp</a>
        </div>
    </div>

    <div class="card card-input shadow mb-3 pb-3">
        <!-- Card Header - Dropdown -->
        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
            <h6 class="m-0 fw-bold text-gray-500"><i class="fas fa-calendar me-2"></i> <?php echo e(__('basic.appointment')); ?>

            </h6>
            <div class="dropdown no-arrow">
                <a class="dropdown-toggle" href="#" role="button" id="dropdownMenuLink" data-bs-toggle="dropdown"
                    aria-haspopup="true" aria-expanded="false">
                    <i class="fas fa-ellipsis-v fa-sm fa-fw text-gray-300"></i>
                </a>
                <div class="dropdown-menu dropdown-menu-right shadow animated--fade-in"
                    aria-labelledby="dropdownMenuLink">
                    <a class="dropdown-item" href="<?php echo e(route('sett.appointment.edit', $appointment->id)); ?>"><i
                            class="fas fa-pen me-1"></i>
                        Edit</a>
                    <?php if($appointment->meet_start_url): ?>
                    <a class="dropdown-item copy_clipboard clickable-item-pointer"
                        data-url="<?php echo e($appointment->meet_join_url); ?>"><i class="fas fa-video me-1"></i>
                        Copy URL Joing online appointment</a>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <!-- Card Body -->
        <div class="card-body px-3">

            <!-- <div class="text-end px-lg-5"> <a href="#" class="d-none bg-white d-sm-inline-block btn btn-sm shadow-sm b-r-l-cont p-2 px-4 text-gray-400"><i class="fas fa-download fa-sm text-gray-300 me-1"></i> Print</a> </div> -->

            <div class="row d-flex justify-content-around align-items-center my-2 px-1 px-md-5">

                <div class="col-8 col-md-4 d-flex align-items-center mb-3 mb-md-0">
                    <img id="avatar_final_info" class="rounded-circle avatar-m me-3"
                        src="<?php echo e(URL::asset('img/useravatar/' . $appointment->patient->avatar)); ?>">
                    <div class="">
                        <p class=" mb-0 text-xs text-gray-300">
                            <?php echo e(__('basic.patient')); ?></p>
                        <a href="<?php echo e(route('sett.patient.show', $appointment->patient->id)); ?>" id="name_final_info"
                            class="mb-1 fw-bold text-gray-600 fs-6">
                            <?php echo e($appointment->patient->name); ?>

                        </a>
                        <p id="number_final_info" class="mb-0 text-xs text-gray-400">
                            <?php echo e($appointment->patient->phone_number); ?></p>
                    </div>
                </div>

                <div class="col-4 col-md-2">
                    <h6 class="text-gray-300 text-xs mb-1"><?php echo e(__('basic.branch')); ?></h6>
                    <p id="branch_final_info" class="text-gray-600 text-s fw-bold">
                        <?php echo e($appointment->branch->name); ?></p>
                </div>

                <div class="col-4 col-md-2">
                    <h6 class="text-gray-300 text-xs mb-1"><?php echo e(__('basic.address')); ?></h6>
                    <p id="addre_final_info" class="text-gray-600 text-s fw-bold">
                        <?php echo e($appointment->branch->address); ?></p>
                </div>

                <div class="col-4 col-md-2">
                    <h6 class="text-gray-300 text-xs mb-1"><?php echo e(__('basic.creator')); ?></h6>
                    <p id="addre_final_info" class="text-gray-600 text-s fw-bold">
                        <?php echo e($appointment->creator->name); ?></p>
                </div>

                <div class="col-4 col-md-2">
                    <div class="visible-print text-center">
                        <?php echo QrCode::color(68, 95,
                        129)->size(60)->style('round')->eye('circle')->generate($appointment->code); ?>

                        <p class="mt-1 mb-0 text-xs fw-bold text-gray-300"><?php echo e($appointment->code); ?></p>
                    </div>
                </div>
            </div>

            <hr>

            <div class="px-2 px-lg-5 mt-4">

                <div class="d-flex justify-content-between align-items-center px-lg-5 mb-3">
                    <div class="me-2">
                        <i class="fas fa-stethoscope me-2 text-gray-400"></i>
                        <span id="service_final_info">
                            <?php echo e($appointment->service_item->name); ?>

                        </span>
                    </div>
                    <div id="service_price_final_info" class="text-center">
                        <?php if($appointment->invoice_item): ?>
                        <?php echo e($appointment->invoice_item->price); ?> <small class="text-gray-300 text-xxxs">
                            <?php echo e(__('basic.egp')); ?></small>
                        <?php else: ?>
                        No fees
                        <?php endif; ?>
                    </div>
                </div>


                <div class="d-flex justify-content-between align-items-center px-lg-5 mb-3">
                    <div class="me-2">
                        <i class="fas fa-percent me-2 text-gray-400"></i> <?php echo e(__('basic.discount')); ?>

                    </div>
                    <div id="discount_amount_place" class="text-center text-decoration-line-through">
                        <?php if($appointment->invoice_item): ?>
                        <?php if(!empty($invoice->invoice_item->invoice->discount)): ?>
                        <?php echo e($appointment->invoice_item->invoice->discount); ?> <small class="text-gray-300 text-xxxs">
                            <?php echo e(__('basic.egp')); ?></small>
                        <?php else: ?>
                        0
                        <?php endif; ?>
                        <?php else: ?>
                        No fees
                        <?php endif; ?>
                    </div>
                </div>

                <div class="d-flex justify-content-between align-items-center px-lg-5 mb-4">
                    <div class="me-2 fw-bold">
                        <i class="fas fa-dollar-sign me-2"></i> <?php echo e(__('basic.total price')); ?>

                    </div>
                    <div id="price_total_final_info" class="fw-bold text-center">

                        <?php if($appointment->invoice_item): ?>
                        <?php echo e($appointment->invoice_item->invoice->final_price); ?> <small class="text-gray-300 text-xxxs">
                            <?php echo e(__('basic.egp')); ?></small>
                        <?php else: ?>
                        No fees
                        <?php endif; ?>
                    </div>
                </div>

                <div class="row mb-2 px-lg-5">
                    <div class="mb-3">
                        <label class="form-label text-gray-300"><?php echo e(__('basic.note')); ?></label>
                        <div class="form-control-textarea overflow-auto"><?php echo e($appointment->note); ?>

                        </div>
                    </div>
                </div>

                <?php $__errorArgs = ['appointment_note'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                <span class="error-msg-form">
                    <?php echo e($message); ?>

                </span>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                <div class="row align-items-center main-color-bg text-white px-lg-5 b-r-s-cont px-4 py-4">
                    <div class="col-12 col-md text-blue-300 mb-2 mb-md-0">
                        <?php echo e(__('patientappo.come before 15 msg')); ?>

                    </div>
                    <div class="col-12 col-md text-center">

                        <h6 class="text-xs mb-1 text-blue-300"><?php echo e(__('basic.appointment time')); ?></h6>
                        <p id="date_final_info" class="text-l fs-4 fw-bold mb-0">
                            <?php echo e(date('h:i a', strtotime($appointment->start_at)) . ' to ' . date('h:i a',
                            strtotime($appointment->end_at))); ?>

                        </p>
                        <p id="time_final_info" class="text-s text-blue-200">
                            <?php echo e(date('d M Y', strtotime($appointment->start_at))); ?></p>
                    </div>

                </div>

            </div>

        </div>

    </div>
</div>

<?php $__env->stopSection(); ?>

<!-- js insert -->
<?php $__env->startSection('js'); ?>

<script>
    //copy online appointment url
        $(document).on('click', '.copy_clipboard', function() {
            var copyText = $(this).data('url');

            var textarea = document.createElement("textarea");
            textarea.textContent = copyText;
            textarea.style.position = "fixed"; // Prevent scrolling to bottom of page in MS Edge.
            document.body.appendChild(textarea);
            textarea.select();
            document.execCommand("copy");

            document.body.removeChild(textarea);
        });
</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/proxima/resources/views/branch/appointment/show.blade.php ENDPATH**/ ?>