<?php $__env->startSection('title', 'Debtors | Proxima - Medical Management app'); ?>

<?php $__env->startSection('title-topbar', 'Debtors'); ?>

<!-- css insert -->
<?php $__env->startSection('css'); ?>

    <!-- tables -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/5.0.1/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/1.11.2/css/dataTables.bootstrap5.min.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.0.1/css/buttons.bootstrap5.min.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/autofill/2.3.9/css/autoFill.bootstrap5.min.css">

<?php $__env->stopSection(); ?>


<!-- content insert -->
<?php $__env->startSection('content'); ?>

    <div class="container-fluid px-0 px-md-2 mt-3">

        <!-- page title link -->
        <div class="d-flex align-items-center justify-content-between mb-3">
            <span class="mb-0">
                <a class="link-cust-text text-gray-200 fw-light" href="<?php echo e(route('sett.home')); ?>">Dashboard |</a>
                <a class="link-cust-text text-gray-200 fw-light" href="<?php echo e(route('sett.invoice.index')); ?>">Invoice | </a>
                <a class="text-gray-300">Invoice show</a>
            </span>

            <div class="d-flex justify-content-center">
                <a href="#"
                    class="d-none bg-white d-sm-inline-block btn btn-sm shadow-sm b-r-l-cont p-2 px-4 text-gray-400 me-2"><i
                        class="fas fa-download fa-sm text-gray-300 me-2"></i> Print</a>
            </div>

        </div>

        <div class="card card-input shadow mb-3 pb-3">
            <!-- Card Header - Dropdown -->
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                <h6 class="m-0 fw-bold text-gray-500"><i class="fas fa-x-ray me-1"></i> Debtor result</h6>
            </div>


            <!-- Card Body -->
            <div class="card-body px-4 px-md-5">

                <div class="row px-0 px-md-3 px-lg-5 pt-3">

                    <div class="col-9 mb-2">

                        <div class="row mb-2">
                            <div class="d-flex mb-2 align-items-center">

                                <img class="rounded-circle avatar-lg me-3"
                                    src="<?php echo e(URL::asset('img/useravatar/' . $debtor->avatar)); ?>">
                                <div class="">
                                    <p class=" mb-0 text-xs text-gray-300">
                                        Receiver</p>
                                    <a class="mb-1 fw-bold fs-5 text-gray-600"><?php echo e($debtor->name); ?></a>
                                    <p class="mb-0 text-xs text-gray-400">ID <strong>
                                            <?php echo e($debtor->id); ?></strong>
                                    </p>
                                </div>
                            </div>
                        </div>

                    </div>

                    <div class="col-3 align-self-center">
                        <div class="">
                            <h6 class="text-gray-300 text-xs mb-0">Company Name</h6>
                            <p id="addre_final_info" class="text-gray-600 fs-3 fw-bold mb-0"><?php echo e($debtor->company_name); ?>

                            </p>
                        </div>
                    </div>
                </div>

                <hr>

                <div class="row px-0 px-md-3 px-lg-5 my-4">

                    <div class="col-12">


                        <div class="table-responsive">
                            <table class="table display datatable-modal" id="table-debitor" width="100%" cellspacing="0">
                                <thead>
                                    <tr>
                                        <th class="text-xs">Name</th>
                                        <th class="text-xs text-center">Branch</th>
                                        <th class="text-xs text-center">Amount</th>
                                        <th class="text-xs text-center">Status</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $invoice; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if($item->status == 0): ?>
                                            <?php
                                                $text_color_invoice = 'cancel-color-btn';
                                                $msg_invoice = 'Not Paid';
                                            ?>
                                        <?php elseif($item->status == 1): ?>
                                            <?php
                                                $text_color_invoice = 'pend-color-btn';
                                                $msg_invoice = __('basic.pending');
                                            ?>
                                        <?php elseif($item->status == 2): ?>
                                            <?php
                                                $text_color_invoice = 'done-color-btn';
                                                $msg_invoice = 'Paid';
                                            ?>
                                        <?php endif; ?>

                                        <tr>
                                            <td class="text-truncate"><a class="text-gray-600"
                                                    href="<?php echo e(route('sett.invoice.show', $item->id)); ?>">
                                                    <?php echo e($item->code); ?></a>
                                            </td>

                                            <td class="text-center">
                                                <?php echo e($item->branch->name); ?>

                                            </td>

                                            <td class="text-center">
                                                <?php if(!empty($item->paid)): ?>
                                                    <?php echo e($item->paid); ?> <small class="text-gray-300 text-xxxs">
                                                        EGP</small>
                                                <?php endif; ?>
                                            </td>

                                            <td class="text-center"> <span
                                                    class="badge rounded-pill <?php echo e($text_color_invoice); ?> badge-padd-l"><?php echo e($msg_invoice); ?></span>
                                            </td>


                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                </tbody>
                            </table>
                        </div>

                    </div>

                </div>



            </div>

        </div>

    <?php $__env->stopSection(); ?>

    <!-- js insert -->
    <?php $__env->startSection('js'); ?>

        <!-- -- datatables plugin -- -->
        <script type="text/javascript" src="https://cdn.datatables.net/1.11.3/js/jquery.dataTables.min.js"></script>
        <script type="text/javascript" src="https://cdn.datatables.net/1.11.3/js/dataTables.bootstrap5.min.js"></script>
        <script type="text/javascript" src="https://cdn.datatables.net/buttons/2.0.1/js/dataTables.buttons.min.js"></script>
        <script type="text/javascript" src="https://cdn.datatables.net/buttons/2.0.1/js/buttons.bootstrap5.min.js"></script>

        <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
        <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
        <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
        <script type="text/javascript" src="https://cdn.datatables.net/buttons/2.0.1/js/buttons.html5.min.js"></script>

        <script type="text/javascript" language="javascript"
                src="https://cdn.datatables.net/buttons/2.0.1/js/buttons.print.min.js"></script>

        <script type="text/javascript" language="javascript"
                src="https://cdn.datatables.net/buttons/2.0.1/js/buttons.colVis.min.js"></script>


        <script>
            $(document).ready(function() {

                var table = $('#table-debitor').DataTable({
                        lengthChange: false,
                        "pageLength": 5,
                        "order": [
                            [0, "ASC"]
                        ],
                        buttons: {
                            dom: {
                                button: {
                                    className: 'btn btn-table-export me-0' //Primary class for all buttons
                                }
                            },
                            buttons: ['copy', 'excel', 'pdf']
                        }
                    }

                );
                table.buttons().container()
                    .appendTo('#table-debitor_wrapper .col-md-6:eq(0)');

            });
        </script>
    <?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/proxima/resources/views/invoice/debtors.blade.php ENDPATH**/ ?>