<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title><?php echo e($patient->first_name); ?> Prescription</title>
    <link rel="stylesheet" href="<?php echo e(public_path('css/kv-mpdf-bootstrap.css')); ?>">

</head>

<body>

    <!-- Patient Info -->
    <div class="card-body px-4">

        <div class="row mb-3 b-r-s-cont border2 py-3 px-2">

            <div class="col-xs-5 text-truncate p-0" style="">
                <div class="w-10">
                    <div class="p-0" style="width: 25%;float: left;">
                        <div class="rounded-circle avatar-m2 profile_img"
                            style="background-image: url(<?php echo e(public_path('img/useravatar/' . $patient->avatar)); ?>)">
                        </div>
                    </div>

                    <div class="text-truncate p-0" style="width: 75%;float: left;">
                        <p class="m-0 p-0 text-s fw-bold2 text-truncate">
                            <?php echo e($patient->first_name . ' ' . $patient->second_name); ?></p>
                        <p class="m-0 p-0 text-xs">AFN <span class="fw-bold2"><?php echo e($patient->new_id); ?></span></p>
                        <p class="m-0 p-0 text-xs">BFN <span class="fw-bold2"><?php echo e($patient->new_branch_id); ?></span></p>
                    </div>
                </div>
            </div>

            <div class="col-xs-2">
                <p class="text-s mb-0">Date</p>
                <?php if(count($patient->prescriptions) > 0): ?>
                <p class="fw-bold2"><?php echo e($patient->prescriptions[0]->date); ?></p>
                <?php endif; ?>
            </div>
        </div>

        <!-- Medicenes -->
        <div class="row mb-3 px-0 mx-0">
            <div class="col-xs-12 px-0">
                <h4 class="fw-bold2">R</h4>
                <div class="table-responsive">
                    <table class="table-responsive text-s1 w-100">
                        <thead>
                            
                        </thead>

                        <tbody>
                            <?php if(count($patient->prescriptions) > 0): ?>

                            <?php $__currentLoopData = $patient->prescriptions[0]->medicines; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr style="word-wrap: break-word;" class="pb-2">
                                <td class="fw-bold2 pb-2">
                                    <?php echo e($item->medicinescats->name); ?>

                                </td>
                                <td class="fw-bold2 text-right" style="direction: rtl">
                                    <?php if($item->qty > 1): ?>
                                    <span>
                                        <?php echo e($item->qty); ?>

                                    </span>
                                    <?php endif; ?>

                                    <span>
                                        <?php echo e($item->medicine_type->name); ?>

                                    </span>
                                    <span>
                                        <?php echo e($item->dose->name); ?>

                                    </span>
                                    <?php if($item->med_duration_id > 1): ?>
                                    <span> لمدة </span>
                                    <span>
                                        <?php echo e($item->duration->name); ?>

                                    </span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            <?php endif; ?>
                        </tbody>

                    </table>
                </div>
            </div>
        </div>


        <?php if(count($patient->prescriptions) > 0): ?>

        <?php if($patient->prescriptions[0]->appointment): ?>
        <?php if($patient->prescriptions[0]->appointment->doctor): ?>
        <h4 class="text-s">Responsible Doctor: <?php echo e($patient->prescriptions[0]->appointment->doctor->first_name); ?></h4>
        <?php endif; ?>
        <?php endif; ?>

        <?php endif; ?>
    </div>


</body>

</html><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/proxima/resources/views/patient/print_pre.blade.php ENDPATH**/ ?>