<?php $__env->startSection('title', 'Complaints | Proxima - Medical Management app'); ?>

<?php $__env->startSection('title-topbar', 'Complaints'); ?>

<!-- css insert -->
<?php $__env->startSection('css'); ?>

<?php $__env->stopSection(); ?>

<!-- content insert -->
<?php $__env->startSection('content'); ?>
    <div class="container-fluid px-2 mt-3">


        <div class="row mb-2">
            <div class="col-12" id="rate-cont-ajax">

            </div>
        </div>



    </div>

<?php $__env->stopSection(); ?>

<!-- js insert -->
<?php $__env->startSection('js'); ?>

    <script>
        $(document).ready(function() {

            //--------------------- fetch appoingtments -------------------

            rate_ajax();

            function rate_ajax() {

                $.ajax({
                    url: '<?php echo e(route('sett.complaint.create')); ?>',
                    type: "GET",
                    dataType: "json",
                    success: function(data) {

                        if (data.length > 0) {

                            var html = ''

                            $.each(data, function(key, value) {
                                var url_show = "<?php echo e(URL::asset('img/useravatar/')); ?>" +
                                    "/" +
                                    value.patient.avatar;

                                html +=
                                    '<div class="row align-items-center shadow b-r-s-cont bg-white overflow-scroll p-4 mb-3">' +

                                    '<div class="col-5 d-flex align-items-center">' +
                                    '<img class="rounded-circle avatar-m2 me-3" src="' +
                                    url_show + '">' +
                                    '<div class="">' +
                                    '<p class=" mb-0 text-xs text-gray-300">Patient</p>' +
                                    '<h6 class="mb-1 fw-bold text-gray-600">' +
                                    value.patient.name +
                                    '</h6>' +
                                    '<p class="mb-0 text-xs text-gray-400">ID <strong>' +
                                    +value.patient.id +
                                    '</strong></p>' +
                                    '</div></div>' +

                                    '<div class="col text-center">' +
                                    '<h6 class="text-gray-300 text-xs mb-1">Appointment time</h6>' +
                                    '<h6 class="text-s text-gray-400 text-truncate">' + value
                                    .start_at +
                                    '</h6></div>' +

                                    '<div class="col text-center mt-3 mt-md-0">' +
                                    '<a data-id="' + value.id +
                                    '" class="click-rate active-color-btn btn btn-sm shadow-sm b-r-l-cont p-2 px-4"><i class="fas fa-star-half-alt fa-sm me-1"></i> Complaint</a>' +
                                    '</div>' +
                                    '</div>'
                            })

                            $('#rate-cont-ajax').html(html);
                        } else {
                            $('#rate-cont-ajax').html(
                                '<div class="text-center text-gray-400">' +
                                '<div><i class="far fa-laugh-wink fs-3 mb-1"></i></div>' +
                                'No Appointment to rate</div>');
                        }


                    }

                })

                timer = setTimeout(function() {
                    rate_ajax();
                }, 10000);

            };


            $(document).on('click', '.click-rate', function() {

                var appointment_id = $(this).data("id");
                var doctor_id = $(this).data("doctor_id");

                window.clearTimeout(timer);

                $('#rate-cont-ajax').html(
                    '<div class="align-items-center shadow b-r-s-cont bg-white overflow-scroll p-4 py-5 text-center">' +
                    '<i class="fas fa-keyboard text-gray-500 fs-1"></i>  <h5 class="text-gray-300 mb-4 text-center">Write here your complaint</h5>' +

                    '<div class="d-flex mb-3 justify-content-center">' +

                    '<textarea name="note" class="form-control" placeholder="Write here your notes .." rows="4" spellcheck="false"></textarea>' +

                    '</div>'
                );
            });

            //rate insert
            $(document).on('click', '.rate-insert', function() {

                var appointment_id = $(this).data("id");
                var rate_number = $(this).data("rate");

                var url = "<?php echo e(route('sett.app_rate_update', ':id')); ?>";
                url = url.replace(':id', appointment_id);

                $.ajax({
                    url: url,
                    type: "POST",
                    data: {
                        '_token': "<?php echo e(csrf_token()); ?>",
                        '_method': "PATCH",
                        'rate_number': rate_number,
                    },
                    success: function(data) {
                        $('#rate-cont-ajax').html(
                            '<div class="align-items-center text-center shadow b-r-s-cont bg-white overflow-scroll p-4 py-5">' +
                            '<i class="far fa-laugh-wink text-xxl main-color text-center mb-3" > </i>' +
                            '<h5 class="text-gray-400 mb-1">' + data + '</h5>' +
                            '</div>' +
                            '</div>'
                        )

                        setTimeout(function() {
                            rate_ajax()
                        }, 3000)

                    }
                });
            });

        });
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/proxima/resources/views/branch/Complaint.blade.php ENDPATH**/ ?>