<?php $__env->startSection('title', 'Follow up | Proxima - Medical Management app'); ?>

<?php $__env->startSection('title-topbar', __('basic.op follow up')); ?>

<!-- css insert -->
<?php $__env->startSection('css'); ?>
    <!-- select 2 -->
    <link href="https://fastly.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

    <!-- boostrap datepicker -->
    <link rel="stylesheet"
        href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.1/css/bootstrap-datepicker3.css" />
<?php $__env->stopSection(); ?>

<!-- content insert -->
<?php $__env->startSection('content'); ?>

    <div class="container-fluid px-2 mt-3">

        <!-- page title link -->
        <div class="d-flex align-items-center justify-content-center">

            <div class="d-flex justify-content-center mt-2 mt-md-0 ms-auto">

                <a class="main-color-bg text-white btn btn-sm shadow-sm b-r-l-cont p-2 px-4 me-1" data-bs-toggle="modal"
                    data-bs-target="#new_record"><i class="fas fa-filter fa-sm me-1"></i> Filter</a>

                <!-- Modal for search filtering -->
                <div class="modal fade" id="new_record" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
                    aria-hidden="true">
                    <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">

                        <form class="mb-0" action="<?php echo e(route('sett.index_inactive_patient')); ?>" method="GET"
                            style="display: contents">

                            <div class="modal-content b-r-s-cont border-0">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="exampleModalLabel"><i class="fas fa-clipboard me-1"></i>
                                        Search Filter</h5>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                        aria-label="Close"></button>
                                </div>

                                <!-- Modal content -->
                                <div class="modal-body px-5 py-3">

                                    <div class="row">

                                        <div class="col-12 mb-2">
                                            <label class="form-label">Specialty
                                                <small>(optional)</small></label>
                                            <select
                                                class="myselect2-record-insert myselect2-record-insert-nosearch select2-hidden-accessible"
                                                id="specialty" name="specialty">
                                                <option value="">
                                                    All
                                                </option>
                                                <?php $__currentLoopData = $specialty_cat; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($item->id); ?>" <blade
                                                        if|%20(%24specialty%20%3D%3D%20%24item-%3Eid)%20selected%20%40endif>
                                                        <blade
                                                            if|%20(%24specialty%20%3D%3D%20%24item-%3Eid)%20selected%20%40endif%3E>
                                                            <?php echo e($item->name); ?>

                                                    </option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>

                                        <div class="col-12 mb-2">
                                            <label class="form-label">Branch
                                                <small>(optional)</small></label>
                                            <select
                                                class="myselect2-record-insert myselect2-record-insert-nosearch select2-hidden-accessible"
                                                id="branch" name="branch">
                                                <option value="">
                                                    All
                                                </option>
                                                <?php $__currentLoopData = $branches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($item->id); ?>" <blade
                                                        if|%20(%24branch%20%3D%3D%20%24item-%3Eid)%20selected%20%40endif>
                                                        <blade
                                                            if|%20(%24branch%20%3D%3D%20%24item-%3Eid)%20selected%20%40endif%3E>
                                                            <?php echo e($item->name); ?>

                                                    </option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>

                                        <div class="col-12 mb-2">
                                            <label class="form-label">From
                                                <small>(optional)</small></label>
                                            <div class="input-group">
                                                <div class="input-group-prepend">
                                                    <div class="input-group-text"><i class="bi bi-calendar2-week-fill"></i>
                                                    </div>
                                                </div>
                                                <input name="from" type="text" class="form-control hasdatetimepicker"
                                                    value="<?php echo e($from); ?>" placeholder="YYYY/MM">
                                            </div>
                                        </div>

                                        <div class="col-12 mb-2">
                                            <label class="form-label">To
                                                <small>(optional)</small></label>
                                            <div class="input-group">
                                                <div class="input-group-prepend">
                                                    <div class="input-group-text"><i class="bi bi-calendar2-week-fill"></i>
                                                    </div>
                                                </div>
                                                <input name="to" type="text" class="form-control hasdatetimepicker"
                                                    value="<?php echo e($to); ?>" placeholder="YYYY/MM">
                                            </div>
                                        </div>
                                    </div>

                                </div>

                                <div class="modal-footer">
                                    <div class="left-side">
                                        <button type="button" class="btn btn-default btn-link"
                                            data-bs-dismiss="modal">Never
                                            Mind</button>
                                    </div>
                                    <div class="divider"></div>
                                    <div class="right-side">
                                        <button type="submit" class="btn btn-default btn-link main-color">Search</button>
                                    </div>
                                </div>
                            </div>
                        </form>

                    </div>

                </div>
            </div>

        </div>

        <div class="row mb-3">
            <ul class="nav nav-tabs nav-tabs-nobg nav-tabs-cat justify-content-center pe-0" id="myTab" role="tablist">
                <li class="nav-item" role="presentation">
                    <a href="<?php echo e(route('sett.op_follow_up')); ?>" class="nav-link" id="year_invoice-tab">
                        <?php echo e(__('basic.no action')); ?></a>
                </li>
                <li class="nav-item" role="presentation">
                    <a href="<?php echo e(route('sett.op_follow_up_inprog')); ?>" class="nav-link active" id="specialty-tab">
                        <?php echo e(__('basic.in progress')); ?></a>
                </li>
                <li class="nav-item" role="presentation">
                    <a href="<?php echo e(route('sett.op_follow_up_today')); ?>" class="nav-link" id="specialty-tab">
                        <?php echo e(__('basic.daily notify')); ?></a>
                </li>
                <li class="nav-item" role="presentation">
                    <a href="<?php echo e(route('sett.op_follow_up_done')); ?>" class="nav-link" id="specialty-tab">
                        <?php echo e(__('basic.done')); ?></a>
                </li>
            </ul>
        </div>

        <div class="row">

            <?php if(count($op) > 0): ?>
                <?php $__currentLoopData = $op; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <!-- total inactive patients -->
                    <div class="col-xl-4 col-md-6 mb-4">
                        <div class="card shadow h-100 p-1 ">
                            <div class="card-body p-2 px-5 px-md-4">

                                <a href="<?php echo e(route('sett.op_follow_up_show', $item->id)); ?>">
                                    <div class="d-flex justify-content-between">

                                        <div class="d-flex">
                                            <i class="fas fs-1 fa-procedures me-2 align-self-center text-gray-400"></i>
                                            <div>
                                                <p class="text-xxs mb-0 text-gray-300">
                                                    <?php echo e(date('h:i a Y-m-d', strtotime($item->start_at))); ?>

                                                </p>
                                                <h6 class="mb-0 fw-bold text-gray-500"><?php echo e($item->service_item->name); ?>

                                                </h6>
                                                <p class="text-xxs mb-0 text-gray-300">Op place:
                                                    <?php echo e($item->place->name); ?>

                                                    <?php if(isset($item->doctor->first_name)): ?>
                                                        with
                                                        docotr <span class="fw-bold"><?php echo e($item->doctor->first_name); ?></span>
                                                    <?php endif; ?>
                                                </p>
                                            </div>
                                        </div>

                                        <div class="text-center">
                                            <p class="text-xs text-gray-200 mb-1">Status</p>
                                            <h6 class="text-s text-gray-400 text-truncate">
                                                <span class="badge rounded-pill prog-color-btn badge-padd-l">In
                                                    Progress</span>
                                            </h6>
                                        </div>

                                    </div>
                                </a>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php else: ?>
                <div class="text-center text-gray-500 fs-5"><i
                        class="bi bi-brightness-alt-high-fill fa-sm fa-fw fs-2"></i>
                    <p class="fw-light mb-0">No Op Follow up to show</p>
                </div>
            <?php endif; ?>
        </div>

        <div class="d-flex mt-4 justify-content-end">
            <?php echo e($op->appends(request()->input())->links()); ?>

        </div>

    <?php $__env->stopSection(); ?>

    <!-- js insert -->
    <?php $__env->startSection('js'); ?>

        <!-- select 2 -->
        <script src="https://fastly.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
        <script>
            $(document).ready(function() {

                $(".myselect2-record-insert").select2({
                    dropdownParent: $("#new_record")
                });

                //hide search
                $('.myselect2-record-insert-nosearch').select2({
                    dropdownParent: $("#new_record"),
                    minimumResultsForSearch: -1
                });

            })
        </script>

        <!-- jquery ui datepicker -->
        <script type="text/javascript"
            src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.1/js/bootstrap-datepicker.min.js"></script>
        <script>
            $(function() {
                $('.hasdatetimepicker').datepicker({
                    todayHighlight: true,
                    format: "mm-yyyy",
                    viewMode: "months",
                    minViewMode: "months"
                });
            });
        </script>
    <?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/medix/public_html/samirghoraba/med/resources/views/branch/operation/op_follow_up_inprog.blade.php ENDPATH**/ ?>