<?php $__env->startSection('title', 'Add Patient | Proxima - Medical Management app'); ?>

<?php $__env->startSection('title-topbar', 'Add Patient'); ?>

<!-- css insert -->
<?php $__env->startSection('css'); ?>

    <!-- select 2 -->
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

    <!-- boostrap datepicker -->
    <link rel="stylesheet"
        href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.1/css/bootstrap-datepicker3.css" />

    <!-- international telephone input -->
    <link href="<?php echo e(URL::asset('plugins/intltelinput/intlTelInput.css')); ?>" rel="stylesheet">


<?php $__env->stopSection(); ?>


<!-- content insert -->
<?php $__env->startSection('content'); ?>

    <div class="container-fluid px-2 mt-3">

        <!-- page title link -->
        <div class="d-sm-flex align-items-center justify-content-between mb-3">
            <span class="mb-0">
                <a class="link-cust-text text-gray-200 fw-light" href="<?php echo e(route('sett.home')); ?>">Dashboard |</a>
                <a class="link-cust-text text-gray-200 fw-light"
                    href="<?php echo e(route('sett.patient.index')); ?>"><?php echo e(__('basic.patient')); ?> | </a>
                <a class="text-gray-300"><?php echo e(__('patientappo.new patient')); ?></a>
            </span>
        </div>

        <div class="card card-input shadow mb-3 pb-3">
            <!-- Card Header - Dropdown -->
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                <h6 class="m-0 fw-bold text-gray-500"><i class="fas fa-user me-2"></i> <?php echo e(__('patientappo.new patient')); ?>

                </h6>
            </div>

            <!-- Card Body -->
            <div class="card-body px-3">

                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="text-red"><i class="fas fa-exclamation me-1"></i> <?php echo e($error); ?></div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                <div class="multi-setps-form-calander col-12">

                    <form id="myform" method="POST" action="<?php echo e(route('sett.patient.store')); ?>"
                        enctype="multipart/form-data">

                        <?php echo csrf_field(); ?>

                        <!-- progressbar -->
                        <ul class="ps-0 progressbar" id="progressbar">
                            <li class="active">

                                <a>
                                    <!-- in case we want to use prog selector href="#clinics" -->
                                    <div class="icon-circle checked d-flex align-items-center justify-content-center">
                                        <i class="bi bi-gear"></i>
                                    </div>
                                    <?php echo e(__('patientappo.basic')); ?>

                                </a>
                            </li>

                            <li>
                                <a>
                                    <div class="icon-circle d-flex align-items-center justify-content-center">
                                        <i class="bi bi-person"></i>
                                    </div>
                                    <?php echo e(__('patientappo.personal')); ?>

                                </a>
                            </li>

                            <li>
                                <a>
                                    <div class="icon-circle d-flex align-items-center justify-content-center">
                                        <i class="bi bi-pin-map"></i>
                                    </div>
                                    <?php echo e(__('basic.medical')); ?>


                                </a>
                            </li>
                            <li>
                                <a>
                                    <div class="icon-circle d-flex align-items-center justify-content-center">
                                        <i class="far fa-paper-plane"></i>
                                    </div>
                                    <?php echo e(__('basic.sending')); ?>

                                </a>
                            </li>
                        </ul>

                        <!-- content -->

                        <div class="cont_tap " id="clinics">

                            <div class="row mb-1">

                                <div class="col-12 col-md-5 align-self-center mb-2">

                                    <div class="avatar-update-container">
                                        <div class="picture">
                                            <img src="<?php echo e(URL::asset('img/dashboard/avatars/default-pp.png')); ?>"
                                                class="picture-src" id="mib_PicturePreview" title="" />
                                            <input type="file" name='avatar' accept="image/*" id="mib_img_input">
                                        </div>
                                        <h6 class="text-gray-300"><?php echo e(__('basic.choose pic')); ?></h6>

                                        <?php $__errorArgs = ['avatar'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="error-msg-form">
                                                <?php echo e($message); ?>

                                            </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>


                                </div>

                                <div class="col-12 col-md-7 mb-2">
                                    <div class="mb-3">
                                        <label class="form-label"><?php echo e(__('patientappo.first name')); ?>

                                            <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                        <input name="first_name" type="text"
                                            class="form-control <?php $__errorArgs = ['first_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            placeholder="Write your first name here" required
                                            value="<?php echo e(old('first_name')); ?>">
                                    </div>

                                    <?php $__errorArgs = ['first_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="error-msg-form">
                                            <?php echo e($message); ?>

                                        </span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                    <div class="mb-3">
                                        <label class="form-label"><?php echo e(__('patientappo.second name')); ?>

                                            <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                        <input name="second_name" type="text"
                                            class="form-control <?php $__errorArgs = ['second_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            placeholder="Write your second name here" required
                                            value="<?php echo e(old('second_name')); ?>">
                                    </div>

                                    <?php $__errorArgs = ['second_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="error-msg-form">
                                            <?php echo e($message); ?>

                                        </span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                            </div>

                            <div class="row mb-2">

                                <div class="col-12 col-md-6 mb-2">
                                    <label class="form-label"><?php echo e(__('patientappo.email')); ?>

                                        <small>(<?php echo e(__('basic.optional')); ?>)</small></label>
                                    <input name="email" type="text"
                                        class="form-control <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        placeholder="Yousef@gmail.com..." value="<?php echo e(old('email')); ?>">
                                    <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="error-msg-form">
                                            <?php echo e($message); ?>

                                        </span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div class="col-12 col-md-6 mb-2">
                                    <label class="form-label"><?php echo e(__('patientappo.mother name')); ?>

                                        <small>(<?php echo e(__('basic.optional')); ?>)</small></label>
                                    <input name="mother_name" type="text"
                                        class="form-control <?php $__errorArgs = ['mother_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        placeholder="Write your mother's name here" value="<?php echo e(old('mother_name')); ?>">

                                    <?php $__errorArgs = ['mother_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="error-msg-form">
                                            <?php echo e($message); ?>

                                        </span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                            </div>


                            <div class="row mb-2">
                                <div class="col-12 col-md-6 mb-2">
                                    <label class="form-label"><?php echo e(__('patientappo.password')); ?>

                                        <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                    <input id="password" name="password" type="password"
                                        class="form-control <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        placeholder="Wrtie your password here..." required>

                                    <?php if($errors->has('password')): ?>
                                        <span class="error-msg-form">
                                            <?php echo e($errors->first('password')); ?>

                                        </span>
                                    <?php else: ?>
                                        <div class="form-text text-gray-200">The automatic password is 'prox' + the given
                                            username
                                        </div>
                                    <?php endif; ?>
                                </div>


                                <div class="col-12 col-md-6 mb-2">
                                    <label class="form-label"><?php echo e(__('patientappo.confirm password')); ?>

                                        <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                    <input name="password_confirmation" type="password" class="form-control"
                                        placeholder="Confirm your password..." id="password-confirm" required>
                                </div>

                            </div>

                            <div class="d-flex justify-content-end mt-3">
                                <input type="button" name="next"
                                    class="next-form-steps btn btn-primary action-button-next" value="Continue" />
                            </div>
                        </div>


                        <div class="cont_tap" id="time">

                            <div class="row mb-2">

                                <div class="col-12 col-md-4 mb-2">
                                    <label class="form-label"><?php echo e(__('basic.status')); ?>

                                        <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                    <select
                                        class="js-example-basic-single select2-no-search select2-hidden-accessible <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        name="status" required>
                                        <option value="1"><?php echo e(__('basic.old patient')); ?></option>
                                        <option value="2"><?php echo e(__('basic.leads no action')); ?></option>
                                        <option value="3"><?php echo e(__('basic.leads interested')); ?></option>
                                        <option value="4"><?php echo e(__('basic.leads not interested')); ?></option>
                                    </select>
                                    <div id="status-js-error-valid"></div>

                                    <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="error-msg-form">
                                            <?php echo e($message); ?>

                                        </span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div class="col-12 col-md-4 mb-2">
                                    <label class="form-label"><?php echo e(__('basic.ask for')); ?>

                                        <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                    <select
                                        class="js-example-basic-single select2-no-search select2-hidden-accessible <?php $__errorArgs = ['ask_for_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        name="ask_for_id" required>
                                        <?php $__currentLoopData = $ask_for; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($item->id); ?>"><?php echo e($item->name); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <div id="ask_for_id-js-error-valid"></div>

                                    <?php $__errorArgs = ['ask_for_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="error-msg-form">
                                            <?php echo e($message); ?>

                                        </span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div class="col-12 col-md-4 mb-2">
                                    <label class="form-label"><?php echo e(__('basic.branch')); ?>

                                        <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                    <select
                                        class="js-example-basic-single select2-no-search select2-hidden-accessible <?php $__errorArgs = ['first_branch_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        name="first_branch_id" required>
                                        <?php $__currentLoopData = $branches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($item->id); ?>"><?php echo e($item->name); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <div id="first_branch_id-js-error-valid"></div>

                                    <?php $__errorArgs = ['first_branch_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="error-msg-form">
                                            <?php echo e($message); ?>

                                        </span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                            </div>

                            <hr>

                            <div class="row mb-2">

                                <div class="col-12 col-md-6 mb-2">
                                    <label class="form-label"><?php echo e(__('patientappo.gendar')); ?>

                                        <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                    <select
                                        class="js-example-basic-single select2-no-search select2-hidden-accessible <?php $__errorArgs = ['gendar'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        name="gendar" required>
                                        <option value="male"><?php echo e(__('patientappo.male')); ?></option>
                                        <option value="female"><?php echo e(__('patientappo.female')); ?></option>
                                    </select>
                                    <div id="gendar-js-error-valid"></div>

                                    <?php $__errorArgs = ['gendar'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="error-msg-form">
                                            <?php echo e($message); ?>

                                        </span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div class="col-12 col-md-6 mb-2">

                                    <label class="form-label"><?php echo e(__('patientappo.birthday')); ?>

                                        <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                    <div class="input-group">
                                        <div class="input-group-prepend">
                                            <div class="input-group-text"><i class="bi bi-calendar2-week-fill"></i>
                                            </div>
                                        </div>
                                        <input name="birthday" type="text"
                                            class="form-control hasdatetimepicker <?php $__errorArgs = ['birthday'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            placeholder="YYYY/MM/DD" required value="<?php echo e(old('birthday')); ?>">
                                    </div>
                                    <div id="birthday-js-error-valid"></div>

                                    <?php $__errorArgs = ['birthday'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="error-msg-form">
                                            <?php echo e($message); ?>

                                        </span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                </div>

                            </div>

                            <hr>

                            <div class="row mb-2">

                                <div class="col-12 col-md-4 mb-2">
                                    <label class="form-label"><?php echo e(__('patientappo.country')); ?>

                                        <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                    <select
                                        class="js-example-basic-single select2-hidden-accessible <?php $__errorArgs = ['country_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        name="country_id" required>
                                        <?php $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $iteam): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($iteam->id); ?>"><?php echo e($iteam->name); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <div id="country-js-error-valid"></div>

                                    <?php $__errorArgs = ['country_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="error-msg-form">
                                            <?php echo e($message); ?>

                                        </span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                </div>

                                <div class="col-12 col-md-4 mb-2">
                                    <label class="form-label"><?php echo e(__('patientappo.city')); ?>

                                        <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                    <select
                                        class="js-example-basic-single select2-hidden-accessible <?php $__errorArgs = ['city_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        name="city_id" required>
                                        <option disabled selected>Open this select menu</option>
                                    </select>

                                    <div id="city-js-error-valid"></div>

                                    <?php if($errors->has('city_id')): ?>
                                        <span class="error-msg-form">
                                            <?php echo e($errors->first('city_id')); ?>

                                        </span>
                                    <?php else: ?>
                                        <div class="form-text text-gray-200"><?php echo e(__('patientappo.city msg')); ?>

                                        </div>
                                    <?php endif; ?>
                                </div>


                                <div class="col-12 col-md-4 mb-2">
                                    <label class="form-label"><?php echo e(__('patientappo.know us')); ?>

                                        <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                    <select
                                        class="js-example-basic-single select2-hidden-accessible select2-no-search <?php $__errorArgs = ['from_recourse_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        name="from_recourse_id">
                                        <?php $__currentLoopData = $from_recourses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $iteam): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($iteam->id); ?>"><?php echo e($iteam->name); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>

                                    <div id="from-recourse-js-error-valid"></div>

                                    <?php $__errorArgs = ['from_recourse_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="error-msg-form">
                                            <?php echo e($message); ?>

                                        </span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                </div>

                            </div>

                            <hr>

                            <div class="row mb-2">

                                <div class="col-12 col-md-6 mb-2">
                                    <label class="form-label"><?php echo e(__('patientappo.phone number')); ?>

                                        <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                    <input id="int-miphone" name="phone_number" type="tel"
                                        class="form-control <?php $__errorArgs = ['phone_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" required
                                        value="<?php echo e(old('phone_number')); ?>">

                                    <div id="phonenumber-js-error-valid"></div>

                                    <?php if($errors->has('phone_number')): ?>
                                        <span class="error-msg-form">
                                            <?php echo e($errors->first('phone_number')); ?>

                                        </span>
                                    <?php else: ?>
                                        <div class="form-text text-gray-200">We'll never share your email with anyone else.
                                        </div>
                                    <?php endif; ?>
                                </div>

                                <div class="col-12 col-md-6 mb-2">
                                    <label class="form-label"><?php echo e(__('patientappo.second phone number')); ?>

                                        <small>(<?php echo e(__('basic.optional')); ?>)</small></label>
                                    <input id="int-miphone2" name="sec_phone_number" type="tel"
                                        class="form-control <?php $__errorArgs = ['sec_phone_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        value="<?php echo e(old('sec_phone_number')); ?>">

                                    <div id="secphonenumber-js-error-valid"></div>

                                    <?php $__errorArgs = ['sec_phone_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="error-msg-form">
                                            <?php echo e($message); ?>

                                        </span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>


                                </div>


                            </div>

                            <div class="d-flex justify-content-between p-4">
                                <input type="button" name="previous"
                                    class="previous-form-steps btn btn-secondary action-button-previous"
                                    value="Previous" />
                                <input type="button" name="next"
                                    class="next-form-steps btn btn-primary action-button-next" value="Continue" />
                            </div>
                        </div>

                        <div class="cont_tap" id="about">


                            <div class="row mb-2">

                                <div class="col-12 col-md-6 mb-2">
                                    <label class="form-label"><?php echo e(__('patientappo.height')); ?>

                                        <small>(<?php echo e(__('basic.optional')); ?>)</small></label>
                                    <input name="height" type="number"
                                        class="form-control <?php $__errorArgs = ['height'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        placeholder="Write your height here" value="<?php echo e(old('height')); ?>">

                                    <?php $__errorArgs = ['height'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="error-msg-form">
                                            <?php echo e($message); ?>

                                        </span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                </div>

                                <div class="col-12 col-md-6 mb-2">
                                    <label class="form-label"><?php echo e(__('patientappo.weight')); ?>

                                        <small>(<?php echo e(__('basic.optional')); ?>)</small></label>
                                    <input name="weight" type="number"
                                        class="form-control <?php $__errorArgs = ['weight'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        placeholder="Write your weight here" value="<?php echo e(old('weight')); ?>">

                                    <?php $__errorArgs = ['weight'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="error-msg-form">
                                            <?php echo e($message); ?>

                                        </span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                </div>


                            </div>

                            <div class="row mb-2">

                                <div class="col-12 col-md-6 mb-2">
                                    <label class="form-label"><?php echo e(__('patientappo.blood type')); ?>

                                        <small>(<?php echo e(__('basic.optional')); ?>)</small></label>
                                    <input name="blood_type" type="text"
                                        class="form-control <?php $__errorArgs = ['blood_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        placeholder="Write your blood type here" value="<?php echo e(old('blood_type')); ?>">

                                    <?php $__errorArgs = ['blood_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="error-msg-form">
                                            <?php echo e($message); ?>

                                        </span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                </div>

                                <div class="col-12 col-md-6 mb-2">
                                    <label
                                        class="form-label"><?php echo e(__('patientappo.insurance')); ?><small>(<?php echo e(__('basic.optional')); ?>)</small></label>
                                    <input name="insurance" type="text"
                                        class="form-control <?php $__errorArgs = ['insurance'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        placeholder="Write your insurance company here" value="<?php echo e(old('insurance')); ?>">

                                    <?php $__errorArgs = ['insurance'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="error-msg-form">
                                            <?php echo e($message); ?>

                                        </span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                </div>
                            </div>

                            <div class="row mb-2">
                                <div class="mb-3">
                                    <label class="form-label"><?php echo e(__('basic.note')); ?>

                                        <small>(<?php echo e(__('basic.optional')); ?>)</small></label>
                                    <textarea name="note" class="form-control" placeholder="Write here your notes .." rows="4"
                                        spellcheck="false"><?php echo e(old('note')); ?></textarea>
                                </div>
                            </div>

                            <?php $__errorArgs = ['note'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                            <div class="d-flex justify-content-between p-4">
                                <input type="button" name="previous"
                                    class="previous-form-steps btn btn-secondary action-button-previous"
                                    value="Previous" />
                                <input type="submit" name="next"
                                    class="next-form-steps btn btn-primary action-button-next"
                                    value="<?php echo e(__('basic.send')); ?>" />
                            </div>
                        </div>

                        <div class="cont_tap" id="sending">
                            <div class="d-flex justify-content-center p2">
                                <img src="<?php echo e(URL::asset('img/dashboard/system/loading-dash.svg')); ?>"
                                    style="width: 195px;" alt="Loading" />
                            </div>
                        </div>

                    </form>
                </div>

            </div>

        </div>
    </div>

<?php $__env->stopSection(); ?>

<!-- js insert -->
<?php $__env->startSection('js'); ?>

    <!-- select 2 -->
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script>
        $(document).ready(function() {
            $('.js-example-basic-single').select2();
            //hide search
            $('.select2-no-search').select2({
                minimumResultsForSearch: -1
            });
        });
    </script>

    <!-- jquery ui datepicker -->
    <script type="text/javascript"
        src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.1/js/bootstrap-datepicker.min.js"></script>
    <script>
        $(function() {
            $('.hasdatetimepicker').datepicker({
                todayHighlight: true,
                format: "yyyy-mm-dd",
            }).on('change', function(){
                $('.datepicker').hide();
            });
        });
    </script>

    <!-- validate jquery -->
    <script src="https://cdn.jsdelivr.net/npm/jquery-validation@1.19.3/dist/jquery.validate.min.js" type="text/javascript">
    </script>
    <script>
        //Rules for the Validator plugin
        var $validator = $('#myform').validate({
            rules: {
                first_name: {
                    minlength: 3,
                },
                second_name: {
                    minlength: 3,
                },
                email: {
                    email: true,
                },
                password: {
                    minlength: 7,
                    maxlength: 100,
                },
                password_confirmation: {
                    minlength: 7,
                    maxlength: 100,
                    equalTo: '#password',
                },
            },
            messages: {
                email: {
                    required: "We need your email address to contact you",
                    email: "Your email address must be in the format of name@domain.com"
                },
                password_confirmation: {
                    equalTo: "Password does not match",
                }
            },
            //for inserting erros for some inputs that makes posation problem such as selector 2 and bt datapicker
            errorPlacement: function(error, element) {
                switch (element.attr("name")) {
                    case 'role':
                        error.insertAfter($("#role-js-error-valid"));
                        break;
                    case 'first_branch_id':
                        error.insertAfter($("#first_branch_id-js-error-valid"));
                        break;
                    case 'gendar':
                        error.insertAfter($("#gendar-js-error-valid"));
                        break;
                    case 'birthday':
                        error.insertAfter($("#birthday-js-error-valid"));
                        break;
                    case 'country':
                        error.insertAfter($("#country-js-error-valid"));
                        break;
                    case 'city':
                        error.insertAfter($("#city-js-error-valid"));
                        break;
                    case 'phone_number':
                        error.insertAfter($("#phonenumber-js-error-valid"));
                        break;
                    case 'sec_phone_number':
                        error.insertAfter($("#secphonenumber-js-error-valid"));
                        break;

                    default:
                        error.insertAfter(element);
                }

            },
        });
    </script>
    <script>
        //insert passwrod depends on the username
        $('input[name="first_name"]').keyup(function(e) {
            e.preventDefault();
            first_name = $(this).val();
            new_password = 'prox' + first_name;
            $('input[name="password"]').val(new_password);
            $('input[name="password_confirmation"]').val(new_password);
        })


        fetchCity();

        //for country and cities ajax inputs
        function fetchCity(countryID = $('select[name="country_id"]').val()) {

            var url = "<?php echo e(route('sett.createcityajax', ':id')); ?>";
            url = url.replace(':id', countryID);

            if (countryID) {
                $.ajax({
                    url: url,
                    type: "GET",
                    dataType: "json",
                    success: function(data) {
                        $('select[name="city_id"]').empty();
                        $.each(data, function(key, value) {
                            $('select[name="city_id"]').append('<option value="' +
                                value.id + '">' + value.name + '</option>');
                        });
                    }
                });
            } else {
                $('select[name="city_id"]').empty();
            }
        }

        $('select[name="country_id"]').on('change', function(e) {
            var country_id = $(this).val();
            fetchCity(country_id)
        });
    </script>




    <!-- international telephone input -->
    <script src="<?php echo e(URL::asset('plugins/intltelinput/intlTelInput.min.js')); ?>"></script>

    <script>
        //to enable international telephone input (#int-miphone) is where we need to insert it
        const phoneInputField = document.querySelector("#int-miphone");
        const phoneInput = window.intlTelInput(phoneInputField, {
            //preferred countries https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2
            preferredCountries: ["eg", "sa", "ae", "qa"],
            utilsScript: "<?php echo e(URL::asset('plugins/intltelinput/utils.js')); ?>",
        });
        const phoneInputField2 = document.querySelector("#int-miphone2");
        const phoneInput2 = window.intlTelInput(phoneInputField2, {
            //preferred countries https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2
            preferredCountries: ["eg", "sa", "ae", "qa"],
            utilsScript: "<?php echo e(URL::asset('plugins/intltelinput/utils.js')); ?>",
        });
    </script>



<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/drsamirghoraba/public_html/prox/proxima/resources/views/patient/create.blade.php ENDPATH**/ ?>