<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name='viewport' content='width=device-width, initial-scale=1.0, user-scalable=0'>
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="Description" content="Proxima for medical management">
    <meta name="Author" content="Proxima | medical management">
    <link rel="icon" type="image/x-icon" href="<?php echo e(URL::asset('img/dashboard/system/favicon.png')); ?>">
    <!-- Head and css files -->
    <?php echo $__env->make('layouts.includes.head', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</head>

<body>

    <!-- Page Loader -->
    <div class="loader-page justify-content-center align-items-center">
        <div class="loader-page-cont">
            <img src="<?php echo e(URL::asset('img/dashboard/system/loader.svg')); ?>" alt="">
            <div class="lds-ellipsis">
                <div></div>
                <div></div>
                <div></div>
                <div></div>
            </div>
        </div>
    </div>

    <!-- fixed content -->
    <?php echo $__env->yieldContent('fixedcontent'); ?>


    <!-- Page Wrapper -->
    <div id="wrapper" class="d-flex">

        <!-- side bar -->
        <?php echo $__env->make('layouts.includes.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <!-- Content right Wrapper -->
        <div id="content-wrapper" class="d-flex flex-column flex-grow-1">

            <!-- top bar -->
            <?php echo $__env->make('layouts.includes.topbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            <!-- Begin Page Content -->
            <?php echo $__env->yieldContent('content'); ?>
            <!-- End content Wrapper -->

            <!-- fotter -->
            <?php echo $__env->make('layouts.includes.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        </div> <!-- End content left Wrapper -->

    </div> <!-- End content Wrapper -->

    <!-- js scripts -->
    <?php echo $__env->make('layouts.includes.footer-script', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

</body>

</html><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/proxima/resources/views/layouts/master.blade.php ENDPATH**/ ?>