<?php $__env->startSection('title', 'Users'); ?>

<!-- css insert -->
<?php $__env->startSection('css'); ?>

    <!-- select 2 -->
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

<?php $__env->stopSection(); ?>

<!-- content insert -->
<?php $__env->startSection('content'); ?>
    <div class="container-fluid px-2 ">
        <div class="card card-input shadow mb-4">
            <!-- Card Header - Dropdown -->
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                <h6 class="m-0 fw-bold">Users table</h6>
                <div class="dropdown no-arrow">
                    <a class="dropdown-toggle" href="#" role="button" id="dropdownMenuLink" data-bs-toggle="dropdown"
                        aria-haspopup="true" aria-expanded="false">
                        <i class="fas fa-ellipsis-v fa-sm fa-fw text-gray-300"></i>
                    </a>
                    <div class="dropdown-menu dropdown-menu-right shadow animated--fade-in"
                        aria-labelledby="dropdownMenuLink">
                        <div class="dropdown-header">Dropdown Header:</div>
                        <a class="dropdown-item" href="#">Action</a>
                    </div>
                </div>
            </div>

            <!-- Card Body -->
            <div class="card-body p-5">

                <div class="d-flex justify-content-around align-items-center flex-wrap">

                    <div class="d-flex mb-4 align-items-center me-2 mb-2">
                        <img class="rounded-circle avatar-m me-3"
                            src="<?php echo e(URL::asset('img/dashboard/avatars/GGeMmsPz.jpeg')); ?>">
                        <div class="">
                            <p class=" mb-0 text-xs text-gray-300">
                                Patient</p>
                            <h5 class="mb-1 fw-bold text-gray-600">Ahmed Ibrahm</h5>
                            <p class="mb-0 text-xs text-gray-400">ID <strong> 2122</strong></p>
                        </div>
                    </div>

                    <div class="me-2">
                        <h6 class="text-gray-300 text-xs mb-1">Branch</h6>
                        <p class="text-gray-600 text-s fw-bold">Haram</p>
                    </div>

                    <div class="me-2">
                        <h6 class="text-gray-300 text-xs mb-1">Address</h6>
                        <p class="text-gray-600 text-s fw-bold">20 Dec 1992</p>
                    </div>
                </div>

                <hr>


                <div class="px-lg-5">
                    <div class="d-flex justify-content-between align-items-center px-lg-5 mb-3">
                        <div class="me-2">
                            <i class="fas fa-stethoscope me-2 text-gray-400"></i> Estimated days to find a buyer
                        </div>
                        <div class=" text-center">
                            $200,00
                        </div>
                    </div>

                    <div class="d-flex justify-content-between align-items-center px-lg-5 mb-3">
                        <div class="me-2">
                            <i class="fas fa-tag me-2 text-gray-400"></i> Coupon
                        </div>

                        <div class=" text-center">
                            <div class="input-group">
                                <input type="text" class="form-control" class="custom-select" id="coupon-input"
                                    style="border-radius: 5px 0px 0px 5px !important;" placeholder="Discount code here ..">
                                <div class="input-group-append">
                                    <button id="coupon-buttn" class="btn btn-outline-secondary" class="form-control "
                                        type="button">Send</button>
                                </div>
                            </div>
                            <div id="search-result-input"></div>

                        </div>
                    </div>

                    <div class="d-flex justify-content-between align-items-center px-lg-5 mb-3 d-none"
                        id="discount_amount_div">
                        <div class="me-2">
                            <i class="fas fa-percent me-2 text-gray-400"></i> Discount
                        </div>
                        <div id="discount_amount_place" class="text-center">
                            0
                        </div>
                    </div>

                    <div class="d-flex justify-content-between align-items-center px-lg-5 mb-4">
                        <div class="me-2 fw-bold">
                            <i class="fas fa-dollar-sign me-2"></i> Total price to pay
                        </div>
                        <div id="total_amount_place" class="fw-bold text-center">
                            $200,00
                        </div>
                    </div>

                    <div class="row align-items-center main-color-bg text-white px-lg-5 b-r-s-cont px-4 py-4">
                        <div class="col-12 col-md text-blue-300 mb-2 mb-md-0">
                            You should come 15 minutes before the appointment to finish the procedders
                        </div>
                        <div class="col-12 col-md text-center">

                            <h6 class="text-xs mb-1 text-blue-300">Appointment Time</h6>
                            <p class="text-l fs-4 fw-bold mb-0">10:00 AM - 12:00 PM</p>
                            <p class="text-s text-blue-200">Mondey 21 2017</p>
                        </div>
                        <input type="hidden" value="" id="search_patient_id" data-price='200'>

                    </div>

                </div>
            </div>



            <!-- Card footer -->
            <div class="card-footer text-center ">
                <a class="text-xs link-cust-text text-gray-300" href="#">
                    <i class="fas fa-chevron-down"></i> More
                </a>
            </div>

        </div>
    </div>
<?php $__env->stopSection(); ?>

<!-- js insert -->
<?php $__env->startSection('js'); ?>


    <!-- select 2 -->
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script>
        $(document).ready(function() {
            $('.js-example-basic-single').select2();
            //hide search
            $('.select2-no-search').select2({
                minimumResultsForSearch: -1
            });

            //multi select
            $('#multiselect').select2();
            $('#multiselect').on('select2:opening select2:closing', function(event) {
                var $searchfield = $(this).parent().find('.select2-search__field');
                $searchfield.prop('disabled', true);
            });

        });
    </script>


    <script>
        $(document).on('click', '#coupon-buttn', function() {

            var search_query = $('#coupon-input').val();
            var patient_check = $('#search_patient_id').val();
            var total_price = $('#search_patient_id').data('price');

            if (!patient_check) {
                var patient_id = 'null';
            } else {
                var patient_id = patient_check;
            }

            $.ajax({
                url: '<?php echo e(url('/appointment/discount_search')); ?>/' + search_query + '/' + patient_id +
                    '/' + total_price,
                type: "GET",
                dataType: "json",
                success: function(data) {

                    if (!data.discount_amount) {
                        $("#discount_amount_div").addClass('d-none');
                        $("#search-result-input").html(data.msg);
                        $("#total_amount_place").html('$' + total_price);

                    } else {
                        $("#discount_amount_div").removeClass('d-none');

                        $("#search-result-input").html('<p class="me-2">' + data.msg +
                            '<small id="delete_coupon" class="text-red clickable-item-pointer"> DELETE</small><p>'
                        );
                        $("#discount_amount_place").html('$' + data.discount_amount);

                        var after_discount = total_price - data.discount_amount;
                        $("#total_amount_place").html('$' + after_discount);
                    }
                }

            });
        });

        $(document).on('click', '#delete_coupon', function() {
            var total_price = $('#search_patient_id').data('price');
            $("#discount_amount_div").addClass('d-none');
            $('#coupon-input').val('');
            $("#search-result-input").html('');
            $("#total_amount_place").html('$' + total_price);
        })
    </script>



<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/proxima/resources/views/blank/coupon.blade.php ENDPATH**/ ?>