<?php $__env->startSection('title', 'Edit User | Proxima - Medical Management app'); ?>

<?php $__env->startSection('title-topbar', 'Edit User'); ?>

<!-- css insert -->
<?php $__env->startSection('css'); ?>

    <!-- select 2 -->
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

    <!-- boostrap datepicker -->
    <link rel="stylesheet"
        href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.1/css/bootstrap-datepicker3.css" />

    <!-- international telephone input -->
    <link href="<?php echo e(URL::asset('plugins/intltelinput/intlTelInput.css')); ?>" rel="stylesheet">


<?php $__env->stopSection(); ?>


<!-- content insert -->
<?php $__env->startSection('content'); ?>

    <div class="container-fluid px-2 mt-3">

        <!-- page title link -->
        <div class="d-sm-flex align-items-center justify-content-between mb-3">
            <span class="mb-0">
                <a class="link-cust-text text-gray-200 fw-light" href="<?php echo e(route('sett.home')); ?>">Dashboard |</a>
                <a class="link-cust-text text-gray-200 fw-light" href="<?php echo e(route('sett.admin.index')); ?>">Users | </a>
                <a class="text-gray-300">Edit user</a>
            </span>
        </div>

        <div class="card card-input shadow mb-3 pb-3">
            <!-- Card Header - Dropdown -->
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                <h6 class="m-0 fw-bold text-gray-500"><i class="fas fa-user-edit me-2"></i> Edit <?php echo e($user->first_name); ?>

                    Profile
                </h6>
            </div>

            <!-- Card Body -->
            <div class="card-body px-3">

                <div class="multi-setps-form-calander col-12">

                    <form id="myform" method="POST" action="<?php echo e(route('sett.admin.update', $user->id)); ?>"
                        enctype="multipart/form-data">

                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PUT'); ?>


                        <!-- progressbar -->
                        <ul class="ps-0 progressbar" id="progressbar">
                            <li class="active">

                                <a>
                                    <!-- in case we want to use prog selector href="#clinics" -->
                                    <div class="icon-circle checked d-flex align-items-center justify-content-center">
                                        <i class="bi bi-gear"></i>
                                    </div>
                                    Basic
                                </a>
                            </li>

                            <li>
                                <a>
                                    <div class="icon-circle d-flex align-items-center justify-content-center">
                                        <i class="bi bi-person"></i>
                                    </div>
                                    Personal
                                </a>
                            </li>

                            <li>
                                <a>
                                    <div class="icon-circle d-flex align-items-center justify-content-center">
                                        <i class="bi bi-pin-map"></i>
                                    </div>
                                    Work
                                </a>
                            </li>
                            <li>
                                <a>
                                    <div class="icon-circle d-flex align-items-center justify-content-center">
                                        <i class="far fa-paper-plane"></i>
                                    </div>
                                    Sending
                                </a>
                            </li>
                        </ul>

                        <!-- content -->

                        <div class="cont_tap " id="clinics">

                            <div class="row mb-1">
                                <div class="col-12 col-md-5 align-self-center mb-2">

                                    <div class="avatar-update-container">
                                        <div class="picture">
                                            <img src="<?php echo e(URL::asset('img/useravatar/' . $user->avatar)); ?>"
                                                class="picture-src" id="mib_PicturePreview" title="" />
                                            <input type="file" name='avatar' accept="image/*" id="mib_img_input">
                                        </div>
                                        <h6 class="text-gray-300">Choose Picture</h6>

                                        <?php $__errorArgs = ['avatar'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="error-msg-form">
                                                <?php echo e($message); ?>

                                            </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>


                                </div>


                                <div class="col-12 col-md-7 mb-2">
                                    <div class="mb-3">
                                        <label class="form-label">First Name <small>(required)</small></label>
                                        <input name="first_name" type="text"
                                            class="form-control <?php $__errorArgs = ['first_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            placeholder="Ahmed..." value="<?php echo e($user->first_name); ?>" autofocus required>
                                    </div>

                                    <?php $__errorArgs = ['first_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="error-msg-form">
                                            <?php echo e($message); ?>

                                        </span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                    <div class="mb-3">
                                        <label class="form-label">Last Name <small>(required)</small></label>
                                        <input name="second_name" type="text"
                                            class="form-control <?php $__errorArgs = ['second_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            placeholder="Yousef..." value="<?php echo e($user->second_name); ?>" required>
                                    </div>

                                    <?php $__errorArgs = ['second_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="error-msg-form">
                                            <?php echo e($message); ?>

                                        </span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                </div>
                            </div>

                            <div class="row mb-2">

                                <div class="col-12 col-md-4 mb-2">
                                    <label class="form-label">Email <small>(required)</small></label>
                                    <input name="email" type="email"
                                        class="form-control <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        placeholder="Write your email here" value="<?php echo e($user->email); ?>" required>

                                    <input name="old_email" type="hidden" value="<?php echo e($user->email); ?>">

                                    <?php if($errors->has('email')): ?>
                                        <span class="invalid-feedback" role="alert">
                                            <?php echo e($errors->first('email')); ?>

                                        </span>
                                    <?php else: ?>
                                        <div class="form-text text-gray-200">We'll never share your email with anyone else.
                                        </div>
                                    <?php endif; ?>
                                </div>

                                <div class="col-12 col-md-4 mb-2">
                                    <label class="form-label">Role <small>(required)</small></label>
                                    <select class="js-example-basic-single select2-no-search select2-hidden-accessible"
                                        name="role[]" multiple required>
                                        <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $iteam): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($iteam->id); ?>"
                                                <?php if(in_array($iteam->id, $userRole)): ?> selected <?php endif; ?>>
                                                <?php echo e($iteam->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <div id="role-js-error-valid"></div>

                                    <?php $__errorArgs = ['role'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="error-msg-form">
                                            <?php echo e($message); ?>

                                        </span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div class="col-12 col-md-4 mb-2">
                                    <label class="form-label">Specialty <small>(required)</small></label>
                                    <select class="js-example-basic-single select2-no-search select2-hidden-accessible"
                                        name="specialty_id" required>
                                        <?php $__currentLoopData = $speicalty; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $iteam): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option <?php if($user->specialty_id == $iteam->id): ?> selected <?php endif; ?>
                                                value="<?php echo e($iteam->id); ?>"><?php echo e($iteam->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <div id="specialty_id-js-error-valid"></div>

                                    <?php $__errorArgs = ['specialty_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="error-msg-form">
                                            <?php echo e($message); ?>

                                        </span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                </div>

                            </div>


                            <div class="row mb-2">
                                <div class="col-12 col-md-6 mb-2">
                                    <label class="form-label">New Password <small>(required)</small></label>
                                    <input id="password" name="newpassword" type="password"
                                        class="form-control <?php $__errorArgs = ['newpassword'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        placeholder="Wrtie your password here...">

                                    <?php if($errors->has('newpassword')): ?>
                                        <span class="error-msg-form">
                                            <?php echo e($errors->first('newpassword')); ?>

                                        </span>
                                    <?php else: ?>
                                        <div class="form-text text-gray-200">Leave it empty if you do not want to change
                                            it.
                                        </div>
                                    <?php endif; ?>
                                </div>


                                <div class="col-12 col-md-6 mb-2">
                                    <label class="form-label">Confirm New password <small>(required)</small></label>
                                    <input name="newpassword_confirmation" type="password" class="form-control"
                                        placeholder="Confirm your password..." id="password-confirm">
                                </div>

                            </div>

                            <div class="d-flex justify-content-end mt-3">
                                <input type="button" name="next"
                                    class="next-form-steps btn btn-primary action-button-next" value="Continue" />
                            </div>
                        </div>


                        <div class="cont_tap" id="time">

                            <div class="row mb-2">

                                <div class="col-12 col-md-6 mb-2">
                                    <label class="form-label">Gendar <small>(required)</small></label>
                                    <select
                                        class="js-example-basic-single select2-no-search select2-hidden-accessible <?php $__errorArgs = ['gendar'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        name="gendar" required>
                                        <option value="male" <?php if($user->gendar === 'male'): ?> selected <?php endif; ?>>Male
                                        </option>
                                        <option value="female" <?php if($user->gendar === 'female'): ?> selected <?php endif; ?>>Female
                                        </option>
                                    </select>
                                    <div id="gendar-js-error-valid"></div>

                                    <?php $__errorArgs = ['gendar'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="error-msg-form">
                                            <?php echo e($message); ?>

                                        </span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                </div>

                                <div class="col-12 col-md-6 mb-2">


                                    <label class="form-label">Birthday <small>(required)</small></label>
                                    <div class="input-group">
                                        <div class="input-group-prepend">
                                            <div class="input-group-text"><i class="bi bi-calendar2-week-fill"></i> </div>
                                        </div>
                                        <input name="birthday" type="text"
                                            class="form-control hasdatetimepicker <?php $__errorArgs = ['birthday'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            placeholder="YYYY/MM/DD" value="<?php echo e($user->birthday); ?>" required>
                                    </div>
                                    <div id="birthday-js-error-valid"></div>

                                    <?php $__errorArgs = ['birthday'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="error-msg-form">
                                            <?php echo e($message); ?>

                                        </span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                </div>

                            </div>

                            <hr>

                            <div class="row mb-2">

                                <div class="col-12 col-md-6 mb-2">
                                    <label class="form-label">Country <small>(required)</small></label>
                                    <select
                                        class="js-example-basic-single select2-hidden-accessible <?php $__errorArgs = ['country'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        name="country" required>
                                        <?php $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $iteam): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($iteam->id); ?>"
                                                <?php if($user->country == $iteam->id): ?> selected <?php endif; ?>>
                                                <?php echo e($iteam->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <div id="country-js-error-valid"></div>

                                    <?php $__errorArgs = ['country'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="error-msg-form">
                                            <?php echo e($message); ?>

                                        </span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                </div>

                                <div class="col-12 col-md-6 mb-2">
                                    <label class="form-label">City <small>(required)</small></label>
                                    <select
                                        class="js-example-basic-single select2-hidden-accessible <?php $__errorArgs = ['city'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        name="city" required>
                                        <option value="<?php echo e($user->cityuser['id']); ?>" selected>
                                            <?php echo e($user->cityuser['name']); ?>

                                        </option>
                                    </select>

                                    <div id="city-js-error-valid"></div>

                                    <?php if($errors->has('city')): ?>
                                        <span class="error-msg-form">
                                            <?php echo e($errors->first('city')); ?>

                                        </span>
                                    <?php else: ?>
                                        <div class="form-text text-gray-200">Select the country first
                                        </div>
                                    <?php endif; ?>
                                </div>

                            </div>

                            <hr>

                            <div class="row mb-2">

                                <div class="col-12 col-md-6 mb-2">
                                    <label class="form-label">Phone Number <small>(required)</small></label>
                                    <input id="int-miphone" name="phone_number" type="tel"
                                        class="form-control <?php $__errorArgs = ['phone_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        value="<?php echo e($user->phone_number); ?>" required>

                                    <input name="old_phone_number" type="hidden" value="<?php echo e($user->phone_number); ?>">

                                    <div id="phonenumber-js-error-valid">
                                    </div>

                                    <?php if($errors->has('phone_number')): ?>
                                        <span class="error-msg-form">
                                            <?php echo e($errors->first('phone_number')); ?>

                                        </span>
                                    <?php else: ?>
                                        <div class="form-text text-gray-200">We'll never share your email with anyone else.
                                        </div>
                                    <?php endif; ?>
                                </div>



                                <div class="col-12 col-md-6 mb-2">
                                    <label class="form-label">Second Phone Number <small>(optional)</small></label>
                                    <input id="int-miphone2" name="sec_phone_number" type="tel"
                                        class="form-control <?php $__errorArgs = ['sec_phone_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        value="<?php echo e($user->sec_phone_number); ?>">

                                    <div id="secphonenumber-js-error-valid"></div>

                                    <?php $__errorArgs = ['sec_phone_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="error-msg-form">
                                            <?php echo e($message); ?>

                                        </span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>


                                </div>


                            </div>

                            <div class="d-flex justify-content-between p-4">
                                <input type="button" name="previous"
                                    class="previous-form-steps btn btn-secondary action-button-previous"
                                    value="Previous" />
                                <input type="button" name="next"
                                    class="next-form-steps btn btn-primary action-button-next" value="Continue" />
                            </div>
                        </div>

                        <div class="cont_tap" id="about">

                            <div class="row mb-2">
                                <div class="col-12 col-md-4 mb-2">
                                    <label class="form-label">Branch <small>(required)</small></label>
                                    <select
                                        class="js-example-basic-single select2-no-search select2-hidden-accessible <?php $__errorArgs = ['branch'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        name="branch" required>
                                        <option value="0" <?php if($user->branch_id == 0): ?> selected <?php endif; ?>>All
                                        </option>
                                        <?php $__currentLoopData = $branches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $iteam): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($iteam->id); ?>"
                                                <?php if($user->branch_id == $iteam->id): ?> selected <?php endif; ?>>
                                                <?php echo e($iteam->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>

                                    <?php $__errorArgs = ['branch'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="error-msg-form">
                                            <?php echo e($message); ?>

                                        </span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div class="col-12 col-md-4 mb-2">
                                    <label class="form-label">Started work <small>(required)</small></label>
                                    <div class="input-group">
                                        <div class="input-group-prepend">
                                            <div class="input-group-text"><i class="bi bi-calendar2-week-fill"></i> </div>
                                        </div>
                                        <input name="started_work" type="text"
                                            class="form-control hasdatetimepicker <?php $__errorArgs = ['started_work'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            placeholder="YYYY/MM/DD" value="<?php echo e($user->started_work); ?>" required>
                                    </div>
                                    <div id="startedwork-js-error-valid"></div>


                                    <?php $__errorArgs = ['started_work'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="error-msg-form">
                                            <?php echo e($message); ?>

                                        </span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div class="col-12 col-md-4 mb-2">
                                    <label class="form-label">Activision <small>(required)</small></label>
                                    <select
                                        class="js-example-basic-single select2-no-search select2-hidden-accessible <?php $__errorArgs = ['deactivate'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        name="deactivate" required>
                                        <option value="0" <?php if($user->deactivate === '0'): ?> selected <?php endif; ?>>Active
                                        </option>
                                        <option value="1" <?php if($user->deactivate === '1'): ?> selected <?php endif; ?>>
                                            Deactivate</option>
                                    </select>
                                    <div id="deactivate-js-error-valid"></div>

                                    <?php $__errorArgs = ['deactivate'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="error-msg-form">
                                            <?php echo e($message); ?>

                                        </span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                </div>

                            </div>

                            <div class="row mb-2">
                                <div class="mb-3">
                                    <label class="form-label">Note <small>(optional)</small></label>
                                    <textarea name="note" class="form-control" placeholder="Write here your notes .." rows="4"
                                        spellcheck="false"><?php echo e($user->note); ?></textarea>
                                </div>

                                <?php $__errorArgs = ['note'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="error-msg-form">
                                        <?php echo e($message); ?>

                                    </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="d-flex justify-content-between p-4">
                                <input type="button" name="previous"
                                    class="previous-form-steps btn btn-secondary action-button-previous"
                                    value="Previous" />
                                <input type="submit" name="next"
                                    class="next-form-steps btn btn-primary action-button-next" value="Continue" />
                            </div>
                        </div>

                        <div class="cont_tap" id="sending">
                            <div class="d-flex justify-content-center p2">
                                <img src="<?php echo e(URL::asset('img/dashboard/system/loading-dash.svg')); ?>"
                                    style="width: 195px;" alt="Loading" />
                            </div>
                        </div>

                    </form>
                </div>

            </div>

        </div>
    </div>

<?php $__env->stopSection(); ?>

<!-- js insert -->
<?php $__env->startSection('js'); ?>

    <!-- select 2 -->
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script>
        $(document).ready(function() {
            $('.js-example-basic-single').select2();
            //hide search
            $('.select2-no-search').select2({
                minimumResultsForSearch: -1
            });
        });
    </script>

    <!-- jquery ui datepicker -->
    <script type="text/javascript"
        src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.1/js/bootstrap-datepicker.min.js"></script>
    <script>
        $(function() {
            $('.hasdatetimepicker').datepicker({
                todayHighlight: true,
                format: "yyyy-mm-dd",
            });
        });
    </script>

    <!-- validate jquery -->
    <script src="https://cdn.jsdelivr.net/npm/jquery-validation@1.19.3/dist/jquery.validate.min.js" type="text/javascript">
    </script>
    <script>
        //Rules for the Validator plugin
        var $validator = $('#myform').validate({
            rules: {
                first_name: {
                    minlength: 3,
                },
                second_name: {
                    minlength: 3,
                },
                email: {
                    email: true,
                },
                newpassword: {
                    minlength: 7,
                    maxlength: 100,
                },
                newpassword_confirmation: {
                    minlength: 7,
                    maxlength: 100,
                    equalTo: '#password',
                },
            },
            messages: {
                email: {
                    required: "We need your email address to contact you",
                    email: "Your email address must be in the format of name@domain.com"
                },
                password_confirmation: {
                    equalTo: "Password does not match",
                }
            },
            //for inserting erros for some inputs that makes posation problem such as selector 2 and bt datapicker
            errorPlacement: function(error, element) {
                switch (element.attr("name")) {
                    case 'role':
                        error.insertAfter($("#role-js-error-valid"));
                        break;
                    case 'gendar':
                        error.insertAfter($("#gendar-js-error-valid"));
                        break;
                    case 'birthday':
                        error.insertAfter($("#birthday-js-error-valid"));
                        break;
                    case 'country':
                        error.insertAfter($("#country-js-error-valid"));
                        break;
                    case 'city':
                        error.insertAfter($("#city-js-error-valid"));
                        break;

                    case 'started_work':
                        error.insertAfter($("#startedwork-js-error-valid"));
                        break;
                    case 'phone_number':
                        error.insertAfter($("#phonenumber-js-error-valid"));
                        break;
                    case 'sec_phone_number':
                        error.insertAfter($("#secphonenumber-js-error-valid"));
                        break;
                    case 'deactivate':
                        error.insertAfter($("#deactivate-js-error-valid"));
                        break;

                    default:
                        error.insertAfter(element);
                }

            },
        });
    </script>
    <script>
        //for country and cities ajax inputs
        $('select[name="country"]').on('change', function(e) {
            e.preventDefault();

            var countryID = $(this).val();
            var url = "<?php echo e(route('sett.createcityajax', ':id')); ?>";
            url = url.replace(':id', countryID);

            var countryID = $(this).val();
            if (countryID) {
                $.ajax({
                    url: url,
                    type: "GET",
                    dataType: "json",
                    success: function(data) {
                        $('select[name="city"]').empty();
                        $.each(data, function(key, value) {
                            $('select[name="city"]').append('<option value="' +
                                value.id + '">' + value.name + '</option>');
                        });
                    }
                });
            } else {
                $('select[name="city"]').empty();
            }
        });
    </script>


    <!-- international telephone input -->
    <script src="<?php echo e(URL::asset('plugins/intltelinput/intlTelInput.min.js')); ?>"></script>

    <script>
        //to enable international telephone input (#int-miphone) is where we need to insert it
        const phoneInputField = document.querySelector("#int-miphone");
        const phoneInput = window.intlTelInput(phoneInputField, {
            //preferred countries https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2
            preferredCountries: ["eg", "sa", "ae", "qa"],
            utilsScript: "<?php echo e(URL::asset('plugins/intltelinput/utils.js')); ?>",
        });
        const phoneInputField2 = document.querySelector("#int-miphone2");
        const phoneInput2 = window.intlTelInput(phoneInputField2, {
            //preferred countries https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2
            preferredCountries: ["eg", "sa", "ae", "qa"],
            utilsScript: "<?php echo e(URL::asset('plugins/intltelinput/utils.js')); ?>",
        });
    </script>



<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/drsamirghoraba/public_html/prox/proxima/resources/views/admins/edit.blade.php ENDPATH**/ ?>