<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title><?php echo e($patient->first_name); ?> Profile</title>
    <link rel="stylesheet" href="<?php echo e(public_path('css/kv-mpdf-bootstrap.css')); ?>">

</head>

<body>

    <!-- Patient Info -->
    <div class="card-body px-4">

        <div class="row mb-3 b-r-s-cont border2 py-3 px-2">

            <div class="col-xs-5 text-truncate p-0" style="">
                <div class="w-10">
                    <div class="p-0" style="width: 25%;float: left;">
                        <div class="rounded-circle avatar-m2 profile_img"
                            style="background-image: url(<?php echo e(public_path('img/useravatar/' . $patient->avatar)); ?>)">
                        </div>
                    </div>

                    <div class="text-truncate p-0" style="width: 75%;float: left;">
                        <p class="m-0 p-0 text-s">
                            Patient</p>
                        <p class="m-0 p-0 text-s fw-bold2 text-truncate">
                            <?php echo e($patient->first_name . ' ' . $patient->second_name); ?></p>
                        <p class="m-0 p-0 text-s"><?php echo e($patient->city->name); ?> <?php echo e($patient->country->name); ?></p>
                    </div>
                </div>
            </div>

            <div class="col-xs-2 px-0" style="display: inline;">
                <p class="text-s mb-0">Age</p>
                <p class="fw-bold2">
                    <?php echo e(\Carbon\Carbon::parse($patient->birthday)->diff(\Carbon\Carbon::now())->format('%y')); ?>

                </p>
            </div>
            <div class="col-xs-2">
                <p class="text-s mb-0">Phone Number</p>
                <p class="fw-bold2"><?php echo e($patient->phone_number); ?></p>
            </div>

            <div class="col-xs-2 px-0 text-truncate">
                <p class="text-s mb-0 text-truncate">Date</p>
                <?php if(count($patient->investigation) > 0): ?>
                <p class="fw-bold2"><?php echo e($patient->investigation[0]->date); ?></p>
                <?php endif; ?>
            </div>
        </div>


        <!-- All exminations -->
        <div class="row mb-3">
            <div class="col-xs-12">
                <h4 class="">Investigation</h4>
                <div class="table-responsive">
                    <table class="table-responsive text-s table-bordered2 bordered w-100">
                        <thead>
                            <tr>
                                <th class="fw-bold2" style="width:40%;">Name</th>
                                <th sclass="fw-bold2" tyle="width:20%;">Value</th>
                            </tr>
                        </thead>

                        <tbody>
                            <?php if(count($patient->investigation) > 0): ?>
                            <?php if($patient->investigation[0]->type == 3): ?>
                            <tr>
                                <td class="w-25 fw-bold2">Colored Photo</td>
                                <td class="fw-bold text-uppercase fw-bold2"><?php echo e($patient->investigation[0]->colored_photo); ?></td>
                            </tr>
                            <tr>
                                <td class="w-25 fw-bold2">Sonar</td>
                                <td class="fw-bold text-uppercase fw-bold2"><?php echo e($patient->investigation[0]->sonar); ?>

                                </td>
                            </tr>
                            <tr>
                                <td class="w-25 fw-bold2">UBM</td>
                                <td class="fw-bold text-uppercase fw-bold2"><?php echo e($patient->investigation[0]->ubm); ?></td>
                            </tr>
                            <tr>
                                <td class="w-25 fw-bold2">Biometry</td>
                                <td class="fw-bold text-uppercase fw-bold2"><?php echo e($patient->investigation[0]->biometry); ?>

                                </td>
                            </tr>
                            <tr>
                                <td class="w-25 fw-bold2">Visual Field</td>
                                <td class="fw-bold text-uppercase fw-bold2"><?php echo e($patient->investigation[0]->visual_field); ?></td>
                            </tr>
                            <tr>
                                <td class="w-25 fw-bold2">FFA</td>
                                <td class="fw-bold text-uppercase fw-bold2"><?php echo e($patient->investigation[0]->ffa); ?></td>
                            </tr>
                            <tr>
                                <td class="w-25 fw-bold2">OCT</td>
                                <td class="fw-bold text-uppercase fw-bold2"><?php echo e($patient->investigation[0]->oct); ?></td>
                            </tr>
                            <tr>
                                <td class="w-25 fw-bold2">Pentacam</td>
                                <td class="fw-bold text-uppercase fw-bold2"><?php echo e($patient->investigation[0]->pentacam); ?>

                                </td>
                            </tr>
                            <tr>
                                <td class="w-25 fw-bold2">Electro Physiology</td>
                                <td class="fw-bold text-uppercase fw-bold2"><?php echo e($patient->investigation[0]->electro_physiology); ?></td>
                            </tr>
                            <tr>
                                <td class="w-25 fw-bold2">Specular Microscopy</td>
                                <td class="fw-bold text-uppercase fw-bold2"><?php echo e($patient->investigation[0]->specular_microscopy); ?></td>
                            </tr>
                            <?php endif; ?>
                            <?php endif; ?>
                        </tbody>

                    </table>
                </div>
            </div>
        </div>



    </div>


</body>

</html><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/proxima/resources/views/patient/print_investigation.blade.php ENDPATH**/ ?>