<!-- treatments and sessions -->
<div class="col-12 col-lg-4">
    <div class="card shadow mb-4">

        <div id="treat-session" class="carousel slide curr-treament-info-carousel" data-bs-ride="carousel"
            data-bs-interval="false">

            <div class="carousel-indicators dots-radius-carousel" style="bottom: 34px; margin-bottom: 0px;">
                <button type="button" data-bs-target="#treat-session" data-bs-slide-to="0"
                    aria-label="Slide 0"></button>
                <button type="button" data-bs-target="#treat-session" data-bs-slide-to="1"
                    aria-label="Slide 1"></button>
                <button type="button" data-bs-target="#treat-session" data-bs-slide-to="2" class="active"
                    aria-current="true" aria-label="Slide 2"></button>
                <button type="button" data-bs-target="#treat-session" data-bs-slide-to="3"
                    aria-label="Slide 3"></button>
            </div>

            <div class="carousel-inner">



                <!-- Current Examination -->
                <div class="carousel-item active">

                    <!-- Card Header - Dropdown -->
                    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                        <div class="d-flex align-items-center">
                            <span class="m-0 fs-6 me-2 fw-bold clickable-item-pointer">
                                <?php echo e(__('basic.eyeglasses')); ?></span>

                            <span
                                class="m-0 text-x link-cust-text text-s me-2 fw-bold clickable-item-pointer text-gray-200"
                                data-bs-target="#treat-session" data-bs-slide-to="1" aria-label="Slide 1">
                                <?php echo e(__('basic.prescription')); ?></span>

                            <span
                                class="m-0 text-x link-cust-text text-s me-2 fw-bold clickable-item-pointer text-gray-200"
                                data-bs-target="#treat-session" data-bs-slide-to="2" aria-label="Slide 2">
                                <?php echo e(__('basic.treatments')); ?></span>
                            <span
                                class="m-0 me-2 text-x link-cust-text text-s fw-bold clickable-item-pointer text-gray-200"
                                data-bs-target="#treat-session" data-bs-slide-to="3" aria-label="Slide 3">
                                <?php echo e(__('patientappo.sessions')); ?></span>

                        </div>
                        <div class="dropdown no-arrow position-absolute end-0">
                            <a class="dropdown-toggle" href="#" role="button" id="dropdownMenuLink"
                                data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                <i class="fas fa-ellipsis-v fa-sm fa-fw text-gray-300"></i>
                            </a>
                            <div class="dropdown-menu dropdown-menu-right shadow animated--fade-in"
                                aria-labelledby="dropdownMenuLink">
                                <div class="dropdown-header">Dropdown Header:</div>
                                <a class="dropdown-item clickable-item-pointer" data-bs-toggle="modal"
                                    data-bs-target="#add_eyeglasses_prescription"><?php echo e(__('basic.add new')); ?></a>
                            </div>
                        </div>
                    </div>

                    <!-- Card Body -->

                    <?php if(!$patient->eyeglasses->isEmpty()): ?>
                    <div id="medicine_card_home" class="card-body align-items-center">

                        <?php $__currentLoopData = $patient->eyeglasses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        
                        <?php if($loop->index === 3) break; ?>

                        <div class="d-flex justify-content-between align-items-center mb-3">

                            <div class="me-1 d-flex align-self-center align-items-center me-2 text-truncate">
                                <i class="fas fa-glasses me-2 fs-4 mb-0"></i>
                                <div class="text-truncate">
                                    <p class="text-s text-truncate text-gray-700 mb-0 fw-bold">
                                        <?php echo e($item->date); ?>

                                    </p>
                                </div>
                            </div>
                            <a href="<?php echo e(route('eyeglasses_prescription_print', [$patient->code, $item->code])); ?>"
                                target="_blank">
                                <span class="badge rounded-pill status-col-link main-color-btn badge-padd-l"><?php echo e(__('basic.download')); ?></span>
                            </a>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                    <?php else: ?>
                    <div class="card-body align-items-center text-center position-relative">
                        <a class="add-new-item stretched-link link-cust-text text-gray-400" href="#"
                            data-bs-toggle="modal" data-bs-target="#add_eyeglasses_prescription">
                            <i class="fas fa-plus-circle fa-sm fa-fw fs-4"></i>
                            <p class="fw-light mb-0"><?php echo e(__('basic.you can add new eyeglasses prescription')); ?></p>
                        </a>
                    </div>
                    <?php endif; ?>

                    <!-- Card footer medicine -->
                    <div class="card-footer text-center ">
                        <a class="text-xs link-cust-text text-gray-300" href="#" data-bs-toggle="modal"
                            data-bs-target="#eyeglasses_prescription_show">
                            <i class="fas fa-chevron-down"></i> <?php echo e(__('basic.more')); ?>

                        </a>
                    </div>

                </div><!-- end of medicens crousel -->



                <!-- Current Medicines -->
                <div class="carousel-item">

                    <!-- Card Header - Dropdown -->
                    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                        <div class="d-flex align-items-center">
                            <span class="m-0 fs-6 me-2 fw-bold clickable-item-pointer"><?php echo e(__('basic.prescription')); ?></span>

                            <span
                                class="m-0 text-x link-cust-text text-s me-2 fw-bold clickable-item-pointer text-gray-200"
                                data-bs-target="#treat-session" data-bs-slide-to="2" aria-label="Slide 2">
                                <?php echo e(__('basic.treatments')); ?></span>

                            <span
                                class="m-0 me-2 text-x link-cust-text me-2 text-s fw-bold clickable-item-pointer text-gray-200"
                                data-bs-target="#treat-session" data-bs-slide-to="3" aria-label="Slide 3">
                                <?php echo e(__('patientappo.sessions')); ?></span>

                            <span
                                class="m-0 text-x link-cust-text text-s me-2 fw-bold clickable-item-pointer text-gray-200"
                                data-bs-target="#treat-session" data-bs-slide-to="0" aria-label="Slide 0">
                                <?php echo e(__('basic.eyeglasses')); ?></span>

                        </div>
                        <div class="dropdown no-arrow">
                            <a class="dropdown-toggle" href="#" role="button" id="dropdownMenuLink"
                                data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                <i class="fas fa-ellipsis-v fa-sm fa-fw text-gray-300"></i>
                            </a>
                            <div class="dropdown-menu dropdown-menu-right shadow animated--fade-in"
                                aria-labelledby="dropdownMenuLink">
                                <div class="dropdown-header">Dropdown Header:</div>
                                <a class="dropdown-item clickable-item-pointer" data-bs-toggle="modal"
                                    data-bs-target="#addmedic"><?php echo e(__('patientappo.add medicine')); ?></a>
                            </div>
                        </div>
                    </div>

                    <!-- Card Body -->

                    <?php if(!$patient->prescriptions->isEmpty()): ?>
                    <div id="medicine_card_home" class="card-body align-items-center">

                        <?php $__currentLoopData = $patient->prescriptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                        
                        <?php if($loop->index === 3) break; ?>
                        <div class="d-flex justify-content-between align-items-center mb-3">
                            <div class="me-1 d-flex align-self-center align-items-center me-2 text-truncate">
                                <i class="fas fa-capsules me-2 fs-4 mb-0"></i>
                                <div class="text-truncate">
                                    <p class="text-s text-truncate text-gray-700 mb-0 fw-bold">
                                        <?php echo e($item->date); ?>

                                    </p>
                                </div>
                            </div>
                            <a href="<?php echo e(route('pat_patient_print_pre', [$patient->code, $item->code])); ?>"
                                target="_blank">
                                <span class="badge rounded-pill status-col-link main-color-btn badge-padd-l"><?php echo e(__('basic.download')); ?></span>
                            </a>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                    <?php else: ?>
                    <div class="card-body align-items-center text-center position-relative">
                        <a class="add-new-item stretched-link link-cust-text text-gray-400" href="#"
                            data-bs-toggle="modal" data-bs-target="#addmedic">
                            <i class="fas fa-plus-circle fa-sm fa-fw fs-4"></i>
                            <p class="fw-light mb-0"><?php echo e(__('patientappo.you can add new medicines')); ?></p>
                        </a>
                    </div>

                    <?php endif; ?>

                    <!-- Card footer medicine -->
                    <div class="card-footer text-center ">
                        <a class="text-xs link-cust-text text-gray-300" href="#" data-bs-toggle="modal"
                            data-bs-target="#medicine_show">
                            <i class="fas fa-chevron-down"></i> <?php echo e(__('basic.more')); ?>

                        </a>
                    </div>

                </div><!-- end of medicens crousel -->


                <!-- Current treatments -->
                <div class="carousel-item">

                    <!-- Card Header - Dropdown -->
                    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                        <div class="d-flex align-items-center">
                            <span class="m-0 fs-6 me-2 fw-bold clickable-item-pointer"><?php echo e(__('basic.treatments')); ?></span>
                            <span
                                class="m-0 me-2 text-x link-cust-text text-s fw-bold clickable-item-pointer text-gray-200"
                                data-bs-target="#treat-session" data-bs-slide-to="3" aria-label="Slide 3">
                                <?php echo e(__('patientappo.sessions')); ?></span>
                            <span
                                class="m-0 me-2 text-x link-cust-text text-s fw-bold clickable-item-pointer text-gray-200"
                                data-bs-target="#treat-session" data-bs-slide-to="0" aria-label="Slide 0">
                                <?php echo e(__('basic.eyeglasses')); ?></span>

                            <span
                                class="m-0 me-2 text-x link-cust-text text-s fw-bold clickable-item-pointer text-gray-200"
                                data-bs-target="#treat-session" data-bs-slide-to="1" aria-label="Slide 1">
                                <?php echo e(__('basic.prescription')); ?></span>

                        </div>
                        <div class="dropdown no-arrow">
                            <a class="dropdown-toggle" href="#" role="button" id="dropdownMenuLink"
                                data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                <i class="fas fa-ellipsis-v fa-sm fa-fw text-gray-300"></i>
                            </a>
                            <div class="dropdown-menu dropdown-menu-right shadow animated--fade-in"
                                aria-labelledby="dropdownMenuLink">
                                <div class="dropdown-header">Dropdown Header:</div>
                                <a class="dropdown-item clickable-item-pointer" data-bs-toggle="modal"
                                    data-bs-target="#addtreatment"><?php echo e(__('patientappo.new treatment')); ?></a>
                            </div>
                        </div>
                    </div>

                    <!-- Card Body -->

                    <?php if(!$patient->treatments->isEmpty()): ?>
                    <div class="card-body pb-4">

                        <?php $__currentLoopData = $patient->treatments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        
                        <?php if($loop->index === 3) break; ?>

                        <?php if($item->status == 0): ?>
                        <?php
                        $text_color = 'main-color';
                        $msg = __('basic.in prog');
                        ?>
                        <?php elseif($item->status == 1): ?>
                        <?php
                        $text_color = 'done-color-btn';
                        $msg = __('patientappo.done');
                        ?>
                        <?php endif; ?>

                        <div class="d-flex justify-content-between align-items-center mb-3">
                            <div class="me-1 d-flex align-self-center align-items-center me-2 text-truncate">
                                <i class="fas fa-circle me-2 text-xxs mb-0 <?php echo e($text_color); ?>"></i>

                                <div class="text-truncate">
                                    <h6 class="text-s fw-bold text-gray-700  mb-0">
                                        <?php echo e($item->treatment_cat->name); ?></h6>
                                    <p class="text-xs text-gray-300 fw-bold mb-0"><?php echo e($msg); ?></p>
                                </div>
                            </div>

                            <div class="text-s text-gray-600 fw-bold"><?php echo e($item->sessions); ?><small
                                    class="text-gray-300 text-xxxs">
                                    Sesi</small>
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                    <?php else: ?>
                    <div class="card-body align-items-center text-center position-relative">
                        <a class="add-new-item stretched-link link-cust-text text-gray-400" href="#"
                            data-bs-toggle="modal" data-bs-target="#addtreatment">
                            <i class="fas fa-plus-circle fa-sm fa-fw fs-4"></i>
                            <p class="fw-light mb-0">You can put your Treatment</p>
                        </a>
                    </div>
                    <?php endif; ?>

                    <!-- Card footer -->
                    <div class="card-footer text-center ">
                        <a class="text-xs link-cust-text text-gray-300 clickable-item-pointer" data-bs-toggle="modal"
                            data-bs-target="#treatment_show">
                            <i class="fas fa-chevron-down"></i> <?php echo e(__('basic.more')); ?>

                        </a>
                    </div>

                </div>

                <!----------- sessions start content ----------->
                <div class="carousel-item">

                    <!-- Card Header - Dropdown -->
                    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                        <div class="d-flex align-items-center">
                            <span class="m-0 fs-6 me-2 fw-bold clickable-item-pointer"><?php echo e(__('patientappo.sessions')); ?></span>
                            <span
                                class="m-0 me-2 text-x link-cust-text text-s fw-bold clickable-item-pointer text-gray-200"
                                data-bs-target="#treat-session" data-bs-slide-to="0" aria-label="Slide 0">
                                <?php echo e(__('basic.eyeglasses')); ?></span>

                            <span
                                class="m-0 me-2 text-x link-cust-text text-s fw-bold clickable-item-pointer text-gray-200"
                                data-bs-target="#treat-session" data-bs-slide-to="1" aria-label="Slide 1">
                                <?php echo e(__('basic.prescription')); ?></span>

                            <span class="m-0 text-x link-cust-text text-s fw-bold clickable-item-pointer text-gray-200"
                                data-bs-target="#treat-session" data-bs-slide-to="0" aria-label="Slide 1">
                                <?php echo e(__('basic.treatments')); ?></span>
                        </div>
                        <div class="dropdown no-arrow">
                            <a class="dropdown-toggle" href="#" role="button" id="dropdownMenuLink"
                                data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                <i class="fas fa-ellipsis-v fa-sm fa-fw text-gray-300"></i>
                            </a>
                            <div class="dropdown-menu dropdown-menu-right shadow animated--fade-in"
                                aria-labelledby="dropdownMenuLink">
                                <div class="dropdown-header">Dropdown Header:</div>
                                <a class="dropdown-item clickable-item-pointer" data-bs-toggle="modal"
                                    data-bs-target="#addsession"><?php echo e(__('patientappo.new session')); ?></a>
                            </div>
                        </div>
                    </div>

                    <!-- Card Body -->
                    <?php if(!$patient->sessions->isEmpty()): ?>
                    <div id="medicine_card_home" class="card-body align-items-center">

                        <?php $__currentLoopData = $patient->sessions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        
                        <?php if($loop->index === 3) break; ?>

                        <?php if($item->status == 0): ?>
                        <?php
                        $text_color = 'main-color';
                        $msg = __('patientappo.not done');
                        ?>
                        <?php elseif($item->status == 1): ?>
                        <?php
                        $text_color = 'done-color-btn';
                        $msg = __('patientappo.done');
                        ?>
                        <?php endif; ?>

                        <?php if($item->invoice_item): ?>
                        <?php if($item->invoice_item->invoice): ?>
                        <?php if($item->invoice_item->invoice->status == 0): ?>
                        <?php
                        $text_color_invoice = 'cancel-color-btn';
                        $msg_invoice = __('basic.not paid');
                        ?>
                        <?php elseif($item->invoice_item->invoice->status == 1): ?>
                        <?php
                        $text_color_invoice = 'pend-color-btn';
                        $msg_invoice = __('basic.pending');
                        ?>
                        <?php elseif($item->invoice_item->invoice->status == 2): ?>
                        <?php
                        $text_color_invoice = 'prog-color-btn';
                        $msg_invoice = __('basic.installment');
                        ?>
                        <?php elseif($item->invoice_item->invoice->status == 3): ?>
                        <?php
                        $text_color_invoice = 'done-color-btn';
                        $msg_invoice = __('basic.paid');
                        ?>
                        <?php elseif($item->invoice_item->invoice->status == 4): ?>
                        <?php
                        $text_color_invoice = 'cancel-color-btn';
                        $msg_invoice = __('basic.refund');
                        ?>
                        <?php endif; ?>
                        <?php else: ?>
                        <?php
                        $text_color_invoice = '';
                        $msg_invoice = '';
                        ?>
                        <?php endif; ?>
                        <?php else: ?>
                        <?php
                        $text_color_invoice = 'done-color-btn';
                        $msg_invoice = __('patientappo.old record');
                        ?>
                        <?php endif; ?>
                        <div class="d-flex justify-content-between align-items-center mb-3">

                            <div class="me-1 d-flex align-self-center align-items-center me-2 text-truncate">
                                <i class="fas fa-circle me-2 text-xxs mb-0 <?php echo e($text_color); ?>"></i>

                                <div class="text-truncate">
                                    <p class="text-s text-truncate text-gray-700 mb-0 fw-bold">
                                        <?php if($item->service_item): ?>
                                        <?php echo e($item->service_item->name); ?>

                                        <?php endif; ?>
                                    </p>
                                    <p class="text-xs text-gray-300 fw-bold mb-0"><?php echo e($msg); ?></p>
                                </div>
                            </div>

                            <span class="badge rounded-pill <?php echo e($text_color_invoice); ?> badge-padd-l"><?php echo e($msg_invoice); ?></span>

                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                    <?php else: ?>
                    <div class="card-body align-items-center text-center position-relative">
                        <a class="add-new-item stretched-link link-cust-text text-gray-400" href="#"
                            data-bs-toggle="modal" data-bs-target="#addsession">
                            <i class="fas fa-plus-circle fa-sm fa-fw fs-4"></i>
                            <p class="fw-light mb-0"><?php echo e(__('patientappo.new session')); ?></p>
                        </a>
                    </div>

                    <?php endif; ?>

                    <!-- Card footer session -->
                    <div class="card-footer text-center ">
                        <a class="text-xs link-cust-text text-gray-300" href="#" data-bs-toggle="modal"
                            data-bs-target="#session_show">
                            <i class="fas fa-chevron-down"></i> <?php echo e(__('basic.more')); ?>

                        </a>
                    </div>

                </div>



            </div>


            <!-- Modal show all treatment -->
            <div class="modal fade" id="treatment_show" tabindex="-1" aria-labelledby="exampleModalLabel"
                aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-xl">
                    <div class="modal-content b-r-s-cont border-0">
                        <div class="modal-header">
                            <h5 class="modal-title" id="exampleModalLabel"><i class="fas fas fa-x-ray me-1"></i>
                                Treatment</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>

                        <!-- Modal content -->
                        <div class="modal-body px-4">

                            <div class="table-responsive">
                                <table class="table display datatable-modal" id="table-treatment" width="100%"
                                    cellspacing="0">
                                    <thead>
                                        <tr>
                                            <th class="text-xs"><?php echo e(__('basic.id')); ?></th>
                                            <th class="text-xs"><?php echo e(__('basic.name')); ?></th>
                                            <th class="text-xs text-center"><?php echo e(__('basic.start')); ?></th>
                                            <th class="text-xs text-center"><?php echo e(__('basic.end')); ?></th>
                                            <th class="text-xs text-center"><?php echo e(__('patientappo.sessions')); ?>

                                            </th>
                                            <th class="text-xs text-center">
                                                <?php echo e(__('patientappo.sessions done')); ?></th>
                                            <th class="text-xs text-center"><?php echo e(__('basic.status')); ?></th>
                                            <th class="text-xs text-center"><?php echo e(__('basic.handle')); ?></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $patient->treatments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if($item->status == 0): ?>
                                        <?php
                                        $text_color = 'active-color-btn';
                                        $msg = __('basic.in prog');
                                        ?>
                                        <?php elseif($item->status == 1): ?>
                                        <?php
                                        $text_color = 'done-color-btn';
                                        $msg = __('patientappo.done');
                                        ?>
                                        <?php endif; ?>

                                        <tr>
                                            <td><?php echo e($item->id); ?></td>
                                            <td class="">
                                                <?php echo e($item->treatment_cat->name); ?></td>
                                            <td><?php echo e($item->start); ?></td>
                                            <td class="text-center"><?php echo e($item->end); ?></td>
                                            <td class="text-center"><?php echo e($item->sessions); ?></td>
                                            <td class="text-center"><?php echo e($item->sessions_done); ?></td>
                                            <td class="text-center"> <span
                                                    class="badge rounded-pill <?php echo e($text_color); ?> badge-padd-l"><?php echo e($msg); ?></span>
                                            </td>

                                            <td class="text-center">
                                                <a data-treatment_id="<?php echo e($item->id); ?>"
                                                    data-treatment_cat_id="<?php echo e($item->treatment_cat->id); ?>"
                                                    data-status_treatment="<?php echo e($item->status); ?>"
                                                    data-sessions="<?php echo e($item->sessions); ?>"
                                                    data-sessions_done="<?php echo e($item->sessions_done); ?>"
                                                    data-start="<?php echo e($item->start); ?>" data-end="<?php echo e($item->end); ?>"
                                                    class="btn btn-sm status-col-link active-color-btn b-r-xs mb-1 treatment_edit_click"
                                                    title="edit"><i class="fas fa-pencil-alt"></i>
                                                    <?php echo e(__('basic.edit')); ?> </a>

                                                <a data-treatment_id="<?php echo e($item->id); ?>"
                                                    class="btn btn-sm status-col-link active-color-btn b-r-xs mb-1 treatment_newsession_click"
                                                    title="edit"><i class="fas fa-pencil-alt"></i>
                                                    <?php echo e(__('patientappo.new session')); ?> </a>

                                                <a data-treatment_id="<?php echo e($item->id); ?>"
                                                    class="btn btn-sm modal-effect status-col-link cancel-color-btn b-r-xs mb-1 treatment_delete_click"
                                                    title="delete" data-effect="effect-scale"><i
                                                        class="fas fa-trash"></i>
                                                    <?php echo e(__('basic.delete')); ?>

                                                </a>

                                            </td>

                                        </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <div class="left-side">
                                <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal"><?php echo e(__('basic.never mind')); ?></button>
                            </div>
                            <div class="divider"></div>
                            <div class="right-side">
                                <button type="button" class="btn btn-default btn-link main-color"><?php echo e(__('basic.save
                                    changes')); ?></button>
                            </div>
                        </div>

                    </div>
                </div>

            </div>

            <!-- Modal treatment insert data -->
            <div class="modal fade" id="addtreatment" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
                aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
                    <div class="modal-content b-r-s-cont border-0">
                        <div class="modal-header">
                            <h5 class="modal-title" id="exampleModalLabel"><i class="fas fas fa-x-ray me-1"></i>
                                <?php echo e(__('patientappo.new treatment')); ?></h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>

                        <form action="<?php echo e(route('sett.treatment.store')); ?>" method="post">
                            <?php echo e(method_field('POST')); ?>

                            <?php echo e(csrf_field()); ?>


                            <!-- Modal content -->
                            <div class="modal-body px-5 py-3">

                                <div class="row mb-2">

                                    <div class="col-12 mb-2">
                                        <label class="form-label"><?php echo e(__('basic.treatment')); ?>

                                            <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                        <select
                                            class="myselect2-treatment-insert select2-hidden-accessible <?php $__errorArgs = ['treatment_cat'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            id="treatment_cat" name="treatment_cat" required>
                                            <?php $__currentLoopData = $treatment_cat; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($item->id); ?>">
                                                <?php echo e($item->name); ?>

                                            </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>

                                        <span id="treatment_cat_error" class="error-msg-form"></span>

                                        <?php $__errorArgs = ['treatment_cat'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="error-msg-form">
                                            <?php echo e($message); ?>

                                        </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                    </div>

                                    <div class="col-12 mb-2">
                                        <label class="form-label"> <?php echo e(__('patientappo.sessions')); ?>

                                            <small>(<?php echo e(__('basic.required')); ?>)</small></label>

                                        <input name="treatment_session" type="number"
                                            class="form-control <?php $__errorArgs = ['treatment_session'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            placeholder="How many session?" required>

                                        <span id="treatment_session_error" class="error-msg-form"></span>

                                        <?php $__errorArgs = ['treatment_session'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="error-msg-form">
                                            <?php echo e($message); ?>

                                        </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>

                                    <div class="col-12 mb-2">
                                        <label class="form-label"><?php echo e(__('basic.start')); ?>

                                            <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                        <div class="input-group">
                                            <div class="input-group-prepend">
                                                <div class="input-group-text"><i class="bi bi-calendar2-week-fill"></i>
                                                </div>
                                            </div>
                                            <input name="treatment_start" type="text"
                                                class="form-control hasdatetimepicker <?php $__errorArgs = ['treatment_start'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                placeholder="YYYY/MM/DD" required>
                                        </div>
                                        <span id="treatment_start_error" class="error-msg-form"></span>

                                        <?php $__errorArgs = ['treatment_start'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="error-msg-form">
                                            <?php echo e($message); ?>

                                        </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>

                                    <div class="col-12 mb-2">
                                        <label class="form-label"><?php echo e(__('basic.end')); ?>

                                            <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                        <div class="input-group">
                                            <div class="input-group-prepend">
                                                <div class="input-group-text"><i class="bi bi-calendar2-week-fill"></i>
                                                </div>
                                            </div>
                                            <input name="treatment_end" type="text"
                                                class="form-control hasdatetimepicker <?php $__errorArgs = ['treatment_end'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                placeholder="YYYY/MM/DD">
                                        </div>
                                        <span id="treatment_end_error" class="error-msg-form"></span>

                                        <?php $__errorArgs = ['treatment_end'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="error-msg-form">
                                            <?php echo e($message); ?>

                                        </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>

                                    <div class="col-12 mb-2">
                                        <label class="form-label"><?php echo e(__('basic.appointment')); ?>

                                            <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                        <select
                                            class="myselect2-treatment-insert select2-hidden-accessible <?php $__errorArgs = ['last_appointment_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            id="last_appointment_id_trea" name="last_appointment_id" required>
                                            <?php $__currentLoopData = $patient->appointments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($item->id); ?>">
                                                <?php echo e($item->start_at); ?>

                                            </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>

                                        <span id="last_appointment_id_error" class="error-msg-form"></span>

                                        <?php $__errorArgs = ['last_appointment_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="error-msg-form">
                                            <?php echo e($message); ?>

                                        </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                    </div>
                                </div>

                                <input name="patient_id" value="<?php echo e($patient->id); ?>" type="hidden">

                            </div>

                            <div class="modal-footer">
                                <div class="left-side">
                                    <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal"><?php echo e(__('basic.never mind')); ?></button>
                                </div>
                                <div class="divider"></div>
                                <div class="right-side">
                                    <button type="submit" class="btn btn-default btn-link main-color">Add
                                        New</button>
                                </div>
                            </div>
                        </form>

                    </div>
                </div>

            </div>

            <!-- Modal treatment update data -->
            <div class="modal fade" id="treatment_edit" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
                aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
                    <div class="modal-content b-r-s-cont border-0">
                        <div class="modal-header">
                            <h5 class="modal-title" id="exampleModalLabel"><i class="fas fa-capsules me-1"></i>
                                Edit treatment</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>

                        <form class="mb-0" action="<?php echo e(route('sett.treatment.update', '21')); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('PUT'); ?>

                            <!-- Modal content -->
                            <div class="modal-body px-5 py-3">

                                <div class="row mb-2">

                                    <div class="col-12 mb-2">
                                        <label class="form-label"><?php echo e(__('basic.treatment')); ?>

                                            <small>(<?php echo e(__('basic.required')); ?>)</small></label>

                                        <select
                                            class="myselect2-treatment-update select2-hidden-accessible <?php $__errorArgs = ['treatment_cat_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            id="treatment_cat_update" name="treatment_cat_update" required>
                                            <?php $__currentLoopData = $treatment_cat; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($item->id); ?>">
                                                <?php echo e($item->name); ?>

                                            </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>

                                        <span id="treatment_cat_update_error" class="error-msg-form"></span>

                                        <?php $__errorArgs = ['treatment_cat_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="error-msg-form">
                                            <?php echo e($message); ?>

                                        </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                    </div>


                                    <div class="col-12 mb-2">
                                        <label class="form-label"> <?php echo e(__('patientappo.sessions')); ?>

                                            <small>(<?php echo e(__('basic.required')); ?>)</small></label>

                                        <input name="treatment_session_update" type="number"
                                            class="form-control <?php $__errorArgs = ['treatment_session_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            placeholder="How many session?" required>

                                        <span id="treatment_session_update_error" class="error-msg-form"></span>

                                        <?php $__errorArgs = ['treatment_session_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="error-msg-form">
                                            <?php echo e($message); ?>

                                        </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>

                                    <div class="col-12 mb-2">
                                        <label class="form-label">Sessions Done
                                            <small>(<?php echo e(__('basic.required')); ?>)</small></label>

                                        <input name="treatment_session_done_update" type="number"
                                            class="form-control <?php $__errorArgs = ['treatment_session_done_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            placeholder="How many session?">

                                        <span id="treatment_session_done_update_error" class="error-msg-form"></span>

                                        <?php $__errorArgs = ['treatment_session_done_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="error-msg-form">
                                            <?php echo e($message); ?>

                                        </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>

                                    <div class="col-12 mb-2">
                                        <label class="form-label"><?php echo e(__('basic.status')); ?>

                                            <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                        <select
                                            class="select2-no-search-treatment select2-hidden-accessible select2-no-search-treatment <?php $__errorArgs = ['status_treatment_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            id="status_treatment_update" name="status_treatment_update" required>
                                            <option value="0">
                                                <?php echo e(__('basic.in prog')); ?>

                                            </option>
                                            <option value="1">
                                                <?php echo e(__('patientappo.done')); ?>

                                            </option>
                                        </select>

                                        <span id="status_treatment_update_error" class="error-msg-form"></span>

                                        <?php $__errorArgs = ['status_treatment_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="error-msg-form">
                                            <?php echo e($message); ?>

                                        </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                    </div>

                                    <div class="col-12 mb-2">
                                        <label class="form-label"><?php echo e(__('basic.start')); ?>

                                            <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                        <div class="input-group">
                                            <div class="input-group-prepend">
                                                <div class="input-group-text"><i class="bi bi-calendar2-week-fill"></i>
                                                </div>
                                            </div>
                                            <input name="treatment_start_update" type="text"
                                                class="form-control hasdatetimepicker <?php $__errorArgs = ['treatment_start_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                placeholder="YYYY/MM/DD" required>
                                        </div>
                                        <span id="treatment_start_update_error" class="error-msg-form"></span>

                                        <?php $__errorArgs = ['treatment_start_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="error-msg-form">
                                            <?php echo e($message); ?>

                                        </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>

                                    <div class="col-12 mb-2">
                                        <label class="form-label"><?php echo e(__('basic.end')); ?>

                                            <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                        <div class="input-group">
                                            <div class="input-group-prepend">
                                                <div class="input-group-text"><i class="bi bi-calendar2-week-fill"></i>
                                                </div>
                                            </div>
                                            <input name="treatment_end_update" type="text"
                                                class="form-control hasdatetimepicker <?php $__errorArgs = ['treatment_end_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                placeholder="YYYY/MM/DD" required>
                                        </div>

                                        <?php $__errorArgs = ['treatment_end_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="error-msg-form">
                                            <?php echo e($message); ?>

                                        </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                        <span id="treatment_end_update_error" class="error-msg-form"></span>
                                    </div>


                                </div>

                                <input name="treatment_id_update" value="" type="hidden">

                            </div>

                            <div class="modal-footer">
                                <div class="left-side">
                                    <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal"><?php echo e(__('basic.never mind')); ?></button>
                                </div>
                                <div class="divider"></div>
                                <div class="right-side">
                                    <button type="submit" class="btn btn-default btn-link main-color"><?php echo e(__('basic.update')); ?></button>
                                </div>
                            </div>
                        </form>

                    </div>
                </div>

            </div>

            <!-- treatment Modal delete -->
            <div class="modal fade" id="treatment_delete" tabindex="-1" aria-labelledby="exampleModalLabel"
                aria-hidden="true">
                <div class="modal-dialog  modal-dialog-centered modal-dialog-scrollable ">

                    <div class="modal-content shadow-lgg b-r-s-cont border-0">

                        <div class="modal-header">
                            <div class="modal-title" id="exampleModalLabel"><i class="fas fa-trash me-1"></i>
                                <?php echo e(__('basic.delete')); ?></div>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>

                        <form action="<?php echo e(route('sett.treatment.destroy', 'test')); ?>" method="post">
                            <?php echo e(method_field('delete')); ?>

                            <?php echo e(csrf_field()); ?>


                            <!-- Modal content -->
                            <div class="modal-body px-4">

                                <div class="modal-body delete-conf-input text-center py-0">
                                    <p class="mb-0">ِAre
                                        you sure you want to delete
                                        this
                                        treatment?</p><br>
                                    <input type="hidden" name="treatment_id_delete" value="">
                                </div>
                            </div>

                            <div class="modal-footer">
                                <div class="left-side">
                                    <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal"><?php echo e(__('basic.never mind')); ?></button>
                                </div>
                                <div class="divider"></div>
                                <div class="right-side">
                                    <button type="submit" class="btn btn-default btn-link text-red"><?php echo e(__('basic.delete')); ?>

                                    </button>
                                </div>

                            </div>
                        </form>

                    </div>
                </div>
            </div>

            <!-- Modal show all session -->
            <div class="modal fade" id="session_show" tabindex="-1" aria-labelledby="exampleModalLabel"
                aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-xl">
                    <div class="modal-content b-r-s-cont border-0">
                        <div class="modal-header">
                            <h5 class="modal-title" id="exampleModalLabel"><i class="fas fas fa-capsules me-1"></i>
                                <?php echo e(__('patientappo.session')); ?></h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>

                        <!-- Modal content -->
                        <div class="modal-body px-4">

                            <div class="table-responsive">
                                <table class="table display datatable-modal" id="table-session" width="100%"
                                    cellspacing="0">
                                    <thead>
                                        <tr>
                                            <th class="text-xs"><?php echo e(__('basic.date')); ?></th>
                                            <th class="text-xs"><?php echo e(__('basic.name')); ?></th>
                                            <th class="text-xs text-center">
                                                <?php echo e(__('patientappo.session status')); ?></th>
                                            <th class="text-xs text-center"><?php echo e(__('patientappo.pay status')); ?>

                                            </th>
                                            <th class="text-xs text-center"><?php echo e(__('patientappo.pay Code')); ?>

                                            </th>
                                            <th class="text-xs text-center"><?php echo e(__('patientappo.treat id')); ?>

                                            </th>
                                            <th class="text-xs text-center">
                                                <?php echo e(__('patientappo.treat sessions')); ?></th>
                                            <th class="text-xs text-center"><?php echo e(__('basic.handle')); ?></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $patient->sessions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if($item->status == 0): ?>
                                        <?php
                                        $text_color = 'active-color-btn';
                                        $msg = __('patientappo.not done');
                                        ?>
                                        <?php elseif($item->status == 1): ?>
                                        <?php
                                        $text_color = 'done-color-btn';
                                        $msg = __('basic.done');
                                        ?>
                                        <?php endif; ?>

                                        <?php if($item->invoice_item): ?>
                                        <?php if($item->invoice_item->invoice): ?>
                                        <?php if($item->invoice_item->invoice->status == 0): ?>
                                        <?php
                                        $text_color_invoice = 'cancel-color-btn';
                                        $msg_invoice = __('basic.not paid');
                                        ?>
                                        <?php elseif($item->invoice_item->invoice->status == 1): ?>
                                        <?php
                                        $text_color_invoice = 'pend-color-btn';
                                        $msg_invoice = __('basic.pending');
                                        ?>
                                        <?php elseif($item->invoice_item->invoice->status == 2): ?>
                                        <?php
                                        $text_color_invoice = 'prog-color-btn';
                                        $msg_invoice = __('basic.installment');
                                        ?>
                                        <?php elseif($item->invoice_item->invoice->status == 3): ?>
                                        <?php
                                        $text_color_invoice = 'done-color-btn';
                                        $msg_invoice = __('basic.paid');
                                        ?>
                                        <?php elseif($item->invoice_item->invoice->status == 4): ?>
                                        <?php
                                        $text_color_invoice = 'cancel-color-btn';
                                        $msg_invoice = __('basic.refund');
                                        ?>
                                        <?php endif; ?>
                                        <?php
                                        $invoice_url = 'href=' . route('sett.invoice.show',
                                        $item->invoice_item->invoice->id);
                                        ?>
                                        <?php else: ?>
                                        <?php
                                        $text_color_invoice = 'done-color-btn';
                                        $msg_invoice = __('patientappo.old record');
                                        $invoice_url = '';
                                        ?>
                                        <?php endif; ?>
                                        <?php else: ?>
                                        <?php
                                        $text_color_invoice = 'done-color-btn';
                                        $msg_invoice = __('patientappo.old record');
                                        $invoice_url = '';
                                        ?>
                                        <?php endif; ?>

                                        <tr>
                                            <td><?php echo e(date('d M Y', strtotime($item->date))); ?></td>
                                            <td><?php echo e($item->service_item->name); ?></td>
                                            <td class="text-center"> <span
                                                    class="badge rounded-pill <?php echo e($text_color); ?> badge-padd-l"><?php echo e($msg); ?></span>
                                            </td>
                                            <td class="text-center">
                                                <a <?php echo e($invoice_url); ?>><span
                                                        class="badge rounded-pill <?php echo e($text_color_invoice); ?> badge-padd-l"><?php echo e($msg_invoice); ?></span></a>
                                            </td>
                                            <td class="text-center">
                                                <?php if($item->invoice_item): ?>
                                                <?php echo e($item->invoice_item->invoice->code); ?>

                                                <?php else: ?>
                                                <?php echo e(__('patientappo.old record')); ?>

                                                <?php endif; ?>
                                            </td>
                                            <td class="text-center">
                                                <?php if(!empty($item->treatment->id)): ?>
                                                <?php echo e($item->treatment->id); ?>

                                                <?php endif; ?>
                                            </td>
                                            <td class="text-center">
                                                <?php if(!empty($item->treatment->sessions)): ?>
                                                <?php echo e($item->treatment->sessions); ?>

                                                <?php endif; ?>
                                            </td>

                                            <td class="text-center">
                                                <a data-session_id="<?php echo e($item->id); ?>"
                                                    data-status_session="<?php echo e($item->status); ?>"
                                                    data-treat_id="<?php if(!empty($item->treatment->id)): ?> <?php echo e($item->treatment->id); ?> <?php endif; ?>"
                                                    class="btn btn-sm status-col-link active-color-btn b-r-xs mb-1 session_edit_click"
                                                    title="edit"><i class="fas fa-pencil-alt"></i>
                                                    <?php echo e(__('basic.edit')); ?> </a>

                                                <?php if($item->invoice_item): ?>
                                                <?php if($item->invoice_item->invoice->status == 0): ?>
                                                <a data-session_id="<?php echo e($item->id); ?>"
                                                    class="btn btn-sm modal-effect status-col-link cancel-color-btn b-r-xs mb-1 session_delete_click"
                                                    title="delete" data-effect="effect-scale" data-bs-toggle="modal"
                                                    data-bs-target="#delete1"><i class="fas fa-trash"></i>
                                                    <?php echo e(__('basic.delete')); ?>

                                                </a>
                                                <?php endif; ?>
                                                <?php endif; ?>

                                            </td>

                                        </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    </tbody>
                                </table>
                            </div>
                        </div>

                        <div class="modal-footer">
                            <div class="left-side">
                                <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal">
                                    <?php echo e(__('basic.never mind')); ?></button>
                            </div>
                            <div class="divider"></div>
                            <div class="right-side">
                                <button type="button" class="btn btn-default btn-link main-color"><?php echo e(__('basic.save
                                    changes')); ?></button>
                            </div>
                        </div>

                    </div>
                </div>

            </div>

            <!-- Modal session update data -->
            <div class="modal fade" id="session_edit" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
                aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
                    <div class="modal-content b-r-s-cont border-0">
                        <div class="modal-header">
                            <h5 class="modal-title" id="exampleModalLabel"><i class="fas fa-capsules me-1"></i>
                                Update Session</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>

                        <form class="mb-0" action="<?php echo e(route('sett.session.update', '21')); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('PUT'); ?>

                            <!-- Modal content -->
                            <div class="modal-body px-5 py-3">

                                <div class="row mb-2">


                                    <div class="col-12 mb-2">
                                        <label class="form-label"><?php echo e(__('basic.status')); ?>

                                            <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                        <select
                                            class="select2-no-search-session select2-hidden-accessible select2-no-search-medicine <?php $__errorArgs = ['status_session_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            id="status_session_update" name="status_session_update" required>
                                            <option value="0">
                                                <?php echo e(__('patientappo.not done')); ?>

                                            </option>
                                            <option value="1">
                                                <?php echo e(__('patientappo.done')); ?>

                                            </option>
                                        </select>

                                        <span id="status_update_update_error" class="error-msg-form"></span>

                                        <?php $__errorArgs = ['status_update_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="error-msg-form">
                                            <?php echo e($message); ?>

                                        </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                    </div>


                                    <div class="col-12 mb-2">
                                        <label class="form-label"><?php echo e(__('patientappo.related to treatment')); ?>

                                            <small>( <?php echo e(__('basic.required')); ?>)</small></label>

                                        <select
                                            class="myselect2-session-update select2-hidden-accessible <?php $__errorArgs = ['related_treatment_id_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            id="related_treatment_id_update" name="related_treatment_id_update">
                                            <?php $__currentLoopData = $patient->treatments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php if($item->status == 0): ?>
                                            <option value="<?php echo e($item->id); ?>">
                                                <?php echo e($item->treatment_cat->name . ' - ' . $item->start); ?>

                                            </option>
                                            <?php endif; ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>

                                        <span id="related_treatment_id_update_error" class="error-msg-form"></span>

                                        <?php $__errorArgs = ['related_treatment_id_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="error-msg-form">
                                            <?php echo e($message); ?>

                                        </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                    </div>


                                </div>

                                <input name="session_id_update" value="" type="hidden">

                            </div>

                            <div class="modal-footer">
                                <div class="left-side">
                                    <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal"><?php echo e(__('basic.never mind')); ?></button>
                                </div>
                                <div class="divider"></div>
                                <div class="right-side">
                                    <button type="submit" class="btn btn-default btn-link main-color"><?php echo e(__('basic.update')); ?></button>
                                </div>
                            </div>
                        </form>

                    </div>
                </div>

            </div>

            <!-- session delete -->
            <div class="modal fade" id="session_delete" tabindex="-1" aria-labelledby="exampleModalLabel"
                aria-hidden="true">
                <div class="modal-dialog  modal-dialog-centered modal-dialog-scrollable ">

                    <div class="modal-content shadow-lgg b-r-s-cont border-0">

                        <div class="modal-header">
                            <div class="modal-title" id="exampleModalLabel"><i class="fas fa-trash me-1"></i>
                                <?php echo e(__('patientappo.session delete')); ?></div>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>

                        <form class="mb-0" action="<?php echo e(route('sett.session.destroy', 'test')); ?>" method="post">
                            <?php echo e(method_field('delete')); ?>

                            <?php echo e(csrf_field()); ?>


                            <!-- Modal content -->
                            <div class="modal-body px-4">

                                <div class="modal-body delete-conf-input text-center py-0">
                                    <p class="mb-0">ِAre
                                        you sure you want to delete
                                        this
                                        session?</p><br>
                                    <input type="hidden" name="session_id_delete" value="">
                                </div>
                            </div>

                            <div class="modal-footer">
                                <div class="left-side">
                                    <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal"><?php echo e(__('basic.never mind')); ?></button>
                                </div>
                                <div class="divider"></div>
                                <div class="right-side">
                                    <button type="submit" class="btn btn-default btn-link text-red"><?php echo e(__('basic.delete')); ?>

                                    </button>
                                </div>

                            </div>
                        </form>

                    </div>
                </div>
            </div>

            <!-- Modal add new session insert data -->
            <div class="modal fade" id="addsession" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
                aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">

                    <form class="mb-0" action="<?php echo e(route('sett.session.store')); ?>" method="post"
                        style="display: contents">
                        <?php echo e(method_field('POST')); ?>

                        <?php echo e(csrf_field()); ?>


                        <div class="modal-content b-r-s-cont border-0">
                            <div class="modal-header">
                                <h5 class="modal-title" id="exampleModalLabel"><i class="fas fa-capsules me-1"></i>
                                    <?php echo e(__('patientappo.new session')); ?></h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal"
                                    aria-label="Close"></button>
                            </div>

                            <!-- Modal content -->
                            <div class="modal-body px-5 py-3">

                                <div class="row mb-2">
                                    <div class="col-12 mb-2">
                                        <label class="form-label"><?php echo e(__('patientappo.session')); ?>

                                            <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                        <select
                                            class="myselect2-session-insert select2-hidden-accessible <?php $__errorArgs = ['session_cat_service'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            id="session_cat_service_insert" multiple name="session_cat_service[]"
                                            required>
                                            <?php $__currentLoopData = $service_cat_ses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($item->id); ?>" data-price="<?php echo e($item->price); ?>">
                                                <?php echo e($item->name . ' - ' . $item->price . 'EGP'); ?>

                                            </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>

                                        <span id="session_cat_service_error" class="error-msg-form"></span>

                                        <?php $__errorArgs = ['session_cat_service'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="error-msg-form">
                                            <?php echo e($message); ?>

                                        </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>

                                    <div class="col-12 mb-3">
                                        <label class="form-label"><?php echo e(__('basic.doctor')); ?>

                                            <small>(<?php echo e(__('basic.required')); ?>)</small></label>

                                        <select
                                            class="myselect2-session-insert select2-hidden-accessible <?php $__errorArgs = ['doc_session'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            id="doc_session" name="doc_session" required>
                                            <?php $__currentLoopData = $doctors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($item->id); ?>">
                                                <?php echo e($item->name); ?>

                                            </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>

                                        <span id="doc_session_error" class="error-msg-form"></span>

                                        <?php $__errorArgs = ['doc_session'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="error-msg-form">
                                            <?php echo e($message); ?>

                                        </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                    </div>

                                    <div class="col-12 mb-2">
                                        <label class="form-label"><?php echo e(__('basic.status')); ?>

                                            <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                        <select
                                            class="myselect2-session-insert-nosearch select2-hidden-accessible <?php $__errorArgs = ['session_status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            id="session_status" name="session_status" required>
                                            <option value="0">
                                                <?php echo e(__('patientappo.new record')); ?>

                                            </option>
                                            <option value="1">
                                                <?php echo e(__('patientappo.old record')); ?>

                                            </option>
                                        </select>

                                        <span id="session_status_error" class="error-msg-form"></span>

                                        <?php $__errorArgs = ['session_status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="error-msg-form">
                                            <?php echo e($message); ?>

                                        </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                    </div>

                                    <div class="col-12 mb-2">
                                        <label class="form-label"><?php echo e(__('patientappo.related to treatment')); ?>

                                            <small>(<?php echo e(__('basic.optional')); ?>)</small></label>
                                        <select
                                            class="myselect2-session-insert select2-hidden-accessible <?php $__errorArgs = ['related_treatment_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            id="related_treatment_id" name="related_treatment_id">
                                            <option disabled selected value> -- select treatment -- </option>
                                            <?php $__currentLoopData = $patient->treatments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php if($item->status == 0): ?>
                                            <option value="<?php echo e($item->id); ?>">
                                                <?php echo e($item->treatment_cat->name . ' - ' . $item->start); ?>

                                            </option>
                                            <?php endif; ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>

                                        <span id="related_treatment_id_error" class="error-msg-form"></span>

                                        <?php $__errorArgs = ['related_treatment_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="error-msg-form">
                                            <?php echo e($message); ?>

                                        </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>

                                    <div class="col-12 mb-2">
                                        <label class="form-label"><?php echo e(__('basic.date')); ?>

                                            <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                        <div class="input-group">
                                            <div class="input-group-prepend">
                                                <div class="input-group-text"><i class="bi bi-calendar2-week-fill"></i>
                                                </div>
                                            </div>
                                            <input name="session_date" type="text"
                                                class="form-control hasdatetimepicker <?php $__errorArgs = ['session_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                placeholder="YYYY/MM/DD" required>
                                        </div>
                                        <span id="session_date_error" class="error-msg-form"></span>

                                        <?php $__errorArgs = ['session_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="error-msg-form">
                                            <?php echo e($message); ?>

                                        </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>

                                    <hr class="my-2">

                                    <div class="col-12 mb-2">
                                        <label class="form-label"><?php echo e(__('basic.appointment')); ?>

                                            <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                        <select
                                            class="myselect2-session-insert-nosearch select2-hidden-accessible <?php $__errorArgs = ['last_appointment_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            id="last_appointment_id_pulses" name="last_appointment_id" required>
                                            <?php $__currentLoopData = $patient->appointments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($item->id); ?>">
                                                <?php echo e($item->start_at); ?>

                                            </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>

                                        <span id="last_appointment_id_error" class="error-msg-form"></span>

                                        <?php $__errorArgs = ['last_appointment_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="error-msg-form">
                                            <?php echo e($message); ?>

                                        </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                    </div>

                                    <div class="col-12 mb-2">
                                        <label class="form-label"><?php echo e(__('basic.invoice')); ?>

                                            <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                        <select
                                            class="myselect2-session-insert-nosearch <?php $__errorArgs = ['session_cat_service'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            id="session_cat_invoice_insert" name="session_cat_invoice" required>
                                            <option value="new">New Invoice</option>
                                            <option value="wallet">Wallet</option>
                                            <?php $__currentLoopData = $patient->invoices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php if($item->status == 0): ?>
                                            <option value="<?php echo e($item->id); ?>">
                                                <?php echo e($item->service_inv_cat . ' - ' . $item->final_price . 'EGP'); ?>

                                            </option>
                                            <?php endif; ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>

                                        <span id="session_cat_invoice_error" class="error-msg-form"></span>

                                        <?php $__errorArgs = ['session_cat_invoice'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="error-msg-form">
                                            <?php echo e($message); ?>

                                        </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>

                                    <div class="col-12 mb-2">
                                        <label class="form-label"><?php echo e(__('basic.invoice note')); ?>

                                            <small>(<?php echo e(__('basic.optional')); ?>)</small></label>
                                        <textarea name="invoice_note" class="form-control"
                                            placeholder="Write here your notes .." rows="4"
                                            spellcheck="false"></textarea>

                                        <span id="session_cat_invoice_error" class="error-msg-form"></span>

                                        <?php $__errorArgs = ['invoice_note'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="error-msg-form">
                                            <?php echo e($message); ?>

                                        </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                    </div>
                                </div>

                                <input name="patient_id" value="<?php echo e($patient->id); ?>" type="hidden">

                            </div>

                            <div class="modal-footer">
                                <div class="left-side">
                                    <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal"><?php echo e(__('basic.never mind')); ?></button>
                                </div>
                                <div class="divider"></div>
                                <div class="right-side">
                                    <button type="submit" class="btn btn-default btn-link main-color">Add
                                        New</button>
                                </div>
                            </div>

                        </div>
                    </form>

                </div>

            </div>



            <!----------------- show all glasses prescription ----------------->

            <!-- Modal Medicine insert data -->
            <div class="modal fade" id="add_eyeglasses_prescription" tabindex="-1" role="dialog"
                aria-labelledby="exampleModalLabel" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-lg">
                    <div class="modal-content b-r-s-cont border-0">
                        <div class="modal-header">
                            <h5 class="modal-title" id="exampleModalLabel"><i class="fas fa-glasses me-1"></i>
                                <?php echo e(__('basic.new eyeglasses prescription')); ?></h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>

                        <form id="add_new_eyeglass_modal" class="mb-0"
                            action="<?php echo e(route('sett.eyeglasses_prescription.store')); ?>" method="post"
                            style="display: contents">
                            <?php echo e(method_field('POST')); ?>

                            <?php echo e(csrf_field()); ?>


                            <!-- Modal content -->
                            <div class="modal-body px-4 py-3">

                                <div class="row mb-2 justify-content-center">

                                    <div class="table-responsive">
                                        <table class="table table_border display" width="100%" cellspacing="0">
                                            <thead>
                                                <tr style="background-color: #e6e6e6;">
                                                    <td class=""></td>
                                                    <th class="text-xs text-center" colspan="3">Right Eye</th>
                                                    <th class="text-xs text-center" colspan="3">Left Eye</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <tr style="background-color: #e6e6e6;">
                                                    <td class=""></td>
                                                    <td class="text-center">Sph.</td>
                                                    <td class="text-center">Cyl.</td>
                                                    <td class="text-center">Axis.</td>
                                                    <td class="text-center">Sph.</td>
                                                    <td class="text-center">Cyl.</td>
                                                    <td class="text-center">Axis.</td>
                                                </tr>
                                                <tr>
                                                    <td class="">D:</td>
                                                    <td class="">
                                                        <select
                                                            class="myselect2-eyeglasses_prescription-insert-nosearch border-0  w-100 select2-hidden-accessible <?php $__errorArgs = ['glass_right_sph'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                            id="glass_right_sph" name="glass_right_sph">
                                                            <option selected value=""></option>
                                                            <?php for($i = 0.25; $i <= 20.00; $i +=0.25): ?> <option
                                                                value="-<?php echo e(number_format($i, 2)); ?>">
                                                                <?php echo e("-" . number_format($i, 2)); ?>

                                                                </option>
                                                                <?php endfor; ?>
                                                                <?php for($i = 0.25; $i <= 20.00; $i +=0.25): ?> <option
                                                                    value="+<?php echo e(number_format($i, 2)); ?>">
                                                                    <?php echo e("+" . number_format($i, 2)); ?>

                                                                    </option>
                                                                    <?php endfor; ?>
                                                        </select>
                                                    </td>
                                                    <td class="">
                                                        <select
                                                            class="myselect2-eyeglasses_prescription-insert-nosearch border-0   w-100 select2-hidden-accessible <?php $__errorArgs = ['glass_right_cyl'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                            id="glass_right_cyl" name="glass_right_cyl">
                                                            <option selected value=""></option>
                                                            <?php for($i = 0.25; $i <= 06.00; $i +=0.25): ?> <option
                                                                value="-<?php echo e(number_format($i, 2)); ?>">
                                                                <?php echo e("-" . number_format($i, 2)); ?>

                                                                </option>
                                                                <?php endfor; ?>
                                                                <?php for($i = 0.25; $i <= 06.00; $i +=0.25): ?> <option
                                                                    value="+<?php echo e(number_format($i, 2)); ?>">
                                                                    <?php echo e("+" . number_format($i, 2)); ?>

                                                                    </option>
                                                                    <?php endfor; ?>
                                                        </select>
                                                    </td>
                                                    <td class="">
                                                        <select
                                                            class="myselect2-eyeglasses_prescription-insert-nosearch border-0   w-100 select2-hidden-accessible <?php $__errorArgs = ['glass_right_axis'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                            id="glass_right_axis" name="glass_right_axis">
                                                            <option selected value=""></option>
                                                            <?php for($i = 5; $i <= 180; $i +=5): ?> <option value="<?php echo e($i); ?>">
                                                                <?php echo e($i); ?>

                                                                </option>
                                                                <?php endfor; ?>
                                                        </select>
                                                    </td>
                                                    <td class="">
                                                        <select
                                                            class="myselect2-eyeglasses_prescription-insert-nosearch border-0  w-100 select2-hidden-accessible <?php $__errorArgs = ['glass_left_sph'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                            id="glass_left_sph" name="glass_left_sph">
                                                            <option selected value=""></option>
                                                            <?php for($i = 0.25; $i <= 20.00; $i +=0.25): ?> <option
                                                                value="-<?php echo e(number_format($i, 2)); ?>">
                                                                <?php echo e("-" . number_format($i, 2)); ?>

                                                                </option>
                                                                <?php endfor; ?>
                                                                <?php for($i = 0.25; $i <= 20.00; $i +=0.25): ?> <option
                                                                    value="+<?php echo e(number_format($i, 2)); ?>">
                                                                    <?php echo e("+" . number_format($i, 2)); ?>

                                                                    </option>
                                                                    <?php endfor; ?>
                                                        </select>
                                                    </td>
                                                    <td class="">
                                                        <select
                                                            class="myselect2-eyeglasses_prescription-insert-nosearch border-0   w-100 select2-hidden-accessible <?php $__errorArgs = ['glass_left_cyl'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                            id="glass_left_cyl" name="glass_left_cyl">
                                                            <option selected value=""></option>
                                                            <?php for($i = 0.25; $i <= 06.00; $i +=0.25): ?> <option
                                                                value="-<?php echo e(number_format($i, 2)); ?>">
                                                                <?php echo e("-" . number_format($i, 2)); ?>

                                                                </option>
                                                                <?php endfor; ?>
                                                                <?php for($i = 0.25; $i <= 06.00; $i +=0.25): ?> <option
                                                                    value="+<?php echo e(number_format($i, 2)); ?>">
                                                                    <?php echo e("+" . number_format($i, 2)); ?>

                                                                    </option>
                                                                    <?php endfor; ?>
                                                        </select>
                                                    </td>
                                                    <td class="">
                                                        <select
                                                            class="myselect2-eyeglasses_prescription-insert-nosearch border-0   w-100 select2-hidden-accessible <?php $__errorArgs = ['glass_left_axis'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                            id="glass_left_axis" name="glass_left_axis">
                                                            <option selected value=""></option>
                                                            <?php for($i = 5; $i <= 180; $i +=5): ?> <option value="<?php echo e($i); ?>">
                                                                <?php echo e($i); ?>

                                                                </option>
                                                                <?php endfor; ?>
                                                        </select>
                                                    </td>
                                                </tr>

                                                <tr>
                                                    <td class=""></td>
                                                    <td class="" colspan="3">
                                                        <select
                                                            class="myselect2-eyeglasses_prescription-insert-nosearch border-0  w-100 select2-hidden-accessible <?php $__errorArgs = ['glass_right_n_select'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                            id="glass_right_n_select" name="glass_right_n_select">
                                                            <option value="0" selected></option>
                                                            <?php for($i = 0.25; $i <= 20.00; $i +=0.25): ?> <option
                                                                value="<?php echo e(number_format($i, 2)); ?>">
                                                                <?php echo e("+" . number_format($i, 2)); ?>

                                                                </option>
                                                                <?php endfor; ?>
                                                        </select>
                                                    </td>

                                                    <td class="" colspan="3">
                                                        <select
                                                            class="myselect2-eyeglasses_prescription-insert-nosearch border-0  w-100 select2-hidden-accessible <?php $__errorArgs = ['glass_left_n_select'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                            id="glass_left_n_select" name="glass_left_n_select">
                                                            <option value="0" selected></option>
                                                            <?php for($i = 0.25; $i <= 20.00; $i +=0.25): ?> <option
                                                                value="<?php echo e(number_format($i, 2)); ?>">
                                                                <?php echo e("+" . number_format($i, 2)); ?>

                                                                </option>
                                                                <?php endfor; ?>
                                                        </select>
                                                    </td>
                                                </tr>


                                                <tr>
                                                    <td class="">N:</td>
                                                    <td class="" colspan="3">
                                                        <input id="glass_right_n" name="glass_right_n" type="text"
                                                            class="form-control w-100 border-0" readonly>
                                                    </td>

                                                    <td class="" colspan="3">
                                                        <input id="glass_left_n" name="glass_left_n" type="text"
                                                            class="form-control w-100 border-0" readonly>

                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>

                                    <div class="col-12 mb-2">
                                        <div class="d-flex align-items-center">
                                            <span class="me-2">IPD:</span>
                                            <input name="glass_ipd" type="text"
                                                class="form-control <?php $__errorArgs = ['glass_ipd'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                placeholder="Write here.." required>
                                        </div>

                                        <?php $__errorArgs = ['glass_ipd'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="error-msg-form">
                                            <?php echo e($message); ?>

                                        </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>

                                    <div class="col-12 col-md-8 mb-2">
                                        <label class="form-label"><?php echo e(__('basic.note')); ?>

                                            <small>(<?php echo e(__('basic.optional')); ?>)</small></label>
                                        <textarea name="glass_note"
                                            class="form-control  <?php $__errorArgs = ['glass_note'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            placeholder="Write here your note .." rows="4"
                                            spellcheck="false"></textarea>
                                        <span id="glass_note_error" class="error-msg-form"></span>

                                        <?php $__errorArgs = ['glass_note'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="error-msg-form">
                                            <?php echo e($message); ?>

                                        </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>

                                    <div class="col-12 col-md-8 mb-2">
                                        <label class="form-label"><?php echo e(__('basic.date')); ?>

                                            <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                        <div class="input-group">
                                            <div class="input-group-prepend">
                                                <div class="input-group-text"><i class="bi bi-calendar2-week-fill"></i>
                                                </div>
                                            </div>
                                            <input name="glass_date" value="<?php echo e(date('Y-m-d')); ?>" type="text"
                                                class="form-control hasdatetimepicker <?php $__errorArgs = ['glass_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                placeholder="YYYY/MM/DD" required>
                                        </div>
                                        <span id="glass_date" class="error-msg-form"></span>

                                        <?php $__errorArgs = ['glass_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="error-msg-form">
                                            <?php echo e($message); ?>

                                        </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>

                                    <div class="col-12 col-md-8 mb-4">
                                        <label class="form-label"><?php echo e(__('basic.appointment')); ?>

                                            <small>(<?php echo e(__('basic.optional')); ?>)</small></label>
                                        <select
                                            class="myselect2-medicine-insert-nosearch select2-hidden-accessible <?php $__errorArgs = ['last_appointment_id_eyeglasses_pres'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            id="last_appointment_id_eyeglasses_pres"
                                            name="last_appointment_id_eyeglasses_pres">
                                            <?php $__currentLoopData = $patient->appointments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($item->id); ?>">
                                                <?php echo e($item->start_at); ?>

                                            </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>

                                        <span id="last_appointment_id_error" class="error-msg-form"></span>

                                        <?php $__errorArgs = ['last_appointment_id_eyeglasses_pres'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="error-msg-form">
                                            <?php echo e($message); ?>

                                        </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>

                                <input name="patient_id" value="<?php echo e($patient->id); ?>" type="hidden">

                            </div>

                            <div class="modal-footer">
                                <div class="left-side">
                                    <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal"><?php echo e(__('basic.never mind')); ?></button>
                                </div>
                                <div class="divider"></div>
                                <div class="right-side">
                                    <button type="submit" class="btn btn-default btn-link main-color">New Glasses
                                        Prescriptions</button>
                                </div>
                            </div>
                        </form>

                    </div>
                </div>

            </div>

            <!-- Modal show all  eyeglasses prescriptions -->
            <div class="modal fade" id="eyeglasses_prescription_show" tabindex="-1" aria-labelledby="exampleModalLabel"
                aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
                    <div class="modal-content b-r-s-cont border-0">
                        <div class="modal-header">
                            <h5 class="modal-title" id="exampleModalLabel"><i class="fas fa-glasses me-1"></i>
                                <?php echo e(__('basic.eyeglasses prescriptions')); ?></h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>

                        <!-- Modal content -->
                        <div class="modal-body px-4">

                            <?php $__currentLoopData = $patient->eyeglasses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="d-flex justify-content-between align-items-center mb-3">

                                <div class="me-1 d-flex align-self-center align-items-center me-2 text-truncate">
                                    <i class="fas fa-glasses me-2 fs-4 mb-0 "></i>

                                    <div class="text-truncate">
                                        <p class="text-s text-truncate text-gray-700 mb-0 fw-bold">
                                            <?php echo e($item->date); ?>

                                        </p>
                                    </div>
                                </div>
                                <div>
                                    <a data-id="<?php echo e($item->id); ?>"
                                        class="btn rounded-pill btn-sm modal-effect status-col-link cancel-color-btn b-r-xs mb-1 eyeglass_delete_click"
                                        title="delete"><i class="fas fa-trash"></i>
                                    </a>
                                    <a href="<?php echo e(route('eyeglasses_prescription_print', [$patient->code, $item->code])); ?>"
                                        target="_blank">
                                        <span class="badge rounded-pill status-col-link main-color-btn badge-padd-l"><?php echo e(__('basic.download')); ?></span>
                                    </a>
                                </div>

                            </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        </div>

                        <div class="modal-footer">
                            <div class="left-side">
                                <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal"><?php echo e(__('basic.never mind')); ?></button>
                            </div>
                            <div class="divider"></div>
                            <div class="right-side">
                                <button id="new_attachment_modal" type="button"
                                    class="btn btn-default btn-link main-color"><?php echo e(__('basic.new attachment')); ?></button>
                            </div>
                        </div>

                    </div>
                </div>

            </div>

            <!-- Modal glass prescrations delete -->
            <div class="modal fade" id="eyeglasses_prescription_delete" tabindex="-1"
                aria-labelledby="exampleModalLabel" aria-hidden="true">
                <div class="modal-dialog  modal-dialog-centered modal-dialog-scrollable ">

                    <div class="modal-content shadow-lgg b-r-s-cont border-0">

                        <div class="modal-header">
                            <div class="modal-title" id="exampleModalLabel"><i class="fas fa-trash me-1"></i>
                                <?php echo e(__('basic.delete')); ?></div>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>

                        <form class="mb-0" action="<?php echo e(route('sett.eyeglasses_prescription.destroy', " 123")); ?>"
                            method="post">
                            <?php echo e(method_field('delete')); ?>

                            <?php echo e(csrf_field()); ?>


                            <!-- Modal content -->
                            <div class="modal-body px-4">

                                <div class="modal-body delete-conf-input text-center py-0">
                                    <p class="mb-0">ِAre you sure you want to delete it?</p><br>
                                    <input type="hidden" name="eyeglass_id_delete" value="">
                                </div>
                            </div>

                            <div class="modal-footer">
                                <div class="left-side">
                                    <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal"><?php echo e(__('basic.never mind')); ?></button>
                                </div>
                                <div class="divider"></div>
                                <div class="right-side">
                                    <button type="submit" class="btn btn-default btn-link text-red"><?php echo e(__('basic.delete')); ?>

                                    </button>
                                </div>

                            </div>
                        </form>

                    </div>
                </div>
            </div>


            <!----------------- show all medicines ----------------->

            <!-- Modal show all medicines -->
            <div class="modal fade" id="medicine_show" tabindex="-1" aria-labelledby="exampleModalLabel"
                aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
                    <div class="modal-content b-r-s-cont border-0">
                        <div class="modal-header">
                            <h5 class="modal-title" id="exampleModalLabel"><i class="fas fas fa-capsules me-1"></i>
                                <?php echo e(__('patientappo.current medicines')); ?></h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>

                        <!-- Modal content -->
                        <div class="modal-body px-4">
                            <?php $__currentLoopData = $patient->prescriptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="d-flex justify-content-between align-items-center mb-3">

                                <div class="me-1 d-flex align-self-center align-items-center me-2 text-truncate">
                                    <i class="fas fa-capsules me-2 fs-4 mb-0 "></i>

                                    <div class="text-truncate">
                                        <p class="text-s text-truncate text-gray-700 mb-0 fw-bold">
                                            <?php echo e($item->date); ?>

                                        </p>
                                    </div>
                                </div>
                                <div>
                                    <a data-id="<?php echo e($item->id); ?>"
                                        class="btn rounded-pill btn-sm modal-effect status-col-link cancel-color-btn b-r-xs mb-1 medicine_delete_click"
                                        title="delete"><i class="fas fa-trash"></i>
                                    </a>
                                    <a href="<?php echo e(route('pat_patient_print_pre', [$patient->code, $item->code])); ?>"
                                        target="_blank">
                                        <span class="badge rounded-pill status-col-link main-color-btn badge-padd-l"><?php echo e(__('basic.download')); ?></span>
                                    </a>
                                </div>

                            </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        </div>

                        <div class="modal-footer">
                            <div class="left-side">
                                <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal"><?php echo e(__('basic.never mind')); ?></button>
                            </div>
                            <div class="divider"></div>
                            <div class="right-side">
                                <button type="button" class="btn btn-default btn-link main-color"><?php echo e(__('basic.save
                                    changes')); ?></button>
                            </div>
                        </div>

                    </div>
                </div>

            </div>

            <!-- Modal Medicine insert data -->
            <div class="modal fade" id="addmedic" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
                aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
                    <div class="modal-content b-r-s-cont border-0">
                        <div class="modal-header">
                            <h5 class="modal-title" id="exampleModalLabel"><i class="fas fa-capsules me-1"></i>
                                <?php echo e(__('patientappo.add new medicines')); ?></h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>

                        <form id="add_new_medicine_modal" class="mb-0" action="<?php echo e(route('sett.medicine.store')); ?>"
                            method="post" style="display: contents">
                            <?php echo e(method_field('POST')); ?>

                            <?php echo e(csrf_field()); ?>


                            <!-- Modal content -->
                            <div class="modal-body px-5 py-3">

                                <div class="row mb-2">

                                    <div class="col-12" id="medicine_cont">


                                        <div class="table-responsive px-0" id="medicine_cont_table"
                                            style="display: none">
                                            <table class="table display datatable-modal border-0" width="100%"
                                                cellspacing="0">
                                                <thead>
                                                    <tr>
                                                        <th class="text-xs"><?php echo e(__('basic.name')); ?></th>
                                                        <th class="text-xs text-center"><?php echo e(__('basic.status')); ?></th>
                                                        <th class="text-xs text-center"><?php echo e(__('basic.doses')); ?>

                                                        </th>
                                                        <th class="text-xs text-center"><?php echo e(__('basic.duration')); ?></th>
                                                        <th class="text-xs text-center"></th>
                                                    </tr>
                                                </thead>
                                                <tbody id="medicine_cont_table_td">

                                                </tbody>
                                            </table>
                                        </div>


                                        <div class="text-center" id="medicine_cont_status">
                                            <h4><i class="fas fa-capsules"></i></h4>
                                            <h5 class=" text-gray-400">You have to add new medicines</h5>
                                        </div>

                                    </div>
                                    <div class="col-12 mb-2">
                                        <label class="form-label"><?php echo e(__('basic.medicines')); ?>

                                            <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                        <select
                                            class="myselect2-medicine-insert select2-hidden-accessible <?php $__errorArgs = ['medicine_pills'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            id="medicine_pills" name="medicine_pills" required>
                                            <?php $__currentLoopData = $medicine_cat; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($item->id); ?>" data-type="<?php echo e($item->type->name); ?>"
                                                data-type_id="<?php echo e($item->medicine_type_id); ?>">
                                                <?php echo e($item->name . ' - ' . $item->price . 'EGP'); ?>

                                            </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>

                                        <span id="medicine_pills_error" class="error-msg-form"></span>

                                        <?php $__errorArgs = ['medicine_pills'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="error-msg-form">
                                            <?php echo e($message); ?>

                                        </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>


                                    <div class="col-12 mb-2">


                                        <div class="row align-items-center rtl mb-2">
                                            <div class="col-9"> <select
                                                    class="myselect2-medicine-insert-nosearch border-0 select2-hidden-accessible <?php $__errorArgs = ['medicine_qty'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                    id="medicine_qty" name="medicine_qty" required>
                                                    <?php for($i = 1; $i < 20; $i++): ?> <option value="<?php echo e($i); ?>">
                                                        <?php echo e($i); ?>

                                                        </option>
                                                        <?php endfor; ?>
                                                </select>
                                                <?php $__errorArgs = ['medicine_qty'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <span class="error-msg-form">
                                                    <?php echo e($message); ?>

                                                </span>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>

                                            <div class="col-3">
                                                <span class="fw-bold" id="medicine_type_text"></span>
                                            </div>
                                        </div>

                                        <div class="row align-items-center rtl mb-2">
                                            <div class="col-12"> <select
                                                    class="myselect2-medicine-insert border-0 select2-hidden-accessible <?php $__errorArgs = ['medicine_dose'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                    id="medicine_dose" name="medicine_dose" required>
                                                    <?php $__currentLoopData = $med_does; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($item->id); ?>">
                                                        <?php echo e($item->name); ?>

                                                    </option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                                <?php $__errorArgs = ['medicine_dose'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <span class="error-msg-form">
                                                    <?php echo e($message); ?>

                                                </span>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>

                                        </div>
                                        <div class="row align-items-center rtl">
                                            <div class="col-3">
                                                <span class="fw-bold" id="medicine_type_text"> <?php echo e(__('basic.for')); ?>

                                                </span>
                                            </div>

                                            <div class="col-9"> <select
                                                    class="myselect2-medicine-insert border-0 select2-hidden-accessible <?php $__errorArgs = ['medicine_duration'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                    id="medicine_duration" name="medicine_duration" required>
                                                    <?php $__currentLoopData = $med_durations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($item->id); ?>">
                                                        <?php echo e($item->name); ?>

                                                    </option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                                <?php $__errorArgs = ['medicine_duration'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <span class="error-msg-form">
                                                    <?php echo e($message); ?>

                                                </span>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                        </div>
                                    </div>

                                    <hr>

                                    <div class="col-12 mb-3">
                                        <label class="form-label"><?php echo e(__('basic.status')); ?>

                                            <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                        <select
                                            class="myselect2-medicine-insert-nosearch select2-hidden-accessible <?php $__errorArgs = ['medicine_status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            id="medicine_status" name="medicine_status" required>
                                            <option value="0">
                                                <?php echo e(__('patientappo.on medicine')); ?>

                                            </option>
                                            <option value="1">
                                                <?php echo e(__('patientappo.no result')); ?>

                                            </option>
                                            <option value="2">
                                                <?php echo e(__('patientappo.done')); ?>

                                            </option>
                                        </select>

                                        <span id="medicine_status_error" class="error-msg-form"></span>

                                        <?php $__errorArgs = ['medicine_status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="error-msg-form">
                                            <?php echo e($message); ?>

                                        </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                    </div>

                                    

                                     <p id="medicine_cont_status_text" class="text-red text-center"></p>

                                    <button id="add_new_medicine_prescription"
                                        class="main-color-btn border-0 b-r-l-cont p-3 mb-3"><i class="fas fa-plus"></i>
                                        Add new medicine Prescription</button>

                                    <div class="col-12 mb-2">
                                        <label class="form-label"><?php echo e(__('basic.note')); ?>

                                            <small>(<?php echo e(__('basic.optional')); ?>)</small></label>
                                        <textarea name="medicine_note"
                                            class="form-control  <?php $__errorArgs = ['medicine_note'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            placeholder="Write here your note .." rows="4"
                                            spellcheck="false"></textarea>
                                        <span id="medicine_note_error" class="error-msg-form"></span>

                                        <?php $__errorArgs = ['medicine_note'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="error-msg-form">
                                            <?php echo e($message); ?>

                                        </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>


                                    <div class="col-12">
                                        <label class="form-label"><?php echo e(__('basic.appointment')); ?>

                                            <small>(<?php echo e(__('basic.optional')); ?>)</small></label>
                                        <select
                                            class="myselect2-medicine-insert-nosearch select2-hidden-accessible <?php $__errorArgs = ['last_appointment_id_medi'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            id="last_appointment_id_medi" name="last_appointment_id_medi">
                                            <?php $__currentLoopData = $patient->appointments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($item->id); ?>">
                                                <?php echo e($item->start_at); ?>

                                            </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>

                                        <span id="last_appointment_id_medi_error" class="error-msg-form"></span>

                                        <?php $__errorArgs = ['last_appointment_id_medi'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="error-msg-form">
                                            <?php echo e($message); ?>

                                        </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>

                                </div>

                                <input name="patient_id" value="<?php echo e($patient->id); ?>" type="hidden">

                            </div>

                            <div class="modal-footer">
                                <div class="left-side">
                                    <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal"><?php echo e(__('basic.never mind')); ?></button>
                                </div>
                                <div class="divider"></div>
                                <div class="right-side">
                                    <div id="new_create_prescr_btn" class="btn btn-default btn-link main-color">Create
                                        New Prescription</div>
                                </div>
                            </div>
                        </form>

                    </div>
                </div>

            </div>

            <!-- Modal Medicine update data -->
            <div class="modal fade" id="medicine_edit" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
                aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
                    <div class="modal-content b-r-s-cont border-0">
                        <div class="modal-header">
                            <h5 class="modal-title" id="exampleModalLabel"><i class="fas fa-capsules me-1"></i>
                                <?php echo e(__('patientappo.update medicines')); ?></h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>

                        <form class="mb-0" action="<?php echo e(route('sett.medicine.update', '21')); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('PUT'); ?>

                            <!-- Modal content -->
                            <div class="modal-body px-5 py-3">

                                <div class="row mb-2">

                                    <div class="col-12 mb-2">
                                        <label class="form-label">Medicine
                                            <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                        <select
                                            class="myselect2-medicine-update select2-hidden-accessible <?php $__errorArgs = ['medicine_pills_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            id="medicine_pills_update" name="medicine_pills_update" required>
                                            <?php $__currentLoopData = $medicine_cat; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($item->id); ?>">
                                                <?php echo e($item->name . ' - ' . $item->price . 'EGP'); ?>

                                            </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>

                                        <span id="medicine_pills_update_error" class="error-msg-form"></span>

                                        <?php $__errorArgs = ['medicine_pills_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="error-msg-form">
                                            <?php echo e($message); ?>

                                        </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                    </div>


                                    <div class="col-12 mb-2">
                                        <label class="form-label"><?php echo e(__('basic.status')); ?>

                                            <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                        <select
                                            class="myselect2-medicine-update select2-hidden-accessible select2-no-search-medicine <?php $__errorArgs = ['status_medicine_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            id="status_medicine_update" name="status_medicine_update" required>
                                            <option value="0">
                                                On medicine
                                            </option>
                                            <option value="1">
                                                No result
                                            </option>
                                            <option value="2">
                                                Done
                                            </option>
                                        </select>

                                        <span id="status_update_update_error" class="error-msg-form"></span>

                                        <?php $__errorArgs = ['status_update_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="error-msg-form">
                                            <?php echo e($message); ?>

                                        </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                    </div>

                                    <div class="col-12 mb-2">
                                        <label class="form-label"><?php echo e(__('basic.start')); ?>

                                            <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                        <div class="input-group">
                                            <div class="input-group-prepend">
                                                <div class="input-group-text"><i class="bi bi-calendar2-week-fill"></i>
                                                </div>
                                            </div>
                                            <input name="medicine_start_update" type="text"
                                                class="form-control hasdatetimepicker <?php $__errorArgs = ['medicine_start_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                placeholder="YYYY/MM/DD" required>
                                        </div>
                                        <span id="medicine_start_update_error" class="error-msg-form"></span>

                                        <?php $__errorArgs = ['medicine_start_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="error-msg-form">
                                            <?php echo e($message); ?>

                                        </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>

                                    <div class="col-12 mb-2">
                                        <label class="form-label"><?php echo e(__('basic.end')); ?>

                                            <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                        <div class="input-group">
                                            <div class="input-group-prepend">
                                                <div class="input-group-text"><i class="bi bi-calendar2-week-fill"></i>
                                                </div>
                                            </div>
                                            <input name="medicine_end_update" type="text"
                                                class="form-control hasdatetimepicker <?php $__errorArgs = ['medicine_end_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                placeholder="YYYY/MM/DD" required>
                                        </div>

                                        <?php $__errorArgs = ['medicine_end_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="error-msg-form">
                                            <?php echo e($message); ?>

                                        </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                        <span id="medicine_end_update_error" class="error-msg-form"></span>
                                    </div>


                                </div>

                                <input name="medicine_id_update" value="" type="hidden">

                            </div>

                            <div class="modal-footer">
                                <div class="left-side">
                                    <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal">Never
                                        Mind</button>
                                </div>
                                <div class="divider"></div>
                                <div class="right-side">
                                    <button type="submit" class="btn btn-default btn-link main-color">Update</button>
                                </div>
                            </div>
                        </form>

                    </div>
                </div>

            </div>

            <!-- Modal delete -->
            <div class="modal fade" id="medicine_delete" tabindex="-1" aria-labelledby="exampleModalLabel"
                aria-hidden="true">
                <div class="modal-dialog  modal-dialog-centered modal-dialog-scrollable ">

                    <div class="modal-content shadow-lgg b-r-s-cont border-0">

                        <div class="modal-header">
                            <div class="modal-title" id="exampleModalLabel"><i class="fas fa-trash me-1"></i>
                                Medicine delete</div>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>

                        <form class="mb-0" action="<?php echo e(route('sett.medicine.destroy', 'test')); ?>" method="post">
                            <?php echo e(method_field('delete')); ?>

                            <?php echo e(csrf_field()); ?>


                            <!-- Modal content -->
                            <div class="modal-body px-4">

                                <div class="modal-body delete-conf-input text-center py-0">
                                    <p class="mb-0">Are
                                        you sure you want to delete this prescription?</p><br>
                                    <input type="hidden" name="prescription_id_delete" value="">
                                </div>
                            </div>

                            <div class="modal-footer">
                                <div class="left-side">
                                    <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal">Never
                                        Mind</button>
                                </div>
                                <div class="divider"></div>
                                <div class="right-side">
                                    <button type="submit" class="btn btn-default btn-link text-red">Delete
                                    </button>
                                </div>

                            </div>
                        </form>

                    </div>
                </div>
            </div>

        </div>
    </div>
</div><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/proxima/resources/views/patient/component/clients/ramad/treat_sess.blade.php ENDPATH**/ ?>