<?php $__env->startSection('title', 'Statistics | Proxima - Medical Management app'); ?>

<?php $__env->startSection('title-topbar', 'Statistics'); ?>

<!-- css insert -->
<?php $__env->startSection('css'); ?>
    <!-- select 2 -->
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

    <!-- boostrap datepicker -->
    <link rel="stylesheet"
        href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.1/css/bootstrap-datepicker3.css" />

    <!-- tables -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/5.0.1/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/1.11.2/css/dataTables.bootstrap5.min.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.0.1/css/buttons.bootstrap5.min.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/autofill/2.3.9/css/autoFill.bootstrap5.min.css">
    <link rel="stylesheet"
        href="https://nightly.datatables.net/fixedheader/css/fixedHeader.dataTables.css?_=f0de745b101295e88f1504c17177ff49.css"
        type="text/css" />
<?php $__env->stopSection(); ?>

<!-- content insert -->
<?php $__env->startSection('content'); ?>

    <div class="container-fluid px-2 mt-3">

        <!-- page title link -->
        <div class="d-sm-flex align-items-center justify-content-between mb-4">

            <span class="mb-0">
                <a class="link-cust-text text-gray-200 fw-light" href="<?php echo e(route('sett.home')); ?>">Dashboard |</a>
                <a class="link-cust-text text-gray-200 fw-light" href="<?php echo e(route('sett.invoice.index')); ?>">Invoice | </a>
                <a class="text-gray-300">Day invoices</a>
            </span>

            <div class="d-flex justify-content-center mt-2 mt-md-0">
                <div class="cont-branch-calendar me-2">
                    <select id="select-specialty-calendar"
                        class="js-example-basic-single select2-no-search select2-hidden-accessible">
                        <option value="all">
                            All
                        </option>
                        <?php $__currentLoopData = $specialty_cat; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($item->id); ?>" <?php if($specialty == $item->id): ?> selected <?php endif; ?>>
                                <?php echo e($item->name); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>

                <div class="cont-branch-calendar me-2">
                    <select id="select-branch-calendar"
                        class="js-example-basic-single select2-no-search select2-hidden-accessible">
                        <?php if(Auth::user()->branch_id == 0): ?>
                            <option value="all">
                                All
                            </option>
                            <?php $__currentLoopData = $branches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($item->id); ?>" <?php if($branch == $item->id): ?> selected <?php endif; ?>>
                                    <?php echo e($item->name); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php else: ?>
                            <option value="<?php echo e(Auth::user()->branch_id); ?>">
                                <?php echo e(Auth::user()->branch->name); ?>

                            </option>
                        <?php endif; ?>
                    </select>
                </div>

                <div class="calendar-datepicker">
                    <div class="input-group">
                        <div class="input-group-prepend">
                            <div class="input-group-text ps-3"><i class="bi bi-calendar2-week-fill"></i> </div>
                        </div>
                        <input id="calendar-date-input" type="text" value="<?php echo e($date); ?>"
                            class="form-control hasdatetimepicker " placeholder="YYYY/MM/DD">
                    </div>
                </div>
            </div>

        </div>

        <div class="row mb-0">
            <?php if(request()->live_report): ?>
                <ul class="nav nav-tabs nav-tabs-nobg mb-3 justify-content-center border-bottom-0 pe-0" id="myTab"
                    role="tablist">
                    <li class="nav-item" role="presentation">
                        <a href="<?php echo e(route('sett.livereport')); ?>">
                            <button class="nav-link" id="year_invoice-tab" data-bs-toggle="tab"
                                data-bs-target="#year_invoice" type="button" role="tab" aria-controls="year_invoice"
                                aria-selected="true" class="text-gray-500"><i class="fas fa-cog me-1"></i>
                                Operations</button>
                        </a>
                    </li>
                    <li class="nav-item" role="presentation">
                        <a href="<?php echo e(route('sett.livereport')); ?>">
                            <button class="nav-link" id="specialty-tab" data-bs-toggle="tab"
                                data-bs-target="#specialty_stat" type="button" role="tab" aria-controls="home"
                                aria-selected="true" class="text-gray-500"><i class="fas fa-users me-1"></i>
                                Workers</button>
                        </a>
                    </li>
                    <li class="nav-item active" role="presentation">
                        <a href="<?php echo e(route('sett.invo_day_search', '?live_report=true')); ?>">
                            <button class="nav-link" id="branches-tab" data-bs-toggle="tab" data-bs-target="#branches"
                                type="button" role="tab" aria-controls="operation_tab" aria-selected="true"
                                class="text-gray-500"><i class="fas fa-money-check me-1"></i>
                                Accounting</button>
                        </a>
                    </li>
                    <li class="nav-item" role="presentation">
                        <a href="<?php echo e(route('sett.pulses_day_st', '?live_report=true')); ?>">
                            <button class="nav-link" id="branches-tab" data-bs-toggle="tab" data-bs-target="#branches"
                                type="button" role="tab" aria-controls="operation_tab" aria-selected="true"
                                class="text-gray-500"><i class="fas fa-thermometer me-1"></i>
                                Pulses</button>
                        </a>
                    </li>
                </ul>
            <?php else: ?>
                <ul class="nav nav-tabs nav-tabs-nobg nav-tabs-cat justify-content-center pe-0" id="myTab"
                    role="tablist">
                    <li class="nav-item" role="presentation">
                        <a href="<?php echo e(route('sett.invo_day_search')); ?>" class="nav-link active" id="year_invoice-tab">
                            <?php echo e(__('basic.daily st')); ?></a>
                    </li>
                    <li class="nav-item" role="presentation">
                        <a href="<?php echo e(route('sett.invo_month_search')); ?>" class="nav-link" id="specialty-tab">
                            <?php echo e(__('basic.monthly st')); ?></a>
                    </li>
                    <li class="nav-item" role="presentation">
                        <a href="<?php echo e(route('sett.invo_year_search')); ?>" class="nav-link" id="specialty-tab">
                            <?php echo e(__('basic.yearly st')); ?></a>
                    </li>
                    <li class="nav-item" role="presentation">
                        <a href="<?php echo e(route('sett.invo_allstatcs')); ?>" class="nav-link" id="specialty-tab">
                            <?php echo e(__('basic.statistics')); ?></a>
                    </li>
                </ul>
            <?php endif; ?>

        </div>

        <div class="row mb-2">
            <ul class="nav nav-tabs nav-tabs-nobg mb-3 justify-content-center border-bottom-0 pe-0" id="myTab"
                role="tablist">
                <li class="nav-item" role="presentation">
                    <button class="nav-link active" id="year_invoice-tab" data-bs-toggle="tab"
                        data-bs-target="#year_invoice" type="button" role="tab" aria-controls="year_invoice"
                        aria-selected="true" class="text-gray-500"><i class="fas fa-money-check me-1"></i>
                        Details</button>
                </li>
                <li class="nav-item" role="presentation">
                    <button class="nav-link" id="specialty-tab" data-bs-toggle="tab" data-bs-target="#specialty_stat"
                        type="button" role="tab" aria-controls="home" aria-selected="true"
                        class="text-gray-500"><i class="fas fa-wallet me-1"></i>
                        Wallet</button>
                </li>
                <?php if(auth()->check() && auth()->user()->hasRole('Super-admin|Operation')): ?>
                    <li class="nav-item" role="presentation">
                        <button class="nav-link" id="operation-tab" data-bs-toggle="tab" data-bs-target="#operation_tab"
                            type="button" role="tab" aria-controls="operation_tab" aria-selected="true"
                            class="text-gray-500"><i class="fas fa-stethoscope me-1"></i>
                            Operation</button>
                    </li>
                <?php endif; ?>
            </ul>
        </div>

        <div class="tab-content" id="myTabContent">

            <div class="tab-pane fade show active" id="year_invoice" role="tabpanel" aria-labelledby="year_invoice">

                <div class="row">
                    <div class="col-12 px-0 px-md-2 mb-4">
                        <div class="card card-input shadow h-100">
                            <!-- Card Header - Dropdown -->
                            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                                <h6 class="m-0 fw-bold"><i class="fas fa-money-check"></i> Income invoices</h6>
                            </div>

                            <!-- Card Body -->
                            <div class="card-body overflow-scroll">

                                <div class="table-responsive">
                                    <table class="table display datatable-modal" id="table-income-all" width="100%"
                                        cellspacing="0">
                                        <thead>
                                            <tr>
                                                <th class="text-xs text-center">Status</th>
                                                <th class="text-xs text-center fw-bold">Total</th>
                                                <?php if(auth()->check() && auth()->user()->hasRole('Super-admin|Accountant')): ?>
                                                    <th class="text-xs text-center fw-bold">Cost</th>
                                                <?php endif; ?>
                                                <th class="text-xs text-center">Cat</th>
                                                <th class="text-xs text-center">Items</th>
                                                <th class="text-xs text-center">Description</th>
                                                <th class="text-xs text-center">Discount</th>
                                                <th class="text-xs text-center">Patient</th>
                                                <th class="text-xs text-center">Branch</th>
                                            </tr>
                                        </thead>

                                        <tbody>
                                            <?php
                                                $total_income_cash = 0;
                                                $total_income_visa = 0;
                                            ?>

                                            <?php $__currentLoopData = $invoice_income; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td class="text-truncate">
                                                        <?php if($item->status == 1): ?>
                                                            <?php
                                                                $status = 'pend-color-btn';
                                                                $status_msg = __('basic.pending');
                                                            ?>
                                                        <?php elseif($item->status == 2): ?>
                                                            <?php
                                                                $status = 'prog-color-btn';
                                                                $status_msg = __('basic.installment');
                                                            ?>
                                                        <?php elseif($item->status == 3): ?>
                                                            <?php
                                                                $status = 'done-color-btn';
                                                                $status_msg = __('basic.paid');
                                                            ?>
                                                        <?php elseif($item->status == 4): ?>
                                                            <?php
                                                                $status = 'cancel-color-btn';
                                                                $status_msg = __('basic.refund');
                                                            ?>
                                                        <?php endif; ?>
                                                        <div
                                                            class="badge px-3 text-xxxs rounded-pill <?php echo e($status); ?> badge-padd-l">
                                                            <?php echo e($status_msg); ?></div>
                                                    </td>
                                                    <td class="text-center fw-bold text-gray-800">
                                                        <?php $__currentLoopData = $item->payment; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item_p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <?php if($item_p->method == 1): ?>
                                                                <?php
                                                                    $payment_method_txt = __('basic.cash');
                                                                    $total_income_cash += $item_p->amount;
                                                                ?>
                                                            <?php elseif($item_p->method == 2): ?>
                                                                <?php
                                                                    $payment_method_txt = __('basic.visa');
                                                                    $total_income_visa += $item_p->amount;
                                                                ?>
                                                            <?php endif; ?>

                                                            <?php echo e($item_p->amount); ?> <small class="text-gray-300 text-xxxs">
                                                                EGP
                                                            </small>
                                                            <div class="text-gray-300 text-xxxs">
                                                                via <?php echo e($payment_method_txt); ?> | shift:
                                                                <?php echo e($item_p->worker->name); ?>

                                                            </div>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </td>
                                                    <?php if(auth()->check() && auth()->user()->hasRole('Super-admin|Accountant')): ?>
                                                        <td class="text-truncate"><?php echo e($item->total_cost); ?> <small
                                                                class="text-gray-300 text-xxxs">
                                                                EGP
                                                            </small></td>
                                                    <?php endif; ?>
                                                    <td class="text-truncate"><?php echo e($item->service_inv_cat->name); ?></td>
                                                    <td class="text-truncate">
                                                        <a href="<?php echo e(route('sett.invoice.show', $item->id)); ?>"
                                                            class="link-cust-text text-gray-400">
                                                            <?php $__currentLoopData = $item->invoice_items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item_items): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <?php echo e($item_items->categorizable->name); ?> |
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </a>
                                                    </td>
                                                    <td class="text-truncate"><?php echo e($item->note); ?></td>
                                                    <td class="text-center text-gray-800">
                                                        <?php if($item->discount): ?>
                                                            <?php echo e($item->discount); ?> <small class="text-gray-300 text-xxxs">
                                                                EGP
                                                            </small>
                                                            <div class="text-gray-300 text-xxxs">
                                                                on <?php echo e($item->items_price); ?> egp
                                                            </div>
                                                        <?php else: ?>
                                                        <?php endif; ?>
                                                    </td>
                                                    <td class="text-truncate">
                                                        <?php if($item->receivable): ?>
                                                            <?php echo e($item->receivable->name); ?>

                                                        <?php else: ?>
                                                            <?php echo e(__('patientappo.no receiver')); ?>

                                                        <?php endif; ?>
                                                    </td>
                                                    <td class="text-truncate"><?php echo e($item->branch->name); ?>

                                                    </td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>


                                        <tfoot>
                                            <tr>
                                                <th class="text-center fw-bold text-s" style="background-color: #e2edfd;">
                                                    TOTAL</th>
                                                <th class="text-center fw-bold text-s2"
                                                    style="background-color: #e2edfd;">
                                                    <?php echo e($total_income = $total_income_cash + $total_income_visa); ?> <small
                                                        class="text-gray-300 text-xxxs">EGP</small>
                                                <th class="text-center fw-bold text-s">Cash</th>
                                                <th class="text-center fw-bold text-s2">
                                                    <?php echo e($total_income_cash); ?> <small
                                                        class="text-gray-300 text-xxxs">EGP</small>
                                                <th class="text-center fw-bold text-s">Credit</th>
                                                <th class="text-center fw-bold text-s2">
                                                    <?php echo e($total_income_visa); ?> <small
                                                        class="text-gray-300 text-xxxs">EGP</small>
                                                </th>
                                                <?php if(auth()->check() && auth()->user()->hasRole('Super-admin|Accountant')): ?>
                                                    <th class="text-center fw-bold text-s">Cost</th>
                                                    <th class="text-center fw-bold text-s2">
                                                        <?php echo e($invoice_income->sum('total_cost')); ?> <small
                                                            class="text-gray-300 text-xxxs">EGP</small>
                                                    </th>
                                                <?php endif; ?>
                                            </tr>
                                        </tfoot>

                                    </table>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-12 px-0 px-md-2 mb-4">
                        <div class="card card-input shadow h-100">
                            <!-- Card Header - Dropdown -->
                            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                                <h6 class="m-0 fw-bold"><i class="fas fa-money-check"></i> Expenses invoices</h6>
                            </div>

                            <!-- Card Body -->
                            <div class="card-body overflow-scroll">

                                <div class="table-responsive">
                                    <table class="table display datatable-modal" id="table-expenses-all" width="100%"
                                        cellspacing="0">
                                        <thead>
                                            <tr>
                                                <th class="text-xs text-center">Status</th>
                                                <th class="text-xs text-center fw-bold">Total</th>
                                                <th class="text-xs text-center">Cat</th>
                                                <th class="text-xs text-center">Items</th>
                                                <th class="text-xs text-center">Description</th>
                                                <th class="text-xs text-center">Discount</th>
                                                <th class="text-xs text-center">Patient</th>
                                                <th class="text-xs text-center">Branch</th>
                                            </tr>
                                        </thead>

                                        <tbody>
                                            <?php
                                                $total_expenses_cash = 0;
                                                $total_expenses_visa = 0;
                                            ?>

                                            <?php $__currentLoopData = $invoice_expenses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td class="text-truncate">
                                                        <?php if($item->status == 1): ?>
                                                            <?php
                                                                $status = 'pend-color-btn';
                                                                $status_msg = __('basic.pending');
                                                            ?>
                                                        <?php elseif($item->status == 2): ?>
                                                            <?php
                                                                $status = 'prog-color-btn';
                                                                $status_msg = __('basic.installment');
                                                            ?>
                                                        <?php elseif($item->status == 3): ?>
                                                            <?php
                                                                $status = 'done-color-btn';
                                                                $status_msg = __('basic.paid');
                                                            ?>
                                                        <?php elseif($item->status == 4): ?>
                                                            <?php
                                                                $status = 'cancel-color-btn';
                                                                $status_msg = __('basic.refund');
                                                            ?>
                                                        <?php endif; ?>
                                                        <div
                                                            class="badge px-3 text-xxxs rounded-pill <?php echo e($status); ?> badge-padd-l">
                                                            <?php echo e($status_msg); ?></div>
                                                    </td>
                                                    <td class="text-center fw-bold text-gray-800">
                                                        <?php $__currentLoopData = $item->payment; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item_p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <?php if($item_p->method == 1): ?>
                                                                <?php
                                                                    $payment_method_txt = __('basic.cash');
                                                                    $total_expenses_cash += $item_p->amount;
                                                                ?>
                                                            <?php elseif($item_p->method == 2): ?>
                                                                <?php
                                                                    $payment_method_txt = __('basic.visa');
                                                                    $total_expenses_visa += $item_p->amount;
                                                                ?>
                                                            <?php endif; ?>

                                                            <?php echo e($item_p->amount); ?> <small class="text-gray-300 text-xxxs">
                                                                EGP
                                                            </small>
                                                            <div class="text-gray-300 text-xxxs">
                                                                via <?php echo e($payment_method_txt); ?> | shift:
                                                                <?php echo e($item_p->worker->name); ?>

                                                            </div>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </td>
                                                    <td class="text-truncate"><?php echo e($item->service_inv_cat->name); ?></td>
                                                    <td class="text-truncate">
                                                        <a href="<?php echo e(route('sett.invoice.show', $item->id)); ?>"
                                                            class="link-cust-text text-gray-400">
                                                            <?php $__currentLoopData = $item->invoice_items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item_items): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <?php echo e($item_items->categorizable->name); ?> |
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </a>
                                                    </td>
                                                    <td class="text-truncate"><?php echo e($item->note); ?></td>
                                                    <td class="text-center text-gray-800">
                                                        <?php if($item->discount): ?>
                                                            <?php echo e($item->discount); ?> <small class="text-gray-300 text-xxxs">
                                                                EGP
                                                            </small>
                                                            <div class="text-gray-300 text-xxxs">
                                                                on <?php echo e($item->items_price); ?> egp
                                                            </div>
                                                        <?php else: ?>
                                                        <?php endif; ?>

                                                    </td>
                                                    <td class="text-truncate">
                                                        <?php if($item->receivable): ?>
                                                            <?php echo e($item->receivable->name); ?>

                                                        <?php else: ?>
                                                            <?php echo e(__('patientappo.no receiver')); ?>

                                                        <?php endif; ?>
                                                    </td>
                                                    <td class="text-truncate"><?php echo e($item->branch->name); ?>

                                                    </td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>


                                        <tfoot>
                                            <tr>
                                                <th class="text-center fw-bold text-s" style="background-color: #e2edfd;">
                                                    TOTAL</th>
                                                <th class="text-center fw-bold text-s2"
                                                    style="background-color: #e2edfd;">
                                                    <?php echo e($total_expenses = $total_expenses_cash + $total_expenses_visa); ?>

                                                    <small class="text-gray-300 text-xxxs">EGP</small>
                                                <th class="text-center fw-bold text-s">Cash</th>
                                                <th class="text-center fw-bold text-s2">
                                                    <?php echo e($total_expenses_cash); ?> <small
                                                        class="text-gray-300 text-xxxs">EGP</small>
                                                <th class="text-center fw-bold text-s">Credit</th>
                                                <th class="text-center fw-bold text-s2">
                                                    <?php echo e($total_expenses_visa); ?> <small
                                                        class="text-gray-300 text-xxxs">EGP</small>
                                                </th>
                                            </tr>
                                        </tfoot>

                                    </table>
                                </div>


                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="tab-pane fade" id="specialty_stat" role="tabpanel" aria-labelledby="specialty-tab">

                <div class="row">
                    <div class="col-12 px-0 px-md-2 mb-4">
                        <div class="card card-input shadow h-100">
                            <!-- Card Header - Dropdown -->
                            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                                <h6 class="m-0 fw-bold"><i class="fas fa-wallet"></i> Wallet transactions</h6>
                            </div>

                            <!-- Card Body -->
                            <div class="card-body overflow-scroll">

                                <div class="table-responsive">
                                    <table class="table display datatable-modal" id="table-income-totals-cat"
                                        width="100%" cellspacing="0">
                                        <thead>
                                            <tr>
                                                <th class="text-xs text-center">Type</th>
                                                <th class="text-xs text-center">Patient</th>
                                                <th class="text-xs text-center">Service name</th>
                                                <th class="text-xs text-center">Balance Before</th>
                                                <th class="text-xs text-center">Amount</th>
                                                <th class="text-xs text-center">Balance After</th>
                                                <th class="text-xs text-center">Branch</th>
                                                <th class="text-xs text-center">Note</th>
                                            </tr>
                                        </thead>

                                        <tfoot>
                                            <tr>
                                                <th width="50%" class="text-center fw-bold text-s"
                                                    style="background-color: #e2edfd;">TOTAL</th>
                                                <th width="50%" class="text-center fw-bold text-s2"
                                                    style="background-color: #e2edfd;">
                                                    <?php echo e($wallet->sum('amount')); ?> <small class="text-gray-300 text-xxxs">
                                                        EGP</small>
                                                </th>
                                            </tr>
                                        </tfoot>

                                        <tbody>
                                            <?php $__currentLoopData = $wallet; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php if($item->type == 0): ?>
                                                    <?php
                                                        $text_color = 'main-color-btn';
                                                        $msg = __('basic.add');
                                                    ?>
                                                <?php elseif($item->type == 1): ?>
                                                    <?php
                                                        $text_color = 'cancel-color-btn';
                                                        $msg = __('basic.withdraw');
                                                    ?>
                                                <?php endif; ?>

                                                <tr>
                                                    <td class="text-center"><span
                                                            class="badge rounded-pill <?php echo e($text_color); ?> badge-padd-l"><?php echo e($msg); ?></span>
                                                    </td>
                                                    <td class="text-center text-truncate">
                                                        <a class="link-cust-text text-gray-500"
                                                            href="<?php echo e(route('sett.patient.show', $item->patient->id)); ?>">
                                                            <?php echo e($item->patient->name); ?></a>
                                                    </td>
                                                    <td class="text-center text-truncate">
                                                        <?php if($item->service): ?>
                                                            <?php echo e($item->service->name); ?>

                                                        <?php else: ?>
                                                            Add new balance
                                                        <?php endif; ?>
                                                    </td>
                                                    <td class="text-center">
                                                        <?php echo e($item->balance_before_tran); ?> <small
                                                            class="text-gray-300 text-xxxs">
                                                            EGP</small>
                                                    </td>
                                                    <td class="text-center">
                                                        <?php echo e($item->amount); ?> <small class="text-gray-300 text-xxxs">
                                                            EGP</small>
                                                    </td>
                                                    <td class="text-center">
                                                        <?php echo e($item->balance_before_tran - $item->amount); ?> <small
                                                            class="text-gray-300 text-xxxs">
                                                            EGP</small>
                                                    </td>
                                                    <td class="text-center text-truncate">
                                                        <?php echo e($item->branch->name); ?>

                                                    </td>
                                                    <td class="text-center text-truncate">
                                                        <?php echo e($item->note); ?>

                                                    </td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                        </tbody>
                                    </table>
                                </div>


                            </div>
                        </div>
                    </div>
                </div>

            </div>

            <?php if(auth()->check() && auth()->user()->hasRole('Super-admin|Operation')): ?>
                <div class="tab-pane fade" id="operation_tab" role="tabpanel" aria-labelledby="operation-tab">

                    <div class="row">
                        <div class="col-12 px-0 px-md-2 mb-4">
                            <div class="card card-input shadow h-100">
                                <!-- Card Header - Dropdown -->
                                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                                    <h6 class="m-0 fw-bold"><i class="fas fa-money-check"></i> Operation income invoices
                                    </h6>
                                </div>

                                <!-- Card Body -->
                                <div class="card-body overflow-scroll">

                                    <div class="table-responsive">
                                        <table class="table display datatable-modal" id="table-operation-income-all"
                                            width="100%" cellspacing="0">
                                            <thead>
                                                <tr>
                                                    <th class="text-xs text-center">Status</th>
                                                    <th class="text-xs text-center fw-bold">Total</th>
                                                    <th class="text-xs text-center fw-bold">Cost</th>
                                                    <th class="text-xs text-center">Cat</th>
                                                    <th class="text-xs text-center">Items</th>
                                                    <th class="text-xs text-center">Description</th>
                                                    <th class="text-xs text-center">Discount</th>
                                                    <th class="text-xs text-center">Patient</th>
                                                    <th class="text-xs text-center">Branch</th>
                                                </tr>
                                            </thead>

                                            <tbody>
                                                <?php
                                                    $total_income_op_cash = 0;
                                                    $total_income_op_visa = 0;
                                                ?>

                                                <?php $__currentLoopData = $invoice_oper_income; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <tr>
                                                        <td class="text-truncate">
                                                            <?php if($item->status == 1): ?>
                                                                <?php
                                                                    $status = 'pend-color-btn';
                                                                    $status_msg = __('basic.pending');
                                                                ?>
                                                            <?php elseif($item->status == 2): ?>
                                                                <?php
                                                                    $status = 'prog-color-btn';
                                                                    $status_msg = __('basic.installment');
                                                                ?>
                                                            <?php elseif($item->status == 3): ?>
                                                                <?php
                                                                    $status = 'done-color-btn';
                                                                    $status_msg = __('basic.paid');
                                                                ?>
                                                            <?php elseif($item->status == 4): ?>
                                                                <?php
                                                                    $status = 'cancel-color-btn';
                                                                    $status_msg = __('basic.refund');
                                                                ?>
                                                            <?php endif; ?>
                                                            <div
                                                                class="badge px-3 text-xxxs rounded-pill <?php echo e($status); ?> badge-padd-l">
                                                                <?php echo e($status_msg); ?></div>
                                                        </td>
                                                        <td class="text-center fw-bold text-gray-800">
                                                            <?php $__currentLoopData = $item->payment; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item_p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <?php if($item_p->method == 1): ?>
                                                                    <?php
                                                                        $payment_method_txt = __('basic.cash');
                                                                        $total_income_cash += $item_p->amount;
                                                                    ?>
                                                                <?php elseif($item_p->method == 2): ?>
                                                                    <?php
                                                                        $payment_method_txt = __('basic.visa');
                                                                        $total_income_visa += $item_p->amount;
                                                                    ?>
                                                                <?php endif; ?>

                                                                <?php echo e($item_p->amount); ?> <small class="text-gray-300 text-xxxs">
                                                                    EGP
                                                                </small>
                                                                <div class="text-gray-300 text-xxxs">
                                                                    via <?php echo e($payment_method_txt); ?> | shift:
                                                                    <?php echo e($item_p->worker->name); ?>

                                                                </div>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </td>
                                                        <td class="text-truncate"><?php echo e($item->total_cost); ?> <small
                                                                class="text-gray-300 text-xxxs">
                                                                EGP
                                                            </small></td>
                                                        <td class="text-truncate"><?php echo e($item->service_inv_cat->name); ?></td>
                                                        <td class="text-truncate">
                                                            <a href="<?php echo e(route('sett.invoice.show', $item->id)); ?>"
                                                                class="link-cust-text text-gray-400">
                                                                <?php $__currentLoopData = $item->invoice_items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item_items): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                    <?php echo e($item_items->categorizable->name); ?> |
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            </a>
                                                        </td>
                                                        <td class="text-truncate"><?php echo e($item->note); ?></td>
                                                        <td class="text-center text-gray-800">
                                                            <?php if($item->discount): ?>
                                                                <?php echo e($item->discount); ?> <small class="text-gray-300 text-xxxs">
                                                                    EGP
                                                                </small>
                                                                <div class="text-gray-300 text-xxxs">
                                                                    on <?php echo e($item->items_price); ?> egp
                                                                </div>
                                                            <?php else: ?>
                                                            <?php endif; ?>

                                                        </td>
                                                        <td class="text-truncate">
                                                            <?php if($item->receivable): ?>
                                                                <?php echo e($item->receivable->name); ?>

                                                            <?php else: ?>
                                                                <?php echo e(__('patientappo.no receiver')); ?>

                                                            <?php endif; ?>
                                                        </td>
                                                        <td class="text-truncate"><?php echo e($item->branch->name); ?>

                                                        </td>
                                                    </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </tbody>


                                            <tfoot>
                                                <tr>
                                                    <th class="text-center fw-bold text-s" style="background-color: #e2edfd;">
                                                        TOTAL</th>
                                                    <th class="text-center fw-bold text-s2"
                                                        style="background-color: #e2edfd;">
                                                        <?php echo e($total_op_income = $total_income_op_cash + $total_income_op_visa); ?>

                                                        <small class="text-gray-300 text-xxxs">EGP</small>
                                                    <th class="text-center fw-bold text-s">Cash</th>
                                                    <th class="text-center fw-bold text-s2">
                                                        <?php echo e($total_income_op_cash); ?> <small
                                                            class="text-gray-300 text-xxxs">EGP</small>
                                                    <th class="text-center fw-bold text-s">Credit</th>
                                                    <th class="text-center fw-bold text-s2">
                                                        <?php echo e($total_income_op_visa); ?> <small
                                                            class="text-gray-300 text-xxxs">EGP</small>
                                                    </th>
                                                    <th class="text-center fw-bold text-s">Cost</th>
                                                    <th class="text-center fw-bold text-s2">
                                                        <?php echo e($invoice_income->sum('total_cost')); ?> <small
                                                            class="text-gray-300 text-xxxs">EGP</small>
                                                    </th>
                                                </tr>
                                            </tfoot>

                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>


                    <div class="row">
                        <div class="col-12 px-0 px-md-2 mb-4">
                            <div class="card card-input shadow h-100">
                                <!-- Card Header - Dropdown -->
                                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                                    <h6 class="m-0 fw-bold"><i class="fas fa-money-check"></i> Operation expenses invoices
                                    </h6>
                                </div>

                                <!-- Card Body -->
                                <div class="card-body overflow-scroll">
                                    <div class="table-responsive">
                                        <table class="table display datatable-modal" id="table-operation-expenses-all"
                                            width="100%" cellspacing="0">
                                            <thead>
                                                <tr>
                                                    <th class="text-xs text-center">Status</th>
                                                    <th class="text-xs text-center fw-bold">Total</th>
                                                    <th class="text-xs text-center">Cat</th>
                                                    <th class="text-xs text-center">Items</th>
                                                    <th class="text-xs text-center">Description</th>
                                                    <th class="text-xs text-center">Discount</th>
                                                    <th class="text-xs text-center">Patient</th>
                                                    <th class="text-xs text-center">Branch</th>
                                                </tr>
                                            </thead>

                                            <tbody>
                                                <?php
                                                    $total_expenses_op_cash = 0;
                                                    $total_expenses_op_visa = 0;
                                                ?>

                                                <?php $__currentLoopData = $invoice_oper_expenses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <tr>
                                                        <td class="text-truncate">
                                                            <?php if($item->status == 1): ?>
                                                                <?php
                                                                    $status = 'pend-color-btn';
                                                                    $status_msg = __('basic.pending');
                                                                ?>
                                                            <?php elseif($item->status == 2): ?>
                                                                <?php
                                                                    $status = 'prog-color-btn';
                                                                    $status_msg = __('basic.installment');
                                                                ?>
                                                            <?php elseif($item->status == 3): ?>
                                                                <?php
                                                                    $status = 'done-color-btn';
                                                                    $status_msg = __('basic.paid');
                                                                ?>
                                                            <?php elseif($item->status == 4): ?>
                                                                <?php
                                                                    $status = 'cancel-color-btn';
                                                                    $status_msg = __('basic.refund');
                                                                ?>
                                                            <?php endif; ?>
                                                            <div
                                                                class="badge px-3 text-xxxs rounded-pill <?php echo e($status); ?> badge-padd-l">
                                                                <?php echo e($status_msg); ?></div>
                                                        </td>
                                                        <td class="text-center fw-bold text-gray-800">
                                                            <?php $__currentLoopData = $item->payment; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item_p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <?php if($item_p->method == 1): ?>
                                                                    <?php
                                                                        $payment_method_txt = __('basic.cash');
                                                                        $total_income_cash += $item_p->amount;
                                                                    ?>
                                                                <?php elseif($item_p->method == 2): ?>
                                                                    <?php
                                                                        $payment_method_txt = __('basic.visa');
                                                                        $total_income_visa += $item_p->amount;
                                                                    ?>
                                                                <?php endif; ?>

                                                                <?php echo e($item_p->amount); ?> <small class="text-gray-300 text-xxxs">
                                                                    EGP
                                                                </small>
                                                                <div class="text-gray-300 text-xxxs">
                                                                    via <?php echo e($payment_method_txt); ?> | shift:
                                                                    <?php echo e($item_p->worker->name); ?>

                                                                </div>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </td>
                                                        <td class="text-truncate"><?php echo e($item->service_inv_cat->name); ?></td>
                                                        <td class="text-truncate">
                                                            <a href="<?php echo e(route('sett.invoice.show', $item->id)); ?>"
                                                                class="link-cust-text text-gray-400">
                                                                <?php $__currentLoopData = $item->invoice_items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item_items): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                    <?php echo e($item_items->categorizable->name); ?> |
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            </a>
                                                        </td>
                                                        <td class="text-truncate"><?php echo e($item->note); ?></td>
                                                        <td class="text-center text-gray-800">
                                                            <?php if($item->discount): ?>
                                                                <?php echo e($item->discount); ?> <small class="text-gray-300 text-xxxs">
                                                                    EGP
                                                                </small>
                                                                <div class="text-gray-300 text-xxxs">
                                                                    on <?php echo e($item->items_price); ?> egp
                                                                </div>
                                                            <?php else: ?>
                                                            <?php endif; ?>

                                                        </td>
                                                        <td class="text-truncate">
                                                            <?php if($item->receivable): ?>
                                                                <?php echo e($item->receivable->name); ?>

                                                            <?php else: ?>
                                                                <?php echo e(__('patientappo.no receiver')); ?>

                                                            <?php endif; ?>
                                                        </td>
                                                        <td class="text-truncate"><?php echo e($item->branch->name); ?>

                                                        </td>
                                                    </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </tbody>


                                            <tfoot>
                                                <tr>
                                                    <th class="text-center fw-bold text-s">TOTAL</th>
                                                    <th class="text-center fw-bold text-s2">
                                                        <?php echo e($total_op_expenses = $total_expenses_op_cash + $total_expenses_op_visa); ?>

                                                        <small class="text-gray-300 text-xxxs">EGP</small>
                                                    <th class="text-center fw-bold text-s">Cash</th>
                                                    <th class="text-center fw-bold text-s2">
                                                        <?php echo e($total_expenses_op_cash); ?> <small
                                                            class="text-gray-300 text-xxxs">EGP</small>
                                                    <th class="text-center fw-bold text-s">Credit</th>
                                                    <th class="text-center fw-bold text-s2">
                                                        <?php echo e($total_expenses_op_visa); ?> <small
                                                            class="text-gray-300 text-xxxs">EGP</small>
                                                    </th>
                                                </tr>
                                            </tfoot>

                                        </table>
                                    </div>


                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            <?php endif; ?>

        </div>

        <div class="row">

            <div class="col-12 px-0 px-md-2">
                <div class="card card-input shadow mb-4">
                    <!-- Card Body -->
                    <div class="card-body">
                        <div class="row">

                            <div class="col-12 col-md-6 mb-3 mb-md-0 border-flex">
                                <div class="mt-4 text-center small">
                                    <span class="me-2">
                                        <i class="fas fa-circle text-success"></i> Income
                                    </span>
                                    <span class="me-2">
                                        <i class="fas fa-circle text-primary"></i> Expenses
                                    </span>
                                </div>
                                <div class="chart-pie pt-4 pb-2">
                                    <canvas id="myChart">
                                        <!-- the code and its style is printed from js -->
                                    </canvas>
                                </div>
                            </div>

                            <div class="col-12 col-md-6 text-center align-self-center">
                                <h6 class="text-gray-400">Net Income</h6>
                                <?php
                                    $profit = $total_income - $total_expenses;
                                ?>
                                <span class="fs-1"><?php echo e($profit); ?><small class="text-gray-300 text-xxxs">
                                        EGP</small></span>
                                <?php if(auth()->check() && auth()->user()->hasRole('Super-admin|Accountant')): ?>
                                    <hr>
                                    <h6 class="text-gray-400">Net Income After Cost</h6>
                                    <span class="fs-1"><?php echo e($total_income - $invoice_income->sum('total_cost')); ?><small
                                            class="text-gray-300 text-xxxs">
                                            EGP</small></span>
                                <?php endif; ?>
                            </div>

                        </div>
                    </div>
                </div>
            </div>

        </div>

    <?php $__env->stopSection(); ?>

    <!-- js insert -->
    <?php $__env->startSection('js'); ?>

        <!-- select 2 -->
        <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

        <script>
            $(document).ready(function() {
                $('.js-example-basic-single').select2();
                //hide search
                $('.select2-no-search').select2({
                    minimumResultsForSearch: -1
                });
            });
        </script>

        <script>
            $(document).ready(function() {

                //--------------------- selectors -------------------
                $(document).on('change', '#select-specialty-calendar, #select-branch-calendar', function() {
                    var date_input = $('#calendar-date-input').val();
                    var date = $('#select-specialty-calendar').val();
                    var date2 = $('#select-branch-calendar').val();

                    var url = "<?php echo e(route('sett.invo_day_search', [':date_input', ':date', ':date2'])); ?>";

                    url = url.replace(':date_input', date_input).replace(':date', date).replace(':date2',
                        date2);

                    var url = url;
                    window.location.href = url;
                });
                $(document).on('change', '#calendar-date-input', function() {
                    var date_input = $('#calendar-date-input').val();
                    var date = $('#select-specialty-calendar').val();
                    var date2 = $('#select-branch-calendar').val();

                    var url = "<?php echo e(route('sett.invo_day_search', [':date_input', ':date', ':date2'])); ?>";

                    url = url.replace(':date_input', date_input).replace(':date', date).replace(':date2',
                        date2);

                    window.location.href = url;
                });
            });
        </script>

        <!-- jquery ui datepicker -->
        <script type="text/javascript"
            src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.1/js/bootstrap-datepicker.min.js"></script>

        <script>
            $(function() {
                $('.hasdatetimepicker').datepicker({
                    todayHighlight: true,
                    format: "yyyy-mm-dd",
                });
            });
        </script>

        <!-- -- Chart.js plugin -- -->
        <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

        <?php
            $chart_color = ['#1a78f1', '#38dfa8', '#d13c62', '#12c7d9', '#03c2c3', '#5035df', '#17a673', '#2e59d9', '#9aeded', '#f3d56a', '#7c859d', '#a4adc5', '#80142f', '#33d293', '#bed233', '#3958e9', '#10c86f', '#654fb6', '#a44fb6', '#89728e', '#c85110', '#6d769d', '#1b6954', '#204494', '#94206b', '#948320', '#209493', '#292094', '#203a65', '#4e6fa5', '#e29031', '#e23168', '#31e0e2', '#e29131', '#319fe2', '#8131e2', '#31a8e2', '#31e2c0', '#31c3e2', '#e2a931', '#3157e2', '#dc3545', '#51b24b', '#a94bb2', '#4b8bb2', '#57b24b', '#a5b24b', '#b2804b', '#b24b4b', '#834bb2', '#b24b6a', '#574bb2', '#236368', '#232c68', '#682345', '#4b2368', '#234b68', '#306823', '#a39f39', '#a239a3', '#a33963', '#a33951', '#a33939', '#c73737', '#6837c7'];
        ?>

        <script>
            // Pie Chart Example
            var ctx = document.getElementById("myChart");
            var myPieChart = new Chart(ctx, {
                type: 'doughnut',
                data: {
                    labels: ["Income", "Expenses"],
                    datasets: [{
                        data: [<?php echo e($total_income); ?>,
                            <?php echo e($total_expenses); ?>

                        ],
                        backgroundColor: ['#1cc88a', '#4e73df'],
                        hoverBackgroundColor: ['#17a673', '#2e59d9'],
                        hoverBorderColor: "rgba(234, 236, 244, 1)",
                    }],
                },
                options: {
                    maintainAspectRatio: false,
                    tooltips: {
                        backgroundColor: "rgb(255,255,255)",
                        bodyFontColor: "#858796",
                        borderColor: '#dddfeb',
                        borderWidth: 1,
                        xPadding: 15,
                        yPadding: 15,
                        displayColors: false,
                        caretPadding: 10,
                        callbacks: {
                            label: function(tooltipItem) {
                                return tooltipItem.yLabel;
                            }
                        }
                    },
                    plugins: {
                        legend: {
                            display: false
                        }
                    },
                    cutoutPercentage: 80,
                },
            });
        </script>

        <!-- -- datatables plugin -- -->
        <script type="text/javascript" src="https://cdn.datatables.net/1.11.3/js/jquery.dataTables.min.js"></script>
        <script type="text/javascript" src="https://cdn.datatables.net/1.11.3/js/dataTables.bootstrap5.min.js"></script>
        <script type="text/javascript" src="https://cdn.datatables.net/buttons/2.0.1/js/dataTables.buttons.min.js"></script>
        <script type="text/javascript" src="https://cdn.datatables.net/buttons/2.0.1/js/buttons.bootstrap5.min.js"></script>

        <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
        <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
        <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
        <script type="text/javascript" src="https://cdn.datatables.net/buttons/2.0.1/js/buttons.html5.min.js"></script>

        <script type="text/javascript" language="javascript"
            src="https://cdn.datatables.net/buttons/2.0.1/js/buttons.print.min.js"></script>

        <script type="text/javascript" language="javascript"
            src="https://cdn.datatables.net/buttons/2.0.1/js/buttons.colVis.min.js"></script>
        <script
            src="https://nightly.datatables.net/fixedheader/js/dataTables.fixedHeader.js?_=f0de745b101295e88f1504c17177ff49">
        </script>

        <script>
            $(document).ready(function() {

                var table = $('#table-income-all').DataTable({
                        lengthChange: false,
                        "pageLength": 10,
                        "order": [
                            [0, "ASC"]
                        ],
                        buttons: {
                            dom: {
                                button: {
                                    className: 'btn btn-table-export me-0' //Primary class for all buttons
                                }
                            },
                            buttons: [{
                                    extend: 'copyHtml5',
                                    footer: true
                                },
                                {
                                    extend: 'excelHtml5',
                                    footer: true
                                },
                                {
                                    extend: 'pdfHtml5',
                                    footer: true
                                },
                                {
                                    extend: 'print',
                                    footer: true
                                }
                            ]
                        }
                    }

                );
                table.buttons().container()
                    .appendTo('#table-income-all_wrapper .col-md-6:eq(0)');

                var table = $('#table-expenses-all').DataTable({
                    lengthChange: false,
                    "pageLength": 10,
                    "order": [
                        [0, "ASC"]
                    ],
                    buttons: {
                        dom: {
                            button: {
                                className: 'btn btn-table-export me-0' //Primary class for all buttons
                            }
                        },
                        buttons: [{
                                extend: 'copyHtml5',
                                footer: true
                            },
                            {
                                extend: 'excelHtml5',
                                footer: true
                            },
                            {
                                extend: 'pdfHtml5',
                                footer: true
                            },
                            {
                                extend: 'print',
                                footer: true
                            }
                        ]
                    }
                });
                table.buttons().container()
                    .appendTo('#table-expenses-all_wrapper .col-md-6:eq(0)');

                var table = $('#table-income-totals-cat').DataTable({
                    lengthChange: false,
                    "pageLength": 10,
                    "order": [
                        [0, "ASC"]
                    ],
                    buttons: {
                        dom: {
                            button: {
                                className: 'btn btn-table-export me-0' //Primary class for all buttons
                            }
                        },
                        buttons: [{
                                extend: 'copyHtml5',
                                footer: true
                            },
                            {
                                extend: 'excelHtml5',
                                footer: true
                            },
                            {
                                extend: 'pdfHtml5',
                                footer: true
                            },
                            {
                                extend: 'print',
                                footer: true
                            }
                        ]
                    }
                });
                table.buttons().container()
                    .appendTo('#table-income-totals-cat_wrapper .col-md-6:eq(0)');

                var table = $('#table-expenses-totals-cat').DataTable({
                    lengthChange: false,
                    "pageLength": 10,
                    "order": [
                        [0, "ASC"]
                    ],
                    buttons: {
                        dom: {
                            button: {
                                className: 'btn btn-table-export me-0' //Primary class for all buttons
                            }
                        },
                        buttons: [{
                                extend: 'copyHtml5',
                                footer: true
                            },
                            {
                                extend: 'excelHtml5',
                                footer: true
                            },
                            {
                                extend: 'pdfHtml5',
                                footer: true
                            },
                            {
                                extend: 'print',
                                footer: true
                            }
                        ]
                    }
                });
                table.buttons().container()
                    .appendTo('#table-expenses-totals-cat_wrapper .col-md-6:eq(0)');

                var table = $('#table-income-totals').DataTable({
                    lengthChange: false,
                    "pageLength": 10,
                    "order": [
                        [0, "ASC"]
                    ],
                    buttons: {
                        dom: {
                            button: {
                                className: 'btn btn-table-export me-0' //Primary class for all buttons
                            }
                        },
                        buttons: [{
                                extend: 'copyHtml5',
                                footer: true
                            },
                            {
                                extend: 'excelHtml5',
                                footer: true
                            },
                            {
                                extend: 'pdfHtml5',
                                footer: true
                            },
                            {
                                extend: 'print',
                                footer: true
                            }
                        ]
                    }
                });
                table.buttons().container()
                    .appendTo('#table-income-totals_wrapper .col-md-6:eq(0)');

                var table = $('#table-expenses-totals').DataTable({
                    lengthChange: false,
                    "pageLength": 10,
                    "order": [
                        [0, "ASC"]
                    ],
                    buttons: {
                        dom: {
                            button: {
                                className: 'btn btn-table-export me-0' //Primary class for all buttons
                            }
                        },
                        buttons: [{
                                extend: 'copyHtml5',
                                footer: true
                            },
                            {
                                extend: 'excelHtml5',
                                footer: true
                            },
                            {
                                extend: 'pdfHtml5',
                                footer: true
                            },
                            {
                                extend: 'print',
                                footer: true
                            }
                        ]
                    }
                });
                table.buttons().container()
                    .appendTo('#table-expenses-totals_wrapper .col-md-6:eq(0)');

                var table = $('#table-operation-income-all').DataTable({
                    lengthChange: false,
                    "pageLength": 10,
                    "order": [
                        [0, "ASC"]
                    ],
                    buttons: {
                        dom: {
                            button: {
                                className: 'btn btn-table-export me-0' //Primary class for all buttons
                            }
                        },
                        buttons: [{
                                extend: 'copyHtml5',
                                footer: true
                            },
                            {
                                extend: 'excelHtml5',
                                footer: true
                            },
                            {
                                extend: 'pdfHtml5',
                                footer: true
                            },
                            {
                                extend: 'print',
                                footer: true
                            }
                        ]
                    }
                });
                table.buttons().container()
                    .appendTo('#table-operation-income-all_wrapper .col-md-6:eq(0)');
                var table = $('#table-operation-expenses-all').DataTable({
                    lengthChange: false,
                    "pageLength": 10,
                    "order": [
                        [0, "ASC"]
                    ],
                    buttons: {
                        dom: {
                            button: {
                                className: 'btn btn-table-export me-0' //Primary class for all buttons
                            }
                        },
                        buttons: [{
                                extend: 'copyHtml5',
                                footer: true
                            },
                            {
                                extend: 'excelHtml5',
                                footer: true
                            },
                            {
                                extend: 'pdfHtml5',
                                footer: true
                            },
                            {
                                extend: 'print',
                                footer: true
                            }
                        ]
                    }
                });
                table.buttons().container()
                    .appendTo('#table-operation-expenses-all_wrapper .col-md-6:eq(0)');

            });
        </script>

    <?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/drsamirghoraba/public_html/prox/proxima/resources/views/invoice/dayinvoice.blade.php ENDPATH**/ ?>