<?php $__env->startSection('title', 'Expenses items | Proxima - Medical Management app'); ?>

<?php $__env->startSection('title-topbar', 'Expenses items'); ?>

<!-- css insert -->
<?php $__env->startSection('css'); ?>

    <!-- -- datatables plugin -- -->
    <link rel="stylesheet" href="https://cdn.datatables.net/1.11.2/css/dataTables.bootstrap5.min.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.0.0/css/buttons.bootstrap5.min.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/autofill/2.3.9/css/autoFill.bootstrap5.min.css">

<?php $__env->stopSection(); ?>



<?php $__env->startSection('fixedcontent'); ?>

    <!-- session successful message -->
    <?php if(Session::has('success')): ?>
        <div id="flash-msg" class="shadow pt-3">
            <div class="d-flex justify-content-between mb-2">
                <i class="fas fs-1 fa-check"></i>
                <a id="flash-msg-btn" class="text-blue-300 clickable-item-pointer"><i class="fas fa-times"></i></a>
            </div>
            <h3>Sent Successfully</h3>
            <p class="text-blue-300"><?php echo e(Session::get('success')); ?></p>
        </div>
    <?php endif; ?>

    <!-- session successful message -->
    <?php if(Session::has('error_delete')): ?>
        <div id="flash-msg" class="shadow pt-3" style="background-color:#ff4152;">
            <div class="d-flex justify-content-between mb-2">
                <i class="fas fs-1 fa-times"></i>
                <a id="flash-msg-btn" class="text-blue-300 clickable-item-pointer"><i class="fas fa-times"
                        style="color:#ffb4bc"></i></a>
            </div>
            <h3>Can not be deleted</h3>
            <p style="color:#ffb4bc"><?php echo e(Session::get('error_delete')); ?></p>
        </div>
    <?php endif; ?>

<?php $__env->stopSection(); ?>


<!-- content insert -->
<?php $__env->startSection('content'); ?>
    <div class="container-fluid px-2 mt-3">

        <!-- page title link -->
        <div class="d-sm-flex align-items-center justify-content-between mb-3">
            <span class="mb-0">
                <a class="link-cust-text text-gray-200 fw-light"
                    href="<?php echo e(route('sett.home')); ?>"><?php echo e(__('basic.dashboard')); ?> |</a>
                <a class="text-gray-300"><?php echo e(__('patientappo.expenses items')); ?></a>
            </span>

            <div class="d-flex justify-content-center">
                <a href="<?php echo e(route('sett.expenses_item.create')); ?>"
                    class=" main-color-bg text-white btn btn-sm shadow-sm b-r-l-cont p-2 px-4 me-1"><i
                        class="fas fa-plus fa-sm me-1"></i> <?php echo e(__('basic.new')); ?></a>
            </div>
        </div>

        <div class="card shadow mb-3 pb-2">
            <!-- Card Header - Dropdown -->
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                <h6 class="m-0 fw-bold text-gray-500"><i
                        class="fas fa-capsules me-2"></i><?php echo e(__('patientappo.expenses items controll')); ?></h6>
                <div class="dropdown no-arrow">
                    <a class="dropdown-toggle" href="#" role="button" id="dropdownMenuLink" data-bs-toggle="dropdown"
                        aria-haspopup="true" aria-expanded="false">
                        <i class="fas fa-ellipsis-v fa-sm fa-fw text-gray-300"></i>
                    </a>
                    <div class="dropdown-menu dropdown-menu-right shadow animated--fade-in"
                        aria-labelledby="dropdownMenuLink">
                        <div class="dropdown-header">Action:</div>
                    </div>
                </div>
            </div>

            <!-- Card Body -->
            <div class="card-body">

                <div class="table-responsive">
                    <table class="table display datatable-modal" id="p-lab-table" width="100%" cellspacing="0">
                        <thead>
                            <tr>
                                <th class="text-xxs"><?php echo e(__('basic.id')); ?></th>
                                <th class="text-xxs"><?php echo e(__('basic.specialty')); ?></th>
                                <th class="text-xxs"><?php echo e(__('basic.type')); ?></th>
                                <th class="text-xxs"><?php echo e(__('basic.name')); ?></th>
                                <th class="text-xxs"><?php echo e(__('basic.price')); ?></th>
                                <th class="text-xxs text-center"><?php echo e(__('basic.handle')); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $debt; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $iteam): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>

                                    <td>
                                        <?php echo e($iteam->id); ?>

                                    </td>

                                    <td>
                                        <?php echo e($iteam->specialty->name); ?>

                                    </td>

                                    <td>
                                        <?php echo e($iteam->service_inv_cat->name); ?>

                                    </td>

                                    <td>
                                        <?php echo e($iteam->name); ?>

                                    </td>

                                    <td>
                                        <?php echo e($iteam->price); ?>

                                    </td>

                                    <td class="text-center">
                                        <div class="d-flex justify-content-center">
                                            <?php if(!in_array($iteam->id, [1])): ?>
                                                <a href="<?php echo e(route('sett.expenses_item.edit', $iteam->id)); ?>"
                                                    class="status-col-link main-color-btn text-white clickable-item-pointer shadow-sm b-r-l-cont-left rate-appointment p-2 px-3">
                                                    <i class="fas fa-edit fa-sm"></i>
                                                    <?php echo e(__('basic.edit')); ?>

                                                </a>
                                                <a title="delete" data-effect="effect-scale"
                                                    data-item_id="<?php echo e($iteam->id); ?>" data-bs-toggle="modal"
                                                    data-bs-target="#delete1"
                                                    class="delete-conf status-col-link cancel-color-btn shadow-sm b-r-l-cont-right p-2 px-3 clickable-item-pointer"><i
                                                        class="fas fa-trash"></i> <?php echo e(__('basic.delete')); ?></a>
                                            <?php endif; ?>
                                        </div>
                                    </td>

                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                        </tbody>
                    </table>
                </div>
            </div>

        </div>


        <!-- Modal -->
        <div class="modal fade" id="delete1" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable ">
                <div class="modal-content b-r-s-cont border-0">

                    <div class="modal-header">
                        <div class="modal-title" id="exampleModalLabel"><i class="fas fa-trash me-1"></i>
                            Item delete</div>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>

                    <form action="<?php echo e(route('sett.expenses_item.destroy', 'test')); ?>" method="post">
                        <?php echo e(method_field('delete')); ?>

                        <?php echo e(csrf_field()); ?>


                        <!-- Modal content -->
                        <div class="modal-body px-4">

                            <div class="modal-body delete-conf-input text-center py-0">
                                <p class="mb-0">ِAre you sure you want to delete
                                    this item?</p><br>
                                <input type="hidden" name="id_delete" value="">
                            </div>
                        </div>

                        <div class="modal-footer">
                            <div class="left-side">
                                <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal">Never
                                    Mind</button>
                            </div>
                            <div class="divider"></div>
                            <div class="right-side">
                                <button type="submit" class="btn btn-default btn-link text-red">Delete
                                </button>
                            </div>

                        </div>
                    </form>

                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<!-- js insert -->
<?php $__env->startSection('js'); ?>
    <script>
        $(document).ready(function() {
            var table = $('#p-lab-table').DataTable({
                lengthChange: true,
                buttons: [{
                    extend: 'csv',
                    split: ['pdf', 'excel'],
                }]
            });
        });
    </script>


    <!-- delete confirmation modal -->
    <script>
        $('.delete-conf').click(function(event) {
            var item_id = $(this).data("item_id");
            var modal = $('.delete-conf-input [name="id_delete"]')
            modal.val(item_id);
        })
    </script>

    <!-- -- datatables plugin -- -->
    <script type="text/javascript" src="https://cdn.datatables.net/1.11.2/js/jquery.dataTables.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/1.11.2/js/dataTables.bootstrap5.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/buttons/1.3.1/js/dataTables.buttons.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/buttons/2.0.0/js/buttons.bootstrap5.min.js"></script>

    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/buttons/1.3.1/js/buttons.html5.min.js"></script>
    <script type="text/javascript" language="javascript"
        src="https://cdn.datatables.net/buttons/2.0.0/js/buttons.print.min.js"></script>
    <script type="text/javascript" language="javascript"
        src="https://cdn.datatables.net/buttons/2.0.0/js/buttons.colVis.min.js"></script>



<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/medix/public_html/samirghoraba/med/resources/views/cats/expenses_item/index.blade.php ENDPATH**/ ?>