<?php $__env->startSection('title', 'With Doctor | Proxima - Medical Management app'); ?>

<?php $__env->startSection('title-topbar', 'Patients Waiting'); ?>

<!-- css insert -->
<?php $__env->startSection('css'); ?>
    <!-- select 2 -->
    <link href="https://fastly.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

    <style>
        .select2-container {
            z-index: 99999;
        }
    </style>
<?php $__env->stopSection(); ?>

<!-- content insert -->
<?php $__env->startSection('content'); ?>
    <div class="container-fluid px-2 mt-3">


        <!-- page title link -->
        <div class="d-sm-flex align-items-center justify-content-between mb-4">
            <span class="mb-0">
                <a class="link-cust-text text-gray-200 fw-light" href="<?php echo e(route('sett.home')); ?>"><?php echo e(__('basic.dashboard')); ?>

                    |</a>
                <a class="link-cust-text text-gray-200 fw-light"
                    href="<?php echo e(route('sett.appointment.index')); ?>"><?php echo e(__('basic.appointments')); ?> |
                </a>
                <a class="text-gray-300"><?php echo e(__('basic.patient arrived')); ?></a>
            </span>
        </div>

        <div class="row mb-2">
            <?php if(count($patients) > 0): ?>
                <?php $__currentLoopData = $patients; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-12" id="withdoctor-cont-ajax">
                        <div class="row align-items-center shadow b-r-s-cont bg-white overflow-scroll p-4 mb-3">

                            <div class="col-5 d-flex align-items-center">
                                <img class="rounded-circle avatar-m2 me-3"
                                    src="<?php echo e(URL::asset('img/useravatar/' . $item->patient->avatar)); ?>">
                                <div class="">
                                    <p class="mb-0 text-xs text-gray-300"><?php echo e(__('basic.patient')); ?></p>
                                    <a href="<?php echo e(route('sett.patient.show', $item->patient->id)); ?>"
                                        class="mb-1 fw-bold text-gray-600">
                                        <?php echo e($item->patient->name); ?>

                                    </a>
                                    <p class="mb-0 text-xs text-gray-400"><?php echo e(__('basic.code')); ?><strong>
                                            <?php echo e($item->patient->code); ?>

                                        </strong></p>
                                </div>
                            </div>

                            <div class="col text-center">
                                <h6 class="text-gray-300 text-xs mb-1"><?php echo e(__('basic.appointment time')); ?></h6>
                                <h6 class="text-s text-gray-400 text-truncate">
                                    <?php echo e(date('d M Y h:i a', strtotime($item->start_at))); ?>

                                </h6>
                            </div>

                            <div class="col text-center">
                                <h6 class="text-gray-300 text-xs mb-1"><?php echo e(__('basic.service')); ?></h6>
                                <h6 class="text-s text-gray-400 text-truncate">
                                    <?php if(count($item->patient->pulses) > 0): ?>
                                        <div data-bs-toggle="modal" data-bs-target="#addpulses<?php echo e($item->id); ?>"
                                            class="status-col-link main-color-btn mb-2 text-white clickable-item-pointer shadow-sm b-r-l-cont rate-appointment p-2 px-2">
                                            <i class="fas fa-thermometer fa-sm"></i>
                                            <?php echo e(__('basic.pulses')); ?>

                                        </div>
                                    <?php else: ?>
                                        No Pulses
                                    <?php endif; ?>
                                    <?php if(count($item->patient->sessions) > 0): ?>
                                        <div data-bs-toggle="modal" data-bs-target="#addsession<?php echo e($item->id); ?>"
                                            class="status-col-link main-color-btn text-white clickable-item-pointer shadow-sm b-r-l-cont p-2 px-2">
                                            <i class="fas fa-syringe fa-sm"></i>
                                            <?php echo e(__('patientappo.session')); ?>

                                        </div>
                                    <?php endif; ?>
                                </h6>

                                <!-- Modal pulses update data -->
                                <div class="modal fade addpulses" id="addpulses<?php echo e($item->id); ?>" role="dialog"
                                    aria-labelledby="exampleModalLabel" aria-hidden="true" style="overflow:hidden">
                                    <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
                                        <div class="modal-content b-r-s-cont border-0">
                                            <div class="modal-header">
                                                <h5 class="modal-title" id="exampleModalLabel"><i
                                                        class="fas fa-thermometer me-1"></i>
                                                    Insert Pulses</h5>
                                                <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                    aria-label="Close"></button>
                                            </div>

                                            <form class="mb-0" action="<?php echo e(route('sett.app_withdoctor_service_save')); ?>"
                                                style="display: contents;" method="POST">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('PUT'); ?>

                                                <!-- Modal content -->
                                                <div class="modal-body px-5 py-3">

                                                    <?php $__currentLoopData = $item->patient->pulses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item_p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <div class="row mb-2 text-start">

                                                            <?php if($item_p->type == 0): ?>
                                                                <?php
                                                                    $text_color = 'active-color-btn';
                                                                    $msg = __('patientappo.session');
                                                                ?>
                                                            <?php elseif($item_p->type == 1): ?>
                                                                <?php
                                                                    $text_color = 'done-color-btn';
                                                                    $msg = __('basic.money per pulse');
                                                                ?>
                                                            <?php elseif($item_p->type == 2): ?>
                                                                <?php
                                                                    $text_color = 'prog-color-btn';
                                                                    $msg = __('basic.session package');
                                                                ?>
                                                            <?php elseif($item_p->type == 3): ?>
                                                                <?php
                                                                    $text_color = 'not_accepted-color-btn';
                                                                    $msg = __('basic.pulses package');
                                                                ?>
                                                            <?php elseif($item_p->type == 4): ?>
                                                                <?php
                                                                    $text_color = 'pend-color-btn';
                                                                    $msg = __('basic.free session');
                                                                ?>
                                                            <?php endif; ?>

                                                            <h6 class="text-gray-300"><i class="fas fa-stethoscope"></i>
                                                                <?php if($item_p->service_item): ?>
                                                                    <?php echo e($item_p->service_item->name); ?>

                                                                <?php else: ?>
                                                                    <?php echo e($item_p->pulse_area->name); ?>

                                                                <?php endif; ?> | <span
                                                                    class="badge rounded-pill <?php echo e($text_color); ?> badge-padd-l"><?php echo e($msg); ?></span>
                                                            </h6>

                                                            <div class="col-12 mb-2 text-start">
                                                                <label class="form-label"> <?php echo e(__('basic.fluence')); ?>

                                                                    <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                                                <select
                                                                    class="select2-no-search select2-hidden-accessible  text-start <?php $__errorArgs = ['fluence_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                                    name="fluence_update[]" required>
                                                                    <option
                                                                        <?php if($item_p->fluence == 6): ?> selected <?php endif; ?>
                                                                        value="6">
                                                                        6
                                                                    </option>
                                                                    <option
                                                                        <?php if($item_p->fluence == 7): ?> selected <?php endif; ?>
                                                                        value="7">
                                                                        7
                                                                    </option>
                                                                    <option
                                                                        <?php if($item_p->fluence == 8): ?> selected <?php endif; ?>
                                                                        value="8">
                                                                        8
                                                                    </option>
                                                                    <option
                                                                        <?php if($item_p->fluence == 9): ?> selected <?php endif; ?>
                                                                        value="9">
                                                                        9
                                                                    </option>
                                                                    <option
                                                                        <?php if($item_p->fluence == 10): ?> selected <?php endif; ?>
                                                                        value="10">
                                                                        10
                                                                    </option>
                                                                    <option
                                                                        <?php if($item_p->fluence == 12): ?> selected <?php endif; ?>
                                                                        value="12">
                                                                        12
                                                                    </option>
                                                                    <option
                                                                        <?php if($item_p->fluence == 14): ?> selected <?php endif; ?>
                                                                        value="14">
                                                                        14
                                                                    </option>
                                                                    <option
                                                                        <?php if($item_p->fluence == 16): ?> selected <?php endif; ?>
                                                                        value="16">
                                                                        16
                                                                    </option>
                                                                    <option
                                                                        <?php if($item_p->fluence == 18): ?> selected <?php endif; ?>
                                                                        value="18">
                                                                        18
                                                                    </option>
                                                                    <option
                                                                        <?php if($item_p->fluence == 20): ?> selected <?php endif; ?>
                                                                        value="20">
                                                                        20
                                                                    </option>
                                                                </select>

                                                                <span id="fluence_update_error"
                                                                    class="error-msg-form"></span>

                                                                <?php $__errorArgs = ['fluence_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                    <span class="error-msg-form">
                                                                        <?php echo e($message); ?>

                                                                    </span>
                                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                            </div>

                                                            <div class="col-12 mb-2">
                                                                <label class="form-label">
                                                                    <?php echo e(__('basic.spot size')); ?>

                                                                    <small>(<?php echo e(__('basic.required')); ?>)</small></label>

                                                                <select
                                                                    class="select2-no-search select2-hidden-accessible <?php $__errorArgs = ['spot_size'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                                    name="spot_size_update[]" required>
                                                                    <option
                                                                        <?php if($item_p->spot_size == 15): ?> selected <?php endif; ?>
                                                                        value="15">
                                                                        15
                                                                    </option>
                                                                    <option
                                                                        <?php if($item_p->spot_size == 18): ?> selected <?php endif; ?>
                                                                        value="18">
                                                                        18
                                                                    </option>
                                                                    <option
                                                                        <?php if($item_p->spot_size == 20): ?> selected <?php endif; ?>
                                                                        value="20">
                                                                        20
                                                                    </option>
                                                                    <option
                                                                        <?php if($item_p->spot_size == 22): ?> selected <?php endif; ?>
                                                                        value="22">
                                                                        22
                                                                    </option>
                                                                    <option
                                                                        <?php if($item_p->spot_size == 24): ?> selected <?php endif; ?>
                                                                        value="24">
                                                                        24
                                                                    </option>
                                                                </select>

                                                                <span id="spot_size_update_error"
                                                                    class="error-msg-form"></span>

                                                                <?php $__errorArgs = ['spot_size_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                    <span class="error-msg-form">
                                                                        <?php echo e($message); ?>

                                                                    </span>
                                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                            </div>

                                                            <div class="col-12 mb-2">
                                                                <label class="form-label">
                                                                    <?php echo e(__('basic.used pulses')); ?>

                                                                    <small>(<?php echo e(__('basic.required')); ?>)</small></label>

                                                                <input name="used_pulses_update[]" type="number"
                                                                    class="form-control <?php $__errorArgs = ['used_pulses_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                                    placeholder="used pulses ..."
                                                                    value="<?php echo e($item_p->used_pulses); ?>" required>

                                                                <span id="used_pulses_update_error"
                                                                    class="error-msg-form"></span>

                                                                <?php $__errorArgs = ['used_pulses_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                    <span class="error-msg-form">
                                                                        <?php echo e($message); ?>

                                                                    </span>
                                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                            </div>

                                                            <input name="pulses_id[]" value="<?php echo e($item_p->id); ?>"
                                                                type="hidden">

                                                            <hr class="my-2">
                                                        </div>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                </div>

                                                <div class="modal-footer">
                                                    <div class="left-side">
                                                        <button type="button" class="btn btn-default btn-link"
                                                            data-bs-dismiss="modal"><?php echo e(__('basic.never mind')); ?></button>
                                                    </div>
                                                    <div class="divider"></div>
                                                    <div class="right-side">
                                                        <button type="submit"
                                                            class="btn btn-default btn-link main-color"><?php echo e(__('basic.update')); ?></button>
                                                    </div>
                                                </div>
                                            </form>

                                        </div>
                                    </div>

                                </div>

                                <!-- Modal pulses update data -->
                                <div class="modal fade addsession" id="addsession<?php echo e($item->id); ?>" role="dialog"
                                    aria-labelledby="exampleModalLabel" aria-hidden="true" style="overflow:hidden">
                                    <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
                                        <div class="modal-content b-r-s-cont border-0">
                                            <div class="modal-header">
                                                <h5 class="modal-title" id="exampleModalLabel"><i
                                                        class="fas fa-thermometer me-1"></i>
                                                    Insert Session</h5>
                                                <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                    aria-label="Close"></button>
                                            </div>

                                            <form class="mb-0"
                                                action="<?php echo e(route('sett.app_withdoctor_service_save_session')); ?>"
                                                style="display: contents;" method="POST">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('PUT'); ?>

                                                <!-- Modal content -->
                                                <div class="modal-body px-5 py-3">

                                                    <?php $__currentLoopData = $item->patient->sessions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <div class="row mb-2 text-start">

                                                            <h6 class="text-gray-300"><i class="fas fa-stethoscope"></i>
                                                                <?php echo e($item->service_item->name); ?>

                                                            </h6>

                                                            <div class="col-12 mb-2">
                                                                <label class="form-label">
                                                                    <?php echo e(__('basic.status')); ?>

                                                                    <small>(<?php echo e(__('basic.required')); ?>)</small></label>

                                                                <select
                                                                    class="select2-no-search select2-hidden-accessible <?php $__errorArgs = ['spot_size'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                                    name="status[]" required>
                                                                    <option
                                                                        <?php if($item->status == 0): ?> selected <?php endif; ?>
                                                                        value="0">
                                                                        not done
                                                                    </option>
                                                                    <option
                                                                        <?php if($item->spot_size == 1): ?> selected <?php endif; ?>
                                                                        value="1">
                                                                        done
                                                                    </option>
                                                                </select>

                                                                <span id="spot_size_update_error"
                                                                    class="error-msg-form"></span>

                                                                <?php $__errorArgs = ['spot_size_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                    <span class="error-msg-form">
                                                                        <?php echo e($message); ?>

                                                                    </span>
                                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                            </div>

                                                            <input name="session_id[]" value="<?php echo e($item->id); ?>"
                                                                type="hidden">

                                                            <hr class="my-2">
                                                        </div>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                </div>

                                                <div class="modal-footer">
                                                    <div class="left-side">
                                                        <button type="button" class="btn btn-default btn-link"
                                                            data-bs-dismiss="modal"><?php echo e(__('basic.never mind')); ?></button>
                                                    </div>
                                                    <div class="divider"></div>
                                                    <div class="right-side">
                                                        <button type="submit"
                                                            class="btn btn-default btn-link main-color"><?php echo e(__('basic.update')); ?></button>
                                                    </div>
                                                </div>
                                            </form>

                                        </div>
                                    </div>

                                </div>

                            </div>
                            <div class="col text-center">
                                <h6 class="text-gray-300 text-xs mb-1"><?php echo e(__('basic.status')); ?></h6>
                                <div class="switch-checkbox">
                                    <input class="done_btn" name="withsomeone" type="checkbox"
                                        value="<?php echo e($item->id); ?>" id="<?php echo e($item->id); ?>"><label
                                        for="<?php echo e($item->id); ?>" class="ms-auto me-auto">Toggle</label>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php else: ?>
                No patients
            <?php endif; ?>

        </div>

    </div>

<?php $__env->stopSection(); ?>

<!-- js insert -->
<?php $__env->startSection('js'); ?>

    <!-- select 2 -->
    <script src="https://fastly.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script>
        $(document).ready(function() {
            $('.js-example-basic-single').select2();
            //hide search
            $('.select2-no-search').select2({
                minimumResultsForSearch: -1
            });
        });


        //rate insert
        $(document).on('change', '.done_btn', function() {

            var appointment_id = $(this).val();

            var url = "<?php echo e(route('sett.app_withdoctor_update', ':id')); ?>";
            url = url.replace(':id', appointment_id);

            $.ajax({
                url: url,
                type: "POST",
                data: {
                    '_token': "<?php echo e(csrf_token()); ?>",
                    '_method': "PATCH",
                    'status': 4,
                },
                success: function(data) {
                    location.reload();
                }
            });
        });
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/medix/public_html/samirghoraba/med/resources/views/branch/appointment/withdoctor_service.blade.php ENDPATH**/ ?>