<?php $__env->startSection('title', 'With Doctor | Medix - Medical Management app'); ?>

<?php $__env->startSection('title-topbar', 'Patients Waiting'); ?>

<!-- css insert -->
<?php $__env->startSection('css'); ?>

<?php $__env->stopSection(); ?>

<!-- content insert -->
<?php $__env->startSection('content'); ?>
    <div class="container-fluid px-2 mt-3">


        <!-- page title link -->
        <div class="d-sm-flex align-items-center justify-content-between mb-4">
            <span class="mb-0">
                <a class="link-cust-text text-gray-200 fw-light"
                    href="<?php echo e(route('sett.home')); ?>"><?php echo e(__('basic.dashboard')); ?> |</a>
                <a class="link-cust-text text-gray-200 fw-light"
                    href="<?php echo e(route('sett.appointment.index')); ?>"><?php echo e(__('basic.appointments')); ?> |
                </a>
                <a class="text-gray-300"><?php echo e(__('basic.patient arrived')); ?></a>
            </span>
        </div>

        <div class="row mb-2">
            <div class="col-12" id="withdoctor-cont-ajax">

            </div>
        </div>

    </div>

<?php $__env->stopSection(); ?>

<!-- js insert -->
<?php $__env->startSection('js'); ?>

    <script>
        $(document).ready(function() {

            //--------------------- fetch appoingtments -------------------

            with_doctor();

            function with_doctor() {

                $.ajax({
                    url: '<?php echo e(route('sett.app_withdoctor_data')); ?>',
                    type: "GET",
                    dataType: "json",
                    success: function(data) {

                        if (data.length > 0) {

                            var html = ''

                            $.each(data, function(key, value) {
                                var url_show = "<?php echo e(URL::asset('img/useravatar/')); ?>" +
                                    "/" +
                                    value.patient.avatar;

                                var patient_url = "<?php echo e(route('sett.patient.show', ':id')); ?>";
                                patient_url = patient_url.replace(':id', value.patient.id);

                                html +=
                                    '<div class="row align-items-center shadow b-r-s-cont bg-white overflow-scroll p-4 mb-3">' +

                                    '<div class="col-5 d-flex align-items-center">' +
                                    '<img class="rounded-circle avatar-m2 me-3" src="' +
                                    url_show + '">' +
                                    '<div class="">' +
                                    '<p class=" mb-0 text-xs text-gray-300"><?php echo e(__('basic.patient')); ?></p>' +
                                    '<a href="' + patient_url +
                                    '" class="mb-1 fw-bold text-gray-600">' +
                                    value.patient.name +
                                    '</a>' +
                                    '<p class="mb-0 text-xs text-gray-400"><?php echo e(__('basic.id')); ?><strong>' +
                                    +value.patient.id +
                                    '</strong></p>' +
                                    '</div></div>' +

                                    '<div class="col text-center">' +
                                    '<h6 class="text-gray-300 text-xs mb-1"><?php echo e(__('basic.appointment time')); ?></h6>' +
                                    '<h6 class="text-s text-gray-400 text-truncate">' + value
                                    .start_at +
                                    '</h6></div>' +

                                    '<div class="col text-center">' +
                                    '<h6 class="text-gray-300 text-xs mb-3"><?php echo e(__('patientappo.done')); ?></h6>' +
                                    '<div class="switch-checkbox">' +
                                    '<input class="done_btn" name="withsomeone" type="checkbox" value="' +
                                    value
                                    .id + '" id="' +
                                    value.id + '"><label for="' + value.id +
                                    '" class="ms-auto me-auto">Toggle</label>' +
                                    '</div>' +
                                    '</div>' +

                                    '</div>'
                            })

                            $('#withdoctor-cont-ajax').html(html);
                        } else {
                            $('#withdoctor-cont-ajax').html(
                                '<div class="text-center text-gray-500 fs-5">' +
                                '<i class="bi bi-brightness-alt-high-fill fa-sm fa-fw fs-2"></i> <p class = "fw-light mb-0" ><?php echo e(__('patientappo.no patients waiting')); ?> </p>'
                            );
                        }


                    }

                })

                timer = setTimeout(function() {
                    with_doctor();
                }, 10000);

            };


            //rate insert
            $(document).on('change', '.done_btn', function() {

                var appointment_id = $(this).val();

                console.log(appointment_id);

                var url = "<?php echo e(route('sett.app_withdoctor_update', ':id')); ?>";
                url = url.replace(':id', appointment_id);

                $.ajax({
                    url: url,
                    type: "POST",
                    data: {
                        '_token': "<?php echo e(csrf_token()); ?>",
                        '_method': "PATCH",
                        'status': 4,
                    },
                    success: function(data) {
                        with_doctor();
                    }
                });
            });

        });
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/medix/public_html/samirghoraba/med/resources/views/branch/appointment/withdoctor.blade.php ENDPATH**/ ?>