<?php $__env->startSection('title', 'Calander'); ?>

<!-- css insert -->
<?php $__env->startSection('css'); ?>

<?php $__env->stopSection(); ?>



<!-- session successful message -->
<?php if(Session::has('success')): ?>
    <div id="flash-msg" class="shadow pt-3">
        <div class="d-flex justify-content-between mb-2">
            <i class="fas fs-1 fa-check"></i>
            <a id="flash-msg-btn" class="text-blue-300 clickable-item-pointer"><i class="fas fa-times"></i></a>
        </div>
        <h3>Sent Successfully</h3>
        <p class="text-blue-300"><?php echo e(Session::get('success')); ?></p>
    </div>
<?php endif; ?>


<div id="add_buttn_fixed">
    <i class="fas fa-plus"></i>
</div>


<!-- content insert -->
<?php $__env->startSection('content'); ?>
    <div class="container-fluid px-2 mt-3">

        <!-- page title link -->
        <div class="d-sm-flex align-items-center justify-content-between mb-3">
            <span class="mb-0">
                <a class="link-cust-text text-gray-200 fw-light" href="<?php echo e(route('sett.home')); ?>">Dashboard |</a>
                <a class="text-gray-300">Users</a>
            </span>
        </div>

        <div class="card shadow mb-3 pb-2">
            <!-- Card Header - Dropdown -->
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                <h6 class="m-0 fw-bold text-gray-500"><i class="fas fa-users me-2"></i> All users</h6>
                <div class="dropdown no-arrow">
                    <a class="dropdown-toggle" href="#" role="button" id="dropdownMenuLink" data-bs-toggle="dropdown"
                        aria-haspopup="true" aria-expanded="false">
                        <i class="fas fa-ellipsis-v fa-sm fa-fw text-gray-300"></i>
                    </a>
                    <div class="dropdown-menu dropdown-menu-right shadow animated--fade-in"
                        aria-labelledby="dropdownMenuLink">
                        <div class="dropdown-header">Action:</div>
                        <a class="dropdown-item" href="<?php echo e(route('sett.admin.create')); ?>"><i class="fas fa-user me-1"></i>
                            new user</a>
                        <a class="dropdown-item" href="<?php echo e(route('sett.role.index')); ?>"><i class="fas fa-plus me-1"></i>
                            roles</a>
                    </div>
                </div>
            </div>

            <!-- Card Body -->
            <div class="card-body">



                <div class="table-responsive">

                    <table class="table table-bordered table-weekly-calender">
                        <thead>
                            <tr id="calander_cont_header">
                            </tr>
                        </thead>
                    </table>
                </div>


                <div id="timeslots_calendar_cont" class="px-2 px-md-4"></div>

            </div>


        </div>
    </div>
<?php $__env->stopSection(); ?>

<!-- js insert -->
<?php $__env->startSection('js'); ?>


    <!-- delete confirmation modal -->
    <script>
        $('.delete-conf').click(function(event) {


            var user_id = $(this).data("user_id");
            var username = $(this).data("username");
            console.log(user_id);
            var modal = $('.delete-conf-input [name="user_id"]')
            modal.val(user_id);
            $('#username').val(username);
        })
    </script>


    <script>
        //--------------------- weekly calander appointment ajax -------------------
        $(document).ready(function() {

            fetchWeeklyCalander();

            function fetchWeeklyCalander(yearin = null, weekin = null) {

                $.ajax({
                    url: '<?php echo e(url('/appointment/weekly_calender')); ?>/' + yearin + '/' + weekin,
                    type: "GET",
                    success: function(data) {
                        $("#calander_cont_header").html(data);
                    }
                });
            };

            //reinsert the calander when the month arrows are clicked
            $(document).on('click', '#change_week', function() {
                var yearin = $(this).data('year');
                var weekin = $(this).data('week');
                fetchWeeklyCalander(yearin, weekin)
            });


            fetchTimeslotsCalander();

            function fetchTimeslotsCalander(year = <?php echo e(date('Y')); ?>, month = <?php echo e(date('m')); ?>, day =
                <?php echo e(date('d')); ?>) {

                $.ajax({
                    url: '<?php echo e(url('/appointment/weekly_calender_date')); ?>/' + year + '/' + month + '/' +
                        day,
                    type: "GET",
                    success: function(data) {
                        $("#timeslots_calendar_cont").html(data);

                        var colors = ['#CEEDFF', '#CED3FF', '#FFCED4', '#CEFFED', '#FFD4CE', '#FFD4CE'];
                        var random_color = colors[Math.floor(Math.random() * colors.length)];
                        $('.timeslots_appointment_show').css('background-color', random_color);;
                    }
                });
            };



            //reinsert the calander when the month arrows are clicked
            $(document).on('click', '#change_calendar_timeslots', function() {
                var year = $(this).data('year');
                var month = $(this).data('month');
                var day = $(this).data('day');
                $('.calendar_weekly_normal').removeClass('calendar_weekly_selected');
                $(this).addClass('calendar_weekly_selected');
                fetchTimeslotsCalander(year, month, day)
            });



        })
    </script>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/proxima/resources/views/branch/appointment/test.blade.php ENDPATH**/ ?>