<?php $__env->startSection('title', 'Invoice | Proxima - Medical Management app'); ?>

<?php $__env->startSection('title-topbar', 'Invoice'); ?>

<!-- css insert -->
<?php $__env->startSection('css'); ?>

<!-- select 2 -->
<link href="https://fastly.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

<!-- boostrap datepicker -->
<link rel="stylesheet"
    href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.1/css/bootstrap-datepicker3.css" />

<!-- tables -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/5.0.1/css/bootstrap.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/1.11.2/css/dataTables.bootstrap5.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.0.1/css/buttons.bootstrap5.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/autofill/2.3.9/css/autoFill.bootstrap5.min.css">

<?php $__env->stopSection(); ?>




<?php $__env->startSection('fixedcontent'); ?>

<div id="add_buttn_fixed">
    <a href="<?php echo e(route('sett.invoice.create')); ?>" class="text-white">
        <i class="fas fa-plus"></i>
    </a>
</div>

<!-- session successful message -->
<?php if(Session::has('success')): ?>
<div id="flash-msg" class="shadow pt-3">
    <div class="d-flex justify-content-between mb-2">
        <i class="fas fs-1 fa-check"></i>
        <a id="flash-msg-btn" class="text-blue-300 clickable-item-pointer"><i class="fas fa-times"></i></a>
    </div>
    <h3>Sent Successfully</h3>
    <p class="text-blue-300"><?php echo e(Session::get('success')); ?></p>
</div>
<?php endif; ?>

<?php $__env->stopSection(); ?>

<!-- content insert -->
<?php $__env->startSection('content'); ?>
<div class="container-fluid px-2 mt-3">

    <!-- page title link -->
    <div class="d-sm-flex align-items-center justify-content-between mb-5">

        <span class="mb-0">
            <a class="link-cust-text text-gray-200 fw-light" href="<?php echo e(route('sett.home')); ?>"><?php echo e(__('basic.dashboard')); ?>

                |</a>
            <a class="text-gray-300"><?php echo e(__('patientappo.invoice search')); ?></a>
        </span>

        <div class="d-flex justify-content-center mt-2 mt-md-0">

            <a href="<?php echo e(route('sett.invo_allstatcs')); ?>"
                class="bg-white btn btn-sm shadow-sm b-r-l-cont p-2 px-4 text-gray-400 me-1"><i
                    class="fas fa-chart-bar fa-sm text-gray-300 me-1"></i> <?php echo e(__('basic.statistics')); ?></a>

            <a href="<?php echo e(route('sett.invo_month_search')); ?>"
                class="bg-white btn btn-sm shadow-sm b-r-l-cont p-2 px-4 text-gray-400 me-1"><i
                    class="fas fa-chart-bar fa-sm text-gray-300 me-1"></i> <?php echo e(__('basic.monthly st')); ?></a>

            <a href="<?php echo e(route('sett.invo_day_search')); ?>"
                class=" main-color-bg btn btn-sm shadow-sm b-r-l-cont p-2 px-4 text-blue-200"><i
                    class="fas fa-chart-bar fa-sm text-blue-200 me-1"></i> <?php echo e(__('basic.daily st')); ?></a>

        </div>

    </div>


    <div class="row justify-content-center position-relative">

        <div class="col-12 col-md-10 col-lg-8 col-xl-7 text-center">
            <img class="img-fluid p-md-2" width="540px"
                src="<?php echo e(URL::asset('img/dashboard/undraw_online_payments_re_y8f2.svg')); ?>" alt="">

            <div class="search-eng-cont">

                <div class="p-1 bg-white rounded rounded-pill"
                    style="box-shadow: -1px 1rem 1rem 7px rgb(58 59 69 / 15%) !important; ">

                    <div class="input-group">
                        <input id="search-eng" type="search"
                            placeholder="Write here the Invoice code or patient name .." aria-describedby="button-add"
                            class="form-control border-0 bg-transparent px-4" autofocus>
                        <div class="input-group-append pe-2 d-flex">
                            <button id="button-addon1" type="submit" class="btn btn-link text-primary typeahead"><i
                                    class="fa fa-search text-gray-300"></i></button>
                        </div>
                    </div>

                </div>

                <div id="search-eng-show-list" class="search-eng-results list-group p-4 bg-white b-r-l-b-cont"
                    style="box-shadow: -1px 1rem 1rem 7px rgb(58 59 69 / 15%) !important; display:none">
                </div>

            </div>

        </div>
    </div>


    <div class="d-sm-flex align-items-center justify-content-between mb-3">
        <span class="mb-0">
        </span>


        <div class="d-flex justify-content-center mt-3">
            <div class="cont-branch-calendar me-2">
                <select id="select-branch-table"
                    class="js-example-basic-single select2-no-search select2-hidden-accessible">
                    <?php if(Auth::user()->branch_id == 0): ?>
                    <?php $__currentLoopData = $branches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $iteam): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($iteam->id); ?>">
                        <?php echo e($iteam->name); ?>

                    </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php else: ?>
                    <option value="<?php echo e(Auth::user()->branch_id); ?>">
                        <?php echo e(Auth::user()->branch->name); ?>

                        <?php endif; ?>
                </select>
            </div>
        </div>


    </div>


    <div class="row">
        <div class="col-12 col-md-6 px-0 px-md-2">
            <div class="card card-input shadow mb-4">
                <!-- Card Header - Dropdown -->
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 fw-bold"><i class="fas fa-x-ray"></i>
                        <?php echo e(__('patientappo.waiting for paying')); ?></h6>
                    <div class="dropdown no-arrow d-flex">
                        <a class="dropdown-toggle align-self-center" href="#" role="button" id="dropdownMenuLink"
                            data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            <i class="fas fa-ellipsis-v fa-sm fa-fw text-gray-300"></i>
                        </a>
                        <div class="dropdown-menu dropdown-menu-right shadow animated--fade-in"
                            aria-labelledby="dropdownMenuLink">
                            <div class="dropdown-header">Dropdown Header:</div>
                            <a class="dropdown-item" href="#">Action</a>
                        </div>
                    </div>
                </div>

                <!-- Card Body -->
                <div class="card-body overflow-scroll" id="invoice_nopay_table_cont">

                    <div class="text-center text-gray-400">
                        <div><i class="far fa-check-circle fs-3 mb-1"></i></div>
                        <?php echo e(__('basic.nothing to show')); ?>

                    </div>

                </div>

            </div>
        </div>




        <div class="col-12 col-md-6 px-0 px-md-2">
            <div class="card card-input shadow mb-4">
                <!-- Card Header - Dropdown -->
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 fw-bold"><i class="fas fa-x-ray"></i> <?php echo e(__('patientappo.latest invoices')); ?>

                    </h6>
                    <div class="dropdown no-arrow d-flex">
                        <a class="dropdown-toggle align-self-center" href="#" role="button" id="dropdownMenuLink"
                            data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            <i class="fas fa-ellipsis-v fa-sm fa-fw text-gray-300"></i>
                        </a>
                        <div class="dropdown-menu dropdown-menu-right shadow animated--fade-in"
                            aria-labelledby="dropdownMenuLink">
                            <div class="dropdown-header">Dropdown Header:</div>
                            <a class="dropdown-item" href="#">Action</a>
                        </div>
                    </div>
                </div>

                <!-- Card Body -->
                <div class="card-body">

                    <div class="table-responsive" id="invoice_result_table_cont">
                        <div class="text-center text-gray-400">
                            <div><i class="far fa-check-circle fs-3 mb-1"></i></div>
                            <?php echo e(__('basic.nothing to show')); ?>

                        </div>

                    </div>
                </div>
            </div>


        </div>
        <?php $__env->stopSection(); ?>

        <!-- js insert -->
        <?php $__env->startSection('js'); ?>

        <!-- select 2 -->
        <script src="https://fastly.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
        <script>
            $(document).ready(function() {
                    $('.js-example-basic-single').select2();
                    //hide search
                    $('.select2-no-search').select2({
                        minimumResultsForSearch: -1
                    });
                });
        </script>

        <!-- jquery ui datepicker -->
        <script type="text/javascript"
            src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.1/js/bootstrap-datepicker.min.js">
        </script>
        <script>
            $(function() {
                    $('.hasdatetimepicker').datepicker({
                        todayHighlight: true,
                        format: "yyyy-mm-dd",
                    });
                });

                $(document).ready(function() {
                    $(document).on('change', '#calendar-date-input', function() {
                        var date = $(this).val();

                        var url = "<?php echo e(route('sett.invo_day_search', ':date')); ?>";
                        url = url.replace(':date', date);

                        window.location.href = url;

                        invoice_result_table(branch);
                        invoice_result_nopay_table(branch);
                    });
                })
        </script>



        <script>
            $(document).ready(function() {

                    //--------------------- search engine ajax -------------------


                    // Send Search Text to the server

                    $("#search-eng").keyup(function() {

                        var branch_id = $('#select-method-search').val();

                        let search_query = $(this).val();

                        var url = "<?php echo e(route('sett.invo_invoice_search', ':search_query')); ?>";
                        url = url.replace(':search_query', search_query);

                        if (search_query != "") {
                            $.ajax({
                                url: url,
                                type: "GET",
                                dataType: "json",
                                success: function(data) {
                                    $("#search-eng-show-list").show();

                                    if (data !== "") {
                                        var html = ''
                                        $.each(data, function(key, value) {

                                            var url_show =
                                                "<?php echo e(route('sett.invoice.show', ':id')); ?>";
                                            url_show = url_show.replace(':id', value.id);

                                            if (value.receivable) {
                                                receivable = value.receivable.name;
                                            } else {
                                                receivable =
                                                    '<?php echo e(__('patientappo.no receiver')); ?>';
                                            };

                                            html +=
                                                '<a href="' + url_show +
                                                '" class="search-eng-a d-flex justify-content-between list-group-item list-group-item-action border-1 text-gray-500" style="cursor: pointer;">' +
                                                '<div class="d-flex me-3 align-items-center"><i class="fas fa-search text-gray-200 me-2"></i><span>' +
                                                value.code + '</span></div>' +
                                                '<div class="text-truncate text-gray-300">' +
                                                receivable +
                                                '</div></a>';
                                        });
                                        $('#search-eng-show-list').html(html);
                                    }

                                    if (data == "") {
                                        $('#search-eng-show-list').html(
                                            '<a class="list-group-item list-group-item-action border-0"><i class="fas fa-search text-gray-200 me-2"></i><?php echo e(__('basic.nothing to show')); ?></a>'
                                        );
                                    }
                                },
                            });
                        } else {
                            $("#search-eng-show-list").empty();
                            $("#search-eng-show-list").hide();;
                        }
                    });


                    //--------------------- search engine ajax -------------------

                    var branch_id = $('#select-branch-table').val();

                    invoice_result_nopay_table();

                    function invoice_result_nopay_table(branch = branch_id) {

                        var url = "<?php echo e(route('sett.invo_invoice_result_nopay_index', ':branch')); ?>";
                        url = url.replace(':branch', branch);

                        var branch_id_select = $('#select-branch-table').val();

                        $.ajax({
                            url: url,
                            type: "GET",
                            dataType: "json",
                            success: function(data) {

                                if (data.length > 0) {

                                    var html = ''

                                    $.each(data, function(key, value) {

                                        var url_show =
                                            "<?php echo e(route('sett.invoice.show', ':id')); ?>";
                                        url_show = url_show.replace(':id', value.id);

                                        if (value.receivable) {
                                            receivable = value.receivable.name;
                                        } else {
                                            receivable = '<?php echo e(__('patientappo.no receiver')); ?>';
                                        };

                                        html +=
                                            '<div class="row mb-2 ">' +

                                            '<div class="col-3 d-flex align-items-center position-relative">' +
                                            '<i class="fas fas fa-money-check-alt me-2 fs-2"></i>' +
                                            '<div class="text-truncate">' +
                                            '<h6 class="mb-1 fw-bold text-gray-600 text-truncate">' +
                                            value.code + '</h6>' +
                                            '<p class="mb-0 text-xs text-gray-300 text-truncate">' +
                                            value.created_at +
                                            '</p>' +
                                            '</div>' +
                                            '<a href="' + url_show +
                                            '" class="stretched-link"></a>' +
                                            '</div>' +

                                            '<div class="col-3 text-center align-self-center text-truncate">' +
                                            '<p class="text-xs text-gray-200 mb-0 text-truncate"><?php echo e(__('basic.patient')); ?></p>' +
                                            '<h6 class="text-s text-gray-400 text-truncate">' +
                                            receivable +
                                            '</h6></div>' +

                                            '<div class="col-3 text-center align-self-center">' +
                                            '<p class="text-xs text-gray-200 mb-0"><?php echo e(__('basic.price')); ?></p>' +
                                            '<div class="text-s text-gray-600 fw-bold">' + value
                                            .final_price +
                                            '<small class="text-gray-300 text-xxxs"> <?php echo e(__('basic.egp')); ?></small></div>' +
                                            '</div>' +

                                            '<div class="col-3 text-center align-self-center">' +

                                            '<a href="' + url_show +
                                            '"><span class="badge rounded-pill badge-padd-l active-color-btn"><?php echo e(__('basic.pay')); ?></span></div></a>' +
                                            '</div>'

                                    })

                                    $('#invoice_nopay_table_cont').html(html);

                                } else {
                                    $('#invoice_nopay_table_cont').html(
                                        '<div class="text-center text-gray-400">' +
                                        '<div><i class="far fa-check-circle fs-3 mb-1"></i></div>' +
                                        '<?php echo e(__('basic.nothing to show')); ?></div>');
                                }

                                timer = setTimeout(function() {
                                    invoice_result_nopay_table(branch_id_select);
                                }, 10000);
                            }

                        })
                    };

                    invoice_result_table();

                    function invoice_result_table(branch = branch_id) {
                        var url = "<?php echo e(route('sett.invo_invoice_result_index', ':branch')); ?>";
                        url = url.replace(':branch', branch);

                        var branch_id_select = $('#select-branch-table').val();

                        $.ajax({
                            url: url,
                            type: "GET",
                            dataType: "json",
                            success: function(data) {

                                if (data.length > 0) {

                                    var html = ''

                                    $.each(data, function(key, value) {

                                        var url_show =
                                            "<?php echo e(route('sett.invoice.show', ':id')); ?>";
                                        url_show = url_show.replace(':id', value.id);

                                        if (value.receivable) {
                                            receivable = value.receivable.name;
                                        } else {
                                            receivable = '<?php echo e(__('patientappo.no receiver')); ?>';
                                        };

                                        html +=
                                            '<div class="row mb-2 ">' +

                                            '<div class="col-4 d-flex align-items-center position-relative">' +
                                            '<i class="fas fas fa-money-check-alt me-2 fs-2"></i>' +
                                            '<div class="text-truncate">' +
                                            '<h6 class="mb-1 fw-bold text-gray-600 text-truncate">' +
                                            value.code + '</h6>' +
                                            '<p class="mb-0 text-xs text-gray-300 text-truncate">' +
                                            value.created_at +
                                            '</p>' +
                                            '</div>' +
                                            '<a href="' + url_show +
                                            '" class="stretched-link"></a>' +
                                            '</div>' +

                                            '<div class="col-4 text-center align-self-center text-truncate">' +
                                            '<p class="text-xs text-gray-200 mb-0 text-truncate"><?php echo e(__('basic.patient')); ?></p>' +
                                            '<h6 class="text-s text-gray-400 text-truncate">' +
                                            receivable +
                                            '</h6></div>' +

                                            '<div class="col-4 text-center align-self-center">' +
                                            '<p class="text-xs text-gray-200 mb-0"><?php echo e(__('basic.price')); ?></p>' +
                                            '<div class="text-s text-gray-600 fw-bold">' + value
                                            .final_price +
                                            '<small class="text-gray-300 text-xxxs"> <?php echo e(__('basic.egp')); ?></small></div>' +
                                            '</div>' +

                                            '</div>'

                                    })

                                    $('#invoice_result_table_cont').html(html);

                                } else {
                                    $('#invoice_result_table_cont').html(
                                        '<div class="text-center text-gray-400">' +
                                        '<div><i class="far fa-check-circle fs-3 mb-1"></i></div>' +
                                        '<?php echo e(__('basic.nothing to show')); ?></div>');
                                }

                                timer2 = setTimeout(function() {
                                    invoice_result_table(branch_id_select);
                                }, 10000);

                            }

                        })
                    };


                    //reinsert lab results when branch selector is changed
                    $(document).on('change', '#select-branch-table', function() {

                        var branch = $(this).val();

                        invoice_result_table(branch);
                        invoice_result_nopay_table(branch);
                        window.clearTimeout(timer);
                        window.clearTimeout(timer2);

                    });

                });
        </script>

        <!-- -- datatables plugin -- -->
        <script type="text/javascript" src="https://cdn.datatables.net/1.11.3/js/jquery.dataTables.min.js"></script>
        <script type="text/javascript" src="https://cdn.datatables.net/1.11.3/js/dataTables.bootstrap5.min.js"></script>
        <script type="text/javascript" src="https://cdn.datatables.net/buttons/2.0.1/js/dataTables.buttons.min.js">
        </script>
        <script type="text/javascript" src="https://cdn.datatables.net/buttons/2.0.1/js/buttons.bootstrap5.min.js">
        </script>

        <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
        <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js">
        </script>
        <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js">
        </script>
        <script type="text/javascript" src="https://cdn.datatables.net/buttons/2.0.1/js/buttons.html5.min.js"></script>

        <script type="text/javascript" language="javascript"
            src="https://cdn.datatables.net/buttons/2.0.1/js/buttons.print.min.js"></script>

        <script type="text/javascript" language="javascript"
            src="https://cdn.datatables.net/buttons/2.0.1/js/buttons.colVis.min.js"></script>

        <script>
            $(document).ready(function() {

                    var table = $('#table-lab').DataTable({
                            lengthChange: false,
                            "order": [
                                [4, "ASC"]
                            ],
                            buttons: {
                                dom: {
                                    button: {
                                        className: 'btn btn-table-export me-0' //Primary class for all buttons
                                    }
                                },
                                buttons: ['copy', 'excel', 'pdf']
                            }
                        }

                    );
                    table.buttons().container()
                        .appendTo('#table-lab_wrapper .col-md-6:eq(0)');

                });
        </script>

        <?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/proxima/resources/views/invoice/index.blade.php ENDPATH**/ ?>