@extends('layouts.master')

@section('title', 'Statistics | Proxima - Medical Management app')

@section('title-topbar', 'Statistics')

<!-- css insert -->
@section('css')

<!-- select 2 -->
<link href="https://fastly.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

<!-- boostrap datepicker -->
<link rel="stylesheet"
    href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.1/css/bootstrap-datepicker3.css" />

<!-- tables -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/5.0.1/css/bootstrap.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/1.11.2/css/dataTables.bootstrap5.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.0.1/css/buttons.bootstrap5.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/autofill/2.3.9/css/autoFill.bootstrap5.min.css">
<link rel="stylesheet"
    href="https://nightly.datatables.net/fixedheader/css/fixedHeader.dataTables.css?_=f0de745b101295e88f1504c17177ff49.css"
    type="text/css" />

@endsection

<!-- content insert -->
@section('content')

<div class="container-fluid px-2 mt-3">

    <!-- page title link -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">

        <span class="mb-0">
            <a class="link-cust-text text-gray-200 fw-light" href="{{ route('sett.home') }}">Dashboard |</a>
            <a class="link-cust-text text-gray-200 fw-light" href="{{ route('sett.invoice.index') }}">Invoice | </a>
            <a class="text-gray-300">Month invoices</a>
        </span>

        <div class="d-flex justify-content-center mt-2 mt-md-0">
            <div class="cont-branch-calendar me-2">
                <select id="select-specialty-calendar"
                    class="js-example-basic-single select2-no-search select2-hidden-accessible">
                    <option value="all">
                        All
                    </option>
                    @foreach ($specialty_cat as $item)
                    <option value="{{ $item->id }}" @if ($specialty==$item->id) selected @endif>
                        {{ $item->name }}
                    </option>
                    @endforeach
                </select>
            </div>

            <div class="cont-branch-calendar me-2">
                <select id="select-branch-calendar"
                    class="js-example-basic-single select2-no-search select2-hidden-accessible">
                    <option value="all">
                        All
                    </option>
                    @foreach ($branches as $item)
                    <option value="{{ $item->id }}" @if ($branch==$item->id) selected @endif>
                        {{ $item->name }}
                    </option>
                    @endforeach
                </select>
            </div>

            <div class="calendar-datepicker">
                <div class="input-group">
                    <div class="input-group-prepend">
                        <div class="input-group-text ps-3"><i class="bi bi-calendar2-week-fill"></i> </div>
                    </div>
                    <input id="calendar-date-input" type="text" value="{{ $date }}"
                        class="form-control hasdatetimepicker " placeholder="MM-YYYY">
                </div>
            </div>
        </div>

    </div>

    <div class="row mb-0">
        <ul class="nav nav-tabs nav-tabs-nobg nav-tabs-cat justify-content-center pe-0" id="myTab" role="tablist">
            <li class="nav-item" role="presentation">
                <a href="{{ route('sett.invo_day_search') }}" class="nav-link" id="year_invoice-tab">
                    {{ __('basic.daily st') }}</a>
            </li>
            <li class="nav-item" role="presentation">
                <a href="{{ route('sett.invo_month_search') }}" class="nav-link active" id="specialty-tab">
                    {{ __('basic.monthly st') }}</a>
            </li>
            <li class="nav-item" role="presentation">
                <a href="{{ route('sett.invo_year_search') }}" class="nav-link" id="specialty-tab">
                    {{ __('basic.yearly st') }}</a>
            </li>
            <li class="nav-item" role="presentation">
                <a href="{{ route('sett.invo_allstatcs') }}" class="nav-link" id="specialty-tab">
                    {{ __('basic.statistics') }}</a>
            </li>
        </ul>
    </div>

    <div class="row mb-2">
        <ul class="nav nav-tabs nav-tabs-nobg mb-3 justify-content-center border-bottom-0 pe-0" id="myTab"
            role="tablist">
            <li class="nav-item" role="presentation">
                <button class="nav-link active" id="specialty-tab" data-bs-toggle="tab" data-bs-target="#specialty_stat"
                    type="button" role="tab" aria-controls="home" aria-selected="true" class="text-gray-500"><i
                        class="fas fa-funnel-dollar me-1"></i>
                    Totals</button>
            </li>
            @role('Super-admin|Operation')
            <li class="nav-item" role="presentation">
                <button class="nav-link" id="operation-tab" data-bs-toggle="tab" data-bs-target="#operation_tab"
                    type="button" role="tab" aria-controls="operation_tab" aria-selected="true" class="text-gray-500"><i
                        class="fas fa-stethoscope me-1"></i>
                    Operation</button>
            </li>
            @endrole
        </ul>
    </div>

    <div class="tab-content" id="myTabContent">

        <div class="tab-pane fade show active" id="specialty_stat" role="tabpanel" aria-labelledby="specialty-tab">

            <div class="row">
                <div class="col-12 px-0 px-md-2 mb-4">
                    <div class="card card-input shadow h-100">
                        <!-- Card Header - Dropdown -->
                        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                            <h6 class="m-0 fw-bold"><i class="fas fa-money-check"></i> Income invoices</h6>
                        </div>

                        <!-- Card Body -->
                        <div class="card-body overflow-scroll">

                            <div class="table-responsive">
                                <table class="table table-modal display" width="100%" cellspacing="0">
                                    <thead>
                                        <tr>
                                            <th class="text-xs text-center">Status</th>
                                            <th class="text-xs text-center fw-bold">Total</th>
                                            @role('Super-admin|Accountant')
                                            <th class="text-xs text-center fw-bold">Cost</th>
                                            @endrole
                                            <th class="text-xs text-center">Cat</th>
                                            <th class="text-xs text-center">Items</th>
                                            <th class="text-xs text-center">Description</th>
                                            <th class="text-xs text-center">Discount</th>
                                            <th class="text-xs text-center">Patient</th>
                                            <th class="text-xs text-center">Branch</th>
                                        </tr>
                                    </thead>

                                    <tbody>

                                        @foreach ($invoice_income_inv as $item)
                                        <tr>
                                            <td class="text-truncate">
                                                @if ($item->status == 1)
                                                @php
                                                $status = 'pend-color-btn';
                                                $status_msg = __('basic.pending');
                                                @endphp
                                                @elseif ($item->status == 2)
                                                @php
                                                $status = 'prog-color-btn';
                                                $status_msg = __('basic.installment');
                                                @endphp
                                                @elseif ($item->status == 3)
                                                @php
                                                $status = 'done-color-btn';
                                                $status_msg = __('basic.paid');
                                                @endphp
                                                @elseif ($item->status == 4)
                                                @php
                                                $status = 'cancel-color-btn';
                                                $status_msg = __('basic.refund');
                                                @endphp
                                                @endif
                                                <div
                                                    class="badge px-3 text-xxxs rounded-pill {{ $status }} badge-padd-l">
                                                    {{ $status_msg }}</div>
                                            </td>
                                            <td class="text-center fw-bold text-gray-800">
                                                @foreach ($item->payment as $item_p)
                                                @if ($item_p->method == 1)
                                                @php
                                                $payment_method_txt = __('basic.cash');
                                                @endphp
                                                @elseif ($item_p->method == 2)
                                                @php
                                                $payment_method_txt = __('basic.visa');
                                                @endphp
                                                @endif

                                                {{ $item_p->amount }} <small class="text-gray-300 text-xxxs">
                                                    EGP
                                                </small>
                                                <div class="text-gray-300 text-xxxs">
                                                    via {{ $payment_method_txt }} | shift:
                                                    {{ $item_p->worker->name }} <br> at
                                                    {{ date('d M Y', strtotime($item_p->paid_date)) }}
                                                </div>
                                                @endforeach
                                            </td>
                                            @role('Super-admin|Accountant')
                                            <td class="text-truncate">{{ $item->total_cost }}</td>
                                            @endrole
                                            <td class="text-truncate">{{ $item->service_inv_cat->name }}</td>
                                            <td class="text-truncate">
                                                <a href="{{ route('sett.invoice.show', $item->id) }}"
                                                    class="link-cust-text text-gray-400">
                                                    @foreach ($item->invoice_items as $item_items)
                                                    @if ($item_items->categorizable)
                                                    {{ $item_items->categorizable->name }} |
                                                    @else
                                                    No Items
                                                    @endif
                                                    @endforeach
                                                </a>
                                            </td>
                                            <td class="text-truncate">{{ $item->note }}</td>
                                            <td class="text-center text-gray-800">
                                                @if ($item->discount)
                                                {{ $item->discount }} <small class="text-gray-300 text-xxxs">
                                                    EGP
                                                </small>
                                                <div class="text-gray-300 text-xxxs">
                                                    on {{ $item->items_price }} EGP
                                                </div>
                                                @else
                                                @endif

                                            </td>
                                            <td class="text-truncate">
                                                @if ($item->receivable)
                                                {{ $item->receivable->name }}
                                                @else
                                                {{ __('patientappo.no receiver') }}
                                                @endif
                                            </td>
                                            <td class="text-truncate">{{ $item->branch->name }}
                                            </td>
                                        </tr>
                                        @endforeach

                                    </tbody>

                                    <tfoot>
                                        <tr>
                                            <th class="text-center fw-bold text-s" style="background-color: #e2edfd;">
                                                TOTAL</th>
                                            <th class="text-center fw-bold text-s2" style="background-color: #e2edfd;">
                                                {{ $total_income = $total_income_cash + $total_income_visa }} <small
                                                    class="text-gray-300 text-xxxs">EGP</small>
                                            <th class="text-center fw-bold text-s">Cash</th>
                                            <th class="text-center fw-bold text-s2">
                                                {{ $total_income_cash }} <small
                                                    class="text-gray-300 text-xxxs">EGP</small>
                                            <th class="text-center fw-bold text-s">Credit</th>
                                            <th class="text-center fw-bold text-s2">
                                                {{ $total_income_visa }} <small
                                                    class="text-gray-300 text-xxxs">EGP</small>
                                            </th>
                                            @role('Super-admin|Accountant')
                                            <th class="text-center fw-bold text-s">Cost</th>
                                            <th class="text-center fw-bold text-s2">
                                                {{ $invoice_income_inv->sum('total_cost') }} <small
                                                    class="text-gray-300 text-xxxs">EGP</small>
                                            </th>
                                            @endrole
                                        </tr>
                                    </tfoot>

                                </table>
                            </div>

                            <div class="d-flex mt-4 justify-content-end">
                                {{ $invoice_income_inv->appends(request()->input())->links() }}
                            </div>
                        </div>
                    </div>
                </div>
            </div>


            <div class="row">
                <div class="col-12 px-0 px-md-2 mb-4">
                    <div class="card card-input shadow h-100">
                        <!-- Card Header - Dropdown -->
                        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                            <h6 class="m-0 fw-bold"><i class="fas fa-money-check"></i> Expenses invoices</h6>
                        </div>

                        <!-- Card Body -->
                        <div class="card-body overflow-scroll">

                            <div class="table-responsive">
                                <table class="table table-modal display" width="100%" cellspacing="0">
                                    <thead>
                                        <tr>
                                            <th class="text-xs text-center">Status</th>
                                            <th class="text-xs text-center fw-bold">Total</th>
                                            <th class="text-xs text-center fw-bold">Cost</th>
                                            <th class="text-xs text-center">Cat</th>
                                            <th class="text-xs text-center">Items</th>
                                            <th class="text-xs text-center">Description</th>
                                            <th class="text-xs text-center">Discount</th>
                                            <th class="text-xs text-center">Patient</th>
                                            <th class="text-xs text-center">Branch</th>
                                        </tr>
                                    </thead>

                                    <tbody>

                                        @foreach ($invoice_expenses_inv as $item)
                                        <tr>
                                            <td class="text-truncate">
                                                @if ($item->status == 1)
                                                @php
                                                $status = 'pend-color-btn';
                                                $status_msg = __('basic.pending');
                                                @endphp
                                                @elseif ($item->status == 2)
                                                @php
                                                $status = 'prog-color-btn';
                                                $status_msg = __('basic.installment');
                                                @endphp
                                                @elseif ($item->status == 3)
                                                @php
                                                $status = 'done-color-btn';
                                                $status_msg = __('basic.paid');
                                                @endphp
                                                @elseif ($item->status == 4)
                                                @php
                                                $status = 'cancel-color-btn';
                                                $status_msg = __('basic.refund');
                                                @endphp
                                                @endif
                                                <div
                                                    class="badge px-3 text-xxxs rounded-pill {{ $status }} badge-padd-l">
                                                    {{ $status_msg }}</div>
                                            </td>
                                            <td class="text-center fw-bold text-gray-800">
                                                @foreach ($item->payment as $item_p)
                                                @if ($item_p->method == 1)
                                                @php
                                                $payment_method_txt = __('basic.cash');
                                                @endphp
                                                @elseif ($item_p->method == 2)
                                                @php
                                                $payment_method_txt = __('basic.visa');
                                                @endphp
                                                @endif

                                                {{ $item_p->amount }} <small class="text-gray-300 text-xxxs">
                                                    EGP
                                                </small>
                                                <div class="text-gray-300 text-xxxs">
                                                    via {{ $payment_method_txt }} | shift:
                                                    {{ $item_p->worker->name }}
                                                </div>
                                                @endforeach
                                            </td>
                                            <td class="text-truncate">{{ $item->total_cost }}</td>
                                            <td class="text-truncate">{{ $item->service_inv_cat->name }}</td>
                                            <td class="text-truncate">
                                                <a href="{{ route('sett.invoice.show', $item->id) }}"
                                                    class="link-cust-text text-gray-400">
                                                    @foreach ($item->invoice_items as $item_items)
                                                    @if ($item_items->categorizable)
                                                    {{ $item_items->categorizable->name }} |
                                                    @else
                                                    No Items
                                                    @endif
                                                    @endforeach
                                                </a>
                                            </td>
                                            <td class="text-truncate">{{ $item->note }}</td>
                                            <td class="text-center text-gray-800">
                                                @if ($item->discount)
                                                {{ $item->discount }} <small class="text-gray-300 text-xxxs">
                                                    EGP
                                                </small>
                                                <div class="text-gray-300 text-xxxs">
                                                    on {{ $item->items_price }} EGP
                                                </div>
                                                @else
                                                @endif

                                            </td>
                                            <td class="text-truncate">
                                                @if ($item->receivable)
                                                {{ $item->receivable->name }}
                                                @else
                                                {{ __('patientappo.no receiver') }}
                                                @endif
                                            </td>
                                            <td class="text-truncate">{{ $item->branch->name }}
                                            </td>
                                        </tr>
                                        @endforeach

                                    </tbody>

                                    <tfoot>
                                        <tr>
                                            <th class="text-center fw-bold text-s" style="background-color: #e2edfd;">
                                                TOTAL</th>
                                            <th class="text-center fw-bold text-s2" style="background-color: #e2edfd;">
                                                {{ $total_expenses = $total_expenses_cash + $total_expenses_visa }}
                                                <small class="text-gray-300 text-xxxs">EGP</small>
                                            <th class="text-center fw-bold text-s">Cash</th>
                                            <th class="text-center fw-bold text-s2">
                                                {{ $total_expenses_cash }} <small
                                                    class="text-gray-300 text-xxxs">EGP</small>
                                            <th class="text-center fw-bold text-s">Credit</th>
                                            <th class="text-center fw-bold text-s2">
                                                {{ $total_expenses_visa }} <small
                                                    class="text-gray-300 text-xxxs">EGP</small>
                                            </th>
                                            <th class="text-center fw-bold text-s">Cost</th>
                                            <th class="text-center fw-bold text-s2">
                                                {{ $invoice_expenses_inv->sum('total_cost') }} <small
                                                    class="text-gray-300 text-xxxs">EGP</small>
                                            </th>
                                        </tr>
                                    </tfoot>

                                </table>
                            </div>

                            <div class="d-flex mt-4 justify-content-end">
                                {{ $invoice_expenses_inv->appends(request()->input())->links() }}
                            </div>
                        </div>
                    </div>
                </div>
            </div>


            {{--
            <div class="row">
                <div class="col-12 px-0 px-md-2 mb-4">
                    <div class="card card-input shadow h-100">
                        <!-- Card Header - Dropdown -->
                        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                            <h6 class="m-0 fw-bold"><i class="fas fa-money-check"></i> Income totals cat</h6>
                        </div>

                        <!-- Card Body -->
                        <div class="card-body overflow-scroll">

                            <div class="table-responsive">
                                <table class="table display datatable-modal" id="table-income-totals-cat" width="100%"
                                    cellspacing="0">
                                    <thead>
                                        <tr>
                                            <th class="text-xs text-center">Name</th>
                                            <th class="text-xs text-center">Total</th>
                                        </tr>
                                    </thead>

                                    <tbody>
                                        @php
                                        $income_details_cat_total = 0;
                                        @endphp

                                        @foreach ($income_details_cat as $item)
                                        @php
                                        $income_details_cat_total += $item->sums;
                                        @endphp
                                        <tr>
                                            <td class="text-center text-truncate">
                                                {{ $item->service_inv_cat->name }}
                                            </td>

                                            <td class="text-center">
                                                {{ $item->sums }} <small class="text-gray-300 text-xxxs">
                                                    EGP</small>
                                            </td>
                                        </tr>
                                        @endforeach

                                    </tbody>

                                    <tfoot>
                                        <tr>
                                            <th class="text-center fw-bold text-s">TOTAL</th>
                                            <th class="text-center fw-bold text-s2">
                                                {{ $income_details_cat_total }} <small class="text-gray-300 text-xxxs">
                                                    EGP</small>
                                            </th>
                                        </tr>
                                    </tfoot>

                                </table>
                            </div>


                        </div>
                    </div>
                </div>
            </div>


            <div class="row">
                <div class="col-12 px-0 px-md-2 mb-4">
                    <div class="card card-input shadow h-100">
                        <!-- Card Header - Dropdown -->
                        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                            <h6 class="m-0 fw-bold"><i class="fas fa-money-check"></i> Expenses totals cat</h6>
                        </div>

                        <!-- Card Body -->
                        <div class="card-body overflow-scroll">

                            <div class="table-responsive">
                                <table class="table display datatable-modal" id="table-expenses-totals-cat" width="100%"
                                    cellspacing="0">
                                    <thead>
                                        <tr>
                                            <th class="text-xs text-center">Name</th>
                                            <th class="text-xs text-center">Total</th>
                                        </tr>
                                    </thead>

                                    <tfoot>
                                        <tr>
                                            <th width="50%" class="text-center fw-bold text-s">TOTAL</th>
                                            <th width="50%" class="text-center fw-bold text-s2">
                                                {{ $expenses_details->sum('sums') }} <small
                                                    class="text-gray-300 text-xxxs">
                                                    EGP</small>
                                            </th>
                                        </tr>
                                    </tfoot>

                                    <tbody>
                                        @foreach ($expenses_details_cat as $item)
                                        <tr>
                                            <td class="text-truncate text-center">
                                                {{ $item->service_inv_cat->name }}
                                            </td>

                                            <td class="text-center">
                                                {{ $item->sums }} <small class="text-gray-300 text-xxxs">
                                                    EGP</small>
                                            </td>
                                        </tr>
                                        @endforeach

                                    </tbody>
                                </table>
                            </div>


                        </div>
                    </div>
                </div>
            </div> --}}
            {{-- <div class="row">
                <div class="col-12 px-0 px-md-2 mb-4">
                    <div class="card card-input shadow h-100">
                        <!-- Card Header - Dropdown -->
                        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                            <h6 class="m-0 fw-bold"><i class="fas fa-money-check"></i> Income totals by items</h6>
                        </div>

                        <!-- Card Body -->
                        <div class="card-body overflow-scroll">

                            <div class="table-responsive">
                                <table class="table display datatable-modal" id="table-income-totals" width="100%"
                                    cellspacing="0">
                                    <thead>
                                        <tr>
                                            <th class="text-xs text-center">Name</th>
                                            <th class="text-xs text-center">Total</th>
                                        </tr>
                                    </thead>

                                    <tfoot>
                                        <tr>
                                            <th width="50%" class="text-center fw-bold text-s">TOTAL</th>
                                            <th width="50%" class="text-center fw-bold text-s2">
                                                {{ $income_details->sum('sums') }} <small
                                                    class="text-gray-300 text-xxxs">
                                                    EGP</small>
                                            </th>
                                        </tr>
                                    </tfoot>

                                    <tbody>
                                        @foreach ($income_details as $item)
                                        <tr>
                                            <td class="text-truncate text-center">
                                                {{ $item->categorizable->name }}
                                            </td>

                                            <td class="text-center">
                                                {{ $item->sums }} <small class="text-gray-300 text-xxxs">
                                                    EGP</small>
                                            </td>
                                        </tr>
                                        @endforeach

                                    </tbody>
                                </table>
                            </div>


                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-12 px-0 px-md-2 mb-4">
                    <div class="card card-input shadow h-100">
                        <!-- Card Header - Dropdown -->
                        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                            <h6 class="m-0 fw-bold"><i class="fas fa-money-check"></i> Expenses totals by items
                            </h6>
                        </div>

                        <!-- Card Body -->
                        <div class="card-body overflow-scroll">

                            <div class="table-responsive">
                                <table class="table display datatable-modal" id="table-expenses-totals" width="100%"
                                    cellspacing="0">
                                    <thead>
                                        <tr>
                                            <th class="text-xs text-center">Name</th>
                                            <th class="text-xs text-center">Total</th>
                                        </tr>
                                    </thead>

                                    <tfoot>
                                        <tr>
                                            <th width="50%" class="text-center fw-bold text-s">TOTAL</th>
                                            <th width="50%" class="text-center fw-bold text-s2">
                                                {{ $expenses_details->sum('sums') }} <small
                                                    class="text-gray-300 text-xxxs">
                                                    EGP</small>
                                            </th>
                                        </tr>
                                    </tfoot>

                                    <tbody>
                                        @foreach ($expenses_details as $item)
                                        <tr>
                                            <td class="text-truncate text-center">
                                                {{ $item->categorizable->name }}
                                            </td>

                                            <td class="text-center">
                                                {{ $item->sums }} <small class="text-gray-300 text-xxxs">
                                                    EGP</small>
                                            </td>
                                        </tr>
                                        @endforeach

                                    </tbody>
                                </table>
                            </div>


                        </div>
                    </div>
                </div>
            </div> --}}

            <div class="row mb-4">
                <div class="col-12 col-md-6 mb-4 mb-md-0">
                    <div class="card card-input shadow h-100">
                        <!-- Card Header - Dropdown -->
                        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                            <h6 class="m-0 fw-bold"><i class="fas fa-money-check"></i> Income totals by items chart
                            </h6>
                        </div>

                        <!-- Card Body -->
                        <div class="card-body overflow-scroll">

                            <h5 class="text-center text-gray-300"> income totals
                            </h5>
                            <div class="chart-pie px-1 pb-3">
                                <canvas id="myChart-credit">
                                    <!-- the code and its style is printed from js -->
                                </canvas>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-12 col-md-6">
                    <div class="card card-input shadow h-100">
                        <!-- Card Header - Dropdown -->
                        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                            <h6 class="m-0 fw-bold"><i class="fas fa-money-check"></i> Expenses totals by items
                                chart
                            </h6>
                        </div>

                        <!-- Card Body -->
                        <div class="card-body overflow-scroll">
                            <h5 class="text-center text-gray-300"> Expenses totals</h5>
                            <div class="chart-pie px-1">
                                <canvas id="myChart-debit">
                                    <!-- the code and its style is printed from js -->
                                </canvas>
                            </div>
                        </div>
                    </div>

                </div>
            </div>

        </div>

        @role('Super-admin|Operation')
        <div class="tab-pane fade" id="operation_tab" role="tabpanel" aria-labelledby="operation-tab">


            <div class="row">
                <div class="col-12 px-0 px-md-2 mb-4">
                    <div class="card card-input shadow h-100">
                        <!-- Card Header - Dropdown -->
                        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                            <h6 class="m-0 fw-bold"><i class="fas fa-money-check"></i>Operation income invoices
                            </h6>
                        </div>

                        <!-- Card Body -->
                        <div class="card-body overflow-scroll">

                            <div class="table-responsive">
                                <table class="table display datatable-modal" id="table-operation-income-all"
                                    width="100%" cellspacing="0">
                                    <thead>
                                        <tr>
                                            <th class="text-xs text-center">Date</th>
                                            <th class="text-xs text-center fw-bold">Total</th>
                                            <th class="text-xs text-center">Cat</th>
                                            <th class="text-xs text-center">Items</th>
                                            <th class="text-xs text-center">Description</th>
                                            <th class="text-xs text-center">Discount</th>
                                            <th class="text-xs text-center">Method</th>
                                            <th class="text-xs text-center">Patient</th>
                                            <th class="text-xs text-center">Branch</th>
                                        </tr>
                                    </thead>

                                    <tfoot>
                                        <tr>
                                            <th class="text-center fw-bold text-s">TOTAL</th>
                                            <th class="text-center fw-bold text-s2">
                                                {{ $invoice_oper_income->sum('total_paid') }} <small
                                                    class="text-gray-300 text-xxxs">EGP</small>
                                            </th>
                                        </tr>
                                    </tfoot>

                                    <tbody>
                                        @foreach ($invoice_oper_income as $item)
                                        @if ($item->payment_method == 1)
                                        @php
                                        $payment_method_txt = __('basic.cash');
                                        @endphp
                                        @elseif ($item->payment_method == 2)
                                        @php
                                        $payment_method_txt = __('basic.visa');
                                        @endphp
                                        @elseif ($item->payment_method == 3)
                                        @php
                                        $payment_method_txt = __('basic.online');
                                        @endphp
                                        @elseif ($item->payment_method == 4)
                                        @php
                                        $payment_method_txt = __('basic.bank transfer');
                                        @endphp
                                        @elseif ($item->payment_method == 5)
                                        @php
                                        $payment_method_txt = __('basic.mobile transfer');
                                        @endphp
                                        @else
                                        @php
                                        $payment_method_txt = '';
                                        @endphp
                                        @endif

                                        <tr>
                                            <td class="text-truncate">
                                                {{ date('d M', strtotime($item->paid_date)) }}
                                            </td>
                                            <td class="text-center fw-bold text-gray-800">
                                                @if ($item->status == 1)
                                                {{ $item->total_paid }} <small class="text-gray-300 text-xxxs">
                                                    EGP
                                                </small>
                                                <div class="text-gray-300 text-xxxs mb-1">
                                                    out of {{ $item->final_price }}
                                                </div>
                                                <div
                                                    class="badge px-3 text-xxxs rounded-pill pend-color-btn badge-padd-l">
                                                    {{ __('basic.pending') }}</div>
                                                @else
                                                {{ $item->total_paid }} <small class="text-gray-300 text-xxxs">
                                                    EGP
                                                </small>
                                                @endif
                                            </td>
                                            <td class="text-truncate">{{ $item->service_inv_cat->name }}</td>
                                            <td class="text-truncate">
                                                <a href="{{ route('sett.invoice.show', $item->id) }}"
                                                    class="link-cust-text text-gray-400">
                                                    @foreach ($item->invoice_items as $item_items)
                                                    @if ($item_items->categorizable)
                                                    {{ $item_items->categorizable->name }} |
                                                    @else
                                                    No Items
                                                    @endif
                                                    @endforeach
                                                </a>
                                            </td>
                                            <td class="text-truncate">{{ $item->note }} @if ($item->worker)
                                                <div class="text-xs">
                                                    shift:
                                                    {{ $item->worker->name }}
                                                </div>
                                                @endif
                                            </td>
                                            <td class="text-center text-gray-800">
                                                @if ($item->discount)
                                                {{ $item->discount }} <small class="text-gray-300 text-xxxs">
                                                    EGP
                                                </small>
                                                <div class="text-gray-300 text-xxxs">
                                                    on {{ $item->items_price }} egp
                                                </div>
                                                @else
                                                @endif
                                            </td>
                                            <td>{{ $payment_method_txt }}</td>
                                            <td class="text-truncate">
                                                @if ($item->receivable)
                                                {{ $item->receivable->name }}
                                                @else
                                                {{ __('patientappo.no receiver') }}
                                                @endif
                                            </td>
                                            <td class="text-truncate">{{ $item->branch->name }}
                                            </td>
                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-12 px-0 px-md-2 mb-4">
                    <div class="card card-input shadow h-100">
                        <!-- Card Header - Dropdown -->
                        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                            <h6 class="m-0 fw-bold"><i class="fas fa-money-check"></i>Operation expenses invoices
                            </h6>
                        </div>

                        <!-- Card Body -->
                        <div class="card-body overflow-scroll">

                            <div class="table-responsive">
                                <table class="table display datatable-modal" id="table-operation-expenses-all"
                                    width="100%" cellspacing="0">
                                    <thead>
                                        <tr>
                                            <th class="text-xs text-center">Date</th>
                                            <th class="text-xs text-center fw-bold">Total</th>
                                            <th class="text-xs text-center">Cat</th>
                                            <th class="text-xs text-center">Items</th>
                                            <th class="text-xs text-center">Description</th>
                                            <th class="text-xs text-center">Discount</th>
                                            <th class="text-xs text-center">Method</th>
                                            <th class="text-xs text-center">Patient</th>
                                            <th class="text-xs text-center">Branch</th>
                                        </tr>
                                    </thead>

                                    <tfoot>
                                        <tr>
                                            <th class="text-center fw-bold text-s">TOTAL</th>
                                            <th class="text-center fw-bold text-s2">
                                                {{ $invoice_oper_expenses->sum('total_paid') }} <small
                                                    class="text-gray-300 text-xxxs">EGP</small>
                                            </th>
                                        </tr>
                                    </tfoot>

                                    <tbody>
                                        @foreach ($invoice_oper_expenses as $item)
                                        @if ($item->payment_method == 1)
                                        @php
                                        $payment_method_txt = __('basic.cash');
                                        @endphp
                                        @elseif ($item->payment_method == 2)
                                        @php
                                        $payment_method_txt = __('basic.visa');
                                        @endphp
                                        @elseif ($item->payment_method == 3)
                                        @php
                                        $payment_method_txt = __('basic.online');
                                        @endphp
                                        @elseif ($item->payment_method == 4)
                                        @php
                                        $payment_method_txt = __('basic.bank transfer');
                                        @endphp
                                        @elseif ($item->payment_method == 5)
                                        @php
                                        $payment_method_txt = __('basic.mobile transfer');
                                        @endphp
                                        @else
                                        @php
                                        $payment_method_txt = '';
                                        @endphp
                                        @endif
                                        <tr>
                                            <td class="text-truncate">
                                                {{ date('d M', strtotime($item->paid_date)) }}
                                            </td>
                                            <td class="text-center fw-bold text-gray-800">
                                                @if ($item->status == 1)
                                                {{ $item->total_paid }} <small class="text-gray-300 text-xxxs">
                                                    EGP
                                                </small>
                                                <div class="text-gray-300 text-xxxs mb-1">
                                                    out of {{ $item->final_price }}
                                                </div>
                                                <div
                                                    class="badge px-3 text-xxxs rounded-pill pend-color-btn badge-padd-l">
                                                    {{ __('basic.pending') }}</div>
                                                @else
                                                {{ $item->total_paid }} <small class="text-gray-300 text-xxxs">
                                                    EGP
                                                </small>
                                                @endif
                                            </td>
                                            <td class="text-truncate">{{ $item->service_inv_cat->name }}</td>
                                            <td class="text-truncate">
                                                <a href="{{ route('sett.invoice.show', $item->id) }}"
                                                    class="link-cust-text text-gray-400">
                                                    @foreach ($item->invoice_items as $item_items)
                                                    @if ($item_items->categorizable)
                                                    {{ $item_items->categorizable->name }} |
                                                    @else
                                                    No Items
                                                    @endif
                                                    @endforeach
                                                </a>
                                            </td>
                                            <td class="text-truncate">{{ $item->note }} @if ($item->worker)
                                                <div class="text-xs">
                                                    shift:
                                                    {{ $item->worker->name }}
                                                </div>
                                                @endif
                                            </td>
                                            <td class="text-center text-gray-800">
                                                @if ($item->discount)
                                                {{ $item->discount }} <small class="text-gray-300 text-xxxs">
                                                    EGP
                                                </small>
                                                <div class="text-gray-300 text-xxxs">
                                                    on {{ $item->items_price }} egp
                                                </div>
                                                @else
                                                @endif
                                            </td>
                                            <td>{{ $payment_method_txt }}</td>
                                            <td class="text-truncate">
                                                @if ($item->receivable)
                                                {{ $item->receivable->name }}
                                                @else
                                                {{ __('patientappo.no receiver') }}
                                                @endif
                                            </td>
                                            <td class="text-truncate">{{ $item->branch->name }}
                                            </td>
                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>


                        </div>
                    </div>
                </div>
            </div>

        </div>
        @endrole

    </div>

    <div class="row">


        {{-- total income (cash - credit) --}}
        <div class="col-12 px-0 px-md-2">
            <div class="card card-input shadow mb-4">
                <!-- Card Body -->
                <div class="card-body">
                    <div class="row">

                        <div class="col-12 col-md-6 mb-3 mb-md-0 border-flex">
                            <div class="mt-4 text-center small">
                                <span class="me-2">
                                    <i class="fas fa-circle text-success"></i> Income (Cash)
                                </span>
                                <span class="me-2">
                                    <i class="fas fa-circle text-primary"></i> Expenses (Cash)
                                </span>
                            </div>
                            <div class="chart-pie pt-4 pb-2">
                                <canvas id="myChart_cash">
                                    <!-- the code and its style is printed from js -->
                                </canvas>
                            </div>
                        </div>

                        <div class="col-12 col-md-6 text-center align-self-center">
                            <h6 class="text-gray-400">Net Income (Cash)</h6>
                            @php
                            $profit_cash = $total_income_cash - $total_expenses_cash;
                            @endphp
                            <span class="fs-1">{{ $profit_cash }}<small class="text-gray-300 text-xxxs">
                                    EGP</small></span>
                            @role('Super-admin|Accountant')
                            <hr>
                            <h6 class="text-gray-400">Net Income After Cost (Cash)</h6>
                            <span class="fs-1">{{ $profit_cash - $invoice_income_inv->sum('total_cost') }}<small
                                    class="text-gray-300 text-xxxs">
                                    EGP</small></span>
                            @endrole
                        </div>

                    </div>
                </div>
            </div>
        </div>

        {{-- total income (cash - credit) --}}
        <div class="col-12 px-0 px-md-2">
            <div class="card card-input shadow mb-4">
                <!-- Card Body -->
                <div class="card-body">
                    <div class="row">

                        <div class="col-12 col-md-6 mb-3 mb-md-0 border-flex">
                            <div class="mt-4 text-center small">
                                <span class="me-2">
                                    <i class="fas fa-circle text-success"></i> Income (Visa)
                                </span>
                                <span class="me-2">
                                    <i class="fas fa-circle text-primary"></i> Expenses (Visa)
                                </span>
                            </div>
                            <div class="chart-pie pt-4 pb-2">
                                <canvas id="myChart_visa">
                                    <!-- the code and its style is printed from js -->
                                </canvas>
                            </div>
                        </div>

                        <div class="col-12 col-md-6 text-center align-self-center">
                            <h6 class="text-gray-400">Net Income (Visa)</h6>
                            @php
                            $profit_visa = $total_expenses_visa - $total_income_visa;
                            @endphp
                            <span class="fs-1">{{ $profit_visa }}<small class="text-gray-300 text-xxxs">
                                    EGP</small></span>
                            @role('Super-admin|Accountant')
                            <hr>
                            <h6 class="text-gray-400">Net Income After Cost (Visa)</h6>
                            <span class="fs-1">{{ $profit_visa - $invoice_expenses_inv->sum('total_cost') }}<small
                                    class="text-gray-300 text-xxxs">
                                    EGP</small></span>
                            @endrole
                        </div>

                    </div>
                </div>
            </div>
        </div>


        <div class="col-12 px-0 px-md-2">
            <div class="card card-input shadow mb-4">
                <!-- Card Body -->
                <div class="card-body">
                    <div class="row">

                        <div class="col-12 col-md-6 mb-3 mb-md-0 border-flex">
                            <div class="mt-4 text-center small">
                                <span class="me-2">
                                    <i class="fas fa-circle text-success"></i> Income
                                </span>
                                <span class="me-2">
                                    <i class="fas fa-circle text-primary"></i> Expenses
                                </span>
                            </div>
                            <div class="chart-pie pt-4 pb-2">
                                <canvas id="myChart">
                                    <!-- the code and its style is printed from js -->
                                </canvas>
                            </div>
                        </div>

                        <div class="col-12 col-md-6 text-center align-self-center">
                            <h6 class="text-gray-400">Net Income</h6>
                            @php
                            $profit = $total_income - $total_expenses;
                            @endphp
                            <span class="fs-1">{{ $profit }}<small class="text-gray-300 text-xxxs">
                                    EGP</small></span>
                            @role('Super-admin|Accountant')
                            <hr>
                            <h6 class="text-gray-400">Net Income After Cost</h6>
                            <span class="fs-1">{{ $total_income - $invoice_income_inv->sum('total_cost') }}<small
                                    class="text-gray-300 text-xxxs">
                                    EGP</small></span>
                            @endrole
                        </div>

                    </div>
                </div>
            </div>
        </div>

    </div>

    @endsection


    <!-- js insert -->
    @section('js')

    <!-- select 2 -->
    <script src="https://fastly.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script>
        $(document).ready(function() {
                $('.js-example-basic-single').select2();
                //hide search
                $('.select2-no-search').select2({
                    minimumResultsForSearch: -1
                });
            });
    </script>

    <script>
        $(document).ready(function() {

                @php
                    $chart_color = [
                        '#1a78f1',
                        '#38dfa8',
                        '#d13c62',
                        '#12c7d9',
                        '#03c2c3',
                        '#5035df',
                        '#17a673',
                        '#2e59d9',
                        '#9aeded',
                        '#f3d56a',
                        '#7c859d',
                        '#a4adc5',
                        '#80142f',
                        '#33d293',
                        '#bed233',
                        '#3958e9',
                        '#10c86f',
                        '#654fb6',
                        '#a44fb6',
                        '#89728e',
                        '#c85110',
                        '#6d769d',
                        '#1b6954',
                        '#204494',
                        '#94206b',
                        '#948320',
                        '#209493',
                        '#292094',
                        '#203a65',
                        '#4e6fa5',
                        '#e29031',
                        '#e23168',
                        '#31e0e2',
                        '#e29131',
                        '#319fe2',
                        '#8131e2',
                        '#31a8e2',
                        '#31e2c0',
                        '#31c3e2',
                        '#e2a931',
                        '#3157e2',
                        '#dc3545',
                        '#51b24b',
                        '#a94bb2',
                        '#4b8bb2',
                        '#57b24b',
                        '#a5b24b',
                        '#b2804b',
                        '#b24b4b',
                        '#834bb2',
                        '#b24b6a',
                        '#574bb2',
                        '#236368',
                        '#232c68',
                        '#682345',
                        '#4b2368',
                        '#234b68',
                        '#306823',
                        '#a39f39',
                        '#a239a3',
                        '#a33963',
                        '#a33951',
                        '#a33939',
                        '#c73737',
                        '#6837c7',
                        '#1e3d64',
                        '#3d72b5',
                        '#f1cd5e',
                        '#cd5ef1',
                        '#73f15e',
                        '#469a65',
                        '#88469a',
                        '#6c9a46',
                        '#7d469a',
                        '#9a467b',
                        '#469a8a',
                        '#87469a',
                        '#9a4646',
                        '#c04ac4',
                        '#c44a4a',
                        '#4aacc4',
                        '#1a78f1',
                        '#38dfa8',
                        '#d13c62',
                        '#12c7d9',
                        '#03c2c3',
                        '#5035df',
                        '#17a673',
                        '#2e59d9',
                        '#9aeded',
                        '#f3d56a',
                        '#7c859d',
                        '#a4adc5',
                        '#80142f',
                        '#a44fb6',
                        '#89728e',
                        '#c85110',
                        '#6d769d',
                        '#1b6954',
                        '#a94bb2',
                        '#4b8bb2',
                        '#57b24b',
                        '#a5b24b',
                        '#b2804b',
                        '#b24b4b',
                        '#834bb2',
                        '#b24b6a',
                        '#574bb2',
                        '#236368',
                        '#232c68',
                        '#682345',
                        '#4b2368',
                        '#234b68',
                        '#306823',
                        '#a39f39',
                        '#a239a3',
                        '#a33963',
                        '#a33951',
                        '#a33939',
                        '#c73737',
                        '#6837c7',
                        '#1e3d64',
                        '#3d72b5',
                        '#f1cd5e',
                        '#cd5ef1',
                        '#73f15e',
                        '#469a65',
                        '#88469a',
                        '#6c9a46',
                        '#7d469a',
                        '#9a467b',
                        '#469a8a',
                        '#87469a',
                        '#9a4646',
                        '#c04ac4',
                        '#c44a4a',
                        '#4aacc4',
                        '#1a78f1',
                        '#38dfa8',
                        '#d13c62',
                        '#12c7d9',
                        '#03c2c3',
                        '#5035df',
                        '#17a673',
                        '#2e59d9',
                        '#9aeded',
                        '#f3d56a',
                        '#7c859d',
                        '#a4adc5',
                        '#80142f',
                        '#a44fb6',
                        '#a94bb2',
                        '#4b8bb2',
                        '#57b24b',
                        '#a5b24b',
                        '#b2804b',
                        '#b24b4b',
                        '#834bb2',
                        '#b24b6a',
                        '#574bb2',
                        '#10c86f',
                        '#654fb6',
                        '#a44fb6',
                        '#89728e',
                        '#c85110',
                        '#6d769d',
                        '#1b6954',
                        '#204494',
                    ];
                @endphp

                //--------------------- selectors -------------------
                $(document).on('change', '#select-specialty-calendar, #select-branch-calendar', function() {
                    var date_input = $('#calendar-date-input').val();
                    var date = $('#select-specialty-calendar').val();
                    var date2 = $('#select-branch-calendar').val();

                    var url = "{{ route('sett.invo_month_search', [':date_input', ':date', ':date2']) }}";

                    url = url.replace(':date_input', date_input).replace(':date', date).replace(':date2',
                        date2);

                    var url = url;
                    window.location.href = url;
                });
                $(document).on('change', '#calendar-date-input', function() {
                    var date_input = $('#calendar-date-input').val();
                    var date = $('#select-specialty-calendar').val();
                    var date2 = $('#select-branch-calendar').val();

                    var url = "{{ route('sett.invo_month_search', [':date_input', ':date', ':date2']) }}";

                    url = url.replace(':date_input', date_input).replace(':date', date).replace(':date2',
                        date2);

                    window.location.href = url;
                });
            });
    </script>

    <!-- jquery ui datepicker -->
    <script type="text/javascript"
        src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.1/js/bootstrap-datepicker.min.js"></script>
    <script>
        $(function() {
                $('.hasdatetimepicker').datepicker({
                    todayHighlight: true,
                    format: "mm-yyyy",
                    viewMode: "months",
                    minViewMode: "months"
                });
            });
    </script>

    <!-- -- Chart.js plugin -- -->
    <script src="https://fastly.jsdelivr.net/npm/chart.js"></script>

    <script>
        // total income and expenses (cash)
                var ctx = document.getElementById("myChart_cash");
            var myPieChart = new Chart(ctx, {
                type: 'doughnut',
                data: {
                    labels: ["Income Cash", "Expenses Cash"],
                    datasets: [{
                        data: [{{ $total_income_cash }},
                            {{ $total_expenses_cash }}
                        ],
                        backgroundColor: ['#1cc88a', '#4e73df'],
                        hoverBackgroundColor: ['#17a673', '#2e59d9'],
                        hoverBorderColor: "rgba(234, 236, 244, 1)",
                    }],
                },
                options: {
                    maintainAspectRatio: false,
                    tooltips: {
                        backgroundColor: "rgb(255,255,255)",
                        bodyFontColor: "#858796",
                        borderColor: '#dddfeb',
                        borderWidth: 1,
                        xPadding: 15,
                        yPadding: 15,
                        displayColors: false,
                        caretPadding: 10,
                        callbacks: {
                            label: function(tooltipItem) {
                                return tooltipItem.yLabel;
                            }
                        }
                    },
                    plugins: {
                        legend: {
                            display: false
                        }
                    },
                    cutoutPercentage: 80,
                },
            });

            // total income and expenses (visa)
            var ctx = document.getElementById("myChart_visa");
            var myPieChart = new Chart(ctx, {
                type: 'doughnut',
                data: {
                    labels: ["Income Visa", "Expenses Visa"],
                    datasets: [{
                        data: [{{ $total_income_visa }},
                            {{ $total_expenses_visa }}
                        ],
                        backgroundColor: ['#1cc88a', '#4e73df'],
                        hoverBackgroundColor: ['#17a673', '#2e59d9'],
                        hoverBorderColor: "rgba(234, 236, 244, 1)",
                    }],
                },
                options: {
                    maintainAspectRatio: false,
                    tooltips: {
                        backgroundColor: "rgb(255,255,255)",
                        bodyFontColor: "#858796",
                        borderColor: '#dddfeb',
                        borderWidth: 1,
                        xPadding: 15,
                        yPadding: 15,
                        displayColors: false,
                        caretPadding: 10,
                        callbacks: {
                            label: function(tooltipItem) {
                                return tooltipItem.yLabel;
                            }
                        }
                    },
                    plugins: {
                        legend: {
                            display: false
                        }
                    },
                    cutoutPercentage: 80,
                },
            });
            
        // Pie Chart Example
            var ctx = document.getElementById("myChart");
            var myPieChart = new Chart(ctx, {
                type: 'doughnut',
                data: {
                    labels: ["Income", "Expenses"],
                    datasets: [{
                        data: [{{ $total_income }},
                            {{ $total_expenses }}
                        ],
                        backgroundColor: ['#1cc88a', '#4e73df'],
                        hoverBackgroundColor: ['#17a673', '#2e59d9'],
                        hoverBorderColor: "rgba(234, 236, 244, 1)",
                    }],
                },
                options: {
                    maintainAspectRatio: false,
                    tooltips: {
                        backgroundColor: "rgb(255,255,255)",
                        bodyFontColor: "#858796",
                        borderColor: '#dddfeb',
                        borderWidth: 1,
                        xPadding: 15,
                        yPadding: 15,
                        displayColors: false,
                        caretPadding: 10,
                        callbacks: {
                            label: function(tooltipItem) {
                                return tooltipItem.yLabel;
                            }
                        }
                    },
                    plugins: {
                        legend: {
                            display: false
                        }
                    },
                    cutoutPercentage: 80,
                },
            });


            // --------- credit chart ---------
            var ctx_recourse = document.getElementById("myChart-credit");
            var myPieChart2 = new Chart(ctx_recourse, {
                type: 'doughnut',
                data: {
                    labels: [
                        @foreach ($income_details_cat as $item)
                            "{{ $item->service_inv_cat->name }}",
                        @endforeach
                    ],
                    datasets: [{
                        data: [
                            @foreach ($income_details_cat as $item)
                                {{ $item->sums . ',' }}
                            @endforeach
                        ],
                        @php
                            $i = 0;
                        @endphp
                        backgroundColor: [
                            @foreach ($income_details_cat as $item)
                                '{{ $chart_color[$i] }}',
                                @php
                                    $i++;
                                @endphp
                            @endforeach
                        ],
                    }],
                },
                options: {
                    maintainAspectRatio: false,
                    tooltips: {
                        backgroundColor: "rgb(255,255,255)",
                        bodyFontColor: "#858796",
                        borderColor: '#dddfeb',
                        borderWidth: 1,
                        xPadding: 15,
                        yPadding: 15,
                        displayColors: false,
                        caretPadding: 10,
                        callbacks: {
                            label: function(tooltipItem) {
                                return tooltipItem.yLabel;
                            }
                        }
                    },
                    plugins: {
                        legend: {
                            display: true
                        },
                        colorschemes: {
                            scheme: 'brewer.Paired12'
                        }
                    },
                    cutoutPercentage: 80,
                },
            });
            // --------- debit chart ---------
            var ctx_recourse = document.getElementById("myChart-debit");
            var myPieChart2 = new Chart(ctx_recourse, {
                type: 'doughnut',
                data: {
                    labels: [
                        @foreach ($expenses_details_cat as $item)
                            "{{ $item->service_inv_cat->name }}",
                        @endforeach
                    ],
                    datasets: [{
                        data: [
                            @foreach ($expenses_details_cat as $item)
                                {{ $item->sums . ',' }}
                            @endforeach
                        ],
                        @php
                            $i = 0;
                        @endphp
                        backgroundColor: [
                            @foreach ($expenses_details_cat as $item)
                                '{{ $chart_color[$i] }}',
                                @php
                                    $i++;
                                @endphp
                            @endforeach
                        ],
                    }],
                },
                options: {
                    maintainAspectRatio: false,
                    tooltips: {
                        backgroundColor: "rgb(255,255,255)",
                        bodyFontColor: "#858796",
                        borderColor: '#dddfeb',
                        borderWidth: 1,
                        xPadding: 15,
                        yPadding: 15,
                        displayColors: false,
                        caretPadding: 10,
                        callbacks: {
                            label: function(tooltipItem) {
                                return tooltipItem.yLabel;
                            }
                        }
                    },
                    plugins: {
                        legend: {
                            display: true
                        },
                        colorschemes: {
                            scheme: 'brewer.Paired12'
                        }
                    },
                    cutoutPercentage: 80,
                },
            });
    </script>

    <!-- -- datatables plugin -- -->
    <script type="text/javascript" src="https://cdn.datatables.net/1.11.3/js/jquery.dataTables.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/1.11.3/js/dataTables.bootstrap5.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/buttons/2.0.1/js/dataTables.buttons.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/buttons/2.0.1/js/buttons.bootstrap5.min.js"></script>

    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/buttons/2.0.1/js/buttons.html5.min.js"></script>

    <script type="text/javascript" language="javascript"
        src="https://cdn.datatables.net/buttons/2.0.1/js/buttons.print.min.js"></script>

    <script type="text/javascript" language="javascript"
        src="https://cdn.datatables.net/buttons/2.0.1/js/buttons.colVis.min.js"></script>
    <script
        src="https://nightly.datatables.net/fixedheader/js/dataTables.fixedHeader.js?_=f0de745b101295e88f1504c17177ff49">
    </script>

    <script>
        $(document).ready(function() {

                var table = $('#table-income-all').DataTable({
                        lengthChange: false,
                        "pageLength": 10,
                        "order": [
                            [0, "ASC"]
                        ],
                        buttons: {
                            dom: {
                                button: {
                                    className: 'btn btn-table-export me-0' //Primary class for all buttons
                                }
                            },
                            buttons: [{
                                    extend: 'copyHtml5',
                                    footer: true
                                },
                                {
                                    extend: 'excelHtml5',
                                    footer: true
                                },
                                {
                                    extend: 'pdfHtml5',
                                    footer: true
                                },
                                {
                                    extend: 'print',
                                    footer: true
                                }
                            ]
                        }
                    }

                );
                table.buttons().container()
                    .appendTo('#table-income-all_wrapper .col-md-6:eq(0)');

                var table = $('#table-expenses-all').DataTable({
                    lengthChange: false,
                    "pageLength": 10,
                    "order": [
                        [0, "ASC"]
                    ],
                    buttons: {
                        dom: {
                            button: {
                                className: 'btn btn-table-export me-0' //Primary class for all buttons
                            }
                        },
                        buttons: [{
                                extend: 'copyHtml5',
                                footer: true
                            },
                            {
                                extend: 'excelHtml5',
                                footer: true
                            },
                            {
                                extend: 'pdfHtml5',
                                footer: true
                            },
                            {
                                extend: 'print',
                                footer: true
                            }
                        ]
                    }
                });
                table.buttons().container()
                    .appendTo('#table-expenses-all_wrapper .col-md-6:eq(0)');

                var table = $('#table-income-totals-cat').DataTable({
                    lengthChange: false,
                    "pageLength": 10,
                    "order": [
                        [0, "ASC"]
                    ],
                    buttons: {
                        dom: {
                            button: {
                                className: 'btn btn-table-export me-0' //Primary class for all buttons
                            }
                        },
                        buttons: [{
                                extend: 'copyHtml5',
                                footer: true
                            },
                            {
                                extend: 'excelHtml5',
                                footer: true
                            },
                            {
                                extend: 'pdfHtml5',
                                footer: true
                            },
                            {
                                extend: 'print',
                                footer: true
                            }
                        ]
                    }
                });
                table.buttons().container()
                    .appendTo('#table-income-totals-cat_wrapper .col-md-6:eq(0)');

                var table = $('#table-expenses-totals-cat').DataTable({
                    lengthChange: false,
                    "pageLength": 10,
                    "order": [
                        [0, "ASC"]
                    ],
                    buttons: {
                        dom: {
                            button: {
                                className: 'btn btn-table-export me-0' //Primary class for all buttons
                            }
                        },
                        buttons: [{
                                extend: 'copyHtml5',
                                footer: true
                            },
                            {
                                extend: 'excelHtml5',
                                footer: true
                            },
                            {
                                extend: 'pdfHtml5',
                                footer: true
                            },
                            {
                                extend: 'print',
                                footer: true
                            }
                        ]
                    }
                });
                table.buttons().container()
                    .appendTo('#table-expenses-totals-cat_wrapper .col-md-6:eq(0)');

                var table = $('#table-income-totals').DataTable({
                    lengthChange: false,
                    "pageLength": 10,
                    "order": [
                        [0, "ASC"]
                    ],
                    buttons: {
                        dom: {
                            button: {
                                className: 'btn btn-table-export me-0' //Primary class for all buttons
                            }
                        },
                        buttons: [{
                                extend: 'copyHtml5',
                                footer: true
                            },
                            {
                                extend: 'excelHtml5',
                                footer: true
                            },
                            {
                                extend: 'pdfHtml5',
                                footer: true
                            },
                            {
                                extend: 'print',
                                footer: true
                            }
                        ]
                    }
                });
                table.buttons().container()
                    .appendTo('#table-income-totals_wrapper .col-md-6:eq(0)');

                var table = $('#table-expenses-totals').DataTable({
                    lengthChange: false,
                    "pageLength": 10,
                    "order": [
                        [0, "ASC"]
                    ],
                    buttons: {
                        dom: {
                            button: {
                                className: 'btn btn-table-export me-0' //Primary class for all buttons
                            }
                        },
                        buttons: [{
                                extend: 'copyHtml5',
                                footer: true
                            },
                            {
                                extend: 'excelHtml5',
                                footer: true
                            },
                            {
                                extend: 'pdfHtml5',
                                footer: true
                            },
                            {
                                extend: 'print',
                                footer: true
                            }
                        ]
                    }
                });
                table.buttons().container()
                    .appendTo('#table-expenses-totals_wrapper .col-md-6:eq(0)');

                var table = $('#table-operation-income-all').DataTable({
                    lengthChange: false,
                    "pageLength": 10,
                    "order": [
                        [0, "ASC"]
                    ],
                    buttons: {
                        dom: {
                            button: {
                                className: 'btn btn-table-export me-0' //Primary class for all buttons
                            }
                        },
                        buttons: [{
                                extend: 'copyHtml5',
                                footer: true
                            },
                            {
                                extend: 'excelHtml5',
                                footer: true
                            },
                            {
                                extend: 'pdfHtml5',
                                footer: true
                            },
                            {
                                extend: 'print',
                                footer: true
                            }
                        ]
                    }
                });
                table.buttons().container()
                    .appendTo('#table-operation-income-all_wrapper .col-md-6:eq(0)');

                var table = $('#table-operation-expenses-all').DataTable({
                    lengthChange: false,
                    "pageLength": 10,
                    "order": [
                        [0, "ASC"]
                    ],
                    buttons: {
                        dom: {
                            button: {
                                className: 'btn btn-table-export me-0' //Primary class for all buttons
                            }
                        },
                        buttons: [{
                                extend: 'copyHtml5',
                                footer: true
                            },
                            {
                                extend: 'excelHtml5',
                                footer: true
                            },
                            {
                                extend: 'pdfHtml5',
                                footer: true
                            },
                            {
                                extend: 'print',
                                footer: true
                            }
                        ]
                    }
                });
                table.buttons().container()
                    .appendTo('#table-operation-expenses-all_wrapper .col-md-6:eq(0)');

            });
    </script>

    @endsection