<?php

namespace App\Models\Invoice;

use App\Models\User;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Invoice_item extends Model
{
    use HasFactory;

    protected $fillable = [
        'id',
        'invoice_id',
        'itemable_id', //like App\Models\Patient\Session_pat
        'itemable_type',
        'categorizable_id', //like App\Models\Patient\Service_item
        'categorizable_type',
        'quantity',
        'price',
        'price',
        'sold_price',
        'doctor_id',
        'doctor_comm',
        'paid',
    ];

    public $timestamps = false;


    public function invoice()
    {
        return $this->belongsTo(Invoice::class, 'invoice_id', 'id');
    }
    
    public function categorizable()
    {
        return $this->morphTo();
    }

    public function itemable()
    {
        return $this->morphTo();
    }

    public function doctor()
    {
        return $this->belongsTo(User::class, 'doctor_id', 'id');
    }

    public function payment()
    {
        return $this->hasMany(Payment::class, 'invoice_id', 'invoice_id');
    }
    

}