<?php

namespace App\Models\Branch;

use App\Models\Patient\Patient;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Branch extends Model
{
    use HasFactory;

    protected $fillable = [
        'id',
        'code',
        'name',
        'address',
        'latitude',
        'longitude',
    ];

    public $timestamps = false;

    public function appointment()
    {
        return $this->hasMany(Appointment::class, 'branch_id', 'id');
    }

    public function patient()
    {
        return $this->hasMany(Patient::class, 'first_branch_id', 'id');
    }
}