<?php

namespace App\Models\Admin;

use App\Models\Branch\Branch;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Attendance extends Model
{
    use HasFactory;

    protected $fillable = [
        'id',
        'worker_id',
        'branch_id',
        'arrived_time',
        'leave_time',
        'worker_ip',
    ];
    
    public $timestamps = false;


    public function worker()
    {
        return $this->belongsTo(User::class, 'worker_id', 'id');
    }

    public function branch()
    {
        return $this->belongsTo(Branch::class, 'branch_id', 'id');
    }
    
}