<?php

namespace App\Http\Controllers\Patient;

use App\Http\Controllers\Controller;
use App\Http\Requests\PatientRequest;
use App\Http\Services\smsGateways\Victorylink;
use App\Http\Services\smsGateways\Whysms;
use App\Models\Branch\Appointment;
use App\Models\Branch\Branch;
use App\Models\Branch\Lab;
use App\Models\Branch\Oper_placecat;
use App\Models\Invoice\Invoice;
use App\Models\Invoice\Invoice_item;
use App\Models\Invoice\Patient_wallet;
use App\Models\location\City;
use App\Models\location\Country;
use App\Models\Patient\Ask_for_cat;
use App\Models\Patient\Ask_for_main_cat;
use App\Models\Patient\Dental\Dent_main_cat;
use App\Models\Patient\Dental\Pat_bs_den_chart;
use App\Models\Patient\Disease;
use App\Models\Patient\Disease_cat;
use App\Models\Patient\Disease_draw;
use App\Models\Patient\Eyeglasses_prescription;
use App\Models\Patient\From_recourse;
use App\Models\Patient\Lead_pat_note;
use App\Models\Patient\Med_dose;
use App\Models\Patient\Med_duration;
use App\Models\Patient\Medicine;
use App\Models\Patient\Medicine_cat;
use App\Models\Patient\Patient;
use App\Models\Patient\Patient_img;
use App\Models\Patient\Pulse;
use App\Models\Patient\Pulse_area_cat;
use App\Models\Patient\Service_item;
use App\Models\Patient\Session_pat;
use App\Models\Patient\Specialty_cat;
use App\Models\Patient\Treatment;
use App\Models\Patient\Treatment_cat;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;
use Illuminate\Validation\Rule;
use Mpdf\Mpdf;
use Mpdf\Tag\Input;
use SimpleSoftwareIO\QrCode\Facades\QrCode;
use PDF;
use Image;


class PatientController extends Controller
{

    public function __construct()
    {
        $this->middleware('role:Super-admin|Doctor|Branch-manager|Receptionist|Call-center|Operation|Operation_doctor')->only('index');
        $this->middleware('role:Super-admin|Doctor|Branch-manager|Receptionist|Call-center|Operation|Operation_doctor')->only('show');
        $this->middleware('role:Super-admin|Doctor|Branch-manager|Receptionist|Call-center|Operation')->only('create');
        $this->middleware('role:Super-admin|Doctor|Branch-manager|Receptionist|Call-center|Operation')->only('store');
        $this->middleware('role:Super-admin|Doctor|Branch-manager|Receptionist|Operation')->only('update');
        $this->middleware('role:Super-admin|Doctor|Branch-manager|Receptionist|Operation')->only('edit');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $branches = Branch::all();
        return view('patient.index', compact('branches'));
    }

    public function new_patients_index()
    {
        $branch = request()->branch;

        $patient = Patient::select('id', 'code', 'first_branch_id', 'avatar', 'birthday', 'country_id', 'city_id', 'phone_number', 'created_at', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'))
            ->where('first_branch_id', $branch)
            ->with(['country' => function ($q) {
                $q->select('id', 'name');
            }])
            ->with(['city' => function ($q) {
                $q->select('id', 'name');
            }])
            ->with(['branch' => function ($q) {
                $q->select('id', 'name');
            }])
            ->orderBy('id', 'DESC')
            ->limit(8)
            ->get();

        return $patient;
    }

    //search all patients depends on filters
    public function show_all_patients(request $request)
    {

        $patients = Patient::select('id', 'code', 'type', 'first_branch_id', 'avatar', 'birthday', 'country_id', 'city_id', 'phone_number', 'from_recourse_id', 'created_at', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'))
            ->with(['country' => function ($q) {
                $q->select('id', 'name');
            }])
            ->with(['city' => function ($q) {
                $q->select('id', 'name');
            }])
            ->with(['branch' => function ($q) {
                $q->select('id', 'name');
            }])
            ->with(['recourse' => function ($q) {
                $q->select('id', 'name');
            }])
            ->with(['lead_notes' => function ($q) {
                $q->select('id', 'worker_id', 'patient_id', 'note', 'status', 'date')
                    ->with(['worker' => function ($q) {
                        $q->select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
                    }]);
            }])
            ->orderBy('id', 'DESC');

        if ($request->input('type_srch')) {
            $patients = $patients->where('type', $request->input('type_srch'));
        }

        if ($request->input('reco_srch')) {
            $patients = $patients->where('recommendation', $request->input('reco_srch'));
        }

        if ($request->input('askfor_srch')) {
            $patients = $patients->where('ask_for_id', $request->input('askfor_srch'));
        }


        if (Auth::user()->branch_id == 0) {
            if ($request->input('branch_srch')) {
                $patients = $patients->where('first_branch_id', $request->input('branch_srch'));
            }
        } else {
            $patients = $patients->where('first_branch_id', Auth::user()->branch_id);
        }

        if ($request->input('resource_srch')) {
            $patients = $patients->where('from_recourse_id', $request->input('resource_srch'));
        }

        if ($request->input('country_srch')) {
            $patients = $patients->where('country_id', $request->input('country_srch'));
        }

        if ($request->input('city_srch')) {
            $patients = $patients->where('city_id', $request->input('city_srch'));
        }

        if ($request->input('gendar_srch')) {
            $patients = $patients->where('gendar', $request->input('gendar_srch'));
        }

        if ($request->input('birthday_srch')) {
            $birthday = $request->input('birthday_srch');
            if ($birthday === "yesterday") {
                $birthday_month = Carbon::yesterday()->format('m');
                $birthday_day = Carbon::yesterday()->format('d');
            } elseif ($birthday === "today") {
                $birthday_month = Carbon::today()->format('m');
                $birthday_day = Carbon::today()->format('d');
            } elseif ($birthday === "tomorrow") {
                $birthday_month = Carbon::tomorrow()->format('m');
                $birthday_day = Carbon::tomorrow()->format('d');
            }

            $patients = $patients->whereMonth('birthday', $birthday_month)
                ->whereDay('birthday', $birthday_day);
        }

        if ($request->input('date_srch')) {
            $date_serc = explode('to', $request->input('date_srch'));
            $date_1_serc = $date_serc[0];

            if (isset($date_serc[1])) {
                $date_2_serc = $date_serc[1];
            } else {
                $date_2_serc = $date_serc[0];
            }
            $patients = $patients->whereBetween('created_at', [
                Carbon::createFromFormat('m-Y', $date_1_serc)->startOfMonth(), //2022-10-01 00:00:00.0
                Carbon::createFromFormat('m-Y', $date_2_serc)->endOfMonth() // 2022-10-31 23:59:59.999999
            ]);
        } else {
            if ($request->input('day_srch')) {
                $date_serc = explode('to', $request->input('day_srch'));
                $date_1_serc = $date_serc[0];

                if (isset($date_serc[1])) {
                    $date_2_serc = $date_serc[1];
                } else {
                    $date_2_serc = $date_serc[0];
                }
                $patients = $patients->whereBetween('created_at', [
                    Carbon::createFromFormat('Y-m-d', $date_1_serc)->startOfDay(), //2022-10-01 00:00:00.0
                    Carbon::createFromFormat('Y-m-d', $date_2_serc)->endOfDay() // 2022-10-31 23:59:59.999999
                ]);
            }
        }

        $patients = $patients->paginate(10);


        //for sending SMS message to the specific group
        if ($request->input('sms_content')) {

            $this->validate($request, [
                'sms_content' => ['sometimes', 'required', 'max:70'],
            ]);

            $sms_content = $request->input('sms_content');

            $patients_sms = Patient::select('id', 'first_name', 'phone_number', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'))
                ->orderBy('id', 'DESC');

            if ($request->input('type_srch')) {
                $patients_sms = $patients_sms->where('type', $request->input('type_srch'));
            }

            if ($request->input('reco_srch')) {
                $patients_sms = $patients_sms->where('recommendation', $request->input('reco_srch'));
            }

            if ($request->input('askfor_srch')) {
                $patients_sms = $patients_sms->where('ask_for_id', $request->input('askfor_srch'))
                    ->where('status', 1);
            }

            if ($request->input('branch_srch')) {
                $patients_sms = $patients_sms->where('first_branch_id', $request->input('branch_srch'));
            }


            if ($request->input('resource_srch')) {
                $patients_sms = $patients_sms->where('from_recourse_id', $request->input('resource_srch'));
            }


            if ($request->input('country_srch')) {
                $patients_sms = $patients_sms->where('country_id', $request->input('country_srch'));
            }

            if ($request->input('city_srch')) {
                $patients_sms = $patients_sms->where('city_id', $request->input('city_srch'));
            }

            if ($request->input('gendar_srch')) {
                $patients_sms = $patients_sms->where('gendar', $request->input('gendar_srch'));
            }

            if ($request->input('date_srch')) {
                $date_serc = explode('to', $request->input('date_srch'));
                $date_1_serc = $date_serc[0];

                if (isset($date_serc[1])) {
                    $date_2_serc = $date_serc[1];
                } else {
                    $date_2_serc = $date_serc[0];
                }

                $patients_sms = $patients_sms->whereBetween('created_at', [
                    Carbon::createFromFormat('m-Y', $date_1_serc)->startOfMonth(), //2022-10-01 00:00:00.0
                    Carbon::createFromFormat('m-Y', $date_2_serc)->endOfMonth() // 2022-10-31 23:59:59.999999
                ]);
            }

            $patients_sms = $patients_sms->get();

            foreach ($patients_sms as $item) {
                //app(Victorylink::class)->sendSms($item->phone_number, $sms_content, 'ar');
            }
        }

        $ask_for = Ask_for_cat::all();

        $specialty = Specialty_cat::all();

        $branch = Branch::all();

        $resources = From_recourse::all();

        $country = Patient::select('country_id', DB::raw('count(country_id) as total'))
            ->with(['country' => function ($q) {
                $q->select('id', 'name');
            }])
            ->groupBy('country_id')
            ->orderBy('total', 'DESC')
            ->limit(7)
            ->get();

        $city = Patient::select('city_id', DB::raw('count(city_id) as total'))
            ->with(['country' => function ($q) {
                $q->select('id', 'name');
            }])
            ->groupBy('city_id')
            ->orderBy('total', 'DESC')
            ->limit(7)
            ->get();

        return view('patient.show_all', compact('patients', 'ask_for', 'specialty', 'branch', 'resources', 'country', 'city'));
    }

    //search all patients depends on filters
    public function my_patients(request $request)
    {

        $patients = Patient::select('id', 'code', 'first_branch_id', 'avatar', 'birthday', 'country_id', 'city_id', 'phone_number', 'from_recourse_id', 'created_at', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'))
            ->with(['country' => function ($q) {
                $q->select('id', 'name');
            }])
            ->with(['city' => function ($q) {
                $q->select('id', 'name');
            }])
            ->with(['branch' => function ($q) {
                $q->select('id', 'name');
            }])
            ->with(['recourse' => function ($q) {
                $q->select('id', 'name');
            }])
            ->whereHas('appointments', function ($q) {
                $q->where('doctor_id', Auth::id())->select('id');
            })
            ->orderBy('id', 'DESC');

        if ($request->input('branch_srch')) {
            $patients = $patients->where('first_branch_id', $request->input('branch_srch'));
        }

        if ($request->input('country_srch')) {
            $patients = $patients->where('country_id', $request->input('country_srch'));
        }

        if ($request->input('city_srch')) {
            $patients = $patients->where('city_id', $request->input('city_srch'));
        }

        if ($request->input('gendar_srch')) {
            $patients = $patients->where('gendar', $request->input('gendar_srch'));
        }

        $patients = $patients->paginate(8);

        $specialty = Specialty_cat::all();

        $branch = Branch::all();

        $country = Patient::select('country_id', DB::raw('count(country_id) as total'))
            ->with(['country' => function ($q) {
                $q->select('id', 'name');
            }])
            ->groupBy('country_id')
            ->orderBy('total', 'DESC')
            ->limit(7)
            ->get();

        $city = Patient::select('city_id', DB::raw('count(city_id) as total'))
            ->with(['country' => function ($q) {
                $q->select('id', 'name');
            }])
            ->groupBy('city_id')
            ->orderBy('total', 'DESC')
            ->limit(7)
            ->get();

        return view('patient.my_patients', compact('patients', 'specialty', 'branch', 'country', 'city'));
    }


    //search all patients depends on filters
    public function vip_patients(request $request)
    {

        $patients = Invoice::select('total_paid', 'receivable_id', 'receivable_type', DB::raw('sum(total_paid) as sums'),)
            ->where('type', 0)
            ->whereIn('status', [1, 2, 3])
            ->where('receivable_id', '!=', 0)
            ->with(['receivable' => function ($q) {
                $q->select('id', 'avatar',  DB::raw('CONCAT(first_Name, " ", second_Name) AS name'), 'first_branch_id', 'birthday', 'country_id', 'city_id', 'phone_number', 'created_at')
                    ->with(['country' => function ($q) {
                        $q->select('id', 'name');
                    }])
                    ->with(['city' => function ($q) {
                        $q->select('id', 'name');
                    }])
                    ->with(['branch' => function ($q) {
                        $q->select('id', 'name');
                    }]);
            }])
            ->groupBy('receivable_id')
            ->limit(100)
            ->orderBy('sums', 'DESC');

        if ($request->input('reco_srch')) {
            $patients = $patients->whereHasMorph('receivable', [Patient::class], function ($q) use ($request) {
                $q->where('recommendation', $request->input('reco_srch'));
            });
        }

        if ($request->input('branch_srch')) {
            $patients = $patients->whereHasMorph('receivable', [Patient::class], function ($q) use ($request) {
                $q->where('first_branch_id', $request->input('branch_srch'));
            });
        }

        if ($request->input('country_srch')) {
            $patients = $patients->whereHasMorph('receivable', [Patient::class], function ($q) use ($request) {
                $q->where('country_id', $request->input('country_srch'));
            });
        }

        if ($request->input('city_srch')) {
            $patients = $patients->whereHasMorph('receivable', [Patient::class], function ($q) use ($request) {
                $q->where('city_id', $request->input('city_srch'));
            });
        }

        if ($request->input('gendar_srch')) {
            $patients = $patients->whereHasMorph('receivable', [Patient::class], function ($q) use ($request) {
                $q->where('gendar', $request->input('gendar_srch'));
            });
        }

        $patients = $patients->paginate(10);

        //for sending SMS message to the specific group
        if ($request->input('sms_content')) {

            $this->validate($request, [
                'sms_content' => ['sometimes', 'required', 'max:70'],
            ]);

            $sms_content = $request->input('sms_content');

            $patients_sms = Invoice::select('total_paid', 'receivable_id', 'receivable_type', DB::raw('sum(total_paid) as sums'),)
                ->where('type', 0)
                ->where('status', 2)
                ->where('receivable_id', '!=', 0)
                ->with(['receivable' => function ($q) {
                    $q->select('id', 'avatar',  DB::raw('CONCAT(first_Name, " ", second_Name) AS name'), 'phone_number');
                }])
                ->groupBy('receivable_id')
                ->orderBy('sums', 'DESC');

            if ($request->input('reco_srch')) {
                $patients_sms = $patients_sms->whereHasMorph('receivable', [Patient::class], function ($q) use ($request) {
                    $q->where('recommendation', $request->input('reco_srch'));
                });
            }

            if ($request->input('branch_srch')) {
                $patients_sms = $patients_sms->whereHasMorph('receivable', [Patient::class], function ($q) use ($request) {
                    $q->where('first_branch_id', $request->input('branch_srch'));
                });
            }

            if ($request->input('country_srch')) {
                $patients_sms = $patients_sms->whereHasMorph('receivable', [Patient::class], function ($q) use ($request) {
                    $q->where('country_id', $request->input('country_srch'));
                });
            }

            if ($request->input('city_srch')) {
                $patients_sms = $patients_sms->whereHasMorph('receivable', [Patient::class], function ($q) use ($request) {
                    $q->where('city_id', $request->input('city_srch'));
                });
            }

            if ($request->input('gendar_srch')) {
                $patients_sms = $patients_sms->whereHasMorph('receivable', [Patient::class], function ($q) use ($request) {
                    $q->where('gendar', $request->input('gendar_srch'));
                });
            }

            $patients_sms = $patients_sms->get();

            return $patients_sms;
            foreach ($patients_sms as $item) {
                //app(Victorylink::class)->sendSms($item->receivable->phone_number, $sms_content, 'ar');
            }
        }

        $specialty = Specialty_cat::all();

        $branch = Branch::all();

        $country = Patient::select('country_id', DB::raw('count(country_id) as total'))
            ->with(['country' => function ($q) {
                $q->select('id', 'name');
            }])
            ->groupBy('country_id')
            ->orderBy('total', 'DESC')
            ->limit(7)
            ->get();

        $city = Patient::select('city_id', DB::raw('count(city_id) as total'))
            ->with(['country' => function ($q) {
                $q->select('id', 'name');
            }])
            ->groupBy('city_id')
            ->orderBy('total', 'DESC')
            ->limit(7)
            ->get();

        return view('patient.vip_patients', compact('patients', 'specialty', 'branch', 'country', 'city'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {

        $branches = Branch::all();

        $countries = Country::orderBy('fav', 'DESC')->get();
        $from_recourses = From_recourse::all();
        $ask_for_main = Ask_for_main_cat::all();

        return view('patient.create', compact('branches', 'countries', 'from_recourses', 'ask_for_main'));
    }

    //for select input ajax to send the cities beasd on the given country
    public function createcityajax($id)
    {
        return City::where('country_id', $id)->orderBy('fav', 'DESC')->get();
    }


    //for select input ajax to send the cities beasd on the given country
    public function create_askfor_ajax($id)
    {
        return Ask_for_cat::where('ask_for_main_cat_id', $id)->get();
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(PatientRequest $request)
    {
        //insert img
        if ($request->hasFile('avatar')) {
            $file_extension = request()->avatar->getClientOriginalExtension();
            $file_name = $request->input('first_name') . time() . '.' . $file_extension;
            $path = 'img/useravatar';
            $request->avatar->move($path, $file_name);
        } else {
            $file_name = 'default-pp.png';
        };


        $branch_id = $request->input('first_branch_id');

        //create the new serial code 000001
        $new_serial_number = serial_number('patient');
        $new_serial_number_branch = serial_number('patient', $branch_id);

        // patient code
        $code_branch = Branch::select('id', 'code')->find($branch_id);

        $user = Patient::create([
            'new_id' => $new_serial_number,
            'new_branch_id' => $new_serial_number_branch,
            'code' => $code_branch->code . "-" . $this->generateRandomString(6),
            'type' => $request->input('status'),
            'ask_for_main_id' => $request->input('ask_for_main_id'),
            'ask_for_id' => $request->input('ask_for_id'),
            'email' => $request->input('email'),
            'password' => bcrypt($request->input('password')),
            'first_branch_id' => $branch_id,
            'first_name' => $request->input('first_name'),
            'second_name' => $request->input('second_name'),
            'mother_name' => $request->input('mother_name'),
            'avatar' => $file_name,
            'birthday' => $request->input('birthday'),
            'gendar' => $request->input('gendar'),
            'country_id' => $request->input('country_id'),
            'city_id' => $request->input('city_id'),
            'phone_number' => $request->input('phone_number'),
            'sec_phone_number' => $request->input('sec_phone_number'),
            'insurance' => $request->input('insurance'),
            'from_recourse_id' => $request->input('from_recourse_id'),
            'height' => $request->input('height'),
            'weight' => $request->input('weight'),
            'blood_type' => $request->input('blood_type'),
            'note' => $request->input('note'),
            'creator_id' => Auth::id(),
        ]);

        session()->flash('success', 'The patient has been created successfully');
        return redirect()->route('sett.patient.show', $user->id);
    }



    public function create_patient_call_center()
    {
        $branches = Branch::all();

        $countries = Country::orderBy('fav', 'DESC')->get();
        $from_recourses = From_recourse::all();
        $ask_for_main = Ask_for_main_cat::all();

        return view('patient.call_center.create', compact('branches', 'countries', 'from_recourses', 'ask_for_main'));
    }

    public function store_patient_call_center(Request $request)
    {
        $this->validate($request, [
            'first_name' => ['required', 'max:30'],
            'second_name' => ['required', 'max:60'],
            'gendar' => ['required'],
            'country_id' => ['required', 'exists:countries,id'],
            'city_id' => ['required', 'exists:cities,id'],
            'first_branch_id' => ['required', 'exists:branches,id'],
            'phone_number' => ['required', 'unique:patients,phone_number', 'max:30'],
            'sec_phone_number' => ['nullable', 'max:30'],
            'from_recourse_id' => ['sometimes', 'required', 'exists:from_recourses,id'],
            'status' => ['required', 'numeric'],
            'ask_for_main_id' => ['required', 'exists:ask_for_main_cats,id'],
            'ask_for_id' => ['required', 'exists:ask_for_cats,id'],
        ]);

        //insert img
        if ($request->hasFile('avatar')) {
            $file_extension = request()->avatar->getClientOriginalExtension();
            $file_name = $request->input('first_name') . time() . '.' . $file_extension;
            $path = 'img/useravatar';
            $request->avatar->move($path, $file_name);
        } else {
            $file_name = 'default-pp.png';
        };


        $branch_id = $request->input('first_branch_id');

        //create the new serial code 000001
        $new_serial_number = serial_number('patient');
        $new_serial_number_branch = serial_number('patient', $branch_id);

        // patient code
        $code_branch = Branch::select('id', 'code')->find($branch_id);

        $user = Patient::create([
            'new_id' => $new_serial_number,
            'new_branch_id' => $new_serial_number_branch,
            'code' => $code_branch->code . "-" . $this->generateRandomString(6),
            'type' => $request->input('status'),
            'ask_for_main_id' => $request->input('ask_for_main_id'),
            'ask_for_id' => $request->input('ask_for_id'),
            'password' => bcrypt("prox" . $request->input('first_name')),
            'first_branch_id' => $branch_id,
            'first_name' => $request->input('first_name'),
            'second_name' => $request->input('second_name'),
            'avatar' => $file_name,
            'birthday' => Carbon::now(),
            'gendar' => $request->input('gendar'),
            'country_id' => $request->input('country_id'),
            'city_id' => $request->input('city_id'),
            'phone_number' => $request->input('phone_number'),
            'sec_phone_number' => $request->input('sec_phone_number'),
            'from_recourse_id' => $request->input('from_recourse_id'),
            'note' => $request->input('note'),
            'creator_id' => Auth::id(),
        ]);

        if (in_array($request->input('status'), [3, 4])) {
            $note = Lead_pat_note::create([
                'worker_id' => Auth::id(),
                'patient_id' => $user->id,
                'note' => $request->input('call_note'),
                'status' => $request->input('status'),
                'date' => Carbon::now(),
            ]);
        }

        session()->flash('success', 'The Call has been created successfully');
        return redirect()->route('sett.patient.show', $user->id);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    //select the searched patients via ajax
    public function patient_search($search_query)
    {
        $search_query = request()->search_query;

        $patient = Patient::select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'))
            ->where(function ($query) use ($search_query) {
                $query->orWhereRaw("concat(first_name, ' ', second_name) like '%$search_query%' ")
                    ->orWhere('first_name', 'like', "%{$search_query}%")
                    ->orWhere('second_name', 'like', "%{$search_query}%")
                    ->orWhere('mother_name', 'like', "%{$search_query}%")
                    ->orWhere('new_id', 'like', "%{$search_query}%")
                    ->orWhere('code', 'like', "%{$search_query}%")
                    ->orWhere('phone_number', 'like', "%{$search_query}%");
            })
            ->limit(10);

        if (Auth::user()->branch_id !== 0) {
            $patient = $patient->where('first_branch_id', Auth::user()->branch_id);
        }

        $patient = $patient->get();

        return $patient;
    }

    public function show($id)
    {
        //for getting the last draw examination
        $appo_last_ex = Disease_draw::select('id', 'calendable_id')
            ->whereHas('appointment')
            ->where('calendable_type', 'App\Models\Branch\Appointment')
            ->where('patient_id', $id)
            ->orderBy('id', 'DESC')
            ->first();

        if ($appo_last_ex) {
            $appo_last_ex_id = $appo_last_ex->calendable_id;
        } else {
            $appo_last_ex_id = '';
        }

        $patient = Patient::with(['country' => function ($q) {
            $q->select('id', 'name');
        }])
            ->with(['city' => function ($q) {
                $q->select('id', 'name');
            }])
            ->with(['recourse' => function ($q) {
                $q->select('id', 'name');
            }])
            //----- appointments -----
            ->with(['appointments' => function ($q) {
                $q->select('id', 'branch_id', 'patient_id', 'doctor_id', 'services_cat_id', 'start_at', 'end_at', 'note_doctor', 'status', 'creator_id', 'last_update_person_id', 'created_at', 'updated_at')
                    ->with(['branch' => function ($q) {
                        $q->select('id', 'name');
                    }])
                    ->with(['doctor' => function ($q) {
                        $q->select('id', 'first_name');
                    }])
                    ->with(['service_item' => function ($q) {
                        $q->select('id', 'name');
                    }])
                    ->with(['invoice_item' => function ($q) {
                        $q->select('id', 'invoice_id', 'itemable_id', 'itemable_type')
                            ->with(['invoice' => function ($q) {
                                $q->select('id', 'code', 'status');
                            }]);
                    }])
                    ->with(['creator' => function ($q) {
                        $q->select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
                    }])
                    ->with(['last_update_person' => function ($q) {
                        $q->select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
                    }])
                    ->orderBy('id', 'DESC');
            }])
            //----- invoices -----
            ->with(['invoices' => function ($q) {
                $q->select('id', 'type', 'service_inv_cat_id', 'code', 'operation', 'receivable_id', 'branch_id', 'discount', 'final_price', 'status', 'note', 'paid_date')
                    ->with(['invoice_items' => function ($q) {
                        $q->select('id', 'categorizable_id')
                            ->with(['categorizable' => function ($q) {
                                $q->select('id', 'name');
                            }]);
                    }])
                    ->with(['service_inv_cat' => function ($q) {
                        $q->select('id', 'name');
                    }])
                    ->with(['branch' => function ($q) {
                        $q->select('id', 'name');
                    }])
                    ->with(['worker' => function ($q) {
                        $q->select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
                    }])
                    ->orderBy('id', 'DESC');
            }])
            //----- wallet -----
            ->with(['wallet_reco' => function ($q) {
                $q->select('id', 'type', 'branch_id', 'patient_id', 'service_item_id', 'balance_before_tran', 'amount', 'date', 'note')
                    ->with(['service' => function ($q) {
                        $q->select('id', 'name');
                    }])
                    ->with(['branch' => function ($q) {
                        $q->select('id', 'name');
                    }]);
            }])
            //----- diseases -----
            ->with(['diseases' => function ($q) use ($appo_last_ex_id) {
                $q->select('id', 'disease_cats', 'calendable_type', 'calendable_id', 'patient_id', 'start', 'end', 'status')
                    ->with(['diseasecats' => function ($q) {
                        $q->select('id', 'name');
                    }])
                    ->with(['appointment' => function ($q) {
                        $q->select('id', 'start_at');
                    }])
                    ->orderBy('status', 'ASC');
            }])
            ->with(['disease_draws' => function ($q) use ($appo_last_ex_id) {
                $q->select('id', 'type', 'calendable_type', 'calendable_id', 'patient_id', 'front', 'back',  'note')
                    ->with(['appointment' => function ($q) {
                        $q->select('id', 'start_at', 'doctor_id')
                            ->with(['doctor' => function ($q) {
                                $q->select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
                            }]);
                    }])
                    ->orderBy('id', 'DESC')
                    ->first();;
            }])
            //----- examinations -----
            ->with('examinations')
            //----- examinations -----
            ->with('eyeglasses')
            //----- investigations -----
            ->with('all_investigation')
            //----- medicines -----
            ->with('prescriptions')
            //----- treatments -----
            ->with(['treatments' => function ($q) {
                $q->select('id', 'patient_id', 'treatment_cat_id', 'sessions', 'sessions_done', 'start', 'end', 'status')
                    ->with(['treatment_cat' => function ($q) {
                        $q->select('id', 'name');
                    }])
                    ->orderBy('status', 'ASC');
            }])
            //----- sessions -----
            ->with(['sessions' => function ($q) {
                $q->select('id', 'patient_id', 'services_cat_id', 'doctor_id', 'treatment_id', 'status', 'date', 'created_at')
                    ->with(['dent_main_cat' => function ($q) {
                        $q->select('id', 'name');
                    }])
                    ->with(['service_item' => function ($q) {
                        $q->select('id', 'name');
                    }])
                    ->with(['treatment' => function ($q) {
                        $q->select('id', 'sessions');
                    }])
                    ->with(['doctor' => function ($q) {
                        $q->select('id', 'first_name');
                    }])
                    ->with(['invoice_item' => function ($q) {
                        $q->select('id', 'invoice_id', 'itemable_id', 'itemable_type', 'sold_price')
                            ->with(['invoice' => function ($q) {
                                $q->select('id', 'code', 'status');
                            }]);
                    }])
                    ->orderBy('status', 'ASC');
            }])
            //----- pulses -----
            ->with(['pulses' => function ($q) {
                $q->select('id', 'patient_id', 'services_cat_id', 'pulses_machine_id', 'appointment_id', 'doctor_id', 'branch_id', 'type', 'fluence', 'pulse_area_id', 'spot_size', 'balance_before_session', 'used_pulses', 'package_id', 'date')
                    ->with(['service_item' => function ($q) {
                        $q->select('id', 'name');
                    }])
                    ->with(['pulse_area' => function ($q) {
                        $q->select('id', 'name');
                    }])
                    ->with(['invoice_item' => function ($q) {
                        $q->select('id', 'invoice_id', 'itemable_id', 'itemable_type')
                            ->with(['invoice' => function ($q) {
                                $q->select('id', 'code', 'status');
                            }]);
                    }])
                    ->with(['doctor' => function ($q) {
                        $q->select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
                    }])
                    ->with(['machine' => function ($q) {
                        $q->select('id', 'name');
                    }])
                    ->with(['package' => function ($q) {
                        $q->with(['service_item' => function ($q) {
                            $q->select('id', 'name');
                        }]);
                    }])
                    ->orderBy('date', 'ASC');
            }])
            //----- package -----
            ->with(['package' => function ($q) {
                $q->with(['service_item' => function ($q) {
                    $q->select('id', 'name');
                }])
                    ->with(['invoice_item' => function ($q) {
                        $q->select('id', 'invoice_id', 'itemable_id', 'itemable_type')
                            ->with(['invoice' => function ($q) {
                                $q->select('id', 'code', 'status');
                            }]);
                    }])
                    ->orderBy('date', 'ASC');
            }])

            //----- lab -----
            ->with(['labs' => function ($q) {
                $q->select('id', 'code', 'patient_id', 'services_cat_id', 'resp_doctor_id', 'xray_file', 'status', 'note_lab', 'created_at')
                    ->with(['service_item' => function ($q) {
                        $q->select('id', 'name');
                    }])
                    ->with(['invoice_item' => function ($q) {
                        $q->select('id', 'invoice_id', 'itemable_id', 'itemable_type')
                            ->with(['invoice' => function ($q) {
                                $q->select('id', 'code', 'status');
                            }]);
                    }])
                    ->orderBy('id', 'DESC');
            }])
            //----- operation -----   
            ->with(['operations' => function ($q) {
                $q->select('id', 'oper_place_id', 'branch_id', 'patient_id', 'doctor_id', 'services_cat_id', 'start_at', 'note', 'status', 'improvement_rate', 'note_after_op')
                    ->with(['place' => function ($q) {
                        $q->select('id', 'name');
                    }])
                    ->with(['doctor' => function ($q) {
                        $q->select('id', 'first_name');
                    }])
                    ->with(['service_item' => function ($q) {
                        $q->select('id', 'name');
                    }])
                    ->with(['pre_op_draw' => function ($q) {
                        $q->select('id', 'type', 'calendable_type', 'calendable_id', 'patient_id', 'front', 'back',  'note');
                    }])
                    ->with(['during_op' => function ($q) {;
                    }])
                    ->with(['diseases' => function ($q) {
                        $q->select('id', 'disease_cats', 'calendable_type', 'calendable_id', 'patient_id', 'start', 'end',  'status', 'created_at')
                            ->with(['diseasecats' => function ($q) {
                                $q->select('id', 'name');
                            }]);
                    }])
                    ->with(['gallery' => function ($q) {
                        $q->select('id', 'op_id', 'type', 'img');
                    }])
                    ->with(['invoice_item' => function ($q) {
                        $q->select('id', 'invoice_id', 'itemable_id', 'itemable_type')
                            ->with(['invoice' => function ($q) {
                                $q->select('id', 'code', 'status');
                            }]);
                    }])
                    ->orderBy('id', 'DESC');
            }])

            // ---- Attachemnts ----
            ->with(['attachments' => function ($q) {
                $q->select('id', 'name', 'patient_id', 'img', 'date');
            }])
            ->find($id);

        $disease_cat = Disease_cat::all();
        $medicine_cat = Medicine_cat::all();
        $med_does = Med_dose::all();
        $med_durations = Med_duration::all();

        $treatment_cat = Treatment_cat::all();

        $service_cat_ses = Service_item::where('service_inv_cat_id', 2)
            ->where('deactivate', 0);

        if (Auth::user()->branch_id !== 0) {
            $service_cat_ses = $service_cat_ses->whereIn('branch_id', [Auth::user()->branch_id, '0']);
        }

        $service_cat_ses = $service_cat_ses->get();

        $service_cat_pulses = Service_item::where('service_inv_cat_id', 3)
            ->where('deactivate', 0);

        if (Auth::user()->branch_id !== 0) {
            $service_cat_pulses = $service_cat_pulses->whereIn('branch_id', [Auth::user()->branch_id, '0']);
        }

        $service_cat_pulses = $service_cat_pulses->get();

        $service_cat_lab = Service_item::where('service_inv_cat_id', 4)
            ->where('deactivate', 0);

        if (Auth::user()->branch_id !== 0) {
            $service_cat_lab = $service_cat_lab->whereIn('branch_id', [Auth::user()->branch_id, '0']);
        }

        $service_cat_lab =  $service_cat_lab->get();

        $service_cat_oper = Service_item::where('service_inv_cat_id', 5)
            ->where('deactivate', 0);

        if (Auth::user()->branch_id !== 0) {
            $service_cat_oper = $service_cat_oper->whereIn('branch_id', [Auth::user()->branch_id, '0']);
        }

        $service_cat_oper =  $service_cat_oper->get();

        $operation_place = Oper_placecat::select('id', 'name')->get();
        $pulses_area = Pulse_area_cat::all();

        $branches = Branch::all();

        $doctors = User::select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'))
            ->whereHas(
                'roles',
                function ($q) {
                    $q->where('name', 'doctor');
                }
            )
            ->get();

        return view('patient.show_samir_ghoraba', compact('patient', 'disease_cat', 'medicine_cat', 'med_does', 'med_durations', 'treatment_cat', 'service_cat_ses', 'service_cat_pulses', 'service_cat_lab', 'service_cat_oper', 'pulses_area', 'operation_place', 'branches', 'doctors'));
    }


    public function show_dental($id)
    {
        //for getting the last draw examination
        $appo_last_ex = Disease_draw::select('id', 'calendable_id')
            ->whereHas('appointment')
            ->where('calendable_type', 'App\Models\Branch\Appointment')
            ->where('patient_id', $id)
            ->orderBy('id', 'DESC')
            ->first();

        if ($appo_last_ex) {
            $appo_last_ex_id = $appo_last_ex->calendable_id;
        } else {
            $appo_last_ex_id = '';
        }

        $patient = Patient::with(['country' => function ($q) {
            $q->select('id', 'name');
        }])
            ->with(['city' => function ($q) {
                $q->select('id', 'name');
            }])
            ->with(['recourse' => function ($q) {
                $q->select('id', 'name');
            }])
            //----- appointments -----
            ->with(['appointments' => function ($q) {
                $q->select('id', 'branch_id', 'patient_id', 'doctor_id', 'services_cat_id', 'start_at', 'end_at', 'note_doctor', 'status')
                    ->with(['branch' => function ($q) {
                        $q->select('id', 'name');
                    }])
                    ->with(['doctor' => function ($q) {
                        $q->select('id', 'first_name');
                    }])
                    ->with(['service_item' => function ($q) {
                        $q->select('id', 'name');
                    }])
                    ->with(['invoice_item' => function ($q) {
                        $q->select('id', 'invoice_id', 'itemable_id', 'itemable_type')
                            ->with(['invoice' => function ($q) {
                                $q->select('id', 'code', 'status');
                            }]);
                    }])
                    ->orderBy('id', 'DESC');
            }])
            //----- invoices -----
            ->with(['invoices' => function ($q) {
                $q->select('id', 'type', 'service_inv_cat_id', 'code', 'operation', 'receivable_id', 'branch_id', 'discount', 'final_price', 'status', 'note', 'paid_date')
                    ->with(['invoice_items' => function ($q) {
                        $q->select('id', 'categorizable_id')
                            ->with(['categorizable' => function ($q) {
                                $q->select('id', 'name');
                            }]);
                    }])
                    ->with(['service_inv_cat' => function ($q) {
                        $q->select('id', 'name');
                    }])
                    ->with(['branch' => function ($q) {
                        $q->select('id', 'name');
                    }])
                    ->with(['worker' => function ($q) {
                        $q->select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
                    }])
                    ->orderBy('id', 'DESC');
            }])
            //----- wallet -----
            ->with(['wallet_reco' => function ($q) {
                $q->select('id', 'type', 'branch_id', 'patient_id', 'service_item_id', 'balance_before_tran', 'amount', 'date', 'note')
                    ->with(['service' => function ($q) {
                        $q->select('id', 'name');
                    }])
                    ->with(['branch' => function ($q) {
                        $q->select('id', 'name');
                    }]);
            }])
            //----- diseases -----
            ->with(['diseases' => function ($q) use ($appo_last_ex_id) {
                $q->select('id', 'disease_cats', 'calendable_type', 'calendable_id', 'patient_id', 'start', 'end', 'status')
                    ->where('calendable_id', $appo_last_ex_id)
                    ->where('calendable_type', 'App\Models\Branch\Appointment')
                    ->with(['diseasecats' => function ($q) {
                        $q->select('id', 'name');
                    }])
                    ->with(['appointment' => function ($q) {
                        $q->select('id', 'start_at');
                    }])
                    ->orderBy('status', 'ASC');
            }])
            ->with(['disease_draws' => function ($q) use ($appo_last_ex_id) {
                $q->select('id', 'type', 'calendable_type', 'calendable_id', 'patient_id', 'front', 'back',  'note')
                    ->where('calendable_id', $appo_last_ex_id)
                    ->where('calendable_type', 'App\Models\Branch\Appointment')
                    ->with(['appointment' => function ($q) {
                        $q->select('id', 'start_at', 'doctor_id')
                            ->with(['doctor' => function ($q) {
                                $q->select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
                            }]);
                    }])
                    ->orderBy('id', 'DESC')
                    ->first();;
            }])
            //----- medicines -----
            ->with(['medicines' => function ($q) {
                $q->select('id', 'medicines_cats', 'patient_id', 'start', 'end', 'status')
                    ->with(['medicinescats' => function ($q) {
                        $q->select('id', 'name');
                    }])
                    ->orderBy('status', 'ASC');
            }])
            //----- treatments -----
            ->with(['treatments' => function ($q) {
                $q->select('id', 'patient_id', 'treatment_cat_id', 'sessions', 'sessions_done', 'start', 'end', 'status')
                    ->with(['treatment_cat' => function ($q) {
                        $q->select('id', 'name');
                    }])
                    ->orderBy('status', 'ASC');
            }])
            //----- sessions -----
            ->with(['sessions' => function ($q) {
                $q->select('id', 'dent_main_cat_id', 'patient_id', 'services_cat_id', 'doctor_id', 'treatment_id', 'tooth', 'surface', 'status', 'date', 'created_at')
                    ->with(['dent_main_cat' => function ($q) {
                        $q->select('id', 'name');
                    }])
                    ->with(['service_item' => function ($q) {
                        $q->select('id', 'name');
                    }])
                    ->with(['treatment' => function ($q) {
                        $q->select('id', 'sessions');
                    }])
                    ->with(['doctor' => function ($q) {
                        $q->select('id', 'first_name');
                    }])
                    ->with(['invoice_item' => function ($q) {
                        $q->select('id', 'invoice_id', 'itemable_id', 'itemable_type', 'sold_price')
                            ->with(['invoice' => function ($q) {
                                $q->select('id', 'code', 'status');
                            }]);
                    }])
                    ->orderBy('status', 'ASC');
            }])
            //----- basic dental chart -----
            ->with(['dental_basic_chart' => function ($q) {
                $q->select('id', 'patient_id', 'doctor_id', 'dent_main_cat_id', 'services_cat_id', 'tooth', 'surface', 'note', 'created_at')
                    ->with(['dent_main_cat' => function ($q) {
                        $q->select('id', 'name');
                    }])
                    ->with(['service_item' => function ($q) {
                        $q->select('id', 'name');
                    }])
                    ->with(['doctor' => function ($q) {
                        $q->select('id', 'first_name');
                    }])
                    ->orderBy('created_at', 'ASC');
            }])
            //----- pulses -----
            ->with(['pulses' => function ($q) {
                $q->select('id', 'patient_id', 'services_cat_id', 'pulses_machine_id', 'appointment_id', 'doctor_id', 'branch_id', 'type', 'fluence', 'pulse_area_id', 'spot_size', 'balance_before_session', 'used_pulses', 'package_id', 'date')
                    ->with(['service_item' => function ($q) {
                        $q->select('id', 'name');
                    }])
                    ->with(['pulse_area' => function ($q) {
                        $q->select('id', 'name');
                    }])
                    ->with(['invoice_item' => function ($q) {
                        $q->select('id', 'invoice_id', 'itemable_id', 'itemable_type')
                            ->with(['invoice' => function ($q) {
                                $q->select('id', 'code', 'status');
                            }]);
                    }])
                    ->with(['doctor' => function ($q) {
                        $q->select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
                    }])
                    ->with(['machine' => function ($q) {
                        $q->select('id', 'name');
                    }])
                    ->with(['package' => function ($q) {
                        $q->with(['service_item' => function ($q) {
                            $q->select('id', 'name');
                        }]);
                    }])
                    ->orderBy('date', 'ASC');
            }])
            //----- package -----
            ->with(['package' => function ($q) {
                $q->with(['service_item' => function ($q) {
                    $q->select('id', 'name');
                }])
                    ->with(['invoice_item' => function ($q) {
                        $q->select('id', 'invoice_id', 'itemable_id', 'itemable_type')
                            ->with(['invoice' => function ($q) {
                                $q->select('id', 'code', 'status');
                            }]);
                    }])
                    ->orderBy('date', 'ASC');
            }])

            //----- lab -----
            ->with(['labs' => function ($q) {
                $q->select('id', 'code', 'patient_id', 'services_cat_id', 'resp_doctor_id', 'xray_file', 'status', 'note_lab', 'created_at')
                    ->with(['service_item' => function ($q) {
                        $q->select('id', 'name');
                    }])
                    ->with(['invoice_item' => function ($q) {
                        $q->select('id', 'invoice_id', 'itemable_id', 'itemable_type')
                            ->with(['invoice' => function ($q) {
                                $q->select('id', 'code', 'status');
                            }]);
                    }])
                    ->orderBy('id', 'DESC');
            }])
            //----- operation -----   
            ->with(['operations' => function ($q) {
                $q->select('id', 'oper_place_id', 'branch_id', 'patient_id', 'doctor_id', 'services_cat_id', 'start_at', 'note', 'status', 'improvement_rate', 'note_after_op')
                    ->with(['place' => function ($q) {
                        $q->select('id', 'name');
                    }])
                    ->with(['doctor' => function ($q) {
                        $q->select('id', 'first_name');
                    }])
                    ->with(['service_item' => function ($q) {
                        $q->select('id', 'name');
                    }])
                    ->with(['pre_op_draw' => function ($q) {
                        $q->select('id', 'type', 'calendable_type', 'calendable_id', 'patient_id', 'front', 'back',  'note');
                    }])
                    ->with(['during_op' => function ($q) {;
                    }])
                    ->with(['diseases' => function ($q) {
                        $q->select('id', 'disease_cats', 'calendable_type', 'calendable_id', 'patient_id', 'start', 'end',  'status', 'created_at')
                            ->with(['diseasecats' => function ($q) {
                                $q->select('id', 'name');
                            }]);
                    }])
                    ->with(['gallery' => function ($q) {
                        $q->select('id', 'op_id', 'type', 'img');
                    }])
                    ->with(['invoice_item' => function ($q) {
                        $q->select('id', 'invoice_id', 'itemable_id', 'itemable_type')
                            ->with(['invoice' => function ($q) {
                                $q->select('id', 'code', 'status');
                            }]);
                    }])
                    ->orderBy('id', 'DESC');
            }])
            ->find($id);

        $disease_cat = Disease_cat::all();
        $medicine_cat = Medicine_cat::all();
        $treatment_cat = Treatment_cat::all();

        $service_cat_ses = Service_item::where('service_inv_cat_id', 2)
            ->where('deactivate', 0)
            ->where('specialty_id', Auth::user()->specialty_id);

        if (Auth::user()->branch_id !== 0) {
            $service_cat_ses = $service_cat_ses->whereIn('branch_id', [Auth::user()->branch_id, '0']);
        }

        $service_cat_ses = $service_cat_ses->get();

        $service_cat_pulses = Service_item::where('service_inv_cat_id', 3)
            ->where('deactivate', 0)
            ->where('specialty_id', Auth::user()->specialty_id);

        if (Auth::user()->branch_id !== 0) {
            $service_cat_pulses = $service_cat_pulses->whereIn('branch_id', [Auth::user()->branch_id, '0']);
        }

        $service_cat_pulses = $service_cat_pulses->get();


        $service_cat_lab = Service_item::where('service_inv_cat_id', 4)
            ->where('deactivate', 0)
            ->where('specialty_id', Auth::user()->specialty_id);

        if (Auth::user()->branch_id !== 0) {
            $service_cat_lab = $service_cat_lab->whereIn('branch_id', [Auth::user()->branch_id, '0']);
        }

        $service_cat_lab =  $service_cat_lab->get();

        $service_cat_oper = Service_item::where('service_inv_cat_id', 5)
            ->where('deactivate', 0)
            ->where('specialty_id', Auth::user()->specialty_id);

        if (Auth::user()->branch_id !== 0) {
            $service_cat_oper = $service_cat_oper->whereIn('branch_id', [Auth::user()->branch_id, '0']);
        }

        $service_cat_oper =  $service_cat_oper->get();

        $operation_place = Oper_placecat::select('id', 'name')->get();
        $pulses_area = Pulse_area_cat::all();

        $branches = Branch::all();

        $doctors = User::select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'))
            ->whereHas(
                'roles',
                function ($q) {
                    $q->where('name', 'doctor');
                }
            )
            ->get();


        //dental
        $dental_min_cat = Dent_main_cat::all();

        $basic_chart_implantation = Pat_bs_den_chart::select('tooth')
            ->where('patient_id', $id)
            ->where('dent_main_cat_id', 1)
            ->groupby('tooth')
            ->pluck('tooth')
            ->toArray();

        $basic_chart_crown_bridge = Pat_bs_den_chart::select('tooth')
            ->where('patient_id', $id)
            ->where('dent_main_cat_id', 2)
            ->groupby('tooth')
            ->pluck('tooth')
            ->toArray();

        $basic_chart_cosmetic_filler = Pat_bs_den_chart::select('tooth')
            ->where('patient_id', $id)
            ->where('dent_main_cat_id', 3)
            ->groupby('tooth')
            ->pluck('tooth')
            ->toArray();

        $basic_chart_nerve_stuffing = Pat_bs_den_chart::select('tooth')
            ->where('patient_id', $id)
            ->where('dent_main_cat_id', 4)
            ->groupby('tooth')
            ->pluck('tooth')
            ->toArray();

        $basic_chart_caries = Pat_bs_den_chart::select('tooth')
            ->where('patient_id', $id)
            ->where('dent_main_cat_id', 5)
            ->groupby('tooth')
            ->pluck('tooth')
            ->toArray();

        $basic_chart_missing = Pat_bs_den_chart::select('tooth')
            ->where('patient_id', $id)
            ->where('dent_main_cat_id', 6)
            ->groupby('tooth')
            ->pluck('tooth')
            ->toArray();

        //dental action chart

        $basic_chart_implantation_a = Session_pat::select('tooth')
            ->where('patient_id', $id)
            ->where('dent_main_cat_id', 1)
            ->groupby('tooth')
            ->pluck('tooth')
            ->toArray();

        $basic_chart_crown_bridge_a = Session_pat::select('tooth')
            ->where('patient_id', $id)
            ->where('dent_main_cat_id', 2)
            ->groupby('tooth')
            ->pluck('tooth')
            ->toArray();

        $basic_chart_cosmetic_filler_a = Session_pat::select('tooth')
            ->where('patient_id', $id)
            ->where('dent_main_cat_id', 3)
            ->groupby('tooth')
            ->pluck('tooth')
            ->toArray();

        $basic_chart_nerve_stuffing_a = Session_pat::select('tooth')
            ->where('patient_id', $id)
            ->where('dent_main_cat_id', 4)
            ->groupby('tooth')
            ->pluck('tooth')
            ->toArray();

        $basic_chart_caries_a = Session_pat::select('tooth')
            ->where('patient_id', $id)
            ->where('dent_main_cat_id', 5)
            ->groupby('tooth')
            ->pluck('tooth')
            ->toArray();

        $basic_chart_missing_a = Session_pat::select('tooth')
            ->where('patient_id', $id)
            ->where('dent_main_cat_id', 6)
            ->groupby('tooth')
            ->pluck('tooth')
            ->toArray();


        return view('patient.show', compact('patient', 'disease_cat', 'medicine_cat', 'treatment_cat', 'service_cat_ses', 'service_cat_pulses', 'service_cat_lab', 'service_cat_oper', 'pulses_area', 'operation_place', 'branches', 'doctors', 'dental_min_cat', 'basic_chart_implantation', 'basic_chart_crown_bridge', 'basic_chart_cosmetic_filler', 'basic_chart_nerve_stuffing', 'basic_chart_caries', 'basic_chart_missing', 'basic_chart_implantation_a', 'basic_chart_crown_bridge_a', 'basic_chart_cosmetic_filler_a', 'basic_chart_nerve_stuffing_a', 'basic_chart_caries_a', 'basic_chart_missing_a'));
    }

    public function sms_form_profile(Request $request, $id)
    {

        $this->validate($request, [
            'sms_content' => ['required', 'max:70'],
        ]);

        $sms_content = $request->input('sms_content');

        $patient = Patient::select('id', 'first_name', 'phone_number')->find($id);

        // app(Whysms::class)->sendSms($patient->phone_number, $sms_content);
        //app(Victorylink::class)->sendSms($patient->phone_number, $sms_content, 'ar');

        session()->flash('success', 'The SMS has been Sent');
        return redirect()->back();
    }

    //to fetch all appointmet info in patient profile
    public function get_all_info_pat_appo($id)
    {

        $appointment = Appointment::select('id', 'branch_id', 'patient_id', 'doctor_id', 'services_cat_id', 'start_at', 'end_at', 'note_doctor', 'status')
            ->with(['branch' => function ($q) {
                $q->select('id', 'name');
            }])
            ->with(['doctor' => function ($q) {
                $q->select('id', 'first_name');
            }])
            ->with(['service_item' => function ($q) {
                $q->select('id', 'name');
            }])
            ->with(['invoice_item' => function ($q) {
                $q->select('id', 'invoice_id', 'itemable_id', 'itemable_type')
                    ->with(['invoice' => function ($q) {
                        $q->select('id', 'code', 'status');
                    }]);
            }])
            //----- diseases -----
            ->with(['diseases' => function ($q) {
                $q->select('id', 'disease_cats', 'appointment_id', 'patient_id', 'start', 'end', 'status')
                    ->with(['diseasecats' => function ($q) {
                        $q->select('id', 'name');
                    }])
                    ->orderBy('status', 'ASC');
            }])
            ->with(['disease_draws' => function ($q) {
                $q->select('id', 'type', 'appointment_id', 'patient_id', 'front', 'back',  'note')
                    ->orderBy('id', 'DESC')
                    ->first();;
            }])
            //----- medicines -----
            ->with(['medicines' => function ($q) {
                $q->select('id', 'medicines_cats', 'appointment_id', 'start', 'end', 'status')
                    ->with(['medicinescats' => function ($q) {
                        $q->select('id', 'name');
                    }])
                    ->orderBy('status', 'ASC');
            }])
            //----- treatments -----
            ->with(['treatments' => function ($q) {
                $q->select('id', 'appointment_id', 'treatment_cat_id', 'sessions', 'sessions_done', 'start', 'end', 'status')
                    ->with(['treatment_cat' => function ($q) {
                        $q->select('id', 'name');
                    }])
                    ->orderBy('status', 'ASC');
            }])
            //----- sessions -----
            ->with(['sessions' => function ($q) {
                $q->select('id', 'appointment_id', 'services_cat_id', 'treatment_id', 'status')
                    ->with(['service_item' => function ($q) {
                        $q->select('id', 'name');
                    }])
                    ->with(['treatment' => function ($q) {
                        $q->select('id', 'sessions');
                    }])
                    ->with(['invoice_item' => function ($q) {
                        $q->select('id', 'invoice_id', 'itemable_id', 'itemable_type')
                            ->with(['invoice' => function ($q) {
                                $q->select('id', 'code', 'status');
                            }]);
                    }])
                    ->orderBy('status', 'ASC');
            }])
            ->orderBy('id', 'DESC')
            ->find($id);

        return $appointment;
    }

    public function allstatcs(Request $request)
    {


        if (!empty($request->input('branch'))) {
            $branch = $request->input('branch');
        } else {
            $branch = 'all';
        }
        if (!empty($request->input('from'))) {
            $from = $request->input('from');
        } else {
            $from = 'all';
        }
        if (!empty($request->input('to'))) {
            $to = $request->input('to');
        } else {
            $to = 'all';
        }

        if (!empty($request->input('type'))) {
            $type = $request->input('type');
        } else {
            $type = 'all';
        }

        $specialty_cat = Specialty_cat::all();
        $branches = Branch::all();

        //-----
        $each_branches = Patient::select('first_branch_id', DB::raw('count(*) as total'))
            ->groupBy('first_branch_id')
            ->with(['branch' => function ($q) {
                $q->select('id', 'name');
            }])
            ->limit(11)
            ->orderBy('total', 'DESC');

        if ($from !== "all") {
            $each_branches = $each_branches->whereBetween('created_at', [
                Carbon::createFromFormat('m-Y', $from)->startOfMonth(), //2022-10-01 00:00:00.0
                Carbon::createFromFormat('m-Y', $to)->endOfMonth() // 2022-10-31 23:59:59.999999
            ]);
        }

        if ($type !== "all") {
            $each_branches = $each_branches->where('type', $type);
        }

        $each_branches = $each_branches->get();

        // ---------------------- 
        //patients for each branches during year
        $branches_name = Branch::whereHas('patient')->get();
        $patient_branches = new Collection();

        foreach ($branches_name as $item) {
            $query = patient::select(
                'first_branch_id',
                DB::raw('count(first_branch_id) as counts'),
                DB::raw("DATE_FORMAT(created_at,'%m') as monthKey")
            )
                ->with(['branch' => function ($q) {
                    $q->select('id', 'name');
                }])
                ->where('first_branch_id', $item->id)
                ->orderBy('created_at', 'ASC');

            if ($from !== "all") {
                $query = $query->whereBetween('created_at', [
                    Carbon::createFromFormat('m-Y', $from)->startOfMonth(), //2022-10-01 00:00:00.0
                    Carbon::createFromFormat('m-Y', $to)->endOfMonth() // 2022-10-31 23:59:59.999999
                ])->groupBy('monthKey');
            } else {
                $query = $query->whereYear('created_at', date('Y'))
                    ->groupBy('monthKey');
            }

            if ($type !== "all") {
                $query = $query->where('type', $type);
            }

            $query = $query->get();

            $appointment_date_branches = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0];

            foreach ($query as $order) {
                $appointment_date_branches[$order->monthKey - 1] = $order->counts;
            }

            if (count($query) > 0) {
                //$branch_name = $query[0]->branch->name;
                $patient_branches->push((object)[
                    'name' => $query[0]->branch->name,
                    'total' => $appointment_date_branches
                ]);
            }
        }

        //-----
        $gendar = Patient::select('gendar', DB::raw('count(*) as total'))
            ->groupBy('gendar')
            ->limit(11);

        if ($branch !== "all") {
            $gendar = $gendar->where('first_branch_id', $branch);
        }

        if ($from !== "all") {
            $gendar = $gendar->whereBetween('created_at', [
                Carbon::createFromFormat('m-Y', $from)->startOfMonth(), //2022-10-01 00:00:00.0
                Carbon::createFromFormat('m-Y', $to)->endOfMonth() // 2022-10-31 23:59:59.999999
            ]);
        }

        if ($type !== "all") {
            $gendar = $gendar->where('type', $type);
        }

        $gendar = $gendar->get();

        //-----
        $resource = Patient::select('from_recourse_id', DB::raw('count(*) as total'))
            ->groupBy('from_recourse_id')
            ->with(['recourse' => function ($q) {
                $q->select('id', 'name');
            }])
            ->limit(11)
            ->orderBy('total', 'DESC');

        if ($branch !== "all") {
            $resource = $resource->where('first_branch_id', $branch);
        }

        if ($from !== "all") {
            $resource = $resource->whereBetween('created_at', [
                Carbon::createFromFormat('m-Y', $from)->startOfMonth(), //2022-10-01 00:00:00.0
                Carbon::createFromFormat('m-Y', $to)->endOfMonth() // 2022-10-31 23:59:59.999999
            ]);
        }

        if ($type !== "all") {
            $resource = $resource->where('type', $type);
        }

        $resource = $resource->get();

        //-----
        $country = Patient::select('country_id', DB::raw('count(*) as total'))
            ->groupBy('country_id')
            ->with(['country' => function ($q) {
                $q->select('id', 'name');
            }])
            ->limit(11)
            ->orderBy('total', 'DESC');

        if ($branch !== "all") {
            $country = $country->where('first_branch_id', $branch);
        }

        if ($branch !== "all") {
            $resource = $resource->where('first_branch_id', $branch);
        }

        if ($from !== "all") {
            $country = $country->whereBetween('created_at', [
                Carbon::createFromFormat('m-Y', $from)->startOfMonth(), //2022-10-01 00:00:00.0
                Carbon::createFromFormat('m-Y', $to)->endOfMonth() // 2022-10-31 23:59:59.999999
            ]);
        }

        if ($type !== "all") {
            $country = $country->where('type', $type);
        }

        $country = $country->get();

        //-----
        $city = Patient::select('city_id', DB::raw('count(*) as total'))
            ->groupBy('city_id')
            ->with(['country' => function ($q) {
                $q->select('id', 'name');
            }])
            ->limit(11)
            ->orderBy('total', 'DESC');

        if ($branch !== "all") {
            $city = $city->where('first_branch_id', $branch);
        }

        if ($from !== "all") {
            $city = $city->whereBetween('created_at', [
                Carbon::createFromFormat('m-Y', $from)->startOfMonth(), //2022-10-01 00:00:00.0
                Carbon::createFromFormat('m-Y', $to)->endOfMonth() // 2022-10-31 23:59:59.999999
            ]);
        }

        if ($type !== "all") {
            $city = $city->where('type', $type);
        }

        $city = $city->get();

        //-----
        $patient = Patient::select(
            DB::raw('count(id) as counts'),
            DB::raw("DATE_FORMAT(created_at,'%m') as monthKey")
        )
            ->orderBy('created_at', 'ASC');

        if ($branch !== "all") {
            $patient = $patient->where('first_branch_id', $branch);
        }

        if ($type !== "all") {
            $patient = $patient->where('type', $type);
        }

        if ($from !== "all") {
            $patient = $patient->whereBetween('created_at', [
                Carbon::createFromFormat('m-Y', $from)->startOfMonth(), //2022-10-01 00:00:00.0
                Carbon::createFromFormat('m-Y', $to)->endOfMonth() // 2022-10-31 23:59:59.999999
            ]);
        } else {
            $patient = $patient->whereYear('created_at', date('Y'))
                ->groupBy('monthKey');
        }

        $patient = $patient->get();

        $patient_date = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0];

        foreach ($patient as $order) {
            $patient_date[$order->monthKey - 1] = $order->counts;
        }

        //-----
        $patient_total = Patient::select('id');

        if ($branch !== "all") {
            $patient_total = $patient_total->where('first_branch_id', $branch);
        }

        if ($from !== "all") {
            $patient_total = $patient_total->whereBetween('created_at', [
                Carbon::createFromFormat('m-Y', $from)->startOfMonth(), //2022-10-01 00:00:00.0
                Carbon::createFromFormat('m-Y', $to)->endOfMonth() // 2022-10-31 23:59:59.999999
            ]);
        }

        if ($type !== "all") {
            $patient_total = $patient_total->where('type', $type);
        }

        $patient_total = $patient_total->count();

        //-----
        $diseases = Disease::select('disease_cats', 'patient_id', 'calendable_id', 'calendable_type',  DB::raw('count(*) as total'))
            ->groupBy('disease_cats')
            ->with(['diseasecats' => function ($q) {
                $q->select('id', 'name');
            }])
            ->limit(11)
            ->orderBy('total', 'DESC');

        if ($branch !== "all") {
            $diseases = $diseases->whereHas('calendable', function ($q) use ($branch) {
                $q->where('branch_id', $branch);
            });
        }

        if ($from !== "all") {
            $diseases = $diseases->whereBetween('created_at', [
                Carbon::createFromFormat('m-Y', $from)->startOfMonth(), //2022-10-01 00:00:00.0
                Carbon::createFromFormat('m-Y', $to)->endOfMonth() // 2022-10-31 23:59:59.999999
            ]);
        }

        if ($type !== "all") {
            $diseases = $diseases->whereHas('patient', function ($q) use ($type) {
                $q->where('type', $type);
            });
        }

        $diseases = $diseases->get();

        //-----
        $treatment = Treatment::select('treatment_cat_id', 'patient_id', 'appointment_id', DB::raw('count(*) as total'))
            ->groupBy('treatment_cat_id')
            ->with(['treatment_cat' => function ($q) {
                $q->select('id', 'name');
            }])
            ->limit(11)
            ->orderBy('total', 'DESC');

        if ($branch !== "all") {
            $treatment = $treatment->whereHas('appointment', function ($q) use ($branch) {
                $q->where('branch_id', $branch);
            });
        }

        if ($from !== "all") {
            $treatment = $treatment->whereBetween('created_at', [
                Carbon::createFromFormat('m-Y', $from)->startOfMonth(), //2022-10-01 00:00:00.0
                Carbon::createFromFormat('m-Y', $to)->endOfMonth() // 2022-10-31 23:59:59.999999
            ]);
        }

        if ($type !== "all") {
            $treatment = $treatment->whereHas('patient', function ($q) use ($type) {
                $q->where('type', $type);
            });
        }

        $treatment = $treatment->get();

        //-----
        $medicine = Medicine::select('medicines_cats', 'patient_id', DB::raw('count(*) as total'))
            ->groupBy('medicines_cats')
            ->with(['medicinescats' => function ($q) {
                $q->select('id', 'name');
            }])
            ->limit(11)
            ->orderBy('total', 'DESC');

        if ($branch !== "all") {
            $medicine = $medicine->whereHas('appointment', function ($q) use ($branch) {
                $q->where('branch_id', $branch);
            });
        }

        if ($from !== "all") {
            $medicine = $medicine->whereBetween('created_at', [
                Carbon::createFromFormat('m-Y', $from)->startOfMonth(), //2022-10-01 00:00:00.0
                Carbon::createFromFormat('m-Y', $to)->endOfMonth() // 2022-10-31 23:59:59.999999
            ]);
        }

        if ($type !== "all") {
            $medicine = $medicine->whereHas('patient', function ($q) use ($type) {
                $q->where('type', $type);
            });
        }

        $medicine = $medicine->get();
        //-----

        return view('patient/allstatcs', compact('branches', 'patient_date', 'patient_total', 'each_branches', 'patient_branches', 'gendar', 'resource', 'country', 'city', 'branch', 'diseases', 'treatment', 'medicine', 'from', 'to'));
    }


    //print
    public function patient_print($id)
    {

        $patient = Patient::with(['country' => function ($q) {
            $q->select('id', 'name');
        }])
            ->with(['city' => function ($q) {
                $q->select('id', 'name');
            }])
            ->with(['recourse' => function ($q) {
                $q->select('id', 'name');
            }])
            ->with('examinations')
            ->find($id);

        $appointments = Appointment::where('patient_id', $id)
            ->with(['branch' => function ($q) {
                $q->select('id', 'name');
            }])
            ->with(['doctor' => function ($q) {
                $q->select('id', 'first_name', 'second_name');
            }])
            ->with(['service_item' => function ($q) {
                $q->select('id', 'name');
            }])
            ->with(['invoice_item' => function ($q) {
                $q->select('id', 'invoice_id', 'itemable_id', 'itemable_type')
                    ->with(['invoice' => function ($q) {
                        $q->select('id', 'code', 'status');
                    }]);
            }])
            ->orderBy('id', 'DESC')
            ->get();

        $invoices = Invoice::select('id', 'code', 'receivable_id', 'discount', 'final_price', 'total_paid', 'status', 'paid_date')
            ->where('receivable_id', $id)->where('receivable_type', 'App\Models\Patient\Patient')
            ->with(['invoice_items' => function ($q) {
                $q->select('id', 'categorizable_id')
                    ->with(['categorizable' => function ($q) {
                        $q->select('id', 'name');
                    }]);
            }])
            ->orderBy('id', 'DESC')
            ->get();

        $medicine = Medicine::select('id', 'medicines_cats', 'start', 'end', 'status')->where('patient_id', $id)
            ->with(['medicinescats' => function ($q) {
                $q->select('id', 'name');
            }])
            ->orderBy('status', 'ASC')
            ->get();

        $disease = Disease::select('id', 'disease_cats', 'calendable_id', 'calendable_type', 'start', 'end', 'status')
            ->where('patient_id', $id)
            ->with(['diseasecats' => function ($q) {
                $q->select('id', 'name');
            }])
            ->with(['calendable' => function ($q) {
                $q->select('id', 'start_at');
            }])
            ->orderBy('status', 'ASC')
            ->get();

        $appo_last_ex = Disease_draw::select('id', 'calendable_id')
            ->where('calendable_type', 'App\Models\Branch\Appointment')
            ->whereHas('appointment')
            ->where('patient_id', $id)
            ->orderBy('id', 'DESC')
            ->first();
        if ($appo_last_ex) {
            $appo_last_ex_id = $appo_last_ex->calendable_id;
        } else {
            $appo_last_ex_id = '';
        }

        $disease_draw = Disease_draw::where('patient_id', $id)
            ->where('calendable_id', $appo_last_ex_id)
            ->where('calendable_type', 'App\Models\Branch\Appointment')
            ->with(['appointment' => function ($q) {
                $q->select('id', 'start_at', 'doctor_id')->with(['doctor' => function ($q) {
                    $q->select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
                }]);
            }])
            ->orderBy('id', 'DESC')
            ->first();

        $treatment = Treatment::select('id', 'treatment_cat_id', 'sessions', 'sessions_done', 'start', 'end', 'status')->where('patient_id', $id)
            ->with(['treatment_cat' => function ($q) {
                $q->select('id', 'name');
            }])
            ->orderBy('status', 'ASC')
            ->get();

        $treatment_cat = Treatment_cat::all();

        $session_pat = Session_pat::select('id', 'services_cat_id', 'treatment_id', 'status')->where('patient_id', $id)
            ->with(['service_item' => function ($q) {
                $q->select('id', 'name');
            }])
            ->with(['treatment' => function ($q) {
                $q->select('id', 'sessions');
            }])
            ->with(['invoice_item' => function ($q) {
                $q->select('id', 'invoice_id', 'itemable_id', 'itemable_type')
                    ->with(['invoice' => function ($q) {
                        $q->select('id', 'code', 'status');
                    }]);
            }])
            ->orderBy('status', 'ASC')
            ->get();

        $lab = Lab::select('id', 'code', 'services_cat_id', 'resp_doctor_id', 'xray_file', 'status', 'note_lab', 'created_at')->where('patient_id', $id)
            ->with(['service_item' => function ($q) {
                $q->select('id', 'name');
            }])
            ->with(['invoice_item' => function ($q) {
                $q->select('id', 'invoice_id', 'itemable_id', 'itemable_type')
                    ->with(['invoice' => function ($q) {
                        $q->select('id', 'code', 'status');
                    }]);
            }])
            ->orderBy('status', 'ASC')
            ->get();

        $logo = public_path('img/dashboard/system/') . prox_sett('logo');

        $qrcode = base64_encode(QrCode::color(36, 137, 127)->size(80)->style('round')->eye('circle')->generate($patient->code));

        // instantiate and use the dompdf class

        $html = view('patient.print', compact('patient', 'appointments', 'invoices', 'medicine', 'disease_draw', 'disease', 'treatment', 'session_pat', 'lab', 'qrcode'))->render();

        $mpdf = new mPDF();

        $mpdf->SetHTMLHeader('<div class="header">
        <div class="row">
        <div class="col-xs-9 m-0 ps-3">
            <img src="' . $logo . '">
        </div>
        <div class="col-xs-2 text-center m-0 ps-3">
            <img src="data:image/svg;base64,' . $qrcode . '">
            <p class="mt-1 mb-0 text-s fw-bold2">' . $patient->code . '</p>
        </div>
        </div>
        </div>
        ', 'O');
        $mpdf->SetHTMLFooter('<div class"text-center"> Page {PAGENO} <span class="text-s">Copyright © 2021 Proxima</span> | {DATE j-m-Y}</div>');

        $mpdf->AddPageByArray([
            'margin-top' => 43,
            'margin-bottom' => 17,
        ]);
        $mpdf->WriteHTML($html);
        $mpdf->output();

        // Output the generated PDF to Browser
        //return $mpdf->stream();

    }


    //print 
    public function patient_print_pre($id)
    {

        //get the last appointment that has Medicines
        $appo_last_med = Medicine::select('id', 'appointment_id')
            ->whereHas('appointment')
            ->with(['appointment' => function ($q) {
                $q->select('id', 'start_at', 'doctor_id')
                    ->with(['doctor' => function ($q) {
                        $q->select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
                    }]);
            }])
            ->whereHas('patient', function ($q) use ($id) {
                $q->where('code', $id);
            })
            ->orderBy('id', 'DESC')
            ->first();

        if ($appo_last_med) {
            $appo_last_med_id = $appo_last_med->appointment->id;
        } else {
            $appo_last_med_id = '';
        }

        $patient = Patient::with(['country' => function ($q) {
            $q->select('id', 'name');
        }])
            ->with(['city' => function ($q) {
                $q->select('id', 'name');
            }])
            ->with(['recourse' => function ($q) {
                $q->select('id', 'name');
            }])
            ->with(['medicines' => function ($q) use ($appo_last_med_id) {
                $q->where('appointment_id', $appo_last_med_id)
                    ->with(['medicinescats' => function ($q) {
                        $q->select('id', 'name');
                    }])
                    ->orderBy('status', 'ASC');
            }])
            ->where('code', $id)
            ->first();

        $qrcode = base64_encode(QrCode::color(36, 137, 127)->size(80)->style('round')->eye('circle')->generate($patient->code));

        $logo = public_path('img/dashboard/system/') . prox_sett('logo');

        // instantiate and use the dompdf class

        $html = view('patient.print_pre', compact('patient', 'appo_last_med', 'qrcode'))->render();

        $mpdf = new mPDF();

        $mpdf->SetHTMLHeader('<div class="header">
        <div class="row">
        <div class="col-xs-9 m-0 ps-3">
            <img src="' . $logo . '">
        </div>
        <div class="col-xs-2 text-center m-0 ps-3">
            <img src="data:image/svg;base64,' . $qrcode . '">
            <p class="mt-1 mb-0 text-s fw-bold2">' . $patient->code . '</p>
        </div>
        </div>
        </div>
        ', 'O');
        $mpdf->SetHTMLFooter('<div class"text-center"> Page {PAGENO} <span class="text-s">Copyright © 2021 Proxima</span> | {DATE j-m-Y}</div>');

        $mpdf->AddPageByArray([
            'margin-top' => 43,
            'margin-bottom' => 17,
        ]);

        $mpdf->WriteHTML($html);
        $mpdf->output();
    }




    //print
    public function ramad_examination_print($id)
    {

        $patient = Patient::with(['country' => function ($q) {
            $q->select('id', 'name');
        }])
            ->with(['city' => function ($q) {
                $q->select('id', 'name');
            }])
            ->with(['recourse' => function ($q) {
                $q->select('id', 'name');
            }])
            ->with('examinations')
            ->with('disease_draws')
            ->find($id);

        $logo = public_path('img/dashboard/system/') . prox_sett('logo');

        $qrcode = base64_encode(QrCode::color(36, 137, 127)->size(80)->style('round')->eye('circle')->generate($patient->code));

        // instantiate and use the dompdf class

        $html = view('patient.print_ramad_examination', compact('patient', 'qrcode'))->render();

        $mpdf = new mPDF();

        $mpdf->SetHTMLHeader('<div class="header">
        <div class="row">
        <div class="col-xs-9 m-0 ps-3">
            <img src="' . $logo . '">
        </div>
        <div class="col-xs-2 text-center m-0 ps-3">
            <img src="data:image/svg;base64,' . $qrcode . '">
            <p class="mt-1 mb-0 text-s fw-bold2">' . $patient->code . '</p>
        </div>
        </div>
        </div>
        ', 'O');
        $mpdf->SetHTMLFooter('<div class"text-center"> Page {PAGENO} <span class="text-s">Copyright © 2021 Proxima</span> | {DATE j-m-Y}</div>');

        $mpdf->AddPageByArray([
            'margin-top' => 43,
            'margin-bottom' => 17,
        ]);
        $mpdf->WriteHTML($html);
        $mpdf->output();

        // Output the generated PDF to Browser
        //return $mpdf->stream();

    }


    //print
    public function eyeglasses_prescription_print($id, $eye_glass_id = null)
    {

        if ($eye_glass_id) {
            $patient = Patient::with(['eyeglasses' => function ($q) use ($eye_glass_id) {
                $q->where('code', $eye_glass_id);
            }])
                ->where('code', $id)
                ->first();
        } else {
            $patient = Patient::with(['eyeglasses' => function ($q) {
                $q->orderBy('id', 'desc')->first();
            }])
                ->where('code', $id)
                ->first();
        }

        $logo = public_path('img/dashboard/system/') . prox_sett('logo');

        $qrcode = base64_encode(QrCode::color(36, 137, 127)->size(80)->style('round')->eye('circle')->generate($patient->code));

        // instantiate and use the dompdf class

        $html = view('patient.print_eyeglasses_prescription', compact('patient', 'qrcode'))->render();

        $mpdf = new mPDF();

        $mpdf->SetHTMLHeader('<div class="header">
        <div class="row">
        <div class="col-xs-9 m-0 ps-3">
            <img src="' . $logo . '">
        </div>
        <div class="col-xs-2 text-center m-0 ps-3">
            <img src="data:image/svg;base64,' . $qrcode . '">
            <p class="mt-1 mb-0 text-s fw-bold2">' . $patient->code . '</p>
        </div>
        </div>
        </div>
        ', 'O');
        $mpdf->SetHTMLFooter('<div class"text-center"> Page {PAGENO} <span class="text-s">Copyright © 2021 Proxima</span> | {DATE j-m-Y}</div>');

        $mpdf->AddPageByArray([
            'margin-top' => 43,
            'margin-bottom' => 17,
        ]);
        $mpdf->WriteHTML($html);
        $mpdf->output();

        // Output the generated PDF to Browser
        //return $mpdf->stream();

    }


    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {

        $patient = Patient::with(['city' => function ($q) {
            $q->select('id', 'name');
        }])
            ->with(['ask_for' => function ($q) {
                $q->select('id', 'name');
            }])
            ->find($id);

        $branches = Branch::all();
        $countries = Country::orderByRaw('RAND()')->get();
        $from_recourses = From_recourse::all();

        $ask_for_main = Ask_for_main_cat::all();

        return view('patient.edit', compact('patient', 'branches', 'countries', 'from_recourses', 'ask_for_main'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(PatientRequest $request, $id)
    {

        $patient = Patient::find($id);

        $patient->type = $request->input('status');
        $patient->ask_for_main_id = $request->input('ask_for_main_id');
        $patient->ask_for_id = $request->input('ask_for_id');
        $patient->email = $request->input('email');
        if (!empty($request->input('first_branch_id'))) {
            $patient->first_branch_id = $request->input('first_branch_id');
        }
        $patient->first_name = $request->input('first_name');
        $patient->second_name = $request->input('second_name');
        $patient->mother_name = $request->input('mother_name');
        $patient->gendar = $request->input('gendar');
        $patient->birthday = $request->input('birthday');
        $patient->country_id = $request->input('country_id');
        $patient->city_id = $request->input('city_id');
        $patient->from_recourse_id = $request->input('from_recourse_id');
        $patient->phone_number = $request->input('phone_number');
        $patient->sec_phone_number = $request->input('sec_phone_number');
        $patient->height = $request->input('height');
        $patient->weight = $request->input('weight');
        $patient->blood_type = $request->input('blood_type');
        $patient->insurance = $request->input('insurance');
        $patient->note = $request->input('note');

        if (!empty($request->input('newpassword'))) {
            $patient->password = bcrypt($request->input('newpassword'));
        }

        //insert img
        if ($request->hasFile('avatar')) {

            if ($patient->avatar !== "default-pp.png") {
                //to remove the old avatar and also keep the default img
                $imagePath = public_path('img/useravatar/' . $patient->avatar);
                if (File::exists($imagePath)) {
                    File::delete($imagePath);
                }
            }

            $file_extension = request()->avatar->getClientOriginalExtension();
            $file_name = $request->input('first_name') . time() . '.' . $file_extension;
            $path = 'img/useravatar';
            $request->avatar->move($path, $file_name);

            $patient->avatar = $file_name; //new img file name
        } else {
            $file_name = request()->avatar;
        }

        $patient->save();

        session()->flash('success', 'The patient has been updated');
        return redirect()->route('sett.patient.show', $patient->id);
    }

    public function pat_slight_edit(Request $request)
    {

        $this->validate($request, [
            'patient_id' => ['required', 'exists:patients,id'],
            'edit_type_status' => ['required', Rule::in([1, 2])],
            'edit_recom_status' => ['required', Rule::in([1, 2, 3])],
            'balance_recom' => ['sometimes', 'required'],
            'wallet_recom' => ['sometimes', 'required'],
        ]);

        $patient = Patient::find($request->input('patient_id'));

        $patient->type = $request->input('edit_type_status');
        $patient->recommendation = $request->input('edit_recom_status');
        $patient->balance = $request->input('balance_recom');
        $patient->wallet = $request->input('wallet_recom');
        $patient->save();

        session()->flash('success', 'The patient has been updated');
        return redirect()->route('sett.patient.show', $patient->id);
    }



    public function add_all_pt_info_appo(Request $request, $id)
    {

        if ($request->input('exist_appointment_id')) {
            $this->validate($request, [
                'exist_appointment_id' => ['sometimes', 'exists:appointments,id'],
            ]);

            $appointment_id = $request->input('exist_appointment_id');
            $branch_id = Appointment::select('branch_id')->where('id', $appointment_id)->first();

            if ($request->input('appo_note')) {
                $appointment_query = Appointment::find($appointment_id);

                $appointment_query->note_doctor = $request->input('appo_note');
                $appointment_query->save();
            }
        } else {
            $this->validate($request, [
                'branch_appo' => ['sometimes', 'exists:branches,id'],
                'responsible_doc_app' => ['sometimes', 'exists:users,id'],
            ]);

            $service_cat_id = Service_item::select('id')->where('service_inv_cat_id', '1')
                ->where('deactivate', 0)
                ->first();

            $appointment = Appointment::create([
                'code' => "AP" . $this->generateRandomString(6),
                'specialty_id' => Auth::user()->specialty_id,
                'branch_id' => $request->input('branch_appo'),
                'patient_id' => $id,
                'doctor_id' => $request->input('responsible_doc_app'),
                'services_cat_id' => $service_cat_id->id,
                'start_at' => $request->input('appo_date'),
                'end_at' => Carbon::parse($request->input('appo_date'))->addMinutes(15),
                'creator_id' => Auth::id(),
                'status' => 4,
                'note_doctor' => $request->input('appo_note'),
            ]);

            $appointment_id = $appointment->id;
            $branch_id = $request->input('branch_appo');
        }

        $patient_update = Patient::find($id);

        $patient_update->weight = $request->input('weight_appo');
        $patient_update->heart_rate = $request->input('heart_rate');
        $patient_update->bl_pressure = $request->input('bl_pressure');
        $patient_update->save();

        if ($request->input('disease_cat')) {

            $disease_cat = $request->input('disease_cat');

            $this->validate($request, [
                'disease_cat' => ['required', 'exists:disease_cats,id'],
                'disease_start' => ['required', 'date', 'date_format:Y-m-d'],
            ]);

            $front = $request->input('front');
            $back = $request->input('back');

            if (!empty($front)) {
                //front
                $file_name = "DF" . $id . time() . '.' . 'png';
                $path = 'img/diseasedraw/' . $file_name;
                Image::make(file_get_contents($front))->save($path);
            } else {
                $file_name = '';
            }
            if (!empty($back)) {
                //back
                $file_name_b = "DB" . $id . time() . '.' . 'png';
                $path_b = 'img/diseasedraw/' . $file_name_b;
                Image::make(file_get_contents($back))->save($path_b);
            } else {
                $file_name_b = '';
            }

            $disease_draw = Disease_draw::create([
                'appointment_id' => $appointment_id,
                'patient_id' => $id,
                'front' => $file_name,
                'back' => $file_name_b,
                'note' => $request->input('note_diseases'),
            ]);


            foreach ($disease_cat as $item) {

                $disease = Disease::create([
                    'disease_cats' => $item,
                    'appointment_id' => $appointment_id,
                    'patient_id' => $id,
                    'start' => $request->input('disease_start'),
                ]);
            }
        }

        if ($request->input('disease_cat')) {
            $this->validate($request, [
                'treatment_cat' => ['required', 'exists:service_items,id'],
                'treatment_session' => ['required'],
                'treatment_start' => ['required', 'date', 'date_format:Y-m-d'],
            ]);

            $treatment = Treatment::create([
                'treatment_cat_id' => $request->input('treatment_cat'),
                'appointment_id' => $appointment_id,
                'sessions' => $request->input('treatment_session'),
                'patient_id' => $id,
                'start' => $request->input('treatment_start'),
                'end' => $request->input('treatment_end'),
            ]);
        }

        if ($request->input('medicine_pills')) {

            $medicines = $request->input('medicine_pills');

            $this->validate($request, [
                'medicine_pills' => ['required', 'exists:medicine_cats,id'],
                'medicine_start' => ['required', 'date', 'date_format:Y-m-d'],
                'medicine_end' => ['required', 'date', 'date_format:Y-m-d'],
                'medicine_status' => ['required'],
            ]);

            foreach ($medicines as $iteam) {
                $medicine = Medicine::create([
                    'medicines_cats' => $iteam,
                    'appointment_id' => $appointment_id,
                    'patient_id' => $id,
                    'start' => $request->input('medicine_start'),
                    'end' => $request->input('medicine_end'),
                    'status' => $request->input('medicine_status'),
                ]);
            }
        }

        if ($request->input('session_cat_service')) {

            $this->validate($request, [
                'session_cat_service' => ['required', 'exists:service_items,id'],
                'session_status' => ['required', Rule::in(['0', '1'])],
                'related_treatment_id' => ['nullable', 'exists:treatments,id'],
                'session_date' => ['required'],
            ]);

            $session_cat_service_id = $request->input('session_cat_service');
            $related_treatment_id = $request->input('related_treatment_id');

            $service_price = Service_item::select('id', 'service_inv_cat_id', 'price')
                ->where('deactivate', 0)
                ->where('id', $session_cat_service_id)->first();

            $session = Session_pat::create([
                'services_cat_id' => $session_cat_service_id,
                'appointment_id' => $appointment_id,
                'patient_id' => $id,
                'treatment_id' => $related_treatment_id,
                'status' => $request->input('session_status'),
                'date' => $request->input('session_date'),
            ]);

            if ($request->input('session_status') !== '1') {
                $invoice = Invoice::create([
                    'code' => "IN" . $this->generateRandomString(6),
                    'service_inv_cat_id' => $service_price->service_inv_cat_id,
                    'specialty_id' => Auth::user()->specialty_id,
                    'branch_id' => $branch_id,
                    'receivable_id' => $id,
                    'receivable_type' => "App\Models\Patient\Patient",
                    'items_price' => $service_price->price,
                    'final_price' => $service_price->price,
                ]);
                $invoice_item = Invoice_item::create([
                    'invoice_id' => $invoice->id,
                    'itemable_id' => $session->id,
                    'itemable_type' => "App\Models\Patient\Session_pat",
                    'categorizable_id' => $session_cat_service_id,
                    'categorizable_type' => "App\Models\Patient\Service_item",
                    'price' => $service_price->price,
                    'sold_price' => $service_price->price,
                ]);
            }
        }

        session()->flash('success', 'The Information has been created successfully');
        return redirect()->back();
    }

    public function generateRandomString($length = 20)
    {
        $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $charactersLength = strlen($characters);
        $randomString = '';
        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[rand(0, $charactersLength - 1)];
        }
        return $randomString;
    }

    public function note_ajax(Request $request, $id)
    {

        $patient = Patient::find($id);

        $patient->note = $request->input('query');

        $patient->save();
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $patient = Patient::find($id);
        $patient->diseases()->delete();
        $patient->appointments()->delete();
        $patient->treatments()->delete();
        $patient->sessions()->delete();
        $patient->labs()->delete();
        $patient->delete();

        session()->flash('success', 'The patient has been deleted successfully');
        return redirect()->route('sett.patient.index');
    }

    //add balance to the wallet
    public function add_wallet_balance(Request $request, $id)
    {

        $this->validate($request, [
            'branch_wallet' => ['required', 'exists:branches,id'],
            'wallet_date' => ['required', 'date'],
            'wallet_price' => ['required'],
        ]);


        $invoice = Invoice::create([
            'code' => "IN" . $this->generateRandomString(6),
            'type' => $request->input('type_wallet'),
            'service_inv_cat_id' => 9,
            'specialty_id' => Auth::user()->specialty_id,
            'receivable_id' => $id,
            'receivable_type' => "App\Models\Patient\Patient",
            'branch_id' => $request->input('branch_wallet'),
            'items_price' => $request->input('wallet_price'),
            'final_price' => $request->input('wallet_price'),
            'note' => $request->input('balance_note'),
        ]);

        if ($request->input('type_wallet') == 0) {
            $categorizable_id = 4;
            $categorizable_type = "App\Models\Patient\Service_item";
        } else {
            $categorizable_id = 1;
            $categorizable_type = "App\Models\Invoice\Expenses_item";
        }

        $invoice_item = Invoice_item::create([
            'invoice_id' => $invoice->id,
            'categorizable_id' => $categorizable_id,
            'categorizable_type' => $categorizable_type,
            'price' => $request->input('wallet_price'),
            'sold_price' => $request->input('wallet_price'),
        ]);

        session()->flash('success', 'The balance has been added successfully');
        return redirect()->back();
    }









    public function add_new_attachment(Request $request)
    {
        $this->validate($request, [
            'patient_id' => ['required', 'exists:patients,id'],
            'attachments_imgs' => ['required'],
            'attachments_imgs.*' => ['image', 'mimes:jpeg,jpg,png,heic,heif', 'max:12000'],
        ]);

        $op_imgs = $request->file('attachments_imgs');

        $patient_id = $request->input('patient_id');

        if ($request->input('attachments_name')) {
            $name =  $request->input('attachments_name') . " " . date('Y-m-d');
        } else {
            $name = "Attachment " . date('Y-m-d');
        }

        foreach ($op_imgs as $key => $img_form) {

            $file_extension = $img_form->getClientOriginalExtension();

            $file_name = "PTAT" . $patient_id . $key . time() . '.' . $file_extension;

            $path = public_path('img/pat_attachments/' . $file_name);

            Image::make($img_form)
                ->resize(800, null, function ($constraint) {
                    $constraint->aspectRatio();
                })
                ->save($path, 60);

            $operation = Patient_img::create([
                'name' => $name,
                'patient_id' => $patient_id,
                'img' => $file_name,
                'date' => date('Y-m-d'),
            ]);
        }

        session()->flash('success', 'The Images has been added successfully');
        return redirect()->back();
    }



    public function delete_new_attachment(Request $request)
    {

        $id = $request->input('attachment_id_op_delete');

        $opimg = Patient_img::find($id);

        $imagePath = public_path('img/pat_attachments/' . $opimg->img);

        if (File::exists($imagePath)) {
            File::delete($imagePath);
        }

        $opimg = $opimg->delete();

        session()->flash('success', 'The Image has been deleted successfully');
        return redirect()->back();
    }



    public function patient_print_sticker(Request $request)
    {
        $this->validate($request, [
            'patient_id' => ['required', 'exists:patients,id'],
            'qty' => ['required'],
        ]);

        $patient_id = $request->input('patient_id');
        $qty = $request->input('qty');

        $patient = Patient::select('id', 'new_id', 'code', 'first_name', 'second_name', 'first_branch_id')->find($patient_id);

        if ($patient->new_id) {
            $barcode = explode('-', $patient->new_id);
            if ($barcode[1]) {
                $new_id = $patient->new_id;
            } else {
                $new_id = 00000000;
            }
        } else {
            $new_id = 00000000;
        }

        $clinicname = prox_sett('clinicname');

        return view('patient.print_sticker', compact('patient', 'new_id', 'qty', 'clinicname'));
    }
}
