<?php

namespace App\Http\Controllers\Patient\Cats;

use App\Http\Controllers\Controller;
use App\Models\Patient\Medicine_cat as PatientMedicine_cat;
use App\Models\Patient\Medicine_type;
use Illuminate\Http\Request;

class Medicine_cat extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $medicine = PatientMedicine_cat::all();
        return view('cats/medicinecat.index', compact('medicine'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $types = Medicine_type::all();
        return view('cats/medicinecat.create', compact('types'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'name' => 'required|unique:medicine_cats,name',
            'price' => 'required|numeric',
            'medicine_type_id' => 'required|exists:medicine_types,id'
        ]);

        $medicine = PatientMedicine_cat::create([
            'name' => $request->input('name'),
            'price' => $request->input('price'),
            'medicine_type_id' => $request->input('medicine_type_id'),
        ]);

        return redirect()->route('sett.medicinecat.index')
            ->with('success', 'medicine has been created successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $medicine = PatientMedicine_cat::find($id);
        $types = Medicine_type::all();

        return view('cats/medicinecat.edit', compact('medicine', 'types'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'name' => 'required',
            'price' => 'required|numeric',
            'medicine_type_id' => 'required|exists:medicine_types,id'
        ]);

        $medicine = PatientMedicine_cat::find($id);
        $medicine->name = $request->input('name');
        $medicine->price = $request->input('price');
        $medicine->medicine_type_id = $request->input('medicine_type_id');
        $medicine->save();

        return redirect()->route('sett.medicinecat.index')
            ->with('success', 'Medicine has updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}