<?php

use App\Http\Controllers\Api\ManagerDashboard\StudentAbsenceAndLateness\GeneralStudentAbsenceController;
use App\Http\Controllers\Api\ManagerDashboard\StudentAbsenceAndLateness\PeriodStudentAbsenceController;
use App\Http\Controllers\Api\ManagerDashboard\StudentAbsenceAndLateness\StudentAbsenceProcedureController;
use App\Http\Controllers\Api\ManagerDashboard\StudentAbsenceAndLateness\StudentLatenessController;
use App\Http\Controllers\Api\ManagerDashboard\StudentAbsenceAndLateness\StudentLatenessProcedureController;
use App\Http\Controllers\Api\ManagerDashboard\StudentAbsenceAndLateness\WaitingPeriodStudentAbsenceController;
use Illuminate\Support\Facades\Route;


/* procedures */
Route::group(['prefix' => 'student-attendance','middleware'=> ['jwt.verify']], function () {

    Route::group(['prefix' => 'general-student-attendance', 'controller' => GeneralStudentAbsenceController::class], function () {
        Route::get('get-day-registered-classes', 'getDayRegisteredClasses');
        Route::get('get-day-students', 'getDayStudents');
        Route::get('student-autocomplete-name', 'studentAutocompleteName');
        Route::post('change-attendance-status', 'changeAttendanceStatus');
        Route::post('make-all-students-absent', 'makeAllStudentsAbsent');
    });

    Route::group(['prefix' => 'period-student-attendance', 'controller' => PeriodStudentAbsenceController::class], function () {
        Route::get('get-date-periods', 'getDatePeriods');
        Route::get('get-period-details', 'getPeriodDetails');
        Route::get('get-day-period-students', 'getDayPeriodStudents');
        Route::get('student-autocomplete-name', 'studentAutocompleteName');
        Route::post('change-period-attendance-status', 'changePeriodAttendanceStatus');
        Route::post('make-all-period-students-absent', 'makeAllPeriodStudentsAbsent');
    });

    Route::group(['prefix' => 'student-lateness', 'controller' => StudentLatenessController::class], function () {
        Route::get('get-day-students', 'getDayStudents');
        Route::get('student-autocomplete-name', 'studentAutocompleteName');
        Route::post('change-attendance-status', 'changeAttendanceStatus');
    });

    Route::group(['prefix' => 'waiting-periods-student-attendance', 'controller' => WaitingPeriodStudentAbsenceController::class], function () {
        Route::get('get-date-periods', 'getDatePeriods');
        Route::get('get-period-details', 'getPeriodDetails');
        Route::get('get-day-period-students', 'getDayPeriodStudents');
        Route::post('change-period-attendance-status', 'changePeriodAttendanceStatus');
        Route::post('make-all-period-students-absent', 'makeAllPeriodStudentsAbsent');
    });

    Route::group(['prefix' => 'student-absence-procedures', 'controller' => StudentAbsenceProcedureController::class], function () {
        Route::get('get-students-procedures', 'getStudentProcedures');
        Route::get('get-procedure-data/{procedure}', 'getProcedureData');
        Route::get('preview-done-procedure/{procedure}', 'previewDoneProcedure');
        Route::post('create-procedure', 'createProcedure');
        Route::delete('delete-procedure/{procedure}', 'deleteProcedure');
    });

    Route::group(['prefix' => 'student-lateness-procedures', 'controller' => StudentLatenessProcedureController::class], function () {
        Route::get('get-students-procedures', 'getStudentProcedures');
        Route::get('get-procedure-data/{procedure}', 'getProcedureData');
        Route::get('preview-done-procedure/{procedure}', 'previewDoneProcedure');
        Route::post('create-procedure', 'createProcedure');
        Route::delete('delete-procedure/{procedure}', 'deleteProcedure');
    });

});