<?php

use App\Http\Controllers\Api\ManagerDashboard\TeacherSchedule\TeacherScheduleController;
use App\Http\Controllers\Api\School\AdminstrativeController;
use App\Http\Controllers\Api\School\SchoolEmployeeAttendanceController;
use App\Http\Controllers\Api\School\SchoolGradeController;
use App\Http\Controllers\Api\School\SchoolSemesterController;
use App\Http\Controllers\Api\School\SchoolSemesterVacationController;
use App\Http\Controllers\Api\School\GuideRegulationController;
use App\Http\Controllers\Api\School\GuideRegulationFileController;
use App\Http\Controllers\Api\School\SchoolController;
use App\Http\Controllers\Api\School\StudentController;
use App\Http\Controllers\Api\School\TeacherController;
use Illuminate\Support\Facades\Route;

Route::group(['prefix' => 'school'], function () {
    /* school grades url*/
    Route::group(['prefix' => 'grades/', 'middleware' => ['jwt.verify'], 'controller' => SchoolGradeController::class], function () {
        Route::get('get-all', 'getAll');
        Route::post('store', 'store');
        Route::get('{grade}/details', 'getById');
        Route::get('{grade}/edit', 'edit');
        Route::post('{grade}/update', 'update');
        Route::post('{grade}/changeStatus', 'changeStatus');
        Route::delete('{grade}/archive', 'archive');
        Route::delete('{grade}/destroy', 'destroy')->withTrashed();
        Route::get('{grade}/restore', 'restore')->withTrashed();
        Route::post('/get-subjects', 'getSubjects');
    });

    Route::group(['namespace' => 'School'], function () {

        /* school semesters url*/
        Route::group(['prefix' => 'semesters/', 'controller' => SchoolSemesterController::class], function () {
            Route::get('get-all', 'getAll');
            Route::post('store', 'store');
            Route::get('{schoolSemester}/details', 'getById');
            Route::post('{schoolSemester}/update', 'update');
            Route::post('{schoolSemester}/change-status', 'changeStatus');
            Route::delete('{schoolSemester}/archive', 'archive');
            Route::delete('{schoolSemester}/destroy', 'destroy')->withTrashed();
            Route::get('{schoolSemester}/restore', 'restore')->withTrashed();
        });


        /* school semester vacations url*/
        Route::group(['prefix' => 'semester-vacations/', 'controller' => SchoolSemesterVacationController::class], function () {
            Route::get('get-all', 'getAll');
            Route::post('store', 'store');
            Route::get('{semesterVacation}/details', 'getById');
            Route::post('{semesterVacation}/update', 'update');
            Route::post('{semesterVacation}/change-status', 'changeStatus');
            Route::delete('{semesterVacation}/archive', 'archive');
            Route::delete('{semesterVacation}/destroy', 'destroy')->withTrashed();
            Route::get('{semesterVacation}/restore', 'restore')->withTrashed();
        });

        /* school guides regulations url*/
        Route::group(['prefix' => 'guides-regulations/', 'controller' => GuideRegulationController::class], function () {
            Route::get('get-all', 'getAll');
            Route::post('store', 'store');
            Route::get('{guideRegulation}/details', 'getById');
            Route::post('{guideRegulation}/update', 'update');
            Route::post('{guideRegulation}/change-status', 'changeStatus');
            Route::delete('{guideRegulation}/archive', 'archive');
            Route::delete('{guideRegulation}/destroy', 'destroy')->withTrashed();
            Route::get('{guideRegulation}/restore', 'restore')->withTrashed();
        });

        /* school Guides and Regulations Files url*/
        Route::group(['prefix' => 'guides-regulations-files/', 'controller' => GuideRegulationFileController::class], function () {
            Route::get('get-all/{id}', 'getAll');
            Route::post('store', 'store');
            Route::get('{guideRegulationFile}/details', 'getById');
            Route::post('{guideRegulationFile}/update', 'update');
            Route::post('{guideRegulationFile}/change-status', 'changeStatus');
            Route::delete('{guideRegulationFile}/archive', 'archive');
            Route::delete('{guideRegulationFile}/destroy', 'destroy')->withTrashed();
            Route::get('{guideRegulationFile}/restore', 'restore')->withTrashed();
            Route::get('{guideRegulationFile}/download', 'download');
        });

        /** school urls */
        Route::group(['middleware' => ['jwt.verify'], 'controller' => SchoolController::class], function () {
            Route::post('get-school-info', 'getSchoolInfo');
            Route::post('get-school-facilities-info', 'getSchoolFacilitiesInfo');
            Route::post('get-school-references-info', 'getSchoolReferencesInfo');
            Route::post('get-school-students-info', 'getSchoolStudentsInfo');
            Route::post('get-school-teachrs-info', 'getSchoolTeachrsInfo');
            Route::post('get-school-adminstratives-info', 'getSchoolAdminstrativesInfo');

            Route::get('get-all-schools', 'getALlSchools');
            Route::post('get-all-school-employees', 'getAllSchoolEmployees');

            Route::get('get-current-works', 'getCurrentWorks');
            Route::post('get-specializations', 'getSpecializations');
            Route::post('get-class-names', 'getClassNames');
            Route::post('get-class-categories', 'getClassCategories');
            Route::post('get-school-classes', 'getSchoolClasses');
            Route::post('set-entsab-school-class', 'setEntsabSchoolClass');
            Route::post('get-entsab-classes', 'getEntsabClasses');
            Route::post('get-entsab-class-students', 'getEntsabClassStudents');
            Route::get('get-school-facilities-json/{schoolId}', 'getSchoolFacilitiesJson');

            Route::get('/get-weeks', 'getWeeks');
            Route::post('/save-year-calander', 'saveYearCalendar');
            Route::get('/get-current-work-employees/{schoolId}/{currentWorkId}', 'getCurrentWorkEmployees');




            Route::get('get-schools', 'getSchools');
            Route::post('update-school-info', 'updateSchoolInfo');
            Route::post('update-school-facilities-info', 'updateSchoolFacilitiesInfo');
            Route::post('update-school-references-info', 'updateSchoolReferencesInfo');
            Route::post('update-school-students-info', 'updateSchoolStudentsInfo');
            Route::post('update-school-teachrs-info', 'updateSchoolTeachrsInfo');
            Route::post('update-school-adminstratives-info', 'updateSchoolAdminstrativesInfo');
            Route::post('delete-school', 'deleteSchool');

            /* school students url*/
            Route::group(['prefix' => 'students', 'controller' => StudentController::class], function () {
                Route::post('store', 'store');
                Route::post('show', 'show');
                Route::get('get-student-absence-logs/{student}', 'getStudentAbsenceLog');
                Route::get('get-student-lateness-logs/{student}', 'getStudentLatenessLog');
                Route::patch('update/{id}', 'update');
                Route::post('destroy', 'destroy')->withTrashed();
            });

            /* school teachers url*/
            Route::group(['prefix' => 'teachers', 'controller' => TeacherController::class], function () {
                Route::post('store', 'store');
                Route::post('show', 'show');
                Route::patch('update/{id}', 'update');
                Route::post('destroy', 'destroy')->withTrashed();
                Route::post('export-teachers', 'exportTeachers');
            });

            /* school adminstratives url*/
            Route::group(['prefix' => 'adminstratives', 'controller' => AdminstrativeController::class], function () {
                Route::post('store', 'store');
                Route::post('show', 'show');
                Route::patch('update/{id}', 'update');
                Route::post('destroy', 'destroy')->withTrashed();
                Route::post('export-adminstratives', 'exportAdminstratives');
            });

            /* school employees attendance url*/
            Route::group(['prefix' => 'attendance', 'controller' => SchoolEmployeeAttendanceController::class], function () {
                Route::post('get-day-attendance', 'getDayAttendance');
                Route::post('store-day-attendance', 'store');
                Route::post('change-attendance-status', 'changeAttendanceStatus');
                Route::post('school-employee-autocomplete-name', 'schoolEmployeeAutocompleteName');
                Route::post('get-school-employee-attendance', 'getSchoolEmployeeAttendance');
            });
        });

        Route::get('/class/{school_class_id}/students', 'SchoolController@get_schoolClass_students');
        Route::get('/{school}/category/{categroy}', [SchoolController::class, 'get_classes_for_category']);
        Route::get('/{school}/schoolClass/{class}', [SchoolController::class, 'get_subject_for_class']);
        Route::get('/{school}/subject/{subject}', [SchoolController::class, 'get_teacher_for_subject']);
        Route::get('/{school}/semester/{semester}/teacher/{teacher}', [TeacherScheduleController::class, 'get_classes_for_teacher']);

        Route::get('/{school}/current-semester', [SchoolController::class, 'get_current_semester']);
    });
});
