<?php

use App\Http\Controllers\Api\ManagerDashboard\LetterAndAlart\AlertController;
use App\Http\Controllers\Api\ManagerDashboard\LetterAndAlart\LetterController;
use App\Http\Controllers\Api\ManagerDashboard\ProceedController;
use Illuminate\Support\Facades\Route;


/* procedures */

Route::group(['prefix' => 'officialLetters'], function () {
    Route::get('index', [LetterController::class,'index']);
    Route::group(['prefix' => 'proceeds', 'controller' => ProceedController::class], function () {

        Route::get('get-all', 'getAll');
        Route::get('{id}', 'getById');
        Route::post('store', 'store');
        Route::post('{id}/update', 'update');
        Route::post('{id}/archive', 'archive');
        Route::post('{id}/delete', 'delete');
        Route::post('{id}/restore', 'restore');
    });

    Route::group(['prefix' => 'school/{school}/letters', 'controller' => LetterController::class], function () {
        Route::get('get-all', 'getAll');
        Route::post('store', 'store');
        Route::get('{letter}/details', 'getById');
        Route::post('{letter}/update', 'update')->withTrashed();
        Route::delete('{letter}/archive', 'archive');
        Route::delete('{letter}/destroy', 'destroy')->withTrashed();
        Route::get('{letter}/restore', 'restore')->withTrashed();
    });
    Route::group(['prefix' => 'school/{school}/alerts', 'controller' => AlertController::class], function () {
        Route::get('get-all', 'getAll')->withTrashed();
        Route::post('store', 'store');
        Route::get('{alert}/details', 'getById');
        Route::post('{alert}/update', 'update')->withTrashed();
        Route::delete('{alert}/archive', 'archive');
        Route::delete('{alert}/destroy', 'destroy')->withTrashed();
        Route::get('{alert}/restore', 'restore')->withTrashed();
    });

});
