<?php

use App\Http\Controllers\Api\ManagerDashboard\Messages\MessagesController;
use App\Http\Controllers\Api\ManagerDashboard\Notification\NotificationController;
use Illuminate\Support\Facades\Route;



    Route::group(['prefix' => 'manager-messages', 'controller' => MessagesController::class], function () {

        Route::get('get-all/{school_id}', 'getAll');
        Route::get('top/{school_id}', 'top_messages');
        Route::post('store', 'store');
        Route::post('{notification_id}/resend', 'resend');
        // Route::post('store-test', 'sms_store');
        Route::post('update', 'update');
        Route::post('{id}/delete', 'delete');
        Route::post('{id}/archive', 'archive');
        Route::post('{id}/restore', 'restore');
    });
    
    Route::group(['prefix' => 'my-notifications', 'controller' => NotificationController::class], function () {
        
        Route::get('topCount', 'topCount');
        Route::get('bar-type', 'bar_type');
        Route::get('top', 'top_notifications');
        Route::get('get-all', 'getAll');
        Route::post('archiveAll/{school}', 'archive');
        Route::get('testTreat', 'testTreat');
    });
