<?php

use App\Http\Controllers\Api\ManagerDashboard\ClassRoomVisit\ClassRoomVisitController;
use App\Http\Controllers\Api\ManagerDashboard\ClassRoomVisit\ClassVisitRateController;
use Illuminate\Support\Facades\Route;

Route::get('school/{school}/managers-and-agents', [ClassRoomVisitController::class,'getManagersAndAgents']);
Route::get('nationalities',[ClassRoomVisitController::class,'getNationalities']);
Route::group(['prefix' => 'classRoomVisits', 'controller' => ClassRoomVisitController::class], function () {
   
  
    Route::get('class-numbers/{schoolId}/{id}', 'getClassNumber');
    Route::get('VisitMethods', 'getVisitMethods');
    Route::get('periods', 'getPeriods');
    // 

    Route::get('get-all/{school}', 'index')->withTrashed();
    Route::get('get-semester/{school}/{semester}', 'getSemester')->withTrashed();
    Route::post('store', 'store');
    Route::post('{classRoomVisit}/update', 'update')->withTrashed();
    Route::delete('{classRoomVisit}/archive', 'archive');
    Route::get('{classRoomVisit}/restore', 'restore')->withTrashed();
    Route::delete('{classRoomVisit}/delete', 'destroy')->withTrashed();

        
    Route::post('{classRoomVisit}/rate', ClassVisitRateController::class);

    Route::get('{classRoomVisit}/rate', 'getRating');

});
