<?php

use App\Http\Controllers\Api\ManagerDashboard\Assignments\AssignmentCategory;
use App\Http\Controllers\Api\ManagerDashboard\Assignments\AssignmentCommitteeController;
use Illuminate\Support\Facades\Route;
use  App\Http\Controllers\Api\ManagerDashboard\Assignments\AssignmentController;
use App\Http\Controllers\Api\ManagerDashboard\Assignments\AssignmentTeamController;
use App\Http\Controllers\Api\ManagerDashboard\Assignments\GeneralAssignmentController;

Route::group(['prefix' => 'assignments'], function () {
    // get All Assignments Tabs 
    Route::get('school/{school}/categories', AssignmentCategory::class);

    // تكليفات العاملين بالمدرسة

    Route::group(['prefix' => 'school/{school}/schoolStaff', 'controller' => AssignmentController::class], function () {

        Route::POST('store', 'store');
        Route::delete('assignment/{assignment}/employee/{employeeId}/archive', 'archive');
        Route::get('assignment/{assignment}/employee/{employeeId}/restore', 'restore');
        Route::Delete('assignment/{assignment}/employee/{employeeId}/delete', 'destroy');
    });
    // تكليفات اللجان
    Route::group(['prefix' => 'school/{school}', 'controller' => AssignmentCommitteeController::class], function () {

        Route::post('committees/{committee}/store-or-update', 'storeOrUpdate');
        Route::get('assignments/{assignment}/details', 'details');
        Route::delete('committees/{committee}/archive', 'archive');
        Route::get('committees/{committee}/restore', 'restore');
        Route::delete('committees/{committee}/delete', 'destroy');
    });
    // تكليفات الفرق 
    Route::group(['prefix' => 'school/{school}/teams', 'controller' => AssignmentTeamController::class], function () {

        Route::POST('{team}/store-or-update', 'storeOrUpdate');
        Route::get('assignments/{assignment}/details', 'details');
        Route::delete('{team}/archive', 'archive');
        Route::get('{team}/restore', 'restore');
        Route::delete('{team}/delete', 'destroy');
    });

    // التكليفات العامة

    Route::group(['prefix' => '/', 'controller' => GeneralAssignmentController::class], function () {

        Route::get('general/assignments-duration', 'getDurations')->withTrashed();

        Route::group(['prefix' => 'school/{school}/general'], function () {
            Route::post('store', 'store');
            Route::delete('assignment/{assignment}/employee/{employeeId}/archive', 'archive');
            Route::get('assignment/{assignment}/employee/{employeeId}/restore', 'restore')->withTrashed();
            Route::delete('assignment/{assignment}/employee/{employeeId}/delete', 'destroy');
        });
    });
});
