<?php


use App\Http\Middleware\UpdateLastSeen;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\AdminDashboard\Video\VideoController;
use App\Http\Controllers\Api\AdminDashboard\Notification\NotificationController;
use App\Http\Controllers\Api\AdminDashboard\Coupons\CouponController;
use App\Http\Controllers\Api\AdminDashboard\AreasAndCites\AreaController;
use App\Http\Controllers\Api\AdminDashboard\TripVideo\TripVideoController;
use App\Http\Controllers\Api\AdminDashboard\Barcode\BarcodeController;
use App\Http\Controllers\Api\AdminDashboard\ExternalSystem\ExternalSystemController;
use App\Http\Controllers\Api\AdminDashboard\Marketing\MarketingController;
use App\Http\Controllers\Api\AdminDashboard\EducationalOffice\EducationalOfficeController;
use App\Http\Controllers\Api\AdminDashboard\EducationalDepartment\EducationalDepartmentController;
use App\Http\Controllers\Api\AdminDashboard\Event\EventController;
use App\Http\Controllers\Api\AdminDashboard\Products\ProductController;
use App\Http\Controllers\Api\AdminDashboard\NamazegCategories\NamazegCategoryController;
use App\Http\Controllers\Api\AdminDashboard\Page\PageController;
use App\Http\Controllers\Api\AdminDashboard\Slider\SliderController;
use App\Http\Controllers\Api\AdminDashboard\Violation\NamazegController;
use App\Http\Controllers\Api\AdminDashboard\BankAccount\BankAccountController;

/* External Systems */

Route::group(['prefix' => 'external-systems/', 'controller' => ExternalSystemController::class], function () {
    Route::get('get-all', 'getAll');
    Route::post('store', 'store');
    Route::get('{external_system}/details', 'getById');
    Route::get('{external_system}/edit', 'edit');
    Route::post('{external_system}/update', 'update');
    Route::post('{external_system}/changeStatus', 'changeStatus');
    Route::delete('{external_system}/archive', 'archive');
    Route::delete('{external_system}/destroy', 'destroy')->withTrashed();
    Route::get('{external_system}/restore', 'restore')->withTrashed();
});

/* EducationalDepartments */
Route::group(['prefix' => 'educational-department/', 'controller' => EducationalDepartmentController::class], function () {
    Route::get('get-all', 'getAll');
    Route::post('store', 'store');
    Route::get('{educationalDepartment}/details', 'getById');
    Route::get('{educationalDepartment}/edit', 'edit');
    Route::post('{educationalDepartment}/update', 'update');
    Route::post('{educationalDepartment}/changeStatus', 'changeStatus');
    Route::delete('{educationalDepartment}/archive', 'archive');
    Route::delete('{educationalDepartment}/destroy', 'destroy')->withTrashed();
    Route::get('{educationalDepartment}/restore', 'restore')->withTrashed();
});

/* EducationalOffices */
Route::group(['prefix' => 'educational-offices/', 'controller' => EducationalOfficeController::class], function () {
    Route::get('get-all', 'getAll');
    Route::get('create', 'create');
    Route::post('store', 'store');
    Route::get('{educationalOffice}/details', 'getById');
    Route::get('{educationalOffice}/edit', 'edit');
    Route::post('{educationalOffice}/update', 'update');
    Route::post('{educationalOffice}/changeStatus', 'changeStatus');
    Route::delete('{educationalOffice}/archive', 'archive');
    Route::delete('{educationalOffice}/destroy', 'destroy')->withTrashed();
    Route::get('{educationalOffice}/restore', 'restore')->withTrashed();
});

Route::group(['prefix' => 'events', 'controller' => EventController::class], function () {
    /* events url*/
    Route::get('get-all', 'getAll');
    Route::get('{id}', 'getById');
    Route::post('store', 'store');
    Route::post('{id}/update', 'update');
    Route::post('{event}/holiday', 'holiday');
    Route::post('{id}/archive', 'archive');
    Route::post('{id}/restore', 'restore');
    Route::post('{id}/delete', 'delete');
});

Route::group(['prefix' => 'pages', 'controller' => PageController::class], function () {
    /* pages url*/
    Route::get('get-all', 'getAll')->withoutMiddleware('auth:api');
    Route::get('{id}', 'getById')->withoutMiddleware('auth:api');
    Route::post('store', 'store');
    Route::post('{id}/update', 'update');
    Route::post('{id}/delete', 'delete');
    Route::post('{id}/archive', 'archive');
    Route::post('{id}/restore', 'restore');
});

Route::group(['prefix' => 'sliders', 'controller' => SliderController::class], function () {
    /* sliders url*/
    Route::get('get-all', 'getAll');
    Route::get('{id}', 'getById');
    Route::post('store', 'store');
    Route::post('{id}/update', 'update');
    Route::post('{id}/delete', 'delete');
    Route::post('{id}/archive', 'archive');
    Route::post('{id}/restore', 'restore');
});


Route::group(['prefix' => 'violations', 'namespace' => 'AdminDashboard\Violation'], function () {

    /* violations-names  url*/
    Route::get('grade/{grade_id}/names', 'ViolationController@getNames');

    /* violations-violations  url*/
    Route::get('violations/get-all/{school_grade_id}', 'ViolationController@getAll');
    Route::get('grade/{violation_grade_id}', 'ViolationController@getById');
    Route::post('category/store', 'ViolationController@store');
    Route::post('category/{id}/update', 'ViolationController@update');
    Route::post('category/{id}/delete', 'ViolationController@delete');
    Route::post('category/{id}/archive', 'ViolationController@archive');
    Route::post('category/{id}/restore', 'ViolationController@restore');

    /* violations-grades  url*/
    Route::post('grades/store', 'GradeViolationController@store');
    Route::post('grades/{id}/update', 'GradeViolationController@update');
    Route::post('grades/{id}/delete', 'GradeViolationController@delete');
    Route::post('grades/{id}/archive', 'GradeViolationController@archive');
    Route::post('grades/{id}/restore', 'GradeViolationController@restore');


    /* violations-title-types  الاجراءات*/
    Route::post('titles/store', 'ViolationTitleController@store');
    Route::get('titles/{violation_title}/next', 'ViolationTitleController@next_step_data');
    Route::post('titles/{violation_title}/store-next', 'ViolationTitleController@store_next_step');
    Route::post('titles/{id}/update', 'ViolationTitleController@update');
    Route::post('titles/{id}/delete', 'ViolationTitleController@delete');
    Route::post('titles/{id}/archive', 'ViolationTitleController@archive');
    Route::post('titles/{id}/restore', 'ViolationTitleController@restore');

    Route::get('related-titles/{violation_title}', 'ViolationTitleController@get_related_titles');



});
/* Namazeggggggggg ----------- violations-punshments-Options  url*/
Route::group(['prefix' => 'namazeg/', 'controller' => NamazegController::class], function () {
    Route::get('get-all', 'getAll');
    Route::get('violation-grade/{violation_grade}/unique', 'violation_namazeg');
    Route::get('{id}', 'getById');
    Route::post('store', 'store');
    Route::post('{id}/update', 'update');
    Route::post('{id}/delete', 'delete');
    Route::post('{id}/archive', 'archive');
    Route::post('{id}/restore', 'restore');
});


/* Notifications */
Route::group(['prefix' => 'notifications', 'controller' => NotificationController::class], function () {
    /* Notifications url*/
    Route::get('get-all', 'getAll');
    Route::get('{id}', 'getById');
    Route::post('store', 'store');
    Route::post('{id}/update', 'update');
    Route::post('{id}/delete', 'delete');
    Route::post('{id}/archive', 'archive');
    Route::post('{id}/restore', 'restore');
});

/* Areas */
Route::group(['prefix' => 'areas/', 'controller' => AreaController::class], function () {
    Route::get('get-all', 'getAll');
    Route::get('create', 'create');
    Route::post('store', 'store');
    Route::get('{area}/details', 'getById');
    Route::get('{area}/edit', 'edit');
    Route::post('{area}/update', 'update')->withTrashed();
    Route::delete('{area}/archive', 'archive');
    Route::get('{area}/restore', 'restore')->withTrashed();
    Route::post('{area}/changeStatus', 'changeStatus');
    Route::delete('{area}/destroy', 'destroy')->withTrashed();
});


Route::group(['prefix' => 'tripVideo', 'controller' => TripVideoController::class], function () {


    Route::get('{tripVideo}', 'show');
    Route::post('{tripVideo}/update', 'update');
});

Route::group(['prefix' => 'videos', 'controller' => VideoController::class], function () {
    /* sliders url*/
    Route::get('get-all', 'getAll');
    Route::get('{id}', 'getById');
    Route::post('store', 'store');
    Route::post('{id}/update', 'update');
    Route::post('{id}/delete', 'delete');
    Route::post('{id}/archive', 'archive');
    Route::post('{id}/restore', 'restore');
});

Route::group(['prefix' => 'barcode', 'controller' => BarcodeController::class], function () {
    /* sliders url*/
    Route::get('get-barcode', 'getAll');
    Route::post('update', 'update');
});

/* Products */

Route::group(['prefix' => 'products', 'controller' => ProductController::class], function () {
    Route::get('index', 'index');
    Route::post('store', 'store');
    Route::get('{product}/details', 'getById');
    Route::post('{product}/update', 'update');
    Route::delete('{product}/archive', 'archive');
    Route::get('{product}/restore', 'restore')->withTrashed();
    Route::delete('{product}/destroy', 'destroy')->withTrashed();
});


/* Coupons */

Route::group(['prefix' => 'coupons', 'controller' => CouponController::class], function () {
    Route::get('get-all', 'getAll');
    Route::post('store', 'store');
    Route::get('{coupon}/details', 'getById');
    Route::post('{coupon}/update', 'update')->withTrashed();
    Route::delete('{coupon}/archive', 'archive');
    Route::get('{coupon}/restore', 'restore')->withTrashed();
    Route::post('{coupon}/changeStatus', 'changeStatus');
    Route::delete('{coupon}/destroy', 'destroy')->withTrashed();
    Route::get('export','export');
    Route::get('{coupon}/usage-history', 'getCouponUsageHistory');
    Route::get('{coupon}/export-usage-history', 'exportCouponUsageHistory');

});


/* marketing */

Route::group(['prefix' => 'marketing', 'controller' => MarketingController::class], function () {
    Route::get('get-all-students', 'getAll');
    Route::post('filter-students-data', 'filterStudentsData');
    Route::get('export-students', 'exportStudents');
    Route::post('schools-auto-complete', 'SchoolsAutoComplete');
    Route::get('get-class-names', 'getClassNames');


});


Route::group(['prefix' => 'namazegCategories', 'controller' => NamazegCategoryController::class], function () {
    /* sliders url*/
    Route::get('get-all', 'getAll');
    Route::get('{id}', 'getById');
    Route::post('store', 'store');
    Route::post('{id}/update', 'update');
    Route::post('{id}/delete', 'delete');
    Route::post('{id}/archive', 'archive');
    Route::post('{id}/restore', 'restore');
});

// Bank Accounts
Route::group(['prefix' => 'bankAccounts', 'controller' => BankAccountController::class], function () {

    Route::get('index', 'index');
    Route::post('store', 'store');
    Route::get('{account}/details', 'show');
    Route::post('{account}/update', 'update')->withTrashed();
    Route::delete('{account}/archive', 'archive');
    Route::delete('{account}/destroy', 'destroy')->withTrashed();

});
