<?php

use App\Http\Controllers\Api\AdminDashboard\Clients\ClientController;
use Illuminate\Support\Facades\Route;

Route::group(['prefix' => 'clients/', 'controller' => ClientController::class], function () {
    Route::get('get-all', 'getAll');
    Route::post('change-client-status/{user}', 'changeStatus');
    Route::get('export-clients', 'exportClients');
    Route::get('client-subscriptions/{user}', 'userSubscriptions');
    Route::post('cancel-subscription', 'cancelSubscription');
    Route::post('restore-subscription', 'restoreSubscription');
    Route::post('update-profile', 'updateProfile');
    Route::post('send-system-account-credentials', 'sendSystemAccountCredentials');
    Route::get('/subscriptions/{subscription}/accept-cancellation', 'acceptCancellation');
    Route::get('/subscriptions/{subscription}/refuse-cancellation', 'refuseCancellation');

});

