<?php

use App\Helpers\Helper;
use App\Http\Controllers\Api\User\EdfapayController;
use App\Jobs\SaveSchedulesJob;
use App\Models\AdminDashboard\School\School;
use App\Models\AdminDashboard\School\SemesterWeekDay;
use App\Models\ManagerDashboard\Namazeg\NamazegManagerPlane;
use App\Models\ManagerDashboard\Settings\Subscription;
use App\Traits\NotificationTrait;
use Carbon\Carbon;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Route;
use PHPOpenSourceSaver\JWTAuth\Facades\JWTAuth;

/////// apis version/////
$version = "v1.0";


 Route::get('edfapay-result', [EdfapayController::class, 'edfapayResult']);
Route::group(['prefix' => $version, 'middleware' => ['ApiLocalization', 'last_seen']], function () {
    Route::get('edfapay', [EdfapayController::class, 'edfapay']);
    Route::post('edfapayCallback', [EdfapayController::class, 'edfapayCallback']);
   

    require base_path('routes/api/adminDashboard/reports.php');

    require base_path('routes/api/adminDashboard/user.php');
    require base_path('routes/api/managerDashboard/school.php');
    require base_path('routes/api/managerDashboard/committeesTeamsMeetings.php');
    require base_path('routes/api/adminDashboard/clients.php');
});

Route::group(['prefix' => $version, 'middleware' => [ 'ApiLocalization', 'last_seen']], function () {

    //  --------------------  Admin Dashboard ----------- //
    require base_path('routes/api/adminDashboard/adminHome.php');
    require base_path('routes/api/adminDashboard/system.php');
    require base_path('routes/api/adminDashboard/procedures.php');
    require base_path('routes/api/adminDashboard/category.php');
    require base_path('routes/api/adminDashboard/logs.php');
    require base_path('routes/api/adminDashboard/finances.php');

    //  --------------------  Manger Dashboard ----------- //
    // Route::group(['middleware' => 'CheckSubscription'], function () {
        require base_path('routes/api/managerDashboard/tables.php');
        require base_path('routes/api/teacherSchoolDashboard/teacherDashboardRoutes.php');
        require base_path('routes/api/managerDashboard/officialLetters.php');
        require base_path('routes/api/SchoolRegistration/SchoolRegistration.php');
        require base_path('routes/api/managerDashboard/circulars.php');
        require base_path('routes/api/managerDashboard/studentAttendance.php');
        require base_path('routes/api/managerDashboard/classRoomVisit.php');
        require base_path('routes/api/managerDashboard/assignments.php');
        require base_path('routes/api/managerDashboard/messagesAndMyNotifications.php');
        require base_path('routes/api/managerDashboard/logs.php');
        require base_path('routes/api/managerDashboard/trashedRecords.php');
        require base_path('routes/api/managerDashboard/namazeg.php');
        require base_path('routes/api/managerDashboard/exams.php');
        require base_path('routes/api/managerDashboard/violations.php');
        require base_path('routes/api/managerDashboard/reports.php');
        require base_path('routes/api/managerDashboard/tasks.php');
        require base_path('routes/api/managerDashboard/managerHome.php');
        require base_path('routes/api/managerDashboard/settings.php');
        require base_path('routes/api/managerDashboard/notificationSettings.php');
    });


// });
Route::group(['prefix' => $version . '/dev'], function () {
    Route::post('teacher-schedules', 'ManagerDashboard\TeacherSchedule\TeacherScheduleController@dev_create_school_table');
    Route::post('supervision-schedules', 'ManagerDashboard\TeacherSchedule\TeacherScheduleController@dev_create_supervisor_school_table');
    Route::post('school/{school_id}/managerPlane', function ($school_id) {
        Helper::managerPLans($school_id);
    });
    Route::post('setting-notifications/school/{school_id}', function ($school_id) {
        Helper::store_default_notification_settings($school_id);
        return response()->json(['message' => 'Data is stored right']);
    });
    Route::post('/school/{school}/generate-notifications', function (School $school) {
        $user = JWTAuth::parseToken()->authenticate();
        $today = Carbon::now()->format('d/m/Y');
        NotificationTrait::CreateWebsiteNotification(
            3,
            'اشترك الان واحصل على وصول كامل لنظام لام',
            'اشترك الان واحصل على وصول كامل لنظام لام',
            $school->id,
            [$user->id],
            'priority_tape'
        );



        $current_semester = Helper::getCurrentSchoolSemester();
        $semesterWeekDay = SemesterWeekDay::where('date', $today)->first();

        $manger_plan = NamazegManagerPlane::where('school_id', $school->id)
            ->where('semester_id', $current_semester->id)
            ->where('week_id', $semesterWeekDay?->week_id)
            ->first();
        NotificationTrait::CreateWebsiteNotification(
            1,
            $manger_plan->title,
            'لم يتم انشاء خطة المدير بعد, يرجى إعداد خطتك الاسبوعية' . ' - ' . $manger_plan->week_name,
            $school->id,
            [$user->id],
            'normal_tape',
            'NamazegManagerPlane',
            131, // رقم النموذج
        );

        NotificationTrait::CreateWebsiteNotification(
            2,
            'مهام غير مكتملة',
            'لديك مهام لم تنتهى منها فى الايام الماضية, يرجى مراجعتها واستكمالها',
            $school->id,
            [$user->id],
            'bell',
        );
        NotificationTrait::CreateWebsiteNotification(
            7,
            'قرب انتهاء الرصيد',
            'رصيدك المتبقى قارب على الانتهاء يرجى تجديد الرصيد قريبا لضمان استمرار الخدمة دون انقطاع ',
            $school->id,
            [$user->id],
            'normal_tape'
        );
        return "notifications stored successfully";
    });
});
