<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class NationalitiesTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $nationalities = [
            'سعودي', // Egyptian
            'مصري', // Saudi Arabian
            'إماراتي', // Emirati
            'أردني', // Jordanian
            'لبناني', // Lebanese
            'مغربي', // Moroccan
            'تونسي', // Tunisian
            'جزائري', // Algerian
            'عراقي', // Iraqi
            'كويتي', // Kuwaiti
            'قطري', // Qatari
            'عماني', // Omani
            'يمني', // Yemeni
            'سوداني', // Sudanese
            'ليبي', // Libyan
            'فلسطيني', // Palestinian
            'سوري', // Syrian
        ];

        foreach ($nationalities as $nationality) {
            DB::table('nationalities')->insert(['name' => $nationality]);
        }
    }
}
