<?php
namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Floor;

class FloorSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // الساحة الخارجية=>0
        $floors=[ 'الدور الارضي', 'الدور الاول', 'الدور الثانى', 'الدور الثالث', 'الدور الرابع', 'الدور الخامص', 'الدور السادس', 'الدور السابع'];
        foreach($floors as $floor){
            $floor_check = Floor::where('name','like','%'.$floor.'%')->first();
            if(!$floor_check){
                Floor::create(['name'=>$floor]);
            }
        }
        Floor::updateOrCreate(['id'=>0],['name'=> 'الساحة الخارجية']);
    }
}
