<?php

namespace Database\Seeders;

use App\Models\AdminDashboard\School\School;
use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\ManagerDashboard\Assignments\Assignment;
use App\Models\ManagerDashboard\Assignments\AssignmentEmployee;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class DefaultAssignmentSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run()
    {
        
        // Get all schools and check for manager (current_work_id = 1)
        $schools = School::all();

        foreach ($schools as $school) {
            $manager = SchoolEmployee::where('current_work_id',1)
                                ->where('school_id', $school->id)
                                ->first();
            if ($manager) {
                // Check if the manager already has an assignment, if not, create it
                $existingAssignment = AssignmentEmployee::where('employee_id', $manager->id)->first();

                if (!$existingAssignment) {
                    // Create the default assignment
                    $assignment = Assignment::create([
                        'date' => now()->format('d/m/Y'),
                        'school_id' => $school->id,
                        'current_work_id'=>1,
                        'date_type'=>'coptic',
                        // Add other necessary fields
                    ]);

                    // Link the manager to the assignment
                    AssignmentEmployee::create([
                        'assignment_id' => $assignment->id,
                        'employee_id' => $manager->id,
                    ]);
                }
            }
        }
    }
}
