<?php

namespace Database\Seeders;

use App\Models\AdminDashboard\Category\Category;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class CategorySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        Category::factory()
            ->count(5) // Create 10 root categories
            ->create()
            ->each(function ($category) {
                // Create 3 child categories for each root category
                Category::factory()
                    ->count(2)
                    ->create(['parent_id' => $category->id]);
            });
    }
}
