<?php

namespace Database\Seeders;

use App\Models\ManagerDashboard\Assignments\DurationAssignment;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class AssignmentGeneralDurations extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $arabicNumbers = [
            1 => 'فصل دراسي',
            2 => 'فصليين دراسيين',
            3 => 'عام دراسي',
            4 => 'عامين دراسيين',
           
        ];
        foreach ($arabicNumbers as $number => $year) {
            DurationAssignment::create([
                'year' => $year,
            ]);
        }
    }
}
