<?php

namespace Database\Seeders;

use App\Models\AdminDashboard\AreaAndCities\Area;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class AreaSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $areas = [
            ['id' => 1, 'name' => 'منطقة الرياض', 'status' => 1, 'created_at' => '2024-09-07 08:56:38', 'updated_at' => '2024-09-07 08:56:38', 'deleted_at' => null],
            ['id' => 2, 'name' => 'منطقة مكة المكرمة', 'status' => 1, 'created_at' => '2024-09-07 08:56:38', 'updated_at' => '2024-09-07 08:56:38', 'deleted_at' => null],
            ['id' => 3, 'name' => 'منطقة المدينة المنورة', 'status' => 1, 'created_at' => '2024-09-07 08:56:38', 'updated_at' => '2024-09-07 08:56:38', 'deleted_at' => null],
            ['id' => 4, 'name' => 'منطقة القصيم', 'status' => 1, 'created_at' => '2024-09-07 08:56:38', 'updated_at' => '2024-09-07 08:56:38', 'deleted_at' => null],
            ['id' => 5, 'name' => 'المنطقة الشرقية', 'status' => 1, 'created_at' => '2024-09-07 08:56:38', 'updated_at' => '2024-09-07 08:56:38', 'deleted_at' => null],
            ['id' => 6, 'name' => 'منطقة عسير', 'status' => 1, 'created_at' => '2024-09-07 08:57:10', 'updated_at' => '2024-09-07 08:57:10', 'deleted_at' => null],
            ['id' => 7, 'name' => 'منطقة تبوك', 'status' => 1, 'created_at' => '2024-09-07 08:57:10', 'updated_at' => '2024-09-07 08:57:10', 'deleted_at' => null],
            ['id' => 8, 'name' => 'منطقة حائل', 'status' => 1, 'created_at' => '2024-09-07 08:57:10', 'updated_at' => '2024-09-07 08:57:10', 'deleted_at' => null],
            ['id' => 9, 'name' => 'منطقة الحدود الشمالية', 'status' => 1, 'created_at' => '2024-09-07 08:57:10', 'updated_at' => '2024-09-07 08:57:10', 'deleted_at' => null],
            ['id' => 10, 'name' => 'منطقة جازان', 'status' => 1, 'created_at' => '2024-09-07 08:57:10', 'updated_at' => '2024-09-07 08:57:10', 'deleted_at' => null],
            ['id' => 11, 'name' => 'منطقة نجران', 'status' => 1, 'created_at' => '2024-09-07 08:57:10', 'updated_at' => '2024-09-07 08:57:10', 'deleted_at' => null],
            ['id' => 12, 'name' => 'منطقة الباحة', 'status' => 1, 'created_at' => '2024-09-07 08:57:10', 'updated_at' => '2024-09-07 08:57:10', 'deleted_at' => null],
            ['id' => 13, 'name' => 'منطقة الجوف', 'status' => 1, 'created_at' => '2024-09-07 08:57:10', 'updated_at' => '2024-09-07 08:57:10', 'deleted_at' => null],
        ];

        foreach ($areas as $area) {
            // Insert only if the area with this 'id' doesn't exist
            if (!Area::where('id', $area['id'])->exists()) {
                Area::create($area);
            }
        }
    }   
}
