<?php

namespace Database\Seeders;

use App\Models\ManagerDashboard\Namazeg\AbsenceQuestioningOption;
use Illuminate\Database\Seeder;

class AbsenceQuestioningOptionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $options = [
            'تحتسب له أجازة مرضية بعد التأكد من نظامية التقارير',
            'يُحتسب غيابه من رصيده للإجازات الضرورية إذا كان رصيده يسمح، وإلا يُحسم عليه',
            'يعتمد الحسم لعدم قبول عذره'
        ];
        foreach ($options as $option) {
            $option_check = AbsenceQuestioningOption::where('name', 'like', '%' . $option . '%')->first();
            if (!$option_check) {
                AbsenceQuestioningOption::create(['name' => $option]);
            }
        }
    }
}
