<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up()
    {
        // Delete orphaned records before applying the constraint
        DB::statement('DELETE FROM violation_students WHERE student_id NOT IN (SELECT id FROM school_students)');

        Schema::table('violation_students', function (Blueprint $table) {
            $table->unsignedBigInteger('student_id')->change();
            $table->foreign('student_id')
                ->references('id')
                ->on('school_students')
                ->onDelete('cascade'); // Add ON DELETE CASCADE
        });
    }

    public function down()
    {
        Schema::table('violation_students', function (Blueprint $table) {
            $table->dropForeign(['student_id']); // Drop foreign key before changing the column type
            $table->integer('student_id')->change();
            $table->foreign('student_id')
                ->references('id')
                ->on('school_students')
                ->onDelete('restrict'); // Revert to previous behavior
        });
    }
};
