<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up()
    {
        // flag for not complete cycle
        Schema::table('violation_student_punishments', function (Blueprint $table) {
            if (!Schema::hasColumn('violation_student_punishments', 'skip_reason')) {
                $table->text('skip_reason')->after('status')->nullable();
            }
        });
    }

    public function down()
    {
        Schema::table('violation_student_punishments', function (Blueprint $table) {
            if (Schema::hasColumn('violation_student_punishments', 'skip_reason')) {
                $table->dropColumn('skip_reason');
            }
        });
    }
};
