<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up()
    {
        // flag for not complete cycle
        Schema::table('violation_students', function (Blueprint $table) {
            if (!Schema::hasColumn('violation_students', 'published')) {
                $table->unsignedBigInteger('published')->after('student_id')->default(0);
            }
        });
    }

    public function down()
    {
        Schema::table('violation_students', function (Blueprint $table) {
            if (Schema::hasColumn('violation_students', 'published')) {
                $table->dropColumn('published');
            }
        });
    }
};
