<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('namazeg_absence_questioning_actions', function (Blueprint $table) {
            $table->unsignedBigInteger('absence_descion_confirm_id')->nullable()->change();

            $table->foreign('absence_descion_confirm_id', 'action_descision_confirm_c')
                  ->references('id')
                  ->on('namazeg_absence_descion_confirms')
                  ->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('namazeg_absence_questioning_actions', function (Blueprint $table) {
            $table->dropForeign('action_descision_confirm_c');
        });
    }
};
