<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('classroom_visits', function (Blueprint $table) {
            $table->unsignedBigInteger('semester_namazeg_version_id')->nullable()->after('school_id');
            $table->foreign('semester_namazeg_version_id')->references('id')->on('namazeg_versions')->onDelete('cascade');
            $table->unsignedBigInteger('namazeg_version_id')->nullable()->after('semester_namazeg_version_id');
            $table->foreign('namazeg_version_id')->references('id')->on('namazeg_versions')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('classroom_visits', function (Blueprint $table) {
            $table->dropForeign(['semester_namazeg_version_id']);
            $table->dropColumn('semester_namazeg_version_id');
            $table->dropForeign(['namazeg_version_id']);
            $table->dropColumn('namazeg_version_id');
        });
    }
};
