<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('namazeg_incident_proceed_witnesses', function (Blueprint $table) {
            $table->unsignedBigInteger('namazeg_incident_proceed_id')->change();
            $table->foreign('namazeg_incident_proceed_id','namazeg_inci_id')->references('id')->on('namazeg_incident_proceeds')
                ->onDelete('cascade'); // You can also use other actions, e.g., 'set null'
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('namazeg_incident_proceed_witnesses', function (Blueprint $table) {
            $table->dropForeign(['namazeg_incident_proceed_id']);
        });
    }
};
