<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('exams_namazeg_teacher_question_assignment_subjects', function (Blueprint $table) {
            $table->unsignedBigInteger('tqa_assignment_id')->change();
            $table->foreign('tqa_assignment_id','assig_id')->references('id')->on('exams_namazeg_teacher_question_assignments')
                ->onDelete('cascade'); // You can also use other actions, e.g., 'set null'
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('exams_namazeg_teacher_question_assignment_subjects', function (Blueprint $table) {
            $table->dropForeign(['tqa_assignment_id']);
        });
    }
};
