<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('report_committees_meetings', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('school_id')->nullable();  // school_id INT(11) DEFAULT NULL
            $table->unsignedBigInteger('report_category_id')->nullable();  // school_id UNSIGNED INT, NOT NULL
            $table->string('date')->nullable();
            $table->enum('date_type', ['coptic', 'hijri'])->nullable();
            $table->unsignedBigInteger('namazeg_version_id')->nullable();  // namazeg_version_id INT(11) DEFAULT NULL
            $table->timestamps();  // created_at and updated_at
            $table->softDeletes();  // deleted_at TIMESTAMP NULL

            $table->foreign('school_id')->references('id')->on('schools')->onDelete('cascade');
            //$table->foreign('report_category_id')->references('id')->on('report_categories')->onDelete('cascade');

        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('report_committees_meetings');
    }
};
